/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.external.system.workspace;

import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildDescriptor;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.MessageEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.CidrWorkspaceBundle;
import com.jetbrains.cidr.external.system.ExternalBundle;
import com.jetbrains.cidr.external.system.ExternalLog;
import com.jetbrains.cidr.external.system.model.ExternalFileConfiguration;
import com.jetbrains.cidr.external.system.model.ExternalLanguageConfiguration;
import com.jetbrains.cidr.external.system.model.ExternalModule;
import com.jetbrains.cidr.external.system.model.ExternalResolveConfiguration;
import com.jetbrains.cidr.external.system.model.impl.ExternalLanguageConfigurationImpl;
import com.jetbrains.cidr.external.system.ui.CompilerInfoNotificationBuilder;
import com.jetbrains.cidr.external.system.ui.CompilerInfoViewManager;
import com.jetbrains.cidr.external.system.workspace.ExternalWorkspace;
import com.jetbrains.cidr.external.system.workspace.ExternalWorkspaceListener;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCVariant;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceInitializationUtil;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfoCache;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.cidr.project.workspace.CidrWorkspaceManager;
import com.jetbrains.cidr.project.workspace.OCRootsSynchronizer;
import com.jetbrains.cidr.project.workspace.ReloadableWorkspace;
import com.jetbrains.cidr.toolchains.EnvironmentProblems;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 N2\u00020\u00012\u00020\u00022\b\u0012\u0004\u0012\u00020\u00040\u00032\u00020\u0005:\u0002NOB\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J8\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH&J\b\u0010\u001f\u001a\u00020\u0012H\u0016J\"\u0010 \u001a\u00020\u00122\u0018\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#0\"H\u0002J\"\u0010&\u001a\u00020\u00142\u0018\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#0\"H\u0002J\b\u0010'\u001a\u00020\u0018H'J\n\u0010(\u001a\u0004\u0018\u00010\u0004H\u0016J\u0010\u0010)\u001a\u00020\u001c2\b\u0010*\u001a\u0004\u0018\u00010\rJ\b\u0010+\u001a\u00020\u001cH\u0014J\u0010\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u0004H\u0016J\b\u0010.\u001a\u00020\u0012H\u0016J\b\u0010/\u001a\u00020\u0012H\u0016J.\u00100\u001a\b\u0012\u0004\u0012\u0002010\f2\b\b\u0001\u00102\u001a\u00020\u00182\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\f2\u0006\u00105\u001a\u000206H\u0002J.\u00107\u001a\u00020\u00122\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u000204082\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020\u001cH\u0002J$\u0010<\u001a\u00020\u00122\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u000204082\u0006\u0010;\u001a\u00020\u001cH\u0002J.\u0010=\u001a\u00020\u00122\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u000204082\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010;\u001a\u00020\u001cH\u0002J\n\u0010>\u001a\u0004\u0018\u00010:H\u0002J\b\u0010?\u001a\u00020\u0012H\u0016J\u0010\u0010@\u001a\u00020\u00122\u0006\u0010A\u001a\u00020BH\u0007J\b\u0010C\u001a\u00020\u001cH\u0014J\u0010\u0010D\u001a\u00020\u001c2\u0006\u0010E\u001a\u00020\u001cH\u0016J \u0010F\u001a\u00020\u00122\u0018\u0010!\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%0#0\"J'\u0010G\u001a\u00020\u00122\u0006\u0010H\u001a\u00020I2\u0017\u0010J\u001a\u0013\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020\u00120K\u00a2\u0006\u0002\bMR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace;", "Lcom/jetbrains/cidr/project/workspace/CidrWorkspace;", "Lcom/jetbrains/cidr/project/workspace/ReloadableWorkspace;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myReloadsQueue", "Lcom/intellij/openapi/progress/BackgroundTaskQueue;", "collectRoots", "", "Ljava/io/File;", "contentRoot", "collectRootsInfo", "Lcom/jetbrains/cidr/project/workspace/OCRootsSynchronizer$RootsInfo;", "commitOCModel", "", "ocModel", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspace$ModifiableModel;", "createEnvironment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "toolchainNameOrNullForDefault", "", "problems", "Lcom/jetbrains/cidr/toolchains/EnvironmentProblems;", "checkIfFunctional", "", "onMissingToolchain", "Ljava/lang/Runnable;", "dispose", "doUpdate", "modules", "", "Lkotlin/Pair;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "Lcom/jetbrains/cidr/external/system/model/ExternalModule;", "doUpdateOCModel", "getClientKey", "getState", "initialize", "openProjectDir", "initializeAndStart", "loadState", "element", "noStateLoaded", "projectOpened", "reportConfigInToolWindow", "Lcom/intellij/build/events/BuildEvent;", "configName", "messages", "Lcom/jetbrains/cidr/lang/workspace/compiler/CompilerInfoCache$Message;", "parentId", "", "reportMessages", "Lcom/intellij/util/containers/MultiMap;", "startEventId", "Ljava/util/UUID;", "isCancelled", "reportMessagesAsNotification", "reportMessagesInToolWindow", "reportStartEvent", "scheduleReload", "selectProjectDir", "newProjectDir", "Ljava/nio/file/Path;", "shouldReportMessages", "unload", "projectClosing", "update", "updateResolveConfiguration", "resolveConfiguration", "Lcom/jetbrains/cidr/external/system/model/ExternalResolveConfiguration;", "block", "Lkotlin/Function1;", "Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace$ExternalResolveConfigurationModifiableModel;", "Lkotlin/ExtensionFunctionType;", "Companion", "ExternalResolveConfigurationModifiableModel", "intellij.cidr.externalSystem"})
@SourceDebugExtension(value={"SMAP\nExternalWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalWorkspace.kt\ncom/jetbrains/cidr/external/system/workspace/ExternalWorkspace\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,512:1\n1#2:513\n1855#3,2:514\n766#3:516\n857#3,2:517\n766#3:519\n857#3,2:520\n1549#3:522\n1620#3,3:523\n*S KotlinDebug\n*F\n+ 1 ExternalWorkspace.kt\ncom/jetbrains/cidr/external/system/workspace/ExternalWorkspace\n*L\n385#1:514,2\n455#1:516\n455#1:517,2\n456#1:519\n456#1:520,2\n460#1:522\n460#1:523,3\n*E\n"})
public abstract class ExternalWorkspace
extends CidrWorkspace
implements ReloadableWorkspace,
PersistentStateComponent<Element>,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BackgroundTaskQueue myReloadsQueue;

    public ExternalWorkspace(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.myReloadsQueue = new BackgroundTaskQueue(this.myProject, ExternalBundle.message("external.project.reload.queue.title", new Object[0]));
    }

    @Nullable
    public abstract CidrToolEnvironment createEnvironment(@Nullable Project var1, @Nullable String var2, @NotNull EnvironmentProblems var3, boolean var4, @Nullable Runnable var5);

    public void projectOpened() {
        if (this.load(true)) {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            CidrWorkspaceManager.Companion.getInstance(project).markLoaded((CidrWorkspace)this);
        } else {
            Project project = this.myProject;
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
            CidrWorkspaceManager.Companion.getInstance(project).markNotLoaded((CidrWorkspace)this);
        }
    }

    public void dispose() {
        this.unload(true);
    }

    protected boolean initializeAndStart() {
        return this.initialize(null);
    }

    public final boolean initialize(@Nullable File openProjectDir) {
        if (!super.initializeAndStart()) {
            return false;
        }
        if (!this.isLinked() && openProjectDir != null) {
            this.linkWithProject(openProjectDir.toPath(), true);
        }
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        OCRootsSynchronizer.Companion.getInstance(project).installLegacyClasspathStorage("External");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        OCWorkspaceInitializationUtil.runWhenOrIfOCWorkspaceIsInitialized((Project)project2, (Disposable)this, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ExternalWorkspace this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ ExternalWorkspace this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this.this$0){
                            final /* synthetic */ ExternalWorkspace this$0;
                            {
                                this.this$0 = $receiver;
                                super(0);
                            }

                            public final void invoke() {
                                Logger $this$debug_u24default$iv = ExternalLog.INSTANCE.getLOG();
                                Throwable e$iv = null;
                                boolean $i$f$debug = false;
                                if ($this$debug_u24default$iv.isDebugEnabled()) {
                                    Logger logger = $this$debug_u24default$iv;
                                    boolean bl = false;
                                    logger.debug("ExternalWorkspace initialization. Updating content roots", e$iv);
                                }
                                this.this$0.updateContentRoots();
                            }
                        }));
                    }
                }), (int)1, null);
            }
        }));
        MessageBus messageBus = this.myProject.getMessageBus();
        Topic<ExternalWorkspaceListener> topic = ExternalWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        Path path = this.getProjectPathOrNull();
        ((ExternalWorkspaceListener)messageBus.syncPublisher(topic)).initialized(this, path != null ? path.toFile() : null);
        Project project3 = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"myProject");
        CidrWorkspaceManager.Companion.getInstance(project3).markInitialized((CidrWorkspace)this);
        return true;
    }

    public boolean unload(boolean projectClosing) {
        boolean removed = super.unload(projectClosing);
        if (!removed) {
            return false;
        }
        this.myReloadsQueue.clear();
        return true;
    }

    public void scheduleReload() {
        String string = ExternalSystemApiUtil.toCanonicalPath((String)String.valueOf(this.getProjectPathOrNull()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toCanonicalPath(...)");
        String path = string;
        ExternalProjectsManager.getInstance((Project)this.getProject()).getExternalProjectsWatcher().markDirty(path);
    }

    @RequiresEdt
    public final void selectProjectDir(@NotNull Path newProjectDir) {
        Intrinsics.checkNotNullParameter((Object)newProjectDir, (String)"newProjectDir");
        this.linkWithProject(newProjectDir, true);
        if (!this.isInitialized()) {
            if (this.isLinked()) {
                StartupManager.getInstance((Project)this.myProject).runAfterOpened(() -> ExternalWorkspace.selectProjectDir$lambda$0(this, newProjectDir));
            }
        } else {
            this.scheduleReload();
        }
    }

    public final void update(@NotNull Collection<? extends Pair<? extends ModuleData, ? extends ExternalModule>> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ExternalWorkspace this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (ExternalWorkspace.access$getMyProject$p$s99679466(this.this$0).isDisposed()) {
                    return;
                }
                MessageBus messageBus = ExternalWorkspace.access$getMyProject$p$s99679466(this.this$0).getMessageBus();
                Topic<ExternalWorkspaceListener> topic = ExternalWorkspaceListener.TOPIC;
                Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
                ((ExternalWorkspaceListener)messageBus.syncPublisher(topic)).updateScheduled(this.this$0);
            }
        }));
        Project project = this.myProject;
        String string = ExternalBundle.message("external.project.reload.queue.title", new Object[0]);
        this.myReloadsQueue.run(new Task.Backgroundable(this, modules, project, string){
            final /* synthetic */ ExternalWorkspace this$0;
            final /* synthetic */ Collection<Pair<ModuleData, ExternalModule>> $modules;
            {
                this.this$0 = $receiver;
                this.$modules = $modules;
                super($super_call_param$1, $super_call_param$2);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ExternalWorkspace.access$doUpdate(this.this$0, this.$modules);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doUpdate(Collection<? extends Pair<? extends ModuleData, ? extends ExternalModule>> modules) {
        block6: {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (!this.shouldLoadWorkspaceForProject()) {
                return;
            }
            if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                throw new AssertionError((Object)"Project generation should not be initiated from writeAction. Will cause a deadlock.");
            }
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            CidrWorkspaceManager.Companion.getInstance(project).markLoading((CidrWorkspace)this);
            ApplicationManager.getApplication().invokeAndWait(() -> ExternalWorkspace.doUpdate$lambda$1(this));
            ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ ExternalWorkspace this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    if (ExternalWorkspace.access$getMyProject$p$s99679466(this.this$0).isDisposed()) {
                        return;
                    }
                    MessageBus messageBus = ExternalWorkspace.access$getMyProject$p$s99679466(this.this$0).getMessageBus();
                    Topic<ExternalWorkspaceListener> topic = ExternalWorkspaceListener.TOPIC;
                    Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
                    ((ExternalWorkspaceListener)messageBus.syncPublisher(topic)).updateStarted(this.this$0);
                }
            }));
            try {
                ProgressManager.checkCanceled();
                if (!this.myProject.isDisposed()) break block6;
            }
            catch (Throwable throwable) {
                ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ ExternalWorkspace this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        if (ExternalWorkspace.access$getMyProject$p$s99679466(this.this$0).isDisposed()) {
                            return;
                        }
                        MessageBus messageBus = ExternalWorkspace.access$getMyProject$p$s99679466(this.this$0).getMessageBus();
                        Topic<ExternalWorkspaceListener> topic = ExternalWorkspaceListener.TOPIC;
                        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
                        ((ExternalWorkspaceListener)messageBus.syncPublisher(topic)).updateFinished(this.this$0);
                        Project project = this.this$0.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        CidrWorkspaceManager.Companion.getInstance(project).markLoaded((CidrWorkspace)this.this$0);
                    }
                }));
                throw throwable;
            }
            ActionsKt.runReadAction((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
            return;
        }
        List firstModule = modules.isEmpty() ? CollectionsKt.emptyList() : CollectionsKt.listOf((Object)CollectionsKt.first((Iterable)modules));
        OCWorkspace.ModifiableModel ocModel = this.doUpdateOCModel(firstModule);
        this.commitOCModel(ocModel);
        ActionsKt.runReadAction((Function0)((Function0)new /* invalid duplicate definition of identical inner class */));
    }

    private final void commitOCModel(OCWorkspace.ModifiableModel ocModel) {
        ApplicationManager.getApplication().invokeAndWait(() -> ExternalWorkspace.commitOCModel$lambda$2(this, ocModel));
    }

    @NonNls
    @NotNull
    public abstract String getClientKey();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final OCWorkspace.ModifiableModel doUpdateOCModel(Collection<? extends Pair<? extends ModuleData, ? extends ExternalModule>> modules) {
        OCWorkspace oCWorkspace = OCWorkspace.getInstance((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)oCWorkspace, (String)"getInstance(...)");
        OCWorkspace ocWorkspace = oCWorkspace;
        OCWorkspace.ModifiableModel modifiableModel2 = ocWorkspace.getModifiableModel(this.getClientKey(), true);
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel2, (String)"getModifiableModel(...)");
        OCWorkspace.ModifiableModel ocModel = modifiableModel2;
        Disposer.register((Disposable)this, (Disposable)((Disposable)ocModel));
        CompilerInfoCache compilerInfoCache = new CompilerInfoCache();
        ProgressIndicator progressIndicator = ProgressManager.getGlobalProgressIndicator();
        Intrinsics.checkNotNull((Object)progressIndicator);
        CompilerInfoCache.Session compilerInfoSession = compilerInfoCache.createSession(progressIndicator);
        MultiMap messages = new MultiMap();
        boolean cancelled = false;
        HashMap configIdToName = new HashMap();
        UUID startEventId = this.reportStartEvent();
        try {
            for (Pair<? extends ModuleData, ? extends ExternalModule> pair : modules) {
                ModuleData ideaModule = (ModuleData)pair.component1();
                ExternalModule cppModule = (ExternalModule)pair.component2();
                for (ExternalResolveConfiguration configuration2 : cppModule.getResolveConfigurations()) {
                    OCResolveConfiguration.ModifiableModel config;
                    OCVariant oCVariant;
                    ProgressManager.checkCanceled();
                    EnvironmentProblems environmentProblems = new EnvironmentProblems();
                    CidrToolEnvironment environment2 = this.createEnvironment(this.myProject, configuration2.getToolchainName(), environmentProblems, false, null);
                    environmentProblems.throwAsExecutionException();
                    ExternalLog.INSTANCE.getLOG().assertTrue(environment2 != null);
                    String string = configuration2.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                    String configurationId = ExternalWorkspace.Companion.configurationId(string, modules.size() > 1 ? ideaModule.getId() : null);
                    Map map = configIdToName;
                    String string2 = configuration2.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
                    Iterator<ExternalFileConfiguration> iterator = string2;
                    map.put(configurationId, iterator);
                    OCWorkspace.ModifiableModel modifiableModel3 = ocModel;
                    String string3 = configurationId;
                    String string4 = configuration2.getConfigName();
                    if (configuration2.getVariant() != null) {
                        void it;
                        String string5 = string4;
                        String string6 = string3;
                        OCWorkspace.ModifiableModel modifiableModel4 = modifiableModel3;
                        boolean bl = false;
                        OCVariant oCVariant2 = new OCVariant((List)it);
                        modifiableModel3 = modifiableModel4;
                        string3 = string6;
                        string4 = string5;
                        oCVariant = oCVariant2;
                    } else {
                        oCVariant = null;
                    }
                    CidrToolEnvironment cidrToolEnvironment = environment2;
                    Intrinsics.checkNotNull((Object)cidrToolEnvironment);
                    Intrinsics.checkNotNullExpressionValue((Object)modifiableModel3.addConfiguration(string3, string4, oCVariant, cidrToolEnvironment.getSupportedFileSeparators()), (String)"addConfiguration(...)");
                    for (ExternalLanguageConfiguration configLanguage : configuration2.getLanguageConfigurations()) {
                        CidrCompilerSwitches cidrCompilerSwitches;
                        OCCompilerSettings.ModifiableModel modifiableModel5;
                        OCCompilerKind oCCompilerKind;
                        ProgressManager.checkCanceled();
                        if (configLanguage instanceof ExternalLanguageConfigurationImpl) {
                            ExternalLanguageConfigurationImpl externalLanguageConfigurationImpl = (ExternalLanguageConfigurationImpl)configLanguage;
                            Project project = this.myProject;
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
                            oCCompilerKind = externalLanguageConfigurationImpl.resolveCompiler(project, environment2);
                        } else {
                            oCCompilerKind = configLanguage.getCompilerKind();
                        }
                        OCCompilerKind compilerKind = oCCompilerKind;
                        OCCompilerSettings.ModifiableModel $this$doUpdateOCModel_u24lambda_u245 = modifiableModel5 = config.getLanguageCompilerSettings(configLanguage.getLanguageKind());
                        boolean bl = false;
                        $this$doUpdateOCModel_u24lambda_u245.setCompiler(compilerKind, configLanguage.getCompilerExecutable(), configuration2.getBuildWorkingDir());
                        if (configLanguage.getCompilerSwitches() != null) {
                            List<String> it;
                            boolean bl2 = false;
                            cidrCompilerSwitches = new CidrSwitchBuilder().addAllRaw(it).build();
                        } else {
                            cidrCompilerSwitches = null;
                        }
                        CidrCompilerSwitches switches = cidrCompilerSwitches;
                        $this$doUpdateOCModel_u24lambda_u245.setCompilerSwitches(switches);
                    }
                    for (ExternalFileConfiguration configSourceFile : configuration2.getFileConfigurations()) {
                        CidrCompilerSwitches cidrCompilerSwitches;
                        ProgressManager.checkCanceled();
                        if (configSourceFile.getCompilerSwitches() != null) {
                            List<String> it;
                            boolean bl = false;
                            cidrCompilerSwitches = new CidrSwitchBuilder().addAllRaw(it).build();
                        } else {
                            cidrCompilerSwitches = null;
                        }
                        CidrCompilerSwitches switches = cidrCompilerSwitches;
                        config.addSource(VfsUtil.fileToUrl((File)configSourceFile.getFile()), configSourceFile.getLanguageKind()).setCompilerSwitches(switches);
                    }
                    compilerInfoSession.schedule((Object)configuration2.getId(), config, environment2, ((Object)this.getProjectPath()).toString());
                }
            }
            compilerInfoSession.waitForAll(messages);
            ocModel.preCommit();
        }
        catch (Throwable ex) {
            if (ex instanceof ProcessCanceledException) {
                cancelled = true;
            }
            compilerInfoSession.dispose();
            Disposer.dispose((Disposable)((Disposable)ocModel));
            throw ex;
        }
        finally {
            this.reportMessages((MultiMap<String, CompilerInfoCache.Message>)messages, startEventId, cancelled);
        }
        return ocModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateResolveConfiguration(@NotNull ExternalResolveConfiguration resolveConfiguration, @NotNull Function1<? super ExternalResolveConfigurationModifiableModel, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)resolveConfiguration, (String)"resolveConfiguration");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        OCWorkspace.ModifiableModel modifiableModel2 = OCWorkspace.getInstance((Project)this.myProject).getModifiableModel(this.getClientKey());
        Intrinsics.checkNotNullExpressionValue((Object)modifiableModel2, (String)"getModifiableModel(...)");
        OCWorkspace.ModifiableModel ocModel = modifiableModel2;
        try {
            String string = resolveConfiguration.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            String configurationId = ExternalWorkspace.Companion.configurationId(string, null);
            OCResolveConfiguration.ModifiableModel resolveConfigurationModel = ocModel.getConfigurationById(configurationId);
            if (resolveConfigurationModel == null) {
                ExternalLog.INSTANCE.getLOG().warn("Resolve configuration model '" + configurationId + "' not found - update failed", new Throwable());
                return;
            }
            if (this.getProject().isDisposed()) {
                return;
            }
            ExternalResolveConfigurationModifiableModel model = new ExternalResolveConfigurationModifiableModel(this, ocModel, resolveConfigurationModel);
            block.invoke((Object)model);
            ocModel.preCommit();
            this.commitOCModel(ocModel);
        }
        finally {
            Disposer.dispose((Disposable)((Disposable)ocModel));
        }
    }

    @NotNull
    protected OCRootsSynchronizer.RootsInfo collectRootsInfo(@Nullable File contentRoot) {
        List list2 = OCWorkspace.getInstance((Project)this.myProject).getConfigurations(this.getClientKey());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getConfigurations(...)");
        List configurations2 = list2;
        List list3 = this.collectExcludeRoots(contentRoot);
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"collectExcludeRoots(...)");
        List excludedRoots = list3;
        OCRootsSynchronizer.RootsInfo rootsInfo = CidrWorkspace.createRootsInfo((List)configurations2, this.collectRoots(contentRoot), (List)CollectionsKt.emptyList(), (List)CollectionsKt.emptyList());
        rootsInfo.additionalBuildDirs.addAll(excludedRoots);
        Intrinsics.checkNotNull((Object)rootsInfo);
        return rootsInfo;
    }

    private final List<File> collectRoots(File contentRoot) {
        Object[] objectArray = new File[2];
        objectArray[0] = contentRoot;
        Path path = this.getProjectPathOrNull();
        objectArray[1] = path != null ? path.toFile() : null;
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @Nullable
    public Element getState() {
        return this.getBaseState().createElement();
    }

    public void noStateLoaded() {
        super.noStateLoaded();
    }

    public void loadState(@NotNull Element element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        this.loadBaseState(CidrWorkspace.State.loadStateElement((Element)element2));
    }

    protected boolean shouldReportMessages() {
        return true;
    }

    private final UUID reportStartEvent() {
        if (!this.shouldReportMessages()) {
            return null;
        }
        if (!Registry.get((String)"compiler.info.show.tab").asBoolean()) {
            return null;
        }
        UUID taskId = UUID.randomUUID();
        DefaultBuildDescriptor descriptor2 = new DefaultBuildDescriptor((Object)taskId, ExternalBundle.message("collect.compiler.info.task.display.name", new Object[0]), ((Object)this.getProjectPath()).toString(), System.currentTimeMillis());
        StartBuildEventImpl startEvent = new StartBuildEventImpl((BuildDescriptor)descriptor2, ExternalBundle.message("collect.compiler.info.task.display.name", new Object[0]));
        return (UUID)ActionsKt.runReadAction((Function0)((Function0)new Function0<UUID>(this, taskId, startEvent){
            final /* synthetic */ ExternalWorkspace this$0;
            final /* synthetic */ UUID $taskId;
            final /* synthetic */ StartBuildEventImpl $startEvent;
            {
                this.this$0 = $receiver;
                this.$taskId = $taskId;
                this.$startEvent = $startEvent;
                super(0);
            }

            @Nullable
            public final UUID invoke() {
                if (ExternalWorkspace.access$getMyProject$p$s99679466(this.this$0).isDisposed()) {
                    return null;
                }
                CompilerInfoViewManager viewManager = (CompilerInfoViewManager)((Object)ExternalWorkspace.access$getMyProject$p$s99679466(this.this$0).getService(CompilerInfoViewManager.class));
                if (Disposer.isDisposed((Disposable)((Disposable)viewManager))) {
                    return null;
                }
                viewManager.onEvent(this.$taskId, (BuildEvent)this.$startEvent);
                return this.$taskId;
            }
        }));
    }

    private final void reportMessages(MultiMap<String, CompilerInfoCache.Message> messages, UUID startEventId, boolean isCancelled) {
        if (ExternalLog.INSTANCE.getLOG().isDebugEnabled()) {
            if (isCancelled) {
                ExternalLog.INSTANCE.getLOG().debug(CidrWorkspaceBundle.message((String)"collect.compiler.info.cancelled.message", (Object[])new Object[0]));
            }
            Collection collection = messages.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CompilerInfoCache.Message it = (CompilerInfoCache.Message)element$iv;
                boolean bl = false;
                Logger logger = ExternalLog.INSTANCE.getLOG();
                logger.debug((switch (WhenMappings.$EnumSwitchMapping$0[it.type.ordinal()]) {
                    case 1 -> "Error: ";
                    case 2 -> "Warning: ";
                    default -> throw new NoWhenBranchMatchedException();
                }) + it.text);
            }
        }
        if (!this.shouldReportMessages()) {
            return;
        }
        if (!Registry.get((String)"compiler.info.show.tab").asBoolean()) {
            this.reportMessagesAsNotification(messages, isCancelled);
        } else {
            this.reportMessagesInToolWindow(messages, startEventId, isCancelled);
        }
    }

    private final void reportMessagesAsNotification(MultiMap<String, CompilerInfoCache.Message> messages, boolean isCancelled) {
        CompilerInfoNotificationBuilder compilerInfoNotificationBuilder = new CompilerInfoNotificationBuilder(messages, isCancelled);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        compilerInfoNotificationBuilder.notify(project);
    }

    private final void reportMessagesInToolWindow(MultiMap<String, CompilerInfoCache.Message> messages, UUID startEventId, boolean isCancelled) {
        Object v2;
        Object object;
        Sequence configEvents2;
        block3: {
            if (startEventId == null) {
                return;
            }
            Set set = messages.entrySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
            configEvents2 = SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)reportMessagesInToolWindow.configEvents.1.INSTANCE), (Function1)((Function1)new Function1<Map.Entry<String, Collection<CompilerInfoCache.Message>>, List<? extends BuildEvent>>(this, startEventId){
                final /* synthetic */ ExternalWorkspace this$0;
                final /* synthetic */ UUID $startEventId;
                {
                    this.this$0 = $receiver;
                    this.$startEventId = $startEventId;
                    super(1);
                }

                @NotNull
                public final List<BuildEvent> invoke(Map.Entry<String, Collection<CompilerInfoCache.Message>> it) {
                    String string = it.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-key>(...)");
                    Collection<CompilerInfoCache.Message> collection = it.getValue();
                    Intrinsics.checkNotNull(collection, (String)"null cannot be cast to non-null type kotlin.collections.List<com.jetbrains.cidr.lang.workspace.compiler.CompilerInfoCache.Message>");
                    return ExternalWorkspace.access$reportConfigInToolWindow(this.this$0, string, (List)collection, this.$startEventId);
                }
            })));
            Collection collection = messages.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
            object = collection;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                CompilerInfoCache.Message it = (CompilerInfoCache.Message)t;
                boolean bl = false;
                if (!(it.type == CompilerInfoCache.Message.Type.ERROR)) continue;
                v2 = t;
                break block3;
            }
            v2 = null;
        }
        boolean isSuccess = v2 == null;
        object = isCancelled ? CidrWorkspaceBundle.message((String)"collect.compiler.info.cancelled.message", (Object[])new Object[0]) : (isSuccess ? ExternalBundle.message("collect.compiler.info.task.finish.successful.message", new Object[0]) : CidrWorkspaceBundle.message((String)"collect.compiler.info.error.message", (Object[])new Object[0]));
        Intrinsics.checkNotNull((Object)object);
        Object finishMessage = object;
        String string = CidrWorkspaceBundle.message((String)"collect.compiler.info.error.message", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String finishDescription = string;
        FinishBuildEventImpl finishEvent = new FinishBuildEventImpl((Object)startEventId, null, System.currentTimeMillis(), (String)finishMessage, isCancelled ? (EventResult)new SkippedResultImpl() : (isSuccess ? (EventResult)new SuccessResultImpl() : (EventResult)new FailureResultImpl(finishDescription, null)));
        ActionsKt.runReadAction((Function0)((Function0)new Function0<Unit>(this, (Sequence<? extends BuildEvent>)configEvents2, startEventId, finishEvent){
            final /* synthetic */ ExternalWorkspace this$0;
            final /* synthetic */ Sequence<BuildEvent> $configEvents;
            final /* synthetic */ UUID $startEventId;
            final /* synthetic */ FinishBuildEventImpl $finishEvent;
            {
                this.this$0 = $receiver;
                this.$configEvents = $configEvents;
                this.$startEventId = $startEventId;
                this.$finishEvent = $finishEvent;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                if (ExternalWorkspace.access$getMyProject$p$s99679466(this.this$0).isDisposed()) {
                    return;
                }
                CompilerInfoViewManager viewManager = (CompilerInfoViewManager)((Object)ExternalWorkspace.access$getMyProject$p$s99679466(this.this$0).getService(CompilerInfoViewManager.class));
                if (Disposer.isDisposed((Disposable)((Disposable)viewManager))) {
                    return;
                }
                Sequence<BuildEvent> sequence = this.$configEvents;
                UUID uUID = this.$startEventId;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    BuildEvent it = (BuildEvent)element$iv;
                    boolean bl = false;
                    viewManager.onEvent(uUID, it);
                }
                viewManager.onEvent(this.$startEventId, (BuildEvent)this.$finishEvent);
            }
        }));
        if (!messages.isEmpty() && !ApplicationManager.getApplication().isHeadlessEnvironment()) {
            ApplicationManager.getApplication().invokeLater(() -> ExternalWorkspace.reportMessagesInToolWindow$lambda$9(this), this.myProject.getDisposed());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<BuildEvent> reportConfigInToolWindow(@NlsSafe String configName, List<? extends CompilerInfoCache.Message> messages, Object parentId) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterable $this$filter$iv = messages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            CompilerInfoCache.Message it = (CompilerInfoCache.Message)element$iv$iv;
            boolean bl = false;
            if (!(it.type == CompilerInfoCache.Message.Type.ERROR)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List errors = (List)destination$iv$iv;
        Iterable $this$filter$iv2 = messages;
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CompilerInfoCache.Message it = (CompilerInfoCache.Message)element$iv$iv;
            boolean bl = false;
            if (!(it.type == CompilerInfoCache.Message.Type.WARNING)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List warnings = (List)destination$iv$iv2;
        ExternalLog.INSTANCE.getLOG().assertTrue(!((Collection)errors).isEmpty() || !((Collection)warnings).isEmpty());
        $this$filter$iv2 = CollectionsKt.plus((Collection)errors, (Iterable)warnings);
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String details;
            void message;
            CompilerInfoCache.Message it = (CompilerInfoCache.Message)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            boolean isError = message.type == CompilerInfoCache.Message.Type.ERROR;
            String string = isError ? CidrWorkspaceBundle.message((String)"collect.compiler.info.error.message", (Object[])new Object[0]) : CidrWorkspaceBundle.message((String)"collect.compiler.info.warning.message", (Object[])new Object[0]);
            Intrinsics.checkNotNull((Object)string);
            String eventMessage = string;
            Intrinsics.checkNotNullExpressionValue((Object)StringUtil.replace((String)message.text, (String)"\n", (String)"\n\t"), (String)"replace(...)");
            collection.add(new MessageEventImpl(parentId, isError ? MessageEvent.Kind.ERROR : MessageEvent.Kind.WARNING, configName, eventMessage, details));
        }
        return (List)destination$iv$iv2;
    }

    private static final void selectProjectDir$lambda$0(ExternalWorkspace this$0, Path $newProjectDir) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$newProjectDir, (String)"$newProjectDir");
        this$0.initialize($newProjectDir.toFile());
    }

    private static final void doUpdate$lambda$1(ExternalWorkspace this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (!this$0.myProject.isDisposed()) {
            FileDocumentManager.getInstance().saveAllDocuments();
        }
    }

    private static final void commitOCModel$lambda$2(ExternalWorkspace this$0, OCWorkspace.ModifiableModel $ocModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$ocModel, (String)"$ocModel");
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this$0, $ocModel){
            final /* synthetic */ ExternalWorkspace this$0;
            final /* synthetic */ OCWorkspace.ModifiableModel $ocModel;
            {
                this.this$0 = $receiver;
                this.$ocModel = $ocModel;
                super(0);
            }

            public final void invoke() {
                if (ExternalWorkspace.access$getMyProject$p$s99679466(this.this$0).isDisposed()) {
                    Disposer.dispose((Disposable)((Disposable)this.$ocModel));
                    return;
                }
                this.$ocModel.commit();
                this.this$0.updateContentRoots();
            }
        }));
    }

    private static final void reportMessagesInToolWindow$lambda$9(ExternalWorkspace this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        BuildContentManager.getInstance((Project)this$0.myProject).getOrCreateToolWindow().activate(null, false);
    }

    @JvmStatic
    @NotNull
    public static final Collection<Pair<ModuleData, ExternalModule>> findExternalModules(@NotNull Project project) {
        return Companion.findExternalModules(project);
    }

    @JvmStatic
    @NotNull
    public static final Collection<DataNode<ExternalModule>> findExternalModuleNodes(@NotNull Project project) {
        return Companion.findExternalModuleNodes(project);
    }

    public static final /* synthetic */ Project access$getMyProject$p$s99679466(ExternalWorkspace $this) {
        return $this.myProject;
    }

    public static final /* synthetic */ void access$doUpdate(ExternalWorkspace $this, Collection modules) {
        $this.doUpdate(modules);
    }

    public static final /* synthetic */ List access$reportConfigInToolWindow(ExternalWorkspace $this, String configName, List messages, Object parentId) {
        return $this.reportConfigInToolWindow(configName, messages, parentId);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004H\u0002J\u001c\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\"\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\u000e0\b2\u0006\u0010\u000b\u001a\u00020\fH\u0007\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace$Companion;", "", "()V", "configurationId", "", "baseId", "moduleName", "findExternalModuleNodes", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/jetbrains/cidr/external/system/model/ExternalModule;", "project", "Lcom/intellij/openapi/project/Project;", "findExternalModules", "Lkotlin/Pair;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "intellij.cidr.externalSystem"})
    @SourceDebugExtension(value={"SMAP\nExternalWorkspace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalWorkspace.kt\ncom/jetbrains/cidr/external/system/workspace/ExternalWorkspace$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,512:1\n1549#2:513\n1620#2,3:514\n766#2:517\n857#2,2:518\n1549#2:520\n1620#2,3:521\n1549#2:524\n1620#2,3:525\n1360#2:528\n1446#2,5:529\n1549#2:534\n1620#2,3:535\n1360#2:538\n1446#2,5:539\n1360#2:544\n1446#2,5:545\n*S KotlinDebug\n*F\n+ 1 ExternalWorkspace.kt\ncom/jetbrains/cidr/external/system/workspace/ExternalWorkspace$Companion\n*L\n485#1:513\n485#1:514,3\n486#1:517\n486#1:518,2\n487#1:520\n487#1:521,3\n492#1:524\n492#1:525,3\n496#1:528\n496#1:529,5\n499#1:534\n499#1:535,3\n504#1:538\n504#1:539,5\n505#1:544\n505#1:545,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Collection<Pair<ModuleData, ExternalModule>> findExternalModules(@NotNull Project project) {
            Iterable $this$filterTo$iv$iv;
            Pair it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Collection<DataNode<ExternalModule>> externalModules = this.findExternalModuleNodes(project);
            Iterable $this$map$iv = externalModules;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                DataNode dataNode = (DataNode)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)ExternalSystemApiUtil.findParent((DataNode)it, (Key)ProjectKeys.MODULE), (Object)it));
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Pair)element$iv$iv;
                boolean bl = false;
                if (!(it.getFirst() != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$map$iv = (List)destination$iv$iv;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Pair)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Object object = it.getFirst();
                Intrinsics.checkNotNull((Object)object);
                collection.add(TuplesKt.to((Object)((DataNode)object).getData(), (Object)((DataNode)it.getSecond()).getData()));
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final Collection<DataNode<ExternalModule>> findExternalModuleNodes(@NotNull Project project) {
            Iterable $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            void $this$flatMapTo$iv$iv2;
            void $this$flatMap$iv2;
            Collection collection;
            Iterable $this$mapTo$iv$iv2;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List list2 = ExternalSystemApiUtil.getAllManagers();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getAllManagers(...)");
            Iterable $this$map$iv2 = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo22 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Iterator it;
                ExternalSystemManager externalSystemManager = (ExternalSystemManager)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getSystemId());
            }
            List systemIds = (List)destination$iv$iv;
            ProjectDataManager projectDataManager = ProjectDataManager.getInstance();
            $this$mapTo$iv$iv2 = systemIds;
            boolean $i$f$flatMap22 = false;
            void $i$f$mapTo22 = $this$flatMap$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                ProjectSystemId it = (ProjectSystemId)element$iv$iv;
                boolean bl = false;
                Collection collection2 = projectDataManager.getExternalProjectsData(project, it);
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"getExternalProjectsData(...)");
                Iterable list$iv$iv = collection2;
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List projectInfos = (List)destination$iv$iv2;
            Iterable $i$f$flatMap22 = projectInfos;
            boolean $i$f$map2 = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ExternalProjectInfo bl = (ExternalProjectInfo)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(it.getExternalProjectStructure());
            }
            List projectDataNodes = CollectionsKt.distinct((Iterable)((List)destination$iv$iv3));
            $this$map$iv = CollectionsKt.filterNotNull((Iterable)projectDataNodes);
            boolean $i$f$flatMap = false;
            $this$mapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DataNode it = (DataNode)element$iv$iv;
                boolean bl = false;
                Collection collection3 = ExternalSystemApiUtil.findAll((DataNode)it, (Key)ProjectKeys.MODULE);
                Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"findAll(...)");
                Iterable list$iv$iv = collection3;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv3;
            $i$f$flatMap = false;
            $this$flatMapTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv3 = new ArrayList();
            $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DataNode it = (DataNode)element$iv$iv;
                boolean bl = false;
                DataNode dataNode = it;
                Intrinsics.checkNotNull((Object)dataNode);
                Collection collection4 = ExternalSystemApiUtil.findAll((DataNode)dataNode, ExternalModule.OC_MODULE_KEY);
                Intrinsics.checkNotNullExpressionValue((Object)collection4, (String)"findAll(...)");
                Iterable list$iv$iv = collection4;
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv3;
        }

        private final String configurationId(String baseId, String moduleName) {
            String string = moduleName;
            return string == null ? baseId : string + ": " + baseId;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\t\u0010\u0012\u001a\u00020\u0003H\u00c2\u0003J\u000e\u0010\u0013\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b\u0014J\t\u0010\u0015\u001a\u00020\u0007H\u00c2\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace$ExternalResolveConfigurationModifiableModel;", "", "owner", "Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace;", "ocModel", "Lcom/jetbrains/cidr/lang/workspace/OCWorkspace$ModifiableModel;", "configModel", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration$ModifiableModel;", "(Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace;Lcom/jetbrains/cidr/lang/workspace/OCWorkspace$ModifiableModel;Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration$ModifiableModel;)V", "getOcModel$intellij_cidr_externalSystem", "()Lcom/jetbrains/cidr/lang/workspace/OCWorkspace$ModifiableModel;", "addSource", "Lcom/jetbrains/cidr/lang/workspace/OCCompilerSettings$ModifiableModel;", "Lorg/jetbrains/annotations/NotNull;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "languageKind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "component1", "component2", "component2$intellij_cidr_externalSystem", "component3", "copy", "equals", "", "other", "hashCode", "", "removeSource", "", "toString", "", "intellij.cidr.externalSystem"})
    public static final class ExternalResolveConfigurationModifiableModel {
        @NotNull
        private final ExternalWorkspace owner;
        @NotNull
        private final OCWorkspace.ModifiableModel ocModel;
        @NotNull
        private final OCResolveConfiguration.ModifiableModel configModel;

        public ExternalResolveConfigurationModifiableModel(@NotNull ExternalWorkspace owner, @NotNull OCWorkspace.ModifiableModel ocModel, @NotNull OCResolveConfiguration.ModifiableModel configModel) {
            Intrinsics.checkNotNullParameter((Object)((Object)owner), (String)"owner");
            Intrinsics.checkNotNullParameter((Object)ocModel, (String)"ocModel");
            Intrinsics.checkNotNullParameter((Object)configModel, (String)"configModel");
            this.owner = owner;
            this.ocModel = ocModel;
            this.configModel = configModel;
        }

        @NotNull
        public final OCWorkspace.ModifiableModel getOcModel$intellij_cidr_externalSystem() {
            return this.ocModel;
        }

        @NotNull
        public final OCCompilerSettings.ModifiableModel addSource(@NotNull VirtualFile file, @NotNull OCLanguageKind languageKind) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)languageKind, (String)"languageKind");
            OCCompilerSettings.ModifiableModel modifiableModel2 = this.configModel.addSource(file, languageKind);
            Intrinsics.checkNotNullExpressionValue((Object)modifiableModel2, (String)"addSource(...)");
            return modifiableModel2;
        }

        public final void removeSource(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.configModel.removeSource(file);
        }

        private final ExternalWorkspace component1() {
            return this.owner;
        }

        @NotNull
        public final OCWorkspace.ModifiableModel component2$intellij_cidr_externalSystem() {
            return this.ocModel;
        }

        private final OCResolveConfiguration.ModifiableModel component3() {
            return this.configModel;
        }

        @NotNull
        public final ExternalResolveConfigurationModifiableModel copy(@NotNull ExternalWorkspace owner, @NotNull OCWorkspace.ModifiableModel ocModel, @NotNull OCResolveConfiguration.ModifiableModel configModel) {
            Intrinsics.checkNotNullParameter((Object)((Object)owner), (String)"owner");
            Intrinsics.checkNotNullParameter((Object)ocModel, (String)"ocModel");
            Intrinsics.checkNotNullParameter((Object)configModel, (String)"configModel");
            return new ExternalResolveConfigurationModifiableModel(owner, ocModel, configModel);
        }

        public static /* synthetic */ ExternalResolveConfigurationModifiableModel copy$default(ExternalResolveConfigurationModifiableModel externalResolveConfigurationModifiableModel, ExternalWorkspace externalWorkspace, OCWorkspace.ModifiableModel modifiableModel2, OCResolveConfiguration.ModifiableModel modifiableModel3, int n, Object object) {
            if ((n & 1) != 0) {
                externalWorkspace = externalResolveConfigurationModifiableModel.owner;
            }
            if ((n & 2) != 0) {
                modifiableModel2 = externalResolveConfigurationModifiableModel.ocModel;
            }
            if ((n & 4) != 0) {
                modifiableModel3 = externalResolveConfigurationModifiableModel.configModel;
            }
            return externalResolveConfigurationModifiableModel.copy(externalWorkspace, modifiableModel2, modifiableModel3);
        }

        @NotNull
        public String toString() {
            return "ExternalResolveConfigurationModifiableModel(owner=" + this.owner + ", ocModel=" + this.ocModel + ", configModel=" + this.configModel + ")";
        }

        public int hashCode() {
            int result2 = this.owner.hashCode();
            result2 = result2 * 31 + this.ocModel.hashCode();
            result2 = result2 * 31 + this.configModel.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExternalResolveConfigurationModifiableModel)) {
                return false;
            }
            ExternalResolveConfigurationModifiableModel externalResolveConfigurationModifiableModel = (ExternalResolveConfigurationModifiableModel)other;
            if (!Intrinsics.areEqual((Object)((Object)this.owner), (Object)((Object)externalResolveConfigurationModifiableModel.owner))) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ocModel, (Object)externalResolveConfigurationModifiableModel.ocModel)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.configModel, (Object)externalResolveConfigurationModifiableModel.configModel);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompilerInfoCache.Message.Type.values().length];
            try {
                nArray[CompilerInfoCache.Message.Type.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerInfoCache.Message.Type.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

