/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.external.system.service;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.CollectionFactory;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u0005R)\u0010\u0003\u001a\u001d\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\u00060\u0004\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/external/system/service/ExternalTaskDisposableCancellationService;", "", "()V", "taskToDisposable", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/externalSystem/model/task/ExternalSystemTaskId;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/jetbrains/cidr/external/system/service/ExternalTaskDisposableCancellationService$IsDisposable;", "cancel", "", "task", "checkCancelled", "", "findDisposable", "Lcom/intellij/openapi/Disposable;", "finish", "isCancelled", "start", "Companion", "IsDisposable", "intellij.cidr.externalSystem"})
public final class ExternalTaskDisposableCancellationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentMap<ExternalSystemTaskId, IsDisposable> taskToDisposable;

    public ExternalTaskDisposableCancellationService() {
        ConcurrentMap concurrentMap = CollectionFactory.createConcurrentWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentWeakValueMap(...)");
        this.taskToDisposable = concurrentMap;
    }

    @Nullable
    public final synchronized Disposable start(@NotNull ExternalSystemTaskId task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        Project project = task2.findProject();
        IsDisposable isDisposable = (IsDisposable)ActionsKt.runReadAction((Function0)((Function0)new Function0<IsDisposable>(project, task2){
            final /* synthetic */ Project $project;
            final /* synthetic */ ExternalSystemTaskId $task;
            {
                this.$project = $project;
                this.$task = $task;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final IsDisposable invoke() {
                IsDisposable isDisposable;
                if (this.$project == null || this.$project.isDisposed()) {
                    isDisposable = null;
                } else {
                    void var1_1;
                    IsDisposable disposable = new IsDisposable(this.$task.toString());
                    Disposer.register((Disposable)((Disposable)this.$project), (Disposable)disposable);
                    isDisposable = var1_1;
                }
                return isDisposable;
            }
        }));
        if (isDisposable == null) {
            return null;
        }
        IsDisposable cancellationDisposable2 = isDisposable;
        this.taskToDisposable.putIfAbsent(task2, cancellationDisposable2);
        return cancellationDisposable2;
    }

    public final synchronized void finish(@NotNull ExternalSystemTaskId task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        IsDisposable isDisposable = (IsDisposable)this.taskToDisposable.remove(task2);
        if (isDisposable == null) {
            return;
        }
        IsDisposable disposable = isDisposable;
        Disposer.dispose((Disposable)disposable);
    }

    public final synchronized boolean cancel(@NotNull ExternalSystemTaskId task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        IsDisposable isDisposable = (IsDisposable)this.taskToDisposable.remove(task2);
        if (isDisposable == null) {
            return false;
        }
        IsDisposable disposable = isDisposable;
        Disposer.dispose((Disposable)disposable);
        return true;
    }

    public final synchronized boolean isCancelled(@NotNull ExternalSystemTaskId task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        IsDisposable isDisposable = (IsDisposable)this.taskToDisposable.get(task2);
        if (isDisposable == null) {
            return false;
        }
        IsDisposable isDisposable2 = isDisposable;
        return isDisposable2.isDisposed();
    }

    public final void checkCancelled(@NotNull ExternalSystemTaskId task2) throws ProcessCanceledException {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        if (this.isCancelled(task2)) {
            throw new ProcessCanceledException();
        }
    }

    @Nullable
    public final synchronized Disposable findDisposable(@NotNull ExternalSystemTaskId task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        return (Disposable)this.taskToDisposable.get(task2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/external/system/service/ExternalTaskDisposableCancellationService$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/cidr/external/system/service/ExternalTaskDisposableCancellationService;", "intellij.cidr.externalSystem"})
    @SourceDebugExtension(value={"SMAP\nExternalTaskDisposableCancellationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExternalTaskDisposableCancellationService.kt\ncom/jetbrains/cidr/external/system/service/ExternalTaskDisposableCancellationService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,83:1\n40#2,3:84\n*S KotlinDebug\n*F\n+ 1 ExternalTaskDisposableCancellationService.kt\ncom/jetbrains/cidr/external/system/service/ExternalTaskDisposableCancellationService$Companion\n*L\n65#1:84,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExternalTaskDisposableCancellationService getInstance() {
            boolean $i$f$service = false;
            Class<ExternalTaskDisposableCancellationService> serviceClass$iv = ExternalTaskDisposableCancellationService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ExternalTaskDisposableCancellationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016R$\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/external/system/service/ExternalTaskDisposableCancellationService$IsDisposable;", "Lcom/intellij/openapi/Disposable;", "name", "", "(Ljava/lang/String;)V", "value", "", "isDisposed", "()Z", "setDisposed", "(Z)V", "myDisposed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getName", "()Ljava/lang/String;", "dispose", "", "toString", "intellij.cidr.externalSystem"})
    private static final class IsDisposable
    implements Disposable {
        @Nullable
        private final String name;
        @NotNull
        private final AtomicBoolean myDisposed;

        public IsDisposable(@Nullable String name2) {
            this.name = name2;
            this.myDisposed = new AtomicBoolean(false);
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final boolean isDisposed() {
            return this.myDisposed.get();
        }

        private final void setDisposed(boolean value) {
            this.myDisposed.set(value);
        }

        public void dispose() {
            this.setDisposed(true);
        }

        @NotNull
        public String toString() {
            String string = this.name;
            if (string == null) {
                string = super.toString();
            }
            return string;
        }
    }
}

