/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.msvc;

import com.intellij.util.system.CpuArch;
import com.jetbrains.cidr.cpp.toolchains.msvc.MSVCArchKt;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0081\u0002\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0017B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/msvc/MSVCArch;", "", "source", "Lcom/intellij/util/system/CpuArch;", "target", "(Ljava/lang/String;ILcom/intellij/util/system/CpuArch;Lcom/intellij/util/system/CpuArch;)V", "getSource", "()Lcom/intellij/util/system/CpuArch;", "getTarget", "toString", "", "X86", "X86_AMD64", "X86_ARM64", "X86_ARM", "AMD64", "AMD64_X86", "AMD64_ARM64", "AMD64_ARM", "ARM64", "ARM64_X86", "ARM64_AMD64", "ARM64_ARM", "Companion", "intellij.clion.toolchains"})
public final class MSVCArch
extends Enum<MSVCArch> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final CpuArch source;
    @NotNull
    private final CpuArch target;
    @NotNull
    private static final String x86 = "x86";
    @NotNull
    private static final String amd64 = "amd64";
    @NotNull
    private static final String x64 = "x64";
    @NotNull
    private static final String arm64 = "arm64";
    @NotNull
    private static final String arm = "arm";
    private static final Pattern MSVC_ARCH_PATTERN;
    public static final /* enum */ MSVCArch X86;
    public static final /* enum */ MSVCArch X86_AMD64;
    public static final /* enum */ MSVCArch X86_ARM64;
    public static final /* enum */ MSVCArch X86_ARM;
    public static final /* enum */ MSVCArch AMD64;
    public static final /* enum */ MSVCArch AMD64_X86;
    public static final /* enum */ MSVCArch AMD64_ARM64;
    public static final /* enum */ MSVCArch AMD64_ARM;
    public static final /* enum */ MSVCArch ARM64;
    public static final /* enum */ MSVCArch ARM64_X86;
    public static final /* enum */ MSVCArch ARM64_AMD64;
    public static final /* enum */ MSVCArch ARM64_ARM;
    private static final /* synthetic */ MSVCArch[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private MSVCArch(CpuArch source, CpuArch target2) {
        this.source = source;
        this.target = target2;
    }

    @NotNull
    public final CpuArch getSource() {
        return this.source;
    }

    @NotNull
    public final CpuArch getTarget() {
        return this.target;
    }

    @NotNull
    public String toString() {
        if (this.target == this.source) {
            return MSVCArch.toString$toMSVCStringNoEx(this.target);
        }
        return MSVCArch.toString$toMSVCStringNoEx(this.source) + "_" + MSVCArch.toString$toMSVCStringNoEx(this.target);
    }

    public static MSVCArch[] values() {
        return (MSVCArch[])$VALUES.clone();
    }

    public static MSVCArch valueOf(String value) {
        return Enum.valueOf(MSVCArch.class, value);
    }

    @NotNull
    public static EnumEntries<MSVCArch> getEntries() {
        return $ENTRIES;
    }

    private static final String toString$toMSVCStringNoEx(CpuArch arch) {
        String string;
        try {
            string = com.jetbrains.cidr.cpp.toolchains.msvc.MSVCArch$Companion.toMSVCString$default(Companion, arch, false, 2, null);
        }
        catch (IllegalArgumentException ex) {
            MSVCArchKt.access$getLOG$p().warn((Throwable)ex);
            string = "";
        }
        return string;
    }

    @JvmStatic
    @NotNull
    public static final String toMSVCString(@NotNull CpuArch arch, boolean preferX) {
        return Companion.toMSVCString(arch, preferX);
    }

    @JvmStatic
    @NotNull
    public static final MSVCArch fromString(@NotNull String value) {
        return Companion.fromString(value);
    }

    @JvmStatic
    @NotNull
    public static final MSVCArch get(@NotNull CpuArch source, @Nullable CpuArch target2) {
        return Companion.get(source, target2);
    }

    static {
        X86 = new MSVCArch(CpuArch.X86, CpuArch.X86);
        X86_AMD64 = new MSVCArch(CpuArch.X86, CpuArch.X86_64);
        X86_ARM64 = new MSVCArch(CpuArch.X86, CpuArch.ARM64);
        X86_ARM = new MSVCArch(CpuArch.X86, CpuArch.ARM32);
        AMD64 = new MSVCArch(CpuArch.X86_64, CpuArch.X86_64);
        AMD64_X86 = new MSVCArch(CpuArch.X86_64, CpuArch.X86);
        AMD64_ARM64 = new MSVCArch(CpuArch.X86_64, CpuArch.ARM64);
        AMD64_ARM = new MSVCArch(CpuArch.X86_64, CpuArch.ARM32);
        ARM64 = new MSVCArch(CpuArch.ARM64, CpuArch.ARM64);
        ARM64_X86 = new MSVCArch(CpuArch.ARM64, CpuArch.X86);
        ARM64_AMD64 = new MSVCArch(CpuArch.ARM64, CpuArch.X86_64);
        ARM64_ARM = new MSVCArch(CpuArch.ARM64, CpuArch.ARM32);
        $VALUES = mSVCArchArray = new MSVCArch[]{MSVCArch.X86, MSVCArch.X86_AMD64, MSVCArch.X86_ARM64, MSVCArch.X86_ARM, MSVCArch.AMD64, MSVCArch.AMD64_X86, MSVCArch.AMD64_ARM64, MSVCArch.AMD64_ARM, MSVCArch.ARM64, MSVCArch.ARM64_X86, MSVCArch.ARM64_AMD64, MSVCArch.ARM64_ARM};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        MSVC_ARCH_PATTERN = Pattern.compile("(?<source>.*?)(_(?<target>.*))?$");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\u001a\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\rH\u0007J\u001a\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\r2\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/msvc/MSVCArch$Companion;", "", "()V", "MSVC_ARCH_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "amd64", "", "arm", "arm64", "x64", "x86", "fromMSVCString", "Lcom/intellij/util/system/CpuArch;", "value", "fromString", "Lcom/jetbrains/cidr/cpp/toolchains/msvc/MSVCArch;", "get", "source", "target", "toMSVCString", "arch", "preferX", "", "intellij.clion.toolchains"})
    @SourceDebugExtension(value={"SMAP\nMSVCArch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MSVCArch.kt\ncom/jetbrains/cidr/cpp/toolchains/msvc/MSVCArch$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1#2:93\n223#3,2:94\n223#3,2:96\n*S KotlinDebug\n*F\n+ 1 MSVCArch.kt\ncom/jetbrains/cidr/cpp/toolchains/msvc/MSVCArch$Companion\n*L\n84#1:94,2\n89#1:96,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final CpuArch fromMSVCString(String value) {
            return switch (value) {
                case MSVCArch.x86 -> CpuArch.X86;
                case MSVCArch.x64, MSVCArch.amd64 -> CpuArch.X86_64;
                case MSVCArch.arm64 -> CpuArch.ARM64;
                case MSVCArch.arm -> CpuArch.ARM32;
                default -> throw new IllegalArgumentException("Unknown arch " + value);
            };
        }

        @JvmStatic
        @NotNull
        public final String toMSVCString(@NotNull CpuArch arch, boolean preferX) {
            Intrinsics.checkNotNullParameter((Object)arch, (String)"arch");
            return switch (WhenMappings.$EnumSwitchMapping$0[arch.ordinal()]) {
                case 1 -> MSVCArch.x86;
                case 2 -> {
                    if (preferX) {
                        yield MSVCArch.x64;
                    }
                    yield MSVCArch.amd64;
                }
                case 3 -> MSVCArch.arm64;
                case 4 -> MSVCArch.arm;
                default -> throw new IllegalArgumentException("Unexpected MSVC arch " + this);
            };
        }

        public static /* synthetic */ String toMSVCString$default(Companion companion, CpuArch cpuArch, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.toMSVCString(cpuArch, bl);
        }

        @JvmStatic
        @NotNull
        public final MSVCArch fromString(@NotNull String value) {
            Object element$iv2;
            block5: {
                String string;
                CpuArch source;
                block7: {
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        Matcher matcher = MSVC_ARCH_PATTERN.matcher(value);
                        if (!matcher.find()) {
                            throw new IllegalArgumentException(value + " does not match msvc arch pattern");
                        }
                        String string2 = matcher.group("source");
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
                        source = this.fromMSVCString(string2);
                        string = matcher.group("target");
                        if (string == null) break block6;
                        String it = string;
                        boolean bl = false;
                        CpuArch cpuArch = Companion.fromMSVCString(it);
                        string = cpuArch;
                        if (cpuArch != null) break block7;
                    }
                    string = source;
                }
                String target2 = string;
                Iterable $this$first$iv = (Iterable)MSVCArch.getEntries();
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    MSVCArch it = (MSVCArch)((Object)element$iv2);
                    boolean bl = false;
                    if (!(it.getSource() == source && it.getTarget() == target2)) continue;
                    break block5;
                }
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            return (MSVCArch)((Object)element$iv2);
        }

        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        @NotNull
        public final MSVCArch get(@NotNull CpuArch source, @Nullable CpuArch target2) {
            Object element$iv;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Iterable $this$first$iv = (Iterable)MSVCArch.getEntries();
            boolean $i$f$first = false;
            Iterator iterator = $this$first$iv.iterator();
            do {
                if (!iterator.hasNext()) throw new NoSuchElementException("Collection contains no element matching the predicate.");
                element$iv = iterator.next();
                MSVCArch it = (MSVCArch)((Object)element$iv);
                boolean bl2 = false;
                if (it.getSource() == source) {
                    CpuArch cpuArch = target2;
                    if (cpuArch == null) {
                        cpuArch = source;
                    }
                    if (cpuArch == it.getTarget()) {
                        bl = true;
                        continue;
                    }
                }
                bl = false;
            } while (!bl);
            return (MSVCArch)((Object)element$iv);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CpuArch.values().length];
                try {
                    nArray[CpuArch.X86.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CpuArch.X86_64.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CpuArch.ARM64.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CpuArch.ARM32.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

