/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.docker;

import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.github.benmanes.caffeine.cache.Scheduler;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.run.common.EnvsBuilder;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remoteRunRuntime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathMapper;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerUtil;
import com.jetbrains.cidr.execution.CidrCoroutineHelper;
import com.jetbrains.cidr.system.RemoteHostUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class DockerExecutor
implements Disposable {
    private final long EXEC_POOL_SIZE = Registry.intValue((String)"clion.docker.exec.pool.size", (int)20);
    private final AsyncCache<@NotNull Triple<DockerCredentialsHolder, DockerContainerSettings, List<DockerVolumeBinding>>, @NotNull DockerApplicationRuntimeWrapper> applicationRuntime = Caffeine.newBuilder().maximumSize(this.EXEC_POOL_SIZE).expireAfterAccess(3000L, TimeUnit.MILLISECONDS).removalListener(DockerExecutor.getRemovalListener()).scheduler(Scheduler.systemScheduler()).executor((Executor)AppExecutorUtil.getAppExecutorService()).buildAsync();

    @NotNull
    private static RemovalListener<Object, DockerApplicationRuntimeWrapper> getRemovalListener() {
        RemovalListener removalListener = (key, value, cause) -> {
            if (value != null) {
                value.removeContainer();
            }
        };
        if (removalListener == null) {
            DockerExecutor.$$$reportNull$$$0(0);
        }
        return removalListener;
    }

    public void dispose() {
        this.applicationRuntime.asMap().values().forEach(future -> future.thenAccept(wrapper -> wrapper.removeContainer()));
    }

    @NotNull
    public ProcessOutput exec(@NotNull DockerCredentialsHolder holder, @NotNull List<DockerVolumeBinding> implicitBindVolumes, @NotNull PathMapper mapper2, @Nullable DockerContainerSettings containerSettings, @NotNull GeneralCommandLine commandLine) throws com.intellij.execution.ExecutionException {
        ProcessOutput processOutput;
        if (holder == null) {
            DockerExecutor.$$$reportNull$$$0(1);
        }
        if (implicitBindVolumes == null) {
            DockerExecutor.$$$reportNull$$$0(2);
        }
        if (mapper2 == null) {
            DockerExecutor.$$$reportNull$$$0(3);
        }
        if (commandLine == null) {
            DockerExecutor.$$$reportNull$$$0(4);
        }
        commandLine.getEnvironment().put("JETBRAINS_REMOTE_RUN", "1");
        String exe = FileUtil.toSystemIndependentName((String)mapper2.convertToRemote(commandLine.getExePath()));
        List command = mapper2.convertToRemote((Collection)commandLine.getCommandLineList(exe));
        commandLine.setExePath(exe);
        File wdFile = commandLine.getWorkDirectory();
        String wd = wdFile != null ? mapper2.convertToRemote(wdFile.getPath()) : null;
        EnvsBuilder envsBuilder = EnvsBuilder.builder().addEnvs(commandLine.getEnvironment());
        if (CidrDockerUtil.isContainerOptionsEnabled() && containerSettings != null) {
            envsBuilder.addEnvs(containerSettings.getEnvVars());
        }
        Object[] vars = envsBuilder.withPassParentEnvironment(true).buildEnvs();
        List envVars = ContainerUtil.map((Object[])vars, var -> var.getName() + "=" + var.getValue());
        try {
            Triple key = new Triple((Object)holder, (Object)containerSettings, implicitBindVolumes);
            CompletableFuture appRuntime = (CompletableFuture)CidrCoroutineHelper.runWithContextPropagationAndIndicator(() -> this.applicationRuntime.get((Object)key, k -> DockerExecutor.getDockerApplicationRuntime((DockerCredentialsHolder)k.getFirst(), (DockerContainerSettings)k.getSecond(), (List)k.getThird())));
            ProcessOutput result2 = ((DockerApplicationRuntimeWrapper)appRuntime.get()).exec(ArrayUtilRt.toStringArray((Collection)command), wd, envVars);
            String message = result2.getStdout();
            if (result2.getExitCode() != 0 && message.contains("OCI runtime exec failed: exec failed:")) {
                throw new IOException(message.trim());
            }
            processOutput = result2;
        }
        catch (ServerRuntimeException | IOException e) {
            throw new com.intellij.execution.ExecutionException(e);
        }
        catch (ExecutionException e) {
            Throwable result2 = e.getCause();
            if (result2 instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)result2;
                Throwable cause = runtimeException.getCause();
                if (cause instanceof CancellationException) {
                    throw new ProcessCanceledException(cause);
                }
                throw new com.intellij.execution.ExecutionException(runtimeException.getCause());
            }
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (processOutput == null) {
            DockerExecutor.$$$reportNull$$$0(5);
        }
        return processOutput;
    }

    @NotNull
    private static DockerApplicationRuntimeWrapper getDockerApplicationRuntime(@NotNull DockerCredentialsHolder holder, @Nullable DockerContainerSettings containerSettings, @NotNull List<DockerVolumeBinding> implicitBindVolumes) {
        if (holder == null) {
            DockerExecutor.$$$reportNull$$$0(6);
        }
        if (implicitBindVolumes == null) {
            DockerExecutor.$$$reportNull$$$0(7);
        }
        try {
            RemoteDockerRuntime dockerRuntime = CidrDockerUtil.getDockerRuntime(holder);
            DockerAgentDeploymentConfigImpl config = CidrDockerUtil.getConfig(holder, containerSettings, dockerRuntime, implicitBindVolumes, null);
            config.withCommand(new String[]{RemoteHostUtil.remoteShell()});
            RemoteDockerApplicationRuntime runtime = RemoteDockerApplicationRuntime.createWithPullImage((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)config);
            runtime.startAndAttach();
            if (CidrDockerUtil.LOG.isDebugEnabled()) {
                CidrDockerUtil.LOG.debug("init cache: " + runtime.getContainerId());
            }
            return new DockerApplicationRuntimeWrapper(runtime);
        }
        catch (com.intellij.execution.ExecutionException | ServerRuntimeException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/docker/DockerExecutor";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitBindVolumes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemovalListener";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/docker/DockerExecutor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "exec";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "exec";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDockerApplicationRuntime";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private static class DockerApplicationRuntimeWrapper {
        private final RemoteDockerApplicationRuntime runtime;
        private final ReadWriteLock rwLock;
        private volatile boolean isDestroyed;
        private final long shutdownTimeout;

        private DockerApplicationRuntimeWrapper(@NotNull RemoteDockerApplicationRuntime runtime) {
            if (runtime == null) {
                DockerApplicationRuntimeWrapper.$$$reportNull$$$0(0);
            }
            this.rwLock = new ReentrantReadWriteLock();
            this.isDestroyed = false;
            this.shutdownTimeout = Registry.intValue((String)"clion.docker.exec.container.shutdown.timeout", (int)30000);
            this.runtime = runtime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProcessOutput exec(String @NotNull [] command, @Nullable String workingDir, @NotNull List<String> envVars) throws IOException, ServerRuntimeException {
            if (envVars == null) {
                DockerApplicationRuntimeWrapper.$$$reportNull$$$0(1);
            }
            if (command == null) {
                DockerApplicationRuntimeWrapper.$$$reportNull$$$0(2);
            }
            this.rwLock.readLock().lock();
            CidrDockerUtil.LOG.assertTrue(!this.isDestroyed, (Object)"Attempt to exec in destroyed container");
            try {
                ProcessOutput processOutput = this.runtime.execWithoutTty(command, workingDir, envVars);
                return processOutput;
            }
            finally {
                this.rwLock.readLock().unlock();
            }
        }

        public void removeContainer() {
            boolean isLockAcquired = false;
            try {
                isLockAcquired = this.rwLock.writeLock().tryLock(this.shutdownTimeout, TimeUnit.MILLISECONDS);
                if (!isLockAcquired) {
                    CidrDockerUtil.LOG.error("Cannot wait for finish process(es): " + this.runtime.getContainerId());
                }
                this.isDestroyed = true;
                this.runtime.removeContainer();
                if (CidrDockerUtil.LOG.isDebugEnabled()) {
                    CidrDockerUtil.LOG.debug("remove container: " + this.runtime.getContainerId());
                }
            }
            catch (InterruptedException e) {
                CidrDockerUtil.LOG.error((Throwable)e);
            }
            finally {
                if (isLockAcquired) {
                    this.rwLock.writeLock().unlock();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runtime";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envVars";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/docker/DockerExecutor$DockerApplicationRuntimeWrapper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "exec";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

