/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains.docker;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.connection.DockerConnectionConfigurator;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.DockerCliPresentationUtil;
import com.intellij.docker.remote.DockerCliTextField;
import com.intellij.docker.remote.DockerContainerSettings;
import com.intellij.docker.remote.DockerCredentialsHolder;
import com.intellij.docker.remote.DockerInterpreterContainerSettingsEditorDialog;
import com.intellij.docker.remote.run.runtime.DockerUtil;
import com.intellij.docker.ui.components.DockerComboWithAutoDetect;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.StatusPanel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUIUtils;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerBundle;
import com.jetbrains.cidr.cpp.toolchains.docker.CidrDockerUtil;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerHelperImpl;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerSettingsConfigurable;
import com.jetbrains.cidr.cpp.toolchains.ui.MiscKt;
import com.jetbrains.cidr.cpp.toolchains.ui.ToolchainPanel;
import com.jetbrains.cidr.cpp.ui.UIUtilKt;
import com.jetbrains.cidr.toolchains.OSType;
import com.jetbrains.cidr.toolchains.SettingsHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DockerCredentialsComponent
implements DockerSettingsConfigurable {
    private final ToolchainPanel myMainPanel;
    private final DockerComboWithAutoDetect myDockerServerCombo;
    private final SimpleColoredComponent myStatusField;
    private final JComboBox<String> myDockerImageCombo;
    @Nullable
    private Runnable myStateChangeListener;
    private final DockerContainerSettings myContainerSettings;
    private final DockerCliTextField myCliField;

    DockerCredentialsComponent(@NotNull ToolchainPanel mainPanel, @NotNull GridBag bag) {
        Application application;
        if (mainPanel == null) {
            DockerCredentialsComponent.$$$reportNull$$$0(0);
        }
        if (bag == null) {
            DockerCredentialsComponent.$$$reportNull$$$0(1);
        }
        this.myStatusField = MiscKt.createStatusField();
        this.myDockerImageCombo = new ComboBox();
        this.myCliField = new DockerCliTextField(){

            @NotNull
            protected Icon getDefaultIcon() {
                Icon icon = AllIcons.General.Gear;
                if (icon == null) {
                    1.$$$reportNull$$$0(0);
                }
                return icon;
            }

            @NotNull
            protected Icon getHoveredIcon() {
                Icon icon = AllIcons.General.GearHover;
                if (icon == null) {
                    1.$$$reportNull$$$0(1);
                }
                return icon;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/cidr/cpp/toolchains/docker/DockerCredentialsComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDefaultIcon";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHoveredIcon";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        this.myMainPanel = mainPanel;
        int nextTopInset = OSType.getCurrent() == OSType.WIN ? 12 : -1;
        JLabel dockerLabel = new JLabel(DockerBundle.message((String)"DockerCredentialsEditor.server.text", (Object[])new Object[0]));
        mainPanel.add((Component)dockerLabel, bag.nextLine().next().insetTop(nextTopInset));
        this.myDockerServerCombo = new DockerComboWithAutoDetect(server -> DockerCredentialsComponent.isDockerServerSupported(server));
        Disposer.register((Disposable)mainPanel, (Disposable)this.myDockerServerCombo);
        this.myDockerServerCombo.getButton().setIcon(AllIcons.General.GearPlain);
        mainPanel.add((Component)this.myDockerServerCombo, bag.next().coverLine().insetTop(nextTopInset));
        this.hideStatusPanel();
        mainPanel.add((Component)this.myStatusField, bag.nextLine().next().next().insets(0, -1, -1, -1));
        JLabel imageLabel = new JLabel(DockerBundle.message((String)"DockerTargetConfigurable.image.row.label", (Object[])new Object[0]));
        mainPanel.add((Component)imageLabel, bag.nextLine().next().insetTop(nextTopInset));
        mainPanel.add(this.myDockerImageCombo, bag.next().coverLine().insetTop(nextTopInset));
        this.myDockerServerCombo.addChangeListener(e -> {
            this.updateStatusPanel(this.myDockerServerCombo.getSelectedItem());
            this.updateDockerImagesCombo((RemoteServer<DockerCloudConfiguration>)this.myDockerServerCombo.getSelectedServer());
            this.notifyStateChanged();
        });
        this.myDockerServerCombo.getComboBox().addItemListener(e -> {
            this.updateStatusPanel(this.myDockerServerCombo.getSelectedItem());
            this.updateDockerImagesCombo((RemoteServer<DockerCloudConfiguration>)this.myDockerServerCombo.getSelectedServer());
            this.notifyStateChanged();
        });
        this.myDockerImageCombo.addItemListener(e -> this.notifyStateChanged());
        RemoteServer initItem = (RemoteServer)ContainerUtil.getFirstItem(DockerCredentialsComponent.getSupportedServers(RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance())));
        if (initItem != null) {
            this.myDockerServerCombo.selectServerInCombo(initItem.getName());
        }
        if ((application = ApplicationManager.getApplication()) != null) {
            application.getMessageBus().connect((Disposable)mainPanel).subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

                public void applicationActivated(@NotNull IdeFrame ideFrame) {
                    if (ideFrame == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    DockerCredentialsComponent.this.updateDockerImagesCombo((RemoteServer<DockerCloudConfiguration>)DockerCredentialsComponent.this.myDockerServerCombo.getSelectedServer());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/jetbrains/cidr/cpp/toolchains/docker/DockerCredentialsComponent$2", "applicationActivated"));
                }
            });
        }
        this.myCliField.setEditable(false);
        this.myContainerSettings = DockerContainerSettings.defaultSettings((int)2);
        JLabel settingsLabel = new JLabel(DockerBundle.message((String)"DockerContainer.settings", (Object[])new Object[0]));
        mainPanel.add((Component)settingsLabel, bag.nextLine().next().insetTop(nextTopInset));
        mainPanel.add((Component)this.myCliField, bag.next().coverLine().insetTop(nextTopInset));
        this.setCliOptionsText();
        this.myCliField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerCredentialsComponent.this.showContainerSettingsEditor();
            }
        });
        boolean isOptionsEnabled = CidrDockerUtil.isContainerOptionsEnabled();
        settingsLabel.setVisible(isOptionsEnabled);
        this.myCliField.setVisible(isOptionsEnabled);
    }

    private void showContainerSettingsEditor() {
        RemoteServer server = this.myDockerServerCombo.getSelectedServer();
        DockerInterpreterContainerSettingsEditorDialog dialog2 = new DockerInterpreterContainerSettingsEditorDialog(server, this.myContainerSettings);
        if (dialog2.showAndGet()) {
            this.setCliOptionsText();
        }
    }

    private void setCliOptionsText() {
        List options = DockerCliPresentationUtil.toCliPresentationOptions((DockerContainerSettings)this.myContainerSettings);
        this.myCliField.setText(StringUtil.join((Collection)options, (String)" "));
        this.myCliField.setSplittedText(options);
    }

    @Override
    public void reset(@Nullable SettingsHandler settings2) {
        if (settings2 != null) {
            this.resetInternal(DockerHelperImpl.check(settings2));
            return;
        }
        if (this.myDockerServerCombo.getSelectedServer() == null) {
            this.myDockerServerCombo.selectServerInCombo(null);
        }
    }

    private void resetInternal(@NotNull DockerHelperImpl.CidrDockerSettingsHandler handler2) {
        if (handler2 == null) {
            DockerCredentialsComponent.$$$reportNull$$$0(2);
        }
        DockerCredentialsHolder credentials = handler2.getDockerCredentials();
        this.myDockerServerCombo.selectServerInCombo(credentials.getAccountName());
        this.updateDockerImagesCombo((RemoteServer<DockerCloudConfiguration>)this.myDockerServerCombo.getSelectedServer(), StringUtil.nullize((String)credentials.getImageName()));
        DockerContainerSettings settings2 = handler2.getContainerSettings();
        if (settings2 != null) {
            settings2.copyTo(this.myContainerSettings);
        }
        this.setCliOptionsText();
    }

    @Override
    public boolean isModified(@NotNull SettingsHandler settings2) {
        if (settings2 == null) {
            DockerCredentialsComponent.$$$reportNull$$$0(3);
        }
        return !Objects.equals(this.getSelectedSettings(), settings2);
    }

    @Override
    @NotNull
    public SettingsHandler getSelectedSettings() {
        DockerComboWithAutoDetect.DockerServerItem server = this.myDockerServerCombo.getSelectedItem();
        String serverName = server == null ? null : server.getServerName();
        String imageName = StringUtil.notNullize((String)((String)this.myDockerImageCombo.getSelectedItem()));
        DockerCredentialsHolder result2 = new DockerCredentialsHolder(serverName, imageName, null, null);
        return new DockerHelperImpl.CidrDockerSettingsHandler(result2, this.myContainerSettings);
    }

    @Override
    public void setStateChangeListener(@Nullable Runnable listener2) {
        this.myStateChangeListener = listener2;
    }

    private void notifyStateChanged() {
        Runnable listener2 = this.myStateChangeListener;
        if (listener2 != null) {
            listener2.run();
        }
    }

    private void updateDockerImagesCombo(@Nullable RemoteServer<DockerCloudConfiguration> server) {
        this.updateDockerImagesCombo(server, null);
    }

    private void updateDockerImagesCombo(@Nullable RemoteServer<DockerCloudConfiguration> server, @Nullable @NlsSafe String imageToBeSelected) {
        if (server == null) {
            return;
        }
        if (imageToBeSelected != null) {
            ComboBoxModel<String> model = this.myDockerImageCombo.getModel();
            if (model == null || model.getSize() == 0) {
                this.myDockerImageCombo.setModel((ComboBoxModel<String>)new CollectionComboBoxModel(Collections.singletonList(imageToBeSelected)));
            }
            this.myDockerImageCombo.setSelectedItem(imageToBeSelected);
        }
        StatusPanel.Action listImagesAction = new StatusPanel().progress(DockerBundle.message((String)"DockerCredentialsEditor.listing.docker.images", (Object[])new Object[0]));
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                List images = DockerUtil.getNotTemplateImages((DockerCloudConfiguration)((DockerCloudConfiguration)server.getConfiguration()));
                ArrayList<String> collectedImages = new ArrayList<String>();
                for (String[] repoTags : images) {
                    collectedImages.addAll(Arrays.asList(repoTags));
                }
                listImagesAction.done();
                CidrDockerUtil.LOG.debug("Docker images collected: " + collectedImages);
                UIUtil.invokeLaterIfNeeded(() -> {
                    CidrDockerUtil.LOG.debug("Populating Docker images combo box: " + collectedImages);
                    @NlsSafe String imageName = imageToBeSelected != null ? imageToBeSelected : (String)this.myDockerImageCombo.getSelectedItem();
                    this.myDockerImageCombo.setModel((ComboBoxModel<String>)new CollectionComboBoxModel(collectedImages));
                    if (imageName != null) {
                        this.myDockerImageCombo.setSelectedItem(imageName);
                    }
                });
            }
            catch (ServerRuntimeException e) {
                listImagesAction.failed(e.getMessage());
            }
            finally {
                UIUtil.invokeLaterIfNeeded(() -> this.myMainPanel.markInitialized());
            }
        });
    }

    private void updateStatusPanel(@Nullable DockerComboWithAutoDetect.DockerServerItem selectedItem) {
        String serverName;
        String string = serverName = selectedItem == null ? null : selectedItem.getServerName();
        if (!DockerCredentialsComponent.isDockerServerSupported(serverName)) {
            this.showServerIsNotSupportedMessage();
        } else {
            this.hideStatusPanel();
        }
    }

    private void showServerIsNotSupportedMessage() {
        this.myStatusField.clear();
        this.myStatusField.setVisible(true);
        this.myStatusField.setIcon(UIUtilKt.getERROR_ICON());
        this.myStatusField.append(CidrDockerBundle.message("docker.message.server.not.supported", new Object[0]), CPPToolchainsUIUtils.getERROR_TEXT_ATTRIBUTES());
    }

    private void hideStatusPanel() {
        this.myStatusField.setVisible(false);
    }

    @NotNull
    private static List<RemoteServer<DockerCloudConfiguration>> getSupportedServers(@NotNull List<RemoteServer<DockerCloudConfiguration>> servers) {
        if (servers == null) {
            DockerCredentialsComponent.$$$reportNull$$$0(4);
        }
        List list2 = ContainerUtil.filter(servers, s -> DockerCredentialsComponent.isDockerServerSupported(s));
        if (list2 == null) {
            DockerCredentialsComponent.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private static boolean isDockerServerSupported(@Nullable String serverName) {
        if (serverName == null) {
            return false;
        }
        RemoteServer server = RemoteServersManager.getInstance().findByName(serverName, (ServerType)DockerCloudType.getInstance());
        return server != null && DockerCredentialsComponent.isDockerServerSupported(server);
    }

    private static boolean isDockerServerSupported(@NotNull RemoteServer<?> server) {
        ServerConfiguration configuration2;
        if (server == null) {
            DockerCredentialsComponent.$$$reportNull$$$0(6);
        }
        if ((configuration2 = server.getConfiguration()) instanceof DockerCloudConfiguration) {
            DockerCloudConfiguration dockerCloudConfiguration = (DockerCloudConfiguration)configuration2;
            String configuratorId = dockerCloudConfiguration.getCustomConfiguratorId();
            return dockerCloudConfiguration.hasLocalConnectionConfig() || DockerConnectionConfigurator.isWsl((String)configuratorId);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainPanel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servers";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/docker/DockerCredentialsComponent";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/docker/DockerCredentialsComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedServers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetInternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isModified";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedServers";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDockerServerSupported";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

