/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.EnvironmentReader;
import com.jetbrains.cidr.cpp.toolchains.HostMachineAwareEnvironmentReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0006J6\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00062\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\tR>\u0010\u0003\u001a2\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\t0\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/CachingEnvironmentReaderService;", "", "()V", "cache", "", "Lkotlin/Pair;", "Lcom/jetbrains/cidr/cpp/toolchains/EnvironmentReader;", "", "Ljava/nio/file/attribute/FileTime;", "", "getModifiedTime", "reader", "file", "invalidate", "", "readEnvironment", "parentEnvironment", "Companion", "intellij.clion.toolchains"})
public final class CachingEnvironmentReaderService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Pair<EnvironmentReader, String>, Pair<FileTime, Map<String, String>>> cache = new ConcurrentHashMap();
    private static final FileTime INVALID_TS = FileTime.fromMillis(0L);

    @NotNull
    public final Map<String, String> readEnvironment(@NotNull String file, @NotNull EnvironmentReader reader, @NotNull Map<String, String> parentEnvironment) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter(parentEnvironment, (String)"parentEnvironment");
        Pair readerToPath = TuplesKt.to((Object)reader, (Object)file);
        FileTime timestamp = this.getModifiedTime(reader, file);
        Pair pair = this.cache.compute((Pair<EnvironmentReader, String>)readerToPath, (arg_0, arg_1) -> CachingEnvironmentReaderService.readEnvironment$lambda$0((Function2)new Function2<Pair<? extends EnvironmentReader, ? extends String>, Pair<? extends FileTime, ? extends Map<String, ? extends String>>, Pair<? extends FileTime, ? extends Map<String, ? extends String>>>(timestamp, reader, file, parentEnvironment){
            final /* synthetic */ FileTime $timestamp;
            final /* synthetic */ EnvironmentReader $reader;
            final /* synthetic */ String $file;
            final /* synthetic */ Map<String, String> $parentEnvironment;
            {
                this.$timestamp = $timestamp;
                this.$reader = $reader;
                this.$file = $file;
                this.$parentEnvironment = $parentEnvironment;
                super(2);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Nullable
            public final Pair<FileTime, Map<String, String>> invoke(@NotNull Pair<? extends EnvironmentReader, String> pair, @Nullable Pair<FileTime, ? extends Map<String, String>> value) {
                Pair pair2;
                Intrinsics.checkNotNullParameter(pair, (String)"<anonymous parameter 0>");
                if (!Intrinsics.areEqual((Object)this.$timestamp, (Object)CachingEnvironmentReaderService.access$getINVALID_TS$cp())) {
                    Pair pair3 = value;
                    if (Intrinsics.areEqual((Object)(pair3 != null ? (FileTime)pair3.getFirst() : null), (Object)this.$timestamp)) {
                        pair2 = value;
                        return pair2;
                    }
                }
                pair2 = TuplesKt.to((Object)this.$timestamp, this.$reader.readEnvironmentFile(this.$file, this.$parentEnvironment));
                return pair2;
            }
        }, arg_0, arg_1));
        Intrinsics.checkNotNull((Object)pair);
        return (Map)pair.getSecond();
    }

    public final void invalidate(@NotNull String file, @NotNull EnvironmentReader reader) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.cache.remove(TuplesKt.to((Object)reader, (Object)file));
    }

    private final FileTime getModifiedTime(EnvironmentReader reader, String file) {
        FileTime fileTime;
        if (!AdvancedSettings.Companion.getBoolean("clion.toolchains.enable.environment.file.cache")) {
            FileTime fileTime2 = INVALID_TS;
            Intrinsics.checkNotNullExpressionValue((Object)fileTime2, (String)"INVALID_TS");
            return fileTime2;
        }
        if (reader instanceof HostMachineAwareEnvironmentReader) {
            Path path = ((HostMachineAwareEnvironmentReader)reader).getHostMachine().getPath(file, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
            Path path2 = path;
            FileTime fileTime3 = Files.exists(path2, new LinkOption[0]) ? Files.getLastModifiedTime(path2, new LinkOption[0]) : INVALID_TS;
            Intrinsics.checkNotNull((Object)fileTime3);
            fileTime = fileTime3;
        } else {
            FileTime fileTime4 = INVALID_TS;
            fileTime = fileTime4;
            Intrinsics.checkNotNullExpressionValue((Object)fileTime4, (String)"INVALID_TS");
        }
        return fileTime;
    }

    private static final Pair readEnvironment$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Pair)$tmp0.invoke(p0, p1);
    }

    @JvmStatic
    public static final void invalidate(@Nullable String toolchainName2) {
        Companion.invalidate(toolchainName2);
    }

    public static final /* synthetic */ FileTime access$getINVALID_TS$cp() {
        return INVALID_TS;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/cpp/toolchains/CachingEnvironmentReaderService$Companion;", "", "()V", "INVALID_TS", "Ljava/nio/file/attribute/FileTime;", "kotlin.jvm.PlatformType", "invalidate", "", "toolchainName", "", "intellij.clion.toolchains"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void invalidate(@Nullable String toolchainName2) {
            CPPToolchains.Toolchain toolchain;
            CPPToolchains.Toolchain toolchain2 = toolchain = CPPToolchains.getInstance().getToolchainByNameOrDefault(toolchainName2);
            if ((toolchain2 != null ? toolchain2.getEnvironment() : null) != null) {
                new CPPEnvironment(toolchain).invalidateEnvironmentCache();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

