/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.Cygwin;
import com.jetbrains.cidr.cpp.toolchains.MSVC;
import com.jetbrains.cidr.cpp.toolchains.MinGW;
import com.jetbrains.cidr.cpp.toolchains.NativeUnixToolSet;
import com.jetbrains.cidr.cpp.toolchains.NativeWindowsToolchain;
import com.jetbrains.cidr.cpp.toolchains.WSL;
import com.jetbrains.cidr.cpp.toolchains.docker.DockerHelper;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public final class CPPToolSetFactory {
    @NotNull
    public static CPPToolSet create(CPPToolSet.Kind kind) {
        CPPToolSet cPPToolSet = switch (kind) {
            case CPPToolSet.Kind.SYSTEM_UNIX_TOOLSET -> NativeUnixToolSet.LOCAL;
            case CPPToolSet.Kind.SSH -> NativeUnixToolSet.REMOTE;
            case CPPToolSet.Kind.DOCKER -> DockerHelper.getInstance().createDockerToolSet(kind);
            case CPPToolSet.Kind.SYSTEM_WINDOWS_TOOLSET -> NativeWindowsToolchain.INSTANCE;
            default -> throw new RuntimeException("Add creation support for " + kind);
        };
        if (cPPToolSet == null) {
            CPPToolSetFactory.$$$reportNull$$$0(0);
        }
        return cPPToolSet;
    }

    @NotNull
    public static CPPToolSet create(CPPToolSet.Kind kind, @NotNull String toolSet) {
        if (toolSet == null) {
            CPPToolSetFactory.$$$reportNull$$$0(1);
        }
        CPPToolSet cPPToolSet = switch (kind) {
            case CPPToolSet.Kind.MSVC -> new MSVC(new File(toolSet));
            case CPPToolSet.Kind.MINGW -> new MinGW(new File(toolSet));
            case CPPToolSet.Kind.CYGWIN -> new Cygwin(new File(toolSet));
            case CPPToolSet.Kind.WSL -> new WSL(toolSet);
            default -> throw new RuntimeException("Add creation support for " + kind);
        };
        if (cPPToolSet == null) {
            CPPToolSetFactory.$$$reportNull$$$0(2);
        }
        return cPPToolSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSetFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolSetFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

