/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.remote;

import com.intellij.openapi.util.InvalidDataException;
import com.jetbrains.cidr.cpp.execution.debugger.CLionDebuggerKind;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0004\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerData;", "", "kind", "Lcom/jetbrains/cidr/cpp/execution/debugger/CLionDebuggerKind;", "(Lcom/jetbrains/cidr/cpp/execution/debugger/CLionDebuggerKind;)V", "isGDB", "", "()Z", "isLLDB", "getKind", "()Lcom/jetbrains/cidr/cpp/execution/debugger/CLionDebuggerKind;", "setKind", "fromData", "debuggerKind", "", "isBundled", "toolchainName", "path", "fromDataV0", "element", "Lorg/jdom/Element;", "fromDataV1", "getOrCreateDebuggerToolchain", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain;", "readExternal", "", "writeExternal", "intellij.clion.execution"})
public final class DebuggerData {
    @NotNull
    private CLionDebuggerKind kind;

    public DebuggerData(@NotNull CLionDebuggerKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        this.kind = kind;
    }

    @NotNull
    public final CLionDebuggerKind getKind() {
        return this.kind;
    }

    public final void setKind(@NotNull CLionDebuggerKind cLionDebuggerKind) {
        Intrinsics.checkNotNullParameter((Object)cLionDebuggerKind, (String)"<set-?>");
        this.kind = cLionDebuggerKind;
    }

    public final void writeExternal(@NotNull Element element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        element2.setAttribute("version", "1");
        Element debugger = new Element("debugger");
        CLionDebuggerKind kind = this.kind;
        if (Intrinsics.areEqual((Object)kind, (Object)CLionDebuggerKind.Bundled.GDB.INSTANCE)) {
            debugger.setAttribute("kind", "GDB");
            debugger.setAttribute("isBundled", "true");
        } else if (Intrinsics.areEqual((Object)kind, (Object)CLionDebuggerKind.Bundled.LLDB.INSTANCE)) {
            debugger.setAttribute("kind", "LLDB");
            debugger.setAttribute("isBundled", "true");
        } else if (kind instanceof CLionDebuggerKind.Custom.ToolchainOriginated) {
            debugger.setAttribute("toolchainName", ((CLionDebuggerKind.Custom.ToolchainOriginated)kind).getToolchain().getName());
        } else if (kind instanceof CLionDebuggerKind.Custom.AdHocSpecified) {
            debugger.setAttribute("kind", "GDB");
            debugger.setText(((CLionDebuggerKind.Custom.AdHocSpecified)kind).getPath());
        }
        element2.addContent(debugger);
    }

    public final void readExternal(@NotNull Element element2) {
        CLionDebuggerKind cLionDebuggerKind;
        int version;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Object object = element2.getAttributeValue("version");
        int n = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : (version = 0);
        if (version == 1) {
            cLionDebuggerKind = this.fromDataV1(element2);
            if (cLionDebuggerKind == null) {
                return;
            }
        } else {
            cLionDebuggerKind = this.fromDataV0(element2);
        }
        this.kind = cLionDebuggerKind;
    }

    private final CLionDebuggerKind fromDataV1(Element element2) {
        Element element3 = element2.getChild("debugger");
        if (element3 == null) {
            return null;
        }
        Element debugger = element3;
        String debuggerKind = debugger.getAttributeValue("kind");
        boolean isBundled = debugger.getAttributeBooleanValue("isBundled");
        String toolchainName2 = debugger.getAttributeValue("toolchainName");
        String path = debugger.getText();
        return this.fromData(debuggerKind, isBundled, toolchainName2, path);
    }

    private final CLionDebuggerKind fromDataV0(Element element2) {
        String path = element2.getAttributeValue("debugger");
        String toolchainName2 = element2.getAttributeValue("toolchainName");
        boolean isBundled = path == null;
        return this.fromData("GDB", isBundled, toolchainName2, path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final CLionDebuggerKind fromData(String debuggerKind, boolean isBundled, String toolchainName2, String path) {
        CPPToolchains.Toolchain toolchain;
        if (debuggerKind != null) {
            CLionDebuggerKind cLionDebuggerKind;
            String string = debuggerKind;
            if (Intrinsics.areEqual((Object)string, (Object)"GDB")) {
                boolean bl = isBundled;
                if (bl) {
                    cLionDebuggerKind = CLionDebuggerKind.Bundled.GDB.INSTANCE;
                    return cLionDebuggerKind;
                } else {
                    if (bl) throw new NoWhenBranchMatchedException();
                    String string2 = path;
                    if (string2 == null) {
                        string2 = "";
                    }
                    cLionDebuggerKind = new CLionDebuggerKind.Custom.AdHocSpecified(string2);
                }
                return cLionDebuggerKind;
            } else {
                if (!Intrinsics.areEqual((Object)string, (Object)"LLDB")) throw new InvalidDataException("Unknown debugger kind");
                cLionDebuggerKind = CLionDebuggerKind.Bundled.LLDB.INSTANCE;
            }
            return cLionDebuggerKind;
        }
        if (toolchainName2 == null || (toolchain = CPPToolchains.getInstance().getToolchainByNameOrDefault(toolchainName2)) == null) return CLionDebuggerKind.Bundled.GDB.INSTANCE;
        return new CLionDebuggerKind.Custom.ToolchainOriginated(toolchain);
    }

    @NotNull
    public final CPPToolchains.Toolchain getOrCreateDebuggerToolchain() {
        return CLionDebuggerKind.getOrCreateDebuggerToolchain$default(this.kind, null, 1, null);
    }

    public final boolean isLLDB() {
        boolean bl;
        CLionDebuggerKind kind = this.kind;
        if (Intrinsics.areEqual((Object)kind, (Object)CLionDebuggerKind.Bundled.GDB.INSTANCE)) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)kind, (Object)CLionDebuggerKind.Bundled.LLDB.INSTANCE)) {
            bl = true;
        } else if (kind instanceof CLionDebuggerKind.Custom.ToolchainOriginated) {
            bl = ((CLionDebuggerKind.Custom.ToolchainOriginated)kind).getToolchain().getDebuggerKind().isLLDB();
        } else if (kind instanceof CLionDebuggerKind.Custom.AdHocSpecified) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public final boolean isGDB() {
        return !this.isLLDB();
    }
}

