/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver.remote;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.channels.SftpChannel;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.util.PathUtil;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbServerLauncher;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbServerRunConfiguration;
import com.jetbrains.cidr.cpp.execution.gdbserver.remote.RemoteGdbServerRunConfiguration;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.system.RemoteUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteGdbServerLauncher
extends GdbServerLauncher {
    public RemoteGdbServerLauncher(@NotNull ExecutionEnvironment executionEnvironment, @NotNull RemoteGdbServerRunConfiguration configuration2, @NotNull CPPToolchains.Toolchain debuggerToolchain) {
        if (executionEnvironment == null) {
            RemoteGdbServerLauncher.$$$reportNull$$$0(0);
        }
        if (configuration2 == null) {
            RemoteGdbServerLauncher.$$$reportNull$$$0(1);
        }
        if (debuggerToolchain == null) {
            RemoteGdbServerLauncher.$$$reportNull$$$0(2);
        }
        super(executionEnvironment, configuration2, debuggerToolchain);
    }

    @Override
    @Nullable
    protected String getGdbServerParameters(@NotNull GdbServerRunConfiguration configuration2) {
        String programParameters;
        if (configuration2 == null) {
            RemoteGdbServerLauncher.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(programParameters = configuration2.getProgramParameters())) && configuration2 instanceof RemoteGdbServerRunConfiguration) {
            return ((RemoteGdbServerRunConfiguration)configuration2).getDefaultGdbServerArgs();
        }
        return programParameters;
    }

    @Override
    protected void prepareSymbolFile(@NotNull String filePath, @NotNull GdbServerRunConfiguration configuration2) throws ExecutionException {
        RemoteGdbServerRunConfiguration remoteConfiguration;
        if (filePath == null) {
            RemoteGdbServerLauncher.$$$reportNull$$$0(4);
        }
        if (configuration2 == null) {
            RemoteGdbServerLauncher.$$$reportNull$$$0(5);
        }
        if (!this.haveToBeDownloaded((remoteConfiguration = (RemoteGdbServerRunConfiguration)configuration2).getDownloadType(), new File(filePath))) {
            return;
        }
        String sshConfigName = remoteConfiguration.getSshConfigName();
        if (sshConfigName == null) {
            throw new ExecutionException(CLionExecutionBundle.message("dialog.message.credentials.are.not.valid", new Object[0]));
        }
        String uploadFilePath = remoteConfiguration.getUploadFile();
        assert (uploadFilePath != null);
        if (!uploadFilePath.contains("/")) {
            throw new ExecutionException(CLionExecutionBundle.message("dialog.message.upload.path.empty", new Object[0]));
        }
        SshConfig sshConfig = SshConfigManager.getInstance((Project)this.getProject()).findConfigByName(sshConfigName);
        RemoteCredentials credentials = RemoteUtil.toCredentials(sshConfig);
        if (credentials == null || !RemoteUtil.checkConnection(credentials)) {
            throw new ExecutionException(CLionExecutionBundle.message("dialog.message.cannot.connect.to.remote.host", new Object[0]));
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            try (SftpChannel channel2 = RemoteUtil.createConnectionBuilder(credentials, indicator).openFailSafeSftpChannel(10000);){
                channel2.uploadFileOrDir(new File(filePath), PathUtil.getParentPath((String)uploadFilePath), PathUtil.getFileName((String)uploadFilePath));
            }
            catch (Exception e) {
                throw new ExecutionException((Throwable)e);
            }
            RemoteUtil.setExecutable(credentials, uploadFilePath, indicator);
            return null;
        }, CLionExecutionBundle.message("remote.gdbserver.upload.executable.dialog.text", new Object[0]), true, this.getProject());
    }

    @Override
    protected BaseProcessHandler<?> createGdbServerProcess(@NotNull GeneralCommandLine gdbServerCommandLine) throws ExecutionException {
        if (gdbServerCommandLine == null) {
            RemoteGdbServerLauncher.$$$reportNull$$$0(6);
        }
        RemoteGdbServerRunConfiguration configuration2 = (RemoteGdbServerRunConfiguration)this.getConfiguration();
        String sshConfigName = configuration2.getSshConfigName();
        assert (sshConfigName != null);
        SshConfig sshConfig = SshConfigManager.getInstance((Project)this.getProject()).findConfigByName(sshConfigName);
        RemoteCredentials credentials = RemoteUtil.toCredentials(sshConfig);
        assert (credentials != null);
        if (StringUtil.isEmpty((String)gdbServerCommandLine.getExePath())) {
            gdbServerCommandLine.setExePath("/usr/bin/gdbserver");
        }
        return RemoteUtil.createRemoteProcess(credentials).withPty(true).withElevated(this.getConfiguration().isElevated()).build(gdbServerCommandLine);
    }

    @Override
    @Nullable
    protected String getWorkingDirectory(@NotNull XDebugSession session, String executable) {
        if (session == null) {
            RemoteGdbServerLauncher.$$$reportNull$$$0(7);
        }
        RemoteGdbServerRunConfiguration configuration2 = (RemoteGdbServerRunConfiguration)this.getConfiguration();
        String uploadFile = configuration2.getUploadFile();
        String workingDirectory = configuration2.getWorkingDirectory();
        if (StringUtil.isEmpty((String)workingDirectory) && uploadFile != null) {
            return PathUtil.getParentPath((String)uploadFile);
        }
        return super.getWorkingDirectory(session, executable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionEnvironment";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerToolchain";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gdbServerCommandLine";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/gdbserver/remote/RemoteGdbServerLauncher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getGdbServerParameters";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareSymbolFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "createGdbServerProcess";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getWorkingDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

