/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets;

import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTarget;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.DebugTargetParameters;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.GenericDebugTarget;
import com.jetbrains.cidr.cpp.execution.gdbserver.debugtargets.NativeDebugTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R&\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00128B@BX\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006!"}, d2={"Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTarget;", "selectedDebugTarget", "getSelectedDebugTarget", "()Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTarget;", "setSelectedDebugTarget", "(Lcom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTarget;)V", "", "selectedDebugTargetName", "getSelectedDebugTargetName", "()Ljava/lang/String;", "setSelectedDebugTargetName", "(Ljava/lang/String;)V", "targetPlatforms", "", "getTargetPlatforms", "()Ljava/util/List;", "dispose", "", "getTargetsFor", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "intellij.clion.execution"})
@SourceDebugExtension(value={"SMAP\nDebugTargetService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DebugTargetService.kt\ncom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n766#2:105\n857#2,2:106\n1603#2,9:108\n1855#2:117\n1856#2:120\n1612#2:121\n1855#2,2:122\n288#2,2:124\n14#3:118\n1#4:119\n*S KotlinDebug\n*F\n+ 1 DebugTargetService.kt\ncom/jetbrains/cidr/cpp/execution/gdbserver/debugtargets/DebugTargetService\n*L\n30#1:105\n30#1:106,2\n36#1:108,9\n36#1:117\n36#1:120\n36#1:121\n40#1:122,2\n61#1:124,2\n36#1:118\n36#1:119\n*E\n"})
public final class DebugTargetService
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private String selectedDebugTargetName;

    public DebugTargetService(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.selectedDebugTargetName = "";
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    public void dispose() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DebugTarget> getTargetsFor(@NotNull RunConfiguration runConfiguration) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Iterable $this$filter$iv = this.getTargetPlatforms();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DebugTarget it = (DebugTarget)element$iv$iv;
            boolean bl = false;
            if (!it.canRun(runConfiguration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DebugTarget> getTargetPlatforms() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = RunManager.Companion.getInstance(this.project).getAllConfigurationsList();
        boolean $i$f$mapNotNull22 = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DebugTargetParameters it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RunConfiguration it = (RunConfiguration)element$iv$iv;
            boolean bl2 = false;
            RunConfiguration $this$asSafely$iv = it;
            boolean $i$f$asSafely = false;
            RunConfiguration runConfiguration = $this$asSafely$iv;
            if (!(runConfiguration instanceof DebugTargetParameters)) {
                runConfiguration = null;
            }
            if ((DebugTargetParameters)runConfiguration == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        LinkedHashSet configurations2 = (LinkedHashSet)CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)new LinkedHashSet());
        Object[] $i$f$mapNotNull22 = new DebugTarget[]{NativeDebugTarget.INSTANCE};
        List result2 = CollectionsKt.mutableListOf((Object[])$i$f$mapNotNull22);
        Iterable $this$forEach$iv = configurations2;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            DebugTargetParameters it = (DebugTargetParameters)element$iv;
            boolean bl = false;
            result2.add(new GenericDebugTarget(it));
        }
        return result2;
    }

    private final String getSelectedDebugTargetName() {
        if (Intrinsics.areEqual((Object)this.selectedDebugTargetName, (Object)"")) {
            String string = PropertiesComponent.getInstance((Project)this.project).getValue("DEBUG_TARGETS_KEY", NativeDebugTarget.INSTANCE.getId());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            this.selectedDebugTargetName = string;
        }
        return this.selectedDebugTargetName;
    }

    private final void setSelectedDebugTargetName(String value) {
        if (!Intrinsics.areEqual((Object)this.selectedDebugTargetName, (Object)value)) {
            this.selectedDebugTargetName = value;
            PropertiesComponent.getInstance((Project)this.project).setValue("DEBUG_TARGETS_KEY", value);
        }
    }

    @NotNull
    public final DebugTarget getSelectedDebugTarget() {
        DebugTarget debugTarget;
        Object v0;
        block3: {
            if (!AdvancedSettings.Companion.getBoolean("clion.debug.targets.enabled")) {
                return NativeDebugTarget.INSTANCE;
            }
            Iterable $this$firstOrNull$iv = this.getTargetPlatforms();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DebugTarget it = (DebugTarget)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.getSelectedDebugTargetName())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if ((debugTarget = (DebugTarget)v0) == null) {
            debugTarget = NativeDebugTarget.INSTANCE;
        }
        return debugTarget;
    }

    public final void setSelectedDebugTarget(@NotNull DebugTarget value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.setSelectedDebugTargetName(value.getId());
    }
}

