/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.gdbserver;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.gdbserver.GdbServerRunConfiguration;
import java.io.File;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Utils {
    @NotNull
    static final Key<Long> DOWNLOAD_LOAD_COUNT_KEY = new Key(GdbServerRunConfiguration.class.getName() + "#LAST_DOWNLOAD_MOD_COUNT");

    private Utils() {
    }

    public static int readIntAttr(@Nullable Element element2, @NotNull String name2, int def) {
        if (name2 == null) {
            Utils.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            return def;
        }
        String s = element2.getAttributeValue(name2);
        if (StringUtil.isEmpty((String)s)) {
            return def;
        }
        try {
            return Integer.parseUnsignedInt(s);
        }
        catch (NumberFormatException e) {
            Logger.getInstance(Utils.class).warn((Throwable)e);
            return def;
        }
    }

    @NotNull
    public static <T extends Enum> T readEnumAttr(@Nullable Element element2, String name2, T def) {
        Object e;
        if (element2 == null) {
            T t = def;
            if (t == null) {
                Utils.$$$reportNull$$$0(1);
            }
            return t;
        }
        String s = element2.getAttributeValue(name2);
        if (StringUtil.isEmpty((String)s)) {
            T t = def;
            if (t == null) {
                Utils.$$$reportNull$$$0(2);
            }
            return t;
        }
        try {
            e = Enum.valueOf(def.getDeclaringClass(), s);
        }
        catch (Throwable t) {
            T t2 = def;
            if (t2 == null) {
                Utils.$$$reportNull$$$0(4);
            }
            return t2;
        }
        if (e == null) {
            Utils.$$$reportNull$$$0(3);
        }
        return (T)e;
    }

    @NotNull
    public static String toBeautyString(@NotNull String obj) {
        if (obj == null) {
            Utils.$$$reportNull$$$0(5);
        }
        String lowerCase = StringUtil.toLowerCase((String)obj);
        String string = StringUtil.toTitleCase((String)lowerCase.replace('_', ' '));
        if (string == null) {
            Utils.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static void checkPort(int port) throws RuntimeConfigurationException {
        if (port <= 1024 || port > 65535) {
            throw new RuntimeConfigurationException(CLionExecutionBundle.message("port.value.must.be.in.range", new Object[0]));
        }
    }

    public static boolean isLatestUploaded(@NotNull File runFile) {
        if (runFile == null) {
            Utils.$$$reportNull$$$0(7);
        }
        VirtualFile vRunFile = VfsUtil.findFileByIoFile((File)runFile, (boolean)true);
        Long latestDownloadModCount = (Long)DOWNLOAD_LOAD_COUNT_KEY.get((UserDataHolder)vRunFile);
        return vRunFile != null && Objects.equals(latestDownloadModCount, vRunFile.getModificationCount());
    }

    public static void markDownloaded(@NotNull File file) {
        VirtualFile vFile;
        if (file == null) {
            Utils.$$$reportNull$$$0(8);
        }
        if ((vFile = VfsUtil.findFileByIoFile((File)file, (boolean)true)) != null) {
            DOWNLOAD_LOAD_COUNT_KEY.set((UserDataHolder)vFile, (Object)vFile.getModificationCount());
        }
    }

    public static void markDownloaded(VirtualFile file) {
        DOWNLOAD_LOAD_COUNT_KEY.set((UserDataHolder)file, (Object)file.getModificationCount());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/gdbserver/Utils";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/gdbserver/Utils";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "readEnumAttr";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toBeautyString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readIntAttr";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toBeautyString";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isLatestUploaded";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "markDownloaded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

