/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.peripheralview;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdField;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdFile;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdNode;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdRoot;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdTreeTable;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdValue;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="EmbeddedSvdWindowState", storages={@Storage(value="$WORKSPACE_FILE$")})
public class SvdWindowState
implements PersistentStateComponent<ProjectState> {
    private ProjectState projectState = new ProjectState();

    @Nullable
    public ProjectState getState() {
        return this.projectState;
    }

    public void loadState(@NotNull ProjectState projectState) {
        if (projectState == null) {
            SvdWindowState.$$$reportNull$$$0(0);
        }
        this.projectState = projectState;
    }

    @Nullable
    private static String calcState(TreeTableTree tree, TreePath treePath, SvdNode<?> svdNode) {
        char[] nodeState = new char[]{'-', 'O'};
        if (svdNode instanceof SvdValue) {
            SvdValue svdValue = (SvdValue)svdNode;
            if (svdValue instanceof SvdField && svdValue.getDefaultFormat() == svdValue.getFormat()) {
                return null;
            }
            nodeState[0] = svdValue.getFormat().getSign();
        }
        nodeState[1] = tree.isExpanded(treePath) ? 69 : 67;
        return new String(nodeState);
    }

    @NotNull
    public static ProjectState get(XDebugProcess process2) {
        SvdWindowState svdWindowState = (SvdWindowState)process2.getSession().getProject().getService(SvdWindowState.class);
        ProjectState projectState = svdWindowState.projectState;
        if (projectState == null) {
            SvdWindowState.$$$reportNull$$$0(1);
        }
        return projectState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectState";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdWindowState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdWindowState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    public static class ProjectState {
        @NotNull
        public final List<Integer> columnWidths = new ArrayList<Integer>(3);
        @NotNull
        public final List<String> columnOrder = new ArrayList<String>(3);
        @NotNull
        public final List<String> loadedFiles = new ArrayList<String>();
        @NotNull
        public final Map<String, String> nodes = new LinkedHashMap<String, String>();

        public void notifyColumnsChange(@NotNull SvdTreeTable treeTable) {
            if (treeTable == null) {
                ProjectState.$$$reportNull$$$0(0);
            }
            this.columnWidths.clear();
            this.columnOrder.clear();
            Enumeration<TableColumn> columns = treeTable.getColumnModel().getColumns();
            while (columns.hasMoreElements()) {
                TableColumn column = columns.nextElement();
                this.columnWidths.add(column.getWidth());
                this.columnOrder.add(column.getIdentifier().toString());
            }
        }

        public void notifyTreeNodeChanged(@NotNull SvdTreeTable treeTable, @NotNull TreePath treePath) {
            if (treeTable == null) {
                ProjectState.$$$reportNull$$$0(1);
            }
            if (treePath == null) {
                ProjectState.$$$reportNull$$$0(2);
            }
            SvdNode svdNode = (SvdNode)treePath.getLastPathComponent();
            String nodeState = SvdWindowState.calcState(treeTable.getTree(), treePath, svdNode);
            if (nodeState == null) {
                this.nodes.remove(svdNode.getId());
            } else {
                this.nodes.put(svdNode.getId(), nodeState);
            }
        }

        public void notifyTreeChange(@NotNull SvdTreeTable treeTable) {
            if (treeTable == null) {
                ProjectState.$$$reportNull$$$0(3);
            }
            SvdRoot svdRoot = treeTable.getRoot();
            this.loadedFiles.clear();
            LinkedHashSet<String> fileSet = new LinkedHashSet<String>();
            for (SvdFile svdFile : svdRoot.getChildren()) {
                fileSet.add(svdFile.getLocation());
            }
            this.loadedFiles.addAll(fileSet);
            this.nodes.clear();
            TreeTableTree tree = treeTable.getTree();
            for (TreePath treePath : TreeUtil.treePathTraverser((JTree)tree).traverse()) {
                String strNodeState;
                SvdNode svdNode = (SvdNode)treePath.getLastPathComponent();
                if (svdNode instanceof SvdRoot || !svdRoot.isActive(svdNode) || (strNodeState = SvdWindowState.calcState(tree, treePath, svdNode)) == null) continue;
                this.nodes.put(svdNode.getId(), strNodeState);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeTable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treePath";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdWindowState$ProjectState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyColumnsChange";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyTreeNodeChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notifyTreeChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

