/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.peripheralview;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdFile;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdNode;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdPeripheral;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdRegister;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdRoot;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class SvdShowHideDialog {
    private final SvdRoot mySvdRoot;
    private final Project myProject;
    private CheckboxTree myTree;
    private CheckedTreeNode myCheckedTreeRoot;
    private JComponent myToolbarComponent;

    public SvdShowHideDialog(@NotNull SvdRoot SvdRoot2, Project project) {
        if (SvdRoot2 == null) {
            SvdShowHideDialog.$$$reportNull$$$0(0);
        }
        this.mySvdRoot = SvdRoot2;
        this.myProject = project;
    }

    private void addCheckedFolder(CheckedTreeNode checkedParent, SvdNode<?> parent) {
        if (parent instanceof SvdRegister) {
            return;
        }
        List<?> children = parent.getChildren();
        for (SvdNode svdNode : children) {
            CheckedTreeNode checkedTreeNode = new CheckedTreeNode((Object)svdNode);
            checkedTreeNode.setChecked(this.mySvdRoot.isActive(svdNode));
            checkedParent.add((MutableTreeNode)checkedTreeNode);
            this.addCheckedFolder(checkedTreeNode, svdNode);
        }
    }

    public void showHideNodes() {
        this.myCheckedTreeRoot = new CheckedTreeNode((Object)this.mySvdRoot);
        this.addCheckedFolder(this.myCheckedTreeRoot, this.mySvdRoot);
        this.myTree = new CheckboxTree(new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.customizeRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
                this.getTextRenderer().append(1.nodeText(value));
            }

            @NlsSafe
            private static String nodeText(Object value) {
                return ((CheckedTreeNode)value).getUserObject().toString();
            }
        }, this.myCheckedTreeRoot){

            protected void installSpeedSearch() {
                TreeSpeedSearch.installOn((JTree)((Object)this), (boolean)true, treePath -> treePath.getLastPathComponent().toString());
            }
        };
        this.myTree.setSelectionRow(0);
        ((JBTreeTraverser)TreeUtil.treePathTraverser((JTree)this.myTree).filter(path -> !(((CheckedTreeNode)path.getLastPathComponent()).getUserObject() instanceof SvdPeripheral))).forEach(arg_0 -> this.myTree.expandPath(arg_0));
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        Rectangle bounds = ScreenUtil.getMainScreenBounds();
        scrollPane.setPreferredSize(new Dimension(bounds.width / 2, bounds.height * 3 / 4));
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        DumbAwareAction loadAction = new DumbAwareAction(CLionExecutionBundle.message("svd.load.file", new Object[0]), CLionExecutionBundle.message("svd.load.hardware.definitions.description", new Object[0]), AllIcons.General.Add){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                SvdShowHideDialog.this.loadFile();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdShowHideDialog$3", "actionPerformed"));
            }
        };
        ActionManager actionManager = ActionManager.getInstance();
        actionGroup2.add((AnAction)loadAction);
        actionGroup2.add((AnAction)new UnloadAction());
        StatusText emptyText = this.myTree.getEmptyText();
        emptyText.setText(CLionExecutionBundle.message("svd.no.registers.loaded", new Object[0]));
        emptyText.appendSecondaryText(CLionExecutionBundle.message("svd.load.file", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, e -> this.loadFile());
        DialogBuilder builder2 = new DialogBuilder();
        builder2.addCloseButton();
        builder2.setCenterPanel((JComponent)scrollPane);
        builder2.setTitle(CLionExecutionBundle.message("svd.select.peripherals.to.show", new Object[0]));
        builder2.setPreferredFocusComponent((JComponent)this.myTree);
        ActionToolbar toolbar = actionManager.createActionToolbar("toolbar", (ActionGroup)actionGroup2, true);
        toolbar.setTargetComponent((JComponent)this.myTree);
        this.myToolbarComponent = toolbar.getComponent();
        builder2.setNorthPanel(this.myToolbarComponent);
        builder2.setHelpId("toolwindows.peripheralview");
        if (this.mySvdRoot.getChildren().isEmpty()) {
            SwingUtilities.invokeLater(this::loadFile);
        }
        builder2.show();
        HashSet nodes = new HashSet();
        SvdShowHideDialog.findActive(nodes, this.myCheckedTreeRoot);
        this.mySvdRoot.setActive(nodes);
    }

    private void loadFile() {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, false, false, false, false).withFileFilter(file -> {
            String extension = file.getExtension();
            return "svd".equalsIgnoreCase(extension) || "xml".equalsIgnoreCase(extension);
        });
        VirtualFile file2 = FileChooser.chooseFile((FileChooserDescriptor)descriptor2, (Project)this.myProject, null);
        if (file2 != null) {
            try {
                String filePathName = file2.getPath();
                CheckedTreeNode foundFile = null;
                for (int i = 0; i < this.myCheckedTreeRoot.getChildCount() && foundFile == null; ++i) {
                    CheckedTreeNode fileCheckedNode = (CheckedTreeNode)this.myCheckedTreeRoot.getChildAt(i);
                    SvdFile svdFile = (SvdFile)fileCheckedNode.getUserObject();
                    if (!VfsUtilCore.pathEqualsTo((VirtualFile)file2, (String)svdFile.getLocation())) continue;
                    foundFile = fileCheckedNode;
                }
                if (foundFile != null) {
                    this.myTree.setSelectionPath(new TreePath(new Object[]{this.myCheckedTreeRoot, foundFile}));
                    PopupUtil.showBalloonForComponent((Component)this.myToolbarComponent, (String)CLionExecutionBundle.message("the.file.s.is.already.loaded", filePathName), (MessageType)MessageType.INFO, (boolean)false, null);
                    return;
                }
                SvdFile svdFile = this.mySvdRoot.addFile(file2.getInputStream(), file2.getName(), filePathName);
                CheckedTreeNode checkedFile = new CheckedTreeNode((Object)svdFile);
                this.addCheckedFolder(checkedFile, svdFile);
                this.myCheckedTreeRoot.add((MutableTreeNode)checkedFile);
                ((DefaultTreeModel)this.myTree.getModel()).nodesWereInserted((TreeNode)this.myCheckedTreeRoot, new int[]{this.myCheckedTreeRoot.getChildCount() - 1});
                TreePath filePath = new TreePath(new Object[]{this.myCheckedTreeRoot, checkedFile});
                ((JBTreeTraverser)((JBTreeTraverser)TreeUtil.treePathTraverser((JTree)this.myTree).filter(filePath::isDescendant)).filter(path -> !(((CheckedTreeNode)path.getLastPathComponent()).getUserObject() instanceof SvdPeripheral))).forEach(arg_0 -> this.myTree.expandPath(arg_0));
                this.myTree.setSelectionPath(filePath);
            }
            catch (IOException e) {
                Logger.getInstance(SvdShowHideDialog.class).error("Unexpected exception while reading " + file2.getCanonicalPath(), (Throwable)e);
            }
        }
    }

    private static boolean findActive(@NotNull HashSet<SvdNode<?>> nodes, @NotNull CheckedTreeNode parent) {
        if (nodes == null) {
            SvdShowHideDialog.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            SvdShowHideDialog.$$$reportNull$$$0(2);
        }
        SvdNode svdNode = (SvdNode)parent.getUserObject();
        boolean active = false;
        if (svdNode instanceof SvdRegister) {
            active = parent.isChecked();
        } else {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                active |= SvdShowHideDialog.findActive(nodes, (CheckedTreeNode)parent.getChildAt(i));
            }
        }
        if (active) {
            nodes.add(svdNode);
        }
        return active;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "SvdRoot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdShowHideDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findActive";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class UnloadAction
    extends AnAction
    implements DumbAware {
        private UnloadAction() {
            super(CLionExecutionBundle.messagePointer("svd.unload.action", new Object[0]), CLionExecutionBundle.messagePointer("svd.unload.action.description", new Object[0]), AllIcons.General.Remove);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            CheckedTreeNode checkedTreeNode;
            Object selected;
            TreePath path;
            if (e == null) {
                UnloadAction.$$$reportNull$$$0(0);
            }
            if ((path = SvdShowHideDialog.this.myTree.getSelectionPath()) != null && (selected = (checkedTreeNode = (CheckedTreeNode)path.getLastPathComponent()).getUserObject()) instanceof SvdFile) {
                int index = SvdShowHideDialog.this.myCheckedTreeRoot.getIndex((TreeNode)checkedTreeNode);
                SvdShowHideDialog.this.myCheckedTreeRoot.remove((MutableTreeNode)checkedTreeNode);
                SvdShowHideDialog.this.myTree.removeSelectionPath(path);
                ((DefaultTreeModel)SvdShowHideDialog.this.myTree.getModel()).nodesWereRemoved((TreeNode)SvdShowHideDialog.this.myCheckedTreeRoot, new int[]{index}, new Object[]{checkedTreeNode});
                SvdShowHideDialog.this.mySvdRoot.unloadFile((SvdFile)selected);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            TreePath path;
            if (e == null) {
                UnloadAction.$$$reportNull$$$0(1);
            }
            boolean fileSelected = (path = SvdShowHideDialog.this.myTree.getSelectionPath()) != null && ((CheckedTreeNode)path.getLastPathComponent()).getUserObject() instanceof SvdFile;
            e.getPresentation().setEnabled(fileSelected);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                UnloadAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdShowHideDialog$UnloadAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdShowHideDialog$UnloadAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

