/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.peripheralview;

import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.Format;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.RegisterAccess;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.RegisterReadAction;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdField;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdNode;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdRegisterClusterLevel;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdValue;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvdRegister
extends SvdValue<SvdField>
implements SvdRegisterClusterLevel<SvdField> {
    private static final Format DEFAULT_FORMAT = Format.HEX;
    private final Address myAddress;
    private volatile long value;
    @Nullable
    private volatile String failReason;

    public SvdRegister(@NotNull String peripheralName, @NotNull String name2, @NotNull String description, Address address, int bitSize, @NotNull RegisterAccess access, @Nullable RegisterReadAction readAction) {
        if (peripheralName == null) {
            SvdRegister.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            SvdRegister.$$$reportNull$$$0(1);
        }
        if (description == null) {
            SvdRegister.$$$reportNull$$$0(2);
        }
        if (access == null) {
            SvdRegister.$$$reportNull$$$0(3);
        }
        super(peripheralName + "|" + name2, name2, description, access, readAction, bitSize, DEFAULT_FORMAT);
        this.value = 0L;
        this.failReason = "-";
        this.myAddress = address;
        if (!this.getAccess().isReadable()) {
            this.markNoValue(CLionExecutionBundle.message("svd.write.only", new Object[0]), false);
        }
    }

    public Address getAddress() {
        return this.myAddress;
    }

    public void processValue(@Nullable List<LLMemoryHunk> hunks, @Nullable Throwable e) {
        if (e != null) {
            this.markNoValue(e.getLocalizedMessage(), !(e instanceof CancellationException));
        } else if (hunks == null) {
            this.markNoValue("-", true);
        } else {
            for (LLMemoryHunk hunk : hunks) {
                if (!hunk.getRange().contains(this.myAddress)) continue;
                int byteSize = (this.getBitSize() + 7) / 8;
                int offset = (int)this.myAddress.minus(hunk.getRange().getStart());
                long value = this.getValue(hunk, offset, byteSize);
                boolean bl = this.changed = this.value != value;
                if (this.changed) {
                    this.value = value;
                    for (SvdField field : this.getChildren()) {
                        field.updateFromValue(value);
                    }
                } else {
                    this.getChildren().forEach(SvdField::markStalled);
                }
                this.failReason = null;
                return;
            }
            this.markNoValue(CLionExecutionBundle.message("non.readable", new Object[0]), true);
        }
    }

    protected long getValue(LLMemoryHunk hunk, int offset, int byteSize) {
        long value = 0L;
        for (int i = byteSize - 1; i >= 0; --i) {
            value = value << 8 | 0xFFL & (long)((Byte)hunk.getBytes().get(offset + i)).byteValue();
        }
        return value;
    }

    public void markNoValue(@NotNull String reason, boolean valueChange) {
        if (reason == null) {
            SvdRegister.$$$reportNull$$$0(4);
        }
        this.changed = valueChange && !reason.equals(this.failReason);
        this.failReason = reason;
    }

    @Override
    @NotNull
    public String getDisplayValue() {
        String string = this.isFailed() ? this.failReason : this.getFormat().format(this.value, this.getBitSize());
        if (string == null) {
            SvdRegister.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isFailed() {
        return this.failReason != null;
    }

    @Override
    @NotNull
    public Format getDefaultFormat() {
        Format format = DEFAULT_FORMAT;
        if (format == null) {
            SvdRegister.$$$reportNull$$$0(6);
        }
        return format;
    }

    @Override
    public void exportCsv(@NotNull PrintWriter writer2, @NotNull String prefix, @NotNull Predicate<SvdNode<?>> predicateActive) {
        if (writer2 == null) {
            SvdRegister.$$$reportNull$$$0(7);
        }
        if (prefix == null) {
            SvdRegister.$$$reportNull$$$0(8);
        }
        if (predicateActive == null) {
            SvdRegister.$$$reportNull$$$0(9);
        }
        writer2.print(prefix);
        writer2.print(", ");
        writer2.print(this.getName());
        writer2.print(", ");
        writer2.print(this.getDisplayValue());
        if (!this.getChildren().isEmpty()) {
            writer2.print(", ");
            for (int i = 0; i < this.getChildren().size(); ++i) {
                SvdField field = (SvdField)this.getChildren().get(i);
                if (i > 0) {
                    writer2.print("; ");
                }
                writer2.print(field.getName());
                writer2.print(": ");
                writer2.print(field.getDisplayValue());
            }
        }
        writer2.println();
    }

    @Override
    public long getStartAddress() {
        return this.myAddress.getUnsignedLongValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "peripheralName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdRegister";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicateActive";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdRegister";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayValue";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "markNoValue";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "exportCsv";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

