/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger.peripheralview;

import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.EnumAccess;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.Format;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.RegisterAccess;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.RegisterReadAction;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdEnum;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdNodeBase;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdRegister;
import com.jetbrains.cidr.cpp.execution.debugger.peripheralview.SvdValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SvdField
extends SvdValue<SvdNodeBase<?>> {
    public static final Format DEFAULT_FORMAT = Format.BIN;
    private final int myBitOffset;
    private final SvdRegister myParent;
    private static final SvdEnum EMPTY_ENUM = new SvdEnum(EnumAccess.READ_WRITE);
    private SvdEnum mySvdEnumRead;
    private SvdEnum mySvdEnumWrite;
    private long myValue;
    private final long myBitMask;

    public SvdField(@NotNull SvdRegister parent, @NotNull String name2, @NotNull String description, @NotNull RegisterAccess access, @Nullable RegisterReadAction readAction, int bitOffset, int size) {
        if (parent == null) {
            SvdField.$$$reportNull$$$0(0);
        }
        if (name2 == null) {
            SvdField.$$$reportNull$$$0(1);
        }
        if (description == null) {
            SvdField.$$$reportNull$$$0(2);
        }
        if (access == null) {
            SvdField.$$$reportNull$$$0(3);
        }
        super(parent.getId() + "|" + name2, name2, description, access, readAction, size, DEFAULT_FORMAT);
        this.mySvdEnumRead = EMPTY_ENUM;
        this.mySvdEnumWrite = EMPTY_ENUM;
        this.myValue = 0L;
        this.myBitOffset = bitOffset;
        this.myParent = parent;
        this.myBitMask = size == 64 ? -1L : -1L << size ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public int getBitOffset() {
        return this.myBitOffset;
    }

    public void updateFromValue(long registerValue) {
        long newValue = registerValue >> this.myBitOffset;
        this.changed = this.myValue != (newValue &= this.myBitMask);
        this.myValue = newValue;
    }

    @Override
    @NotNull
    public String getDisplayValue() {
        if (this.getAccess().isReadable() && !this.myParent.isFailed()) {
            if (this.getFormat() == Format.ENUM) {
                String string = this.mySvdEnumRead.getDisplayValue(this.myValue, this.getBitSize());
                if (string == null) {
                    SvdField.$$$reportNull$$$0(4);
                }
                return string;
            }
            String string = this.getFormat().format(this.myValue, this.getBitSize());
            if (string == null) {
                SvdField.$$$reportNull$$$0(5);
            }
            return string;
        }
        return "-";
    }

    public void setSvdEnumRead(@NotNull SvdEnum svdEnumRead) {
        if (svdEnumRead == null) {
            SvdField.$$$reportNull$$$0(6);
        }
        this.mySvdEnumRead = svdEnumRead;
    }

    @NotNull
    public SvdEnum getSvdEnumRead() {
        SvdEnum svdEnum = this.mySvdEnumRead;
        if (svdEnum == null) {
            SvdField.$$$reportNull$$$0(7);
        }
        return svdEnum;
    }

    public void setSvdEnumWrite(@NotNull SvdEnum svdEnumWrite) {
        if (svdEnumWrite == null) {
            SvdField.$$$reportNull$$$0(8);
        }
        this.mySvdEnumWrite = svdEnumWrite;
    }

    @Override
    @NotNull
    public Format getDefaultFormat() {
        Format format = DEFAULT_FORMAT;
        if (format == null) {
            SvdField.$$$reportNull$$$0(9);
        }
        return format;
    }

    public void markStalled() {
        this.changed = false;
    }

    @Override
    public boolean isEnumFormatSupported() {
        return !this.mySvdEnumRead.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdField";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "svdEnumRead";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "svdEnumWrite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/peripheralview/SvdField";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSvdEnumRead";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFormat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setSvdEnumRead";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setSvdEnumWrite";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 9 -> new IllegalStateException(string);
        };
    }
}

