/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ExecutionUiService;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.CMakeBuildProfileExecutionTarget;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeDapDebugProcess;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeDebugProcess;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeDebugUsagesCollector;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeListRunConfiguration;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeRunProfileState;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.sun.jna.platform.win32.Kernel32;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class CMakeListRunner
extends AsyncProgramRunner<RunnerSettings> {
    private static final AtomicInteger ourPipeCounter = new AtomicInteger();
    private final List<XDebugSessionListener> myDebugSessionListeners = new ArrayList<XDebugSessionListener>();

    @NotNull
    public String getRunnerId() {
        return "CMakeListRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            CMakeListRunner.$$$reportNull$$$0(0);
        }
        if (profile == null) {
            CMakeListRunner.$$$reportNull$$$0(1);
        }
        return profile instanceof CMakeListRunConfiguration && "Debug".equals(executorId);
    }

    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment2, @NotNull RunProfileState state) throws ExecutionException {
        CMakeRunProfileState cmakeState;
        if (environment2 == null) {
            CMakeListRunner.$$$reportNull$$$0(2);
        }
        if (state == null) {
            CMakeListRunner.$$$reportNull$$$0(3);
        }
        if ((cmakeState = (CMakeRunProfileState)((Object)ObjectUtils.tryCast((Object)state, CMakeRunProfileState.class))) == null) {
            throw new ExecutionException(CLionCMakeBundle.message("cmake.dbg.unexpected.run.profile.state", new Object[0]));
        }
        CMakeDebugUsagesCollector.logDebuggerUsed(environment2.getProject());
        FileDocumentManager.getInstance().saveAllDocuments();
        AsyncPromise<RunContentDescriptor> result2 = new AsyncPromise<RunContentDescriptor>(){

            protected boolean shouldLogErrors() {
                return false;
            }
        };
        AsyncPromise execResult = new AsyncPromise();
        AsyncPromise execResultFinal = execResult.onError(arg_0 -> CMakeListRunner.lambda$execute$0((AsyncPromise)result2, arg_0));
        ApplicationManager.getApplication().executeOnPooledThread(() -> this.configureCMakeStateAndExecute(environment2, cmakeState, (AsyncPromise<ExecutionResult>)execResult));
        execResultFinal.thenAsync(arg_0 -> this.lambda$execute$3(environment2, (AsyncPromise)result2, cmakeState, arg_0));
        AsyncPromise<RunContentDescriptor> asyncPromise = result2;
        if (asyncPromise == null) {
            CMakeListRunner.$$$reportNull$$$0(4);
        }
        return asyncPromise;
    }

    private void configureCMakeStateAndExecute(@NotNull ExecutionEnvironment environment2, @NotNull CMakeRunProfileState cmakeState, @NotNull AsyncPromise<ExecutionResult> execResult) {
        if (environment2 == null) {
            CMakeListRunner.$$$reportNull$$$0(5);
        }
        if (cmakeState == null) {
            CMakeListRunner.$$$reportNull$$$0(6);
        }
        if (execResult == null) {
            CMakeListRunner.$$$reportNull$$$0(7);
        }
        File debugTokenFile = null;
        try {
            CMakeExecutableTool.CMakeDebugProtocol debugProtocol = CMakeListRunner.getDebugProtocol(environment2);
            cmakeState.setDebugProtocol(debugProtocol);
            if (debugProtocol == CMakeExecutableTool.CMakeDebugProtocol.SYSPROGS) {
                try {
                    cmakeState.setDebugPort(NetUtils.findAvailableSocketPort());
                }
                catch (Exception e) {
                    throw new ExecutionException(CLionCMakeBundle.message("cmake.dbg.failed.to.find.port", new Object[0]), (Throwable)e);
                }
                Pair<String, File> tokenAndFile = CMakeListRunner.createDebugToken();
                debugTokenFile = (File)tokenAndFile.second;
                cmakeState.setDebugToken((String)tokenAndFile.first);
                cmakeState.setDebugTokenFile((File)tokenAndFile.second);
            } else if (debugProtocol == CMakeExecutableTool.CMakeDebugProtocol.DAP) {
                try {
                    String pipePath = SystemInfo.isWindows ? String.format("\\\\.\\pipe\\cmake-debug-%d-%d", Kernel32.INSTANCE.GetCurrentProcessId(), ourPipeCounter.incrementAndGet()) : FileUtil.generateRandomTemporaryPath().getAbsolutePath();
                    cmakeState.setDebugPipePath(pipePath);
                }
                catch (Exception e) {
                    throw new ExecutionException(CLionCMakeBundle.message("cmake.dbg.failed.to.create.debug.pipe", new Object[0]), (Throwable)e);
                }
            }
            execResult.setResult((Object)cmakeState.execute(environment2.getExecutor(), (ProgramRunner)this));
        }
        catch (Exception e) {
            if (debugTokenFile != null) {
                FileUtil.delete(debugTokenFile);
            }
            execResult.setError((Throwable)e);
        }
    }

    public void addDebugSessionListener(@NotNull XDebugSessionListener listener2) {
        if (listener2 == null) {
            CMakeListRunner.$$$reportNull$$$0(8);
        }
        this.myDebugSessionListeners.add(listener2);
    }

    @NotNull
    private static CMakeExecutableTool.CMakeDebugProtocol getDebugProtocol(@NotNull ExecutionEnvironment environment2) {
        if (environment2 == null) {
            CMakeListRunner.$$$reportNull$$$0(9);
        }
        Project project = environment2.getProject();
        CMakeWorkspace cmakeWorkspace = CMakeWorkspace.getInstance(project);
        CMakeListRunConfiguration config = (CMakeListRunConfiguration)((Object)ObjectUtils.tryCast((Object)environment2.getRunProfile(), CMakeListRunConfiguration.class));
        if (config == null) {
            CMakeExecutableTool.CMakeDebugProtocol cMakeDebugProtocol = CMakeExecutableTool.CMakeDebugProtocol.NONE;
            if (cMakeDebugProtocol == null) {
                CMakeListRunner.$$$reportNull$$$0(10);
            }
            return cMakeDebugProtocol;
        }
        ExecutionTarget target2 = environment2.getExecutionTarget();
        if (!(target2 instanceof CMakeBuildProfileExecutionTarget)) {
            CMakeExecutableTool.CMakeDebugProtocol cMakeDebugProtocol = CMakeExecutableTool.CMakeDebugProtocol.NONE;
            if (cMakeDebugProtocol == null) {
                CMakeListRunner.$$$reportNull$$$0(11);
            }
            return cMakeDebugProtocol;
        }
        CMakeBuildProfileExecutionTarget cmakeTarget = (CMakeBuildProfileExecutionTarget)target2;
        String cmakeProfileName = cmakeTarget.getProfileName();
        CMakeProfileInfo cmakeProfileInfo = cmakeWorkspace.getCMakeProfileInfoByName(cmakeProfileName);
        CPPEnvironment cppEnv = cmakeProfileInfo != null ? cmakeProfileInfo.getEnvironment() : null;
        CMakeExecutableTool cmake = cppEnv != null ? cppEnv.getCMake() : null;
        CMakeExecutableTool.CMakeDebugProtocol cMakeDebugProtocol = cmake != null ? cmake.getDebugProtocol() : CMakeExecutableTool.CMakeDebugProtocol.NONE;
        if (cMakeDebugProtocol == null) {
            CMakeListRunner.$$$reportNull$$$0(12);
        }
        return cMakeDebugProtocol;
    }

    @NotNull
    private static Pair<String, File> createDebugToken() throws ExecutionException {
        Pair pair;
        try {
            File tokenFile = FileUtil.createTempFile((String)"cmake-debug", (String)"token");
            String token = UUID.randomUUID().toString();
            FileUtil.writeToFile((File)tokenFile, (String)token, (Charset)StandardCharsets.US_ASCII);
            PosixFileAttributeView attributes = Files.getFileAttributeView(tokenFile.toPath(), PosixFileAttributeView.class, new LinkOption[0]);
            if (attributes != null) {
                attributes.setPermissions(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
            }
            tokenFile.setReadable(false, false);
            tokenFile.setReadable(true, true);
            tokenFile.setWritable(false, false);
            tokenFile.setWritable(true, true);
            pair = Pair.create((Object)token, (Object)tokenFile);
        }
        catch (IOException e) {
            throw new ExecutionException(CLionCMakeBundle.message("cmake.dbg.failed.to.create.token", new Object[0]), (Throwable)e);
        }
        if (pair == null) {
            CMakeListRunner.$$$reportNull$$$0(13);
        }
        return pair;
    }

    private /* synthetic */ Promise lambda$execute$3(ExecutionEnvironment environment2, AsyncPromise result2, final CMakeRunProfileState cmakeState, final ExecutionResult executionResult) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if ("Run".equals(environment2.getExecutor().getId())) {
                final RunContentDescriptor runContentDescriptor = ExecutionUiService.getInstance().showRunContent(executionResult, environment2);
                ProcessHandler handler2 = executionResult.getProcessHandler();
                if (handler2 != null && runContentDescriptor != null) {
                    handler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void processTerminated(@NotNull ProcessEvent event) {
                            if (event == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            int exitCode = event.getExitCode();
                            ExecutionConsole console = runContentDescriptor.getExecutionConsole();
                            if (console instanceof ConsoleView) {
                                ((ConsoleView)console).print("Process terminated with exit code " + exitCode + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/cpp/execution/debugger/CMakeListRunner$2", "processTerminated"));
                        }
                    });
                }
                result2.setResult((Object)runContentDescriptor);
            } else {
                try {
                    result2.setResult((Object)XDebuggerManager.getInstance((Project)environment2.getProject()).startSession(environment2, new XDebugProcessStarter(){

                        @NotNull
                        public XDebugProcess start(@NotNull XDebugSession session) throws ExecutionException {
                            if (session == null) {
                                3.$$$reportNull$$$0(0);
                            }
                            for (XDebugSessionListener listener2 : CMakeListRunner.this.myDebugSessionListeners) {
                                session.addSessionListener(listener2);
                            }
                            if (cmakeState.getDebugProtocol() == CMakeExecutableTool.CMakeDebugProtocol.DAP) {
                                return new CMakeDapDebugProcess(session, executionResult, Objects.requireNonNull(cmakeState.getDebugPipePath()));
                            }
                            if (cmakeState.getDebugProtocol() == CMakeExecutableTool.CMakeDebugProtocol.SYSPROGS) {
                                CMakeDebugProcess process2 = new CMakeDebugProcess(executionResult, session);
                                process2.connect(Objects.requireNonNull(cmakeState.getDebugPort()), Objects.requireNonNull(cmakeState.getDebugToken()), Objects.requireNonNull(cmakeState.getDebugTokenFile()));
                                CMakeDebugProcess cMakeDebugProcess = process2;
                                if (cMakeDebugProcess == null) {
                                    3.$$$reportNull$$$0(1);
                                }
                                return cMakeDebugProcess;
                            }
                            throw new ExecutionException(CLionCMakeBundle.message("cmake.dbg.debug.is.not.supported", new Object[0]));
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[switch (n) {
                                default -> 3;
                                case 1 -> 2;
                            }];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "session";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeListRunner$3";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeListRunner$3";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "start";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "start";
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                            }
                            String string = String.format(v0, objectArray);
                            throw switch (n) {
                                default -> new IllegalArgumentException(string);
                                case 1 -> new IllegalStateException(string);
                            };
                        }
                    }).getRunContentDescriptor());
                }
                catch (ExecutionException e) {
                    result2.setError((Throwable)e);
                }
            }
        });
        return Promises.resolvedPromise();
    }

    private static /* synthetic */ void lambda$execute$0(AsyncPromise result2, Throwable err) {
        result2.setError(err);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeListRunner";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeState";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execResult";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeListRunner";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugProtocol";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugToken";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 4: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "configureCMakeStateAndExecute";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDebugSessionListener";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDebugProtocol";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

