/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProviderBase;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XErrorValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeDebugConstants;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeExceptionBreakpointProperties;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeExceptionBreakpointType;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeLineBreakpointProperties;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeLineBreakpointType;
import com.jetbrains.cidr.cpp.execution.debugger.CMakePackets;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeRunProfileState;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cmake.CMakeListsFileType;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeCommandArguments;
import com.jetbrains.cmake.psi.CMakeFile;
import com.jetbrains.cmake.psi.CMakeForeachCommand;
import com.jetbrains.cmake.psi.CMakeFunctionCommand;
import com.jetbrains.cmake.psi.CMakeIfCommand;
import com.jetbrains.cmake.psi.CMakeMacroCommand;
import com.jetbrains.cmake.psi.CMakeRoutine;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.ProcessHandlerWrapper;

public class CMakeDebugProcess
extends XDebugProcess {
    static final Logger LOG = Logger.getInstance(CMakeDebugProcess.class);
    private String myDebugToken;
    private File myDebugTokenFile;
    private final ExecutionResult myExecutionResult;
    private final CPPEnvironment myCPPEnvironment;
    private volatile Socket mySocket;
    private InputStream myInput;
    private OutputStream myOutput;
    private final BlockingQueue<CMakePackets.CMakePacket> mySendQueue;
    private volatile boolean myConnected;
    private volatile boolean myStop;
    private final AtomicLong mySuspendId;
    private volatile boolean myUpdatePosition;
    private final CountDownLatch myTargetExited;
    private final AtomicReference<Promise<Object>> myStopPromise;
    private volatile Future<?> mySender;
    private volatile Future<?> myReceiver;
    private volatile Consumer<@NotNull CMakePackets.CMakePacket> myPacketConsumer;
    private final Semaphore myRequestSemaphore;
    private final XBreakpointHandler<?>[] myBreakpointHandlers;
    private final Map<Integer, XBreakpoint<CMakeLineBreakpointProperties>> myBreakpoints;
    private final Map<XBreakpoint<CMakeLineBreakpointProperties>, Integer> myBreakpointIds;
    private volatile Integer myRunToPositionBreakpointId;
    private final AtomicReference<List<CMakePackets.CMakeBacktraceEntry>> myStackBeforeStepIn;
    private final AtomicInteger myPendingBreakpointCount;
    static final Set<String> NATIVE_FUNCTIONS = Set.of("project");
    private static final XValuePresentation EMPTY_PRESENTATION = new XValuePresentation(){

        @NotNull
        public String getSeparator() {
            return "";
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
            if (renderer == null) {
                4.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$4", "renderValue"));
        }
    };

    protected CMakeDebugProcess(@NotNull ExecutionResult executionResult, @NotNull XDebugSession session) {
        if (executionResult == null) {
            CMakeDebugProcess.$$$reportNull$$$0(0);
        }
        if (session == null) {
            CMakeDebugProcess.$$$reportNull$$$0(1);
        }
        super(session);
        this.mySendQueue = new ArrayBlockingQueue<CMakePackets.CMakePacket>(100);
        this.mySuspendId = new AtomicLong();
        this.myTargetExited = new CountDownLatch(1);
        this.myStopPromise = new AtomicReference();
        this.myPacketConsumer = null;
        this.myRequestSemaphore = new Semaphore(1);
        this.myBreakpointHandlers = new XBreakpointHandler[]{new CMakeLineBreakpointHandler()};
        this.myBreakpoints = new ConcurrentHashMap<Integer, XBreakpoint<CMakeLineBreakpointProperties>>();
        this.myBreakpointIds = new ConcurrentHashMap<XBreakpoint<CMakeLineBreakpointProperties>, Integer>();
        this.myRunToPositionBreakpointId = null;
        this.myStackBeforeStepIn = new AtomicReference();
        this.myPendingBreakpointCount = new AtomicInteger();
        this.myExecutionResult = executionResult;
        this.myCPPEnvironment = (CPPEnvironment)this.myExecutionResult.getProcessHandler().getUserData(CMakeRunProfileState.CPP_ENVIRONMENT_KEY);
        this.myExecutionResult.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                int exitCode = event.getExitCode();
                ConsoleView console = CMakeDebugProcess.this.getSession().getConsoleView();
                if (console != null) {
                    console.print("Process terminated with exit code " + exitCode + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                }
                if (CMakeDebugProcess.this.myDebugTokenFile != null) {
                    FileUtil.delete((File)CMakeDebugProcess.this.myDebugTokenFile);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$1", "processTerminated"));
            }
        });
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        return new XDebuggerEditorsProviderBase(){

            @NotNull
            public FileType getFileType() {
                FileType fileType = CMakeListsFileType.INSTANCE;
                if (fileType == null) {
                    2.$$$reportNull$$$0(0);
                }
                return fileType;
            }

            protected PsiFile createExpressionCodeFragment(@NotNull Project project, @NotNull String text, @Nullable PsiElement context2, boolean isPhysical) {
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (text == null) {
                    2.$$$reportNull$$$0(2);
                }
                return PsiFileFactory.getInstance((Project)project).createFileFromText("expression.cmake", (Language)PlainTextLanguage.INSTANCE, (CharSequence)text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFileType";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "createExpressionCodeFragment";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    public void connect(int debugPort, @NotNull String debugToken, @NotNull File debugTokenFile) throws ExecutionException {
        if (debugToken == null) {
            CMakeDebugProcess.$$$reportNull$$$0(2);
        }
        if (debugTokenFile == null) {
            CMakeDebugProcess.$$$reportNull$$$0(3);
        }
        this.myDebugToken = debugToken;
        this.myDebugTokenFile = debugTokenFile;
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            InetSocketAddress address = null;
            try {
                this.waitForDebugSessionInit();
                address = new InetSocketAddress(CMakeDebugProcess.getLocalHostAddress(), debugPort);
                this.mySocket = this.connect(address);
                this.myInput = this.mySocket.getInputStream();
                this.myOutput = this.mySocket.getOutputStream();
                CMakeDebugProcess.readBanner(this.myInput);
                this.mySender = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    while (!this.myStop) {
                        try {
                            CMakePackets.CMakePacket packet = this.mySendQueue.poll(1L, TimeUnit.SECONDS);
                            if (packet == null) continue;
                            try {
                                CMakeDebugProcess.sendPacket(this.myOutput, packet);
                            }
                            catch (IOException e) {
                                if (this.isTargetExited()) continue;
                                LOG.warn("Failed to send cmake debugger packet " + packet, (Throwable)e);
                            }
                        }
                        catch (InterruptedException e) {
                            if (this.myStop) continue;
                            LOG.warn((Throwable)e);
                        }
                    }
                });
                CMakePackets.CMakePacketScTargetStopped initialStop = this.runHandshake();
                this.myConnected = true;
                this.myReceiver = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    while (!this.myStop) {
                        try {
                            Consumer<CMakePackets.CMakePacket> consumer;
                            CMakePackets.CMakePacket packet = CMakeDebugProcess.readPacket(this.myInput);
                            if (packet instanceof CMakePackets.CMakePacketScTargetExited) {
                                this.myTargetExited.countDown();
                                continue;
                            }
                            if (packet instanceof CMakePackets.CMakePacketScTargetStopped) {
                                if (this.isShutdownStarted()) {
                                    this.sendPacket(new CMakePackets.CMakePacketCsTerminate());
                                    continue;
                                }
                                if (!this.myUpdatePosition) continue;
                                List prevStack = this.myStackBeforeStepIn.getAndSet(null);
                                CMakeDebugConstants.CMakeTargetStopReason stopReason = ((CMakePackets.CMakePacketScTargetStopped)packet).stopReason;
                                CMakeSuspendContext suspendContext = new CMakeSuspendContext((CMakePackets.CMakePacketScTargetStopped)packet);
                                Integer runToPositionBreakpointId = this.myRunToPositionBreakpointId;
                                if (runToPositionBreakpointId != null) {
                                    this.sendRequest(new CMakePackets.CMakePacketCsDeleteBreakpoint(runToPositionBreakpointId)).onSuccess(response -> {
                                        if (response instanceof CMakePackets.CMakePacketScBreakpointUpdated) {
                                            this.myRunToPositionBreakpointId = null;
                                        }
                                    });
                                }
                                if (stopReason == CMakeDebugConstants.CMakeTargetStopReason.Breakpoint) {
                                    int breakpointId = ((CMakePackets.CMakePacketScTargetStopped)packet).intArg;
                                    XBreakpoint<CMakeLineBreakpointProperties> breakpoint = this.myBreakpoints.get(breakpointId);
                                    if (breakpoint != null) {
                                        if (this.getSession().breakpointReached(breakpoint, null, (XSuspendContext)suspendContext)) continue;
                                        this.resume(suspendContext);
                                        continue;
                                    }
                                    this.getPositionReached(suspendContext);
                                    continue;
                                }
                                if (stopReason == CMakeDebugConstants.CMakeTargetStopReason.Exception) {
                                    suspendContext.setErrorDetails(((CMakePackets.CMakePacketScTargetStopped)packet).strArg);
                                    XBreakpoint<CMakeExceptionBreakpointProperties> breakpoint = CMakeExceptionBreakpointType.findDefaultErrorBreakpoint(this.getSession().getProject());
                                    if (breakpoint != null) {
                                        if (this.getSession().breakpointReached(breakpoint, null, (XSuspendContext)suspendContext)) continue;
                                        this.resume(suspendContext);
                                        continue;
                                    }
                                    this.getPositionReached(suspendContext);
                                    continue;
                                }
                                if (this.isSteppedIntoLibraryCode(prevStack, ((CMakePackets.CMakePacketScTargetStopped)packet).backtrace)) {
                                    this.sendPacket(new CMakePackets.CMakePacketCsStepOut());
                                    continue;
                                }
                                this.getPositionReached(suspendContext);
                                continue;
                            }
                            if (packet instanceof CMakePackets.CMakePacketDebugMessage || (consumer = this.myPacketConsumer) == null) continue;
                            consumer.accept(packet);
                        }
                        catch (CMakePackets.CMakeParsePacketException e) {
                            if (Thread.currentThread().isInterrupted() || this.isTargetExited() || this.isShutdownStarted()) continue;
                            CMakeDebugProcess.logPacketParseError(e);
                            this.showErrorNotification("cmake.dbg.failed.to.parse.packet", e);
                        }
                        catch (IOException e) {
                            if (Thread.currentThread().isInterrupted() || this.isTargetExited() || this.isShutdownStarted()) continue;
                            LOG.warn("Failed to read cmake debugger packet", (Throwable)e);
                            this.showErrorNotification("cmake.dbg.failed.to.parse.packet", e);
                        }
                    }
                });
                ReadAction.run(() -> this.getSession().initBreakpoints());
                while (true) {
                    if (this.myStop) {
                        LOG.info("Stop waiting for breakpoints initialization: debug session stopped");
                        return;
                    }
                    if (!this.myRequestSemaphore.tryAcquire(1L, TimeUnit.SECONDS)) continue;
                    this.myRequestSemaphore.release();
                    if (this.myPendingBreakpointCount.get() == 0) break;
                }
                this.myUpdatePosition = true;
                this.getSession().rebuildViews();
                this.getSession().setPauseActionSupported(true);
                this.reachInitialBreakPositionOrResume(initialStop);
            }
            catch (Exception e) {
                CMakePackets.CMakeParsePacketException parsePacketException = (CMakePackets.CMakeParsePacketException)ObjectUtils.tryCast((Object)e, CMakePackets.CMakeParsePacketException.class);
                if (parsePacketException != null) {
                    CMakeDebugProcess.logPacketParseError(parsePacketException);
                }
                LOG.warn("Connection to " + (Serializable)(address != null ? address : "cmake") + " failed", (Throwable)e);
                this.myConnected = false;
                this.showErrorNotification("cmake.dbg.failed.to.connect", e);
                this.getSession().stop();
            }
        });
    }

    private void getPositionReached(CMakeSuspendContext suspendContext) {
        this.mySuspendId.incrementAndGet();
        this.getSession().positionReached((XSuspendContext)suspendContext);
    }

    private static void logPacketParseError(@NotNull CMakePackets.CMakeParsePacketException e) {
        String payload;
        if (e == null) {
            CMakeDebugProcess.$$$reportNull$$$0(4);
        }
        if (StringUtil.isNotEmpty((String)(payload = e.getPayload()))) {
            LOG.warn("Failed to parse cmake packet: " + payload, (Throwable)e);
        } else {
            LOG.warn((Throwable)e);
        }
    }

    private void showErrorNotification(@NotNull String messageKey, Exception e) {
        if (messageKey == null) {
            CMakeDebugProcess.$$$reportNull$$$0(5);
        }
        String details = e.getMessage();
        String msg = CLionCMakeBundle.message(messageKey, details);
        XDebuggerManagerImpl.getNotificationGroup().createNotification(msg, NotificationType.ERROR).notify(this.getSession().getProject());
    }

    private boolean isTargetExited() {
        try {
            return this.myTargetExited.await(0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @NotNull
    private Socket connect(@NotNull SocketAddress address) throws IOException, InterruptedException, ExecutionException {
        if (address == null) {
            CMakeDebugProcess.$$$reportNull$$$0(6);
        }
        int connectAttemptLeft = 3;
        long backoffMillis = 100L;
        ProcessHandler processHandler = this.myExecutionResult.getProcessHandler();
        while (!processHandler.isProcessTerminated()) {
            Socket socket;
            try {
                Socket socket2 = new Socket();
                socket2.connect(address, (int)TimeUnit.SECONDS.toMillis(30L));
                LOG.debug("Connected to cmake debugger (" + address + ")");
                socket = socket2;
            }
            catch (ConnectException ce) {
                Thread.sleep(backoffMillis);
                backoffMillis *= 5L;
                if (--connectAttemptLeft == 0) {
                    throw ce;
                }
                LOG.debug("Failed to connect to cmake debugger (" + address + "), attempts left " + connectAttemptLeft);
                continue;
            }
            if (socket == null) {
                CMakeDebugProcess.$$$reportNull$$$0(7);
            }
            return socket;
        }
        throw new ExecutionException(CLionCMakeBundle.message("cmake.dbg.cmake.terminated", new Object[0]));
    }

    private void reachInitialBreakPositionOrResume(@NotNull CMakePackets.CMakePacketScTargetStopped initialStop) {
        if (initialStop == null) {
            CMakeDebugProcess.$$$reportNull$$$0(8);
        }
        CMakePackets.CMakeBacktraceEntry initialBreakTopFrame = (CMakePackets.CMakeBacktraceEntry)ContainerUtil.getFirstItem(initialStop.backtrace);
        VirtualFile vfile = this.findVirtualFile(initialBreakTopFrame);
        XBreakpoint<CMakeLineBreakpointProperties> reachedBreakpoint = null;
        if (vfile != null) {
            for (XBreakpoint<CMakeLineBreakpointProperties> breakpoint : this.myBreakpoints.values()) {
                XSourcePosition position = breakpoint.getSourcePosition();
                if (position == null || position.getLine() != CMakeDebugProcess.line0(initialBreakTopFrame.line1) || !vfile.equals(position.getFile())) continue;
                reachedBreakpoint = breakpoint;
                break;
            }
        }
        if (reachedBreakpoint != null) {
            CMakeSuspendContext suspendContext = new CMakeSuspendContext(initialStop);
            if (!this.getSession().breakpointReached(reachedBreakpoint, null, (XSuspendContext)suspendContext)) {
                this.resume(suspendContext);
            }
        } else {
            this.resume(null);
        }
    }

    private boolean isSteppedIntoLibraryCode(@Nullable List<CMakePackets.CMakeBacktraceEntry> prevStack, @NotNull List<CMakePackets.CMakeBacktraceEntry> curStack) {
        if (curStack == null) {
            CMakeDebugProcess.$$$reportNull$$$0(9);
        }
        if (prevStack == null || prevStack.isEmpty() || curStack.size() != prevStack.size() + 1) {
            return false;
        }
        Project project = this.getSession().getProject();
        GlobalSearchScope projectScope = ProjectScope.getProjectScope((Project)project);
        VirtualFile prevVFile = this.findVirtualFile(prevStack.get(0));
        if (prevVFile == null || !((Boolean)ReadAction.compute(() -> projectScope.accept(prevVFile))).booleanValue()) {
            return false;
        }
        VirtualFile curVFile = this.findVirtualFile(curStack.get(0));
        return curVFile == null || (Boolean)ReadAction.compute(() -> projectScope.accept(curVFile)) == false;
    }

    @NotNull
    private CMakePackets.CMakePacketScTargetStopped runHandshake() throws IOException, CMakePackets.CMakeParsePacketException {
        CMakePackets.CMakePacket packet = CMakeDebugProcess.readPacket(this.myInput);
        if (!(packet instanceof CMakePackets.CMakePacketScHandshake)) {
            throw new RuntimeException("Unexpected cmake packet " + packet.type.name());
        }
        this.sendPacket(new CMakePackets.CMakePacketCsHandshake(this.myDebugToken));
        while ((packet = CMakeDebugProcess.readPacket(this.myInput)) instanceof CMakePackets.CMakePacketDebugMessage) {
        }
        if (!(packet instanceof CMakePackets.CMakePacketScTargetStopped) || ((CMakePackets.CMakePacketScTargetStopped)packet).stopReason != CMakeDebugConstants.CMakeTargetStopReason.InitialBreakIn) {
            throw new RuntimeException("Unexpected cmake packet " + packet.type.name());
        }
        CMakePackets.CMakePacketScTargetStopped cMakePacketScTargetStopped = (CMakePackets.CMakePacketScTargetStopped)packet;
        if (cMakePacketScTargetStopped == null) {
            CMakeDebugProcess.$$$reportNull$$$0(10);
        }
        return cMakePacketScTargetStopped;
    }

    private void waitForDebugSessionInit() {
        XDebugSession session = this.getSession();
        XDebuggerManager debuggerManager = XDebuggerManager.getInstance((Project)session.getProject());
        while (!ContainerUtil.exists((Object[])debuggerManager.getDebugSessions(), it -> it == session)) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void sendPacket(CMakePackets.CMakePacket packet) {
        while (!this.myStop) {
            try {
                if (!this.mySendQueue.offer(packet, 1L, TimeUnit.SECONDS)) continue;
            }
            catch (InterruptedException e) {
                LOG.warn("Failed to enqueue cmake packet " + packet, (Throwable)e);
            }
            break;
        }
    }

    @NotNull
    public ExecutionConsole createConsole() {
        ExecutionResult executionResult = this.myExecutionResult;
        ExecutionConsole executionConsole = executionResult == null ? super.createConsole() : executionResult.getExecutionConsole();
        if (executionConsole == null) {
            CMakeDebugProcess.$$$reportNull$$$0(11);
        }
        return executionConsole;
    }

    @NotNull
    protected ProcessHandler doGetProcessHandler() {
        ProcessHandler handler2;
        ProcessHandler processHandler = handler2 = this.myExecutionResult != null ? this.myExecutionResult.getProcessHandler() : null;
        if (handler2 == null) {
            return new DefaultDebugProcessHandler(){

                public boolean isSilentlyDestroyOnClose() {
                    return true;
                }
            };
        }
        return new ProcessHandlerWrapper((XDebugProcess)this, handler2);
    }

    public boolean checkCanPerformCommands() {
        Socket socket = this.mySocket;
        return this.myConnected && socket != null && socket.isConnected();
    }

    public boolean checkCanInitBreakpoints() {
        return false;
    }

    public void resume(@Nullable XSuspendContext context2) {
        this.mySuspendId.incrementAndGet();
        this.sendPacket(new CMakePackets.CMakePacketCsContinue());
    }

    @Nls
    public String getCurrentStateMessage() {
        if (this.mySocket != null && this.mySocket.isClosed()) {
            return XDebuggerBundle.message((String)"debugger.state.message.disconnected", (Object[])new Object[0]);
        }
        if (this.mySocket == null || !this.mySocket.isConnected()) {
            return XDebuggerBundle.message((String)"debugger.state.message.connecting", (Object[])new Object[0]);
        }
        return super.getCurrentStateMessage();
    }

    private boolean isShutdownStarted() {
        return this.myStopPromise.get() != null;
    }

    @NotNull
    public Promise<Object> stopAsync() {
        AsyncPromise newPromise = new AsyncPromise();
        if (this.myStopPromise.compareAndSet(null, (Promise<Object>)newPromise)) {
            Promises.runAsync(() -> {
                try {
                    if (this.mySender != null) {
                        try {
                            if (!this.myTargetExited.await(1L, TimeUnit.MILLISECONDS)) {
                                this.sendPacket(new CMakePackets.CMakePacketCsBreakIn());
                                this.sendPacket(new CMakePackets.CMakePacketCsTerminate());
                                this.myTargetExited.await(5L, TimeUnit.SECONDS);
                            }
                        }
                        catch (InterruptedException e) {
                            LOG.debug("Failed to stop debug session gracefully", (Throwable)e);
                        }
                    }
                    try {
                        Future<?> receiver;
                        this.myStop = true;
                        Future<?> sender = this.mySender;
                        if (sender != null) {
                            sender.cancel(true);
                        }
                        if ((receiver = this.myReceiver) != null) {
                            receiver.cancel(true);
                        }
                        if (this.mySocket != null) {
                            this.mySocket.close();
                        }
                    }
                    catch (IOException e) {
                        LOG.warn("Error while stopping cmake debug session", (Throwable)e);
                    }
                }
                finally {
                    newPromise.setResult(new Object());
                }
                this.getSession().stop();
                return null;
            });
            AsyncPromise asyncPromise = newPromise;
            if (asyncPromise == null) {
                CMakeDebugProcess.$$$reportNull$$$0(12);
            }
            return asyncPromise;
        }
        Promise<Object> promise = this.myStopPromise.get();
        if (promise == null) {
            CMakeDebugProcess.$$$reportNull$$$0(13);
        }
        return promise;
    }

    public void startForceStepInto(@Nullable XSuspendContext context2) {
        this.mySuspendId.incrementAndGet();
        this.sendPacket(new CMakePackets.CMakePacketCsStepIn());
    }

    public void startStepInto(@Nullable XSuspendContext context2) {
        this.mySuspendId.incrementAndGet();
        if (context2 == null) {
            this.sendPacket(new CMakePackets.CMakePacketCsStepIn());
            return;
        }
        CMakeExecutionStack currentStack = (CMakeExecutionStack)((CMakeSuspendContext)context2).getActiveExecutionStack();
        this.myStackBeforeStepIn.set(currentStack.myStack);
        this.sendPacket(new CMakePackets.CMakePacketCsStepIn());
    }

    public void startStepOver(@Nullable XSuspendContext context2) {
        this.mySuspendId.incrementAndGet();
        this.sendPacket(new CMakePackets.CMakePacketCsStepOver());
    }

    public void startStepOut(@Nullable XSuspendContext context2) {
        this.mySuspendId.incrementAndGet();
        this.sendPacket(new CMakePackets.CMakePacketCsStepOut());
    }

    public void startPausing() {
        this.sendPacket(new CMakePackets.CMakePacketCsBreakIn());
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context2) {
        if (position == null) {
            CMakeDebugProcess.$$$reportNull$$$0(14);
        }
        VirtualFile file = position.getFile();
        ApplicationManager.getApplication().executeOnPooledThread(() -> this.sendRequest(new CMakePackets.CMakePacketCsCreateBreakpoint(file.getPath(), CMakeDebugProcess.line1(position.getLine()))).onError(err -> {
            XDebuggerManagerImpl.getNotificationGroup().createNotification(CLionCMakeBundle.message("cmake.dbg.failed.to.create.tmp.breakpoint", new Object[0]), NotificationType.WARNING).notify(this.getSession().getProject());
            this.sendPacket(new CMakePackets.CMakePacketCsContinue());
        }).onSuccess(response -> {
            CMakePackets.CMakePacketScBreakpointCreated createdPacket = (CMakePackets.CMakePacketScBreakpointCreated)response;
            this.myRunToPositionBreakpointId = createdPacket.breakpointId;
            this.sendPacket(new CMakePackets.CMakePacketCsContinue());
        }));
    }

    static void readBanner(InputStream in) throws IOException {
        String expectedBanner = "Sysprogs High-Level Debug Protocol";
        byte[] buf = CMakePackets.readFully(in, expectedBanner.length() + 1);
        String actualBanner = new String(buf, 0, expectedBanner.length(), StandardCharsets.US_ASCII);
        if (buf[expectedBanner.length()] != 0 || !expectedBanner.equals(actualBanner)) {
            LOG.debug("Expected banner: '" + expectedBanner + "', got: '" + actualBanner + "'");
            throw new RuntimeException(CLionCMakeBundle.message("cmake.dbg.unexpected.banner", new Object[0]));
        }
    }

    @NotNull
    static CMakePackets.CMakePacket readPacket(InputStream in) throws IOException, CMakePackets.CMakeParsePacketException {
        CMakePackets.CMakePacket cMakePacket;
        byte[] data2;
        CMakePackets.Payload header = new CMakePackets.Payload(CMakePackets.readFully(in, 8));
        int packetType = header.readInt();
        int payloadSize = header.readInt();
        try {
            data2 = CMakePackets.readFully(in, payloadSize);
        }
        catch (IOException e) {
            throw new CMakePackets.CMakeParsePacketException(CLionCMakeBundle.message("cmake.dbg.failed.to.read.packet", packetType, payloadSize), e);
        }
        CMakePackets.Payload payload = new CMakePackets.Payload(packetType, data2);
        CMakeDebugConstants.CMakePacketType value = CMakeDebugConstants.CMakePacketType.values()[packetType];
        try {
            CMakePackets.CMakePacket packet = switch (value) {
                case CMakeDebugConstants.CMakePacketType.scHandshake -> CMakePackets.readHandshake(payload);
                case CMakeDebugConstants.CMakePacketType.scTargetStopped -> CMakePackets.readTargetStopped(payload);
                case CMakeDebugConstants.CMakePacketType.scExpressionCreated -> CMakePackets.readScExpressionCreated(payload);
                case CMakeDebugConstants.CMakePacketType.scExpressionChildrenQueried -> CMakePackets.readScExpressionChildrenQueried(payload);
                case CMakeDebugConstants.CMakePacketType.scError -> CMakePackets.readScError(payload);
                case CMakeDebugConstants.CMakePacketType.scDebugMessage -> CMakePackets.readDebugMessage(payload);
                case CMakeDebugConstants.CMakePacketType.scBreakpointCreated -> CMakePackets.readBreakpointCreated(payload);
                case CMakeDebugConstants.CMakePacketType.scBreakpointUpdated -> CMakePackets.readBreakpointUpdated();
                case CMakeDebugConstants.CMakePacketType.scTargetRunning -> CMakePackets.readTargetRunning();
                case CMakeDebugConstants.CMakePacketType.scTargetExited -> CMakePackets.readTargetExited(payload);
                case CMakeDebugConstants.CMakePacketType.scVarsOut -> CMakePackets.readVarsOut(payload);
                default -> CMakePackets.readGenericPacket(packetType, payload);
            };
            LOG.debug("in:  " + packet);
            cMakePacket = packet;
        }
        catch (CMakePackets.CMakeParsePacketException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMakePackets.CMakeParsePacketException(e.getMessage(), payload.formatPayload(), e);
        }
        if (cMakePacket == null) {
            CMakeDebugProcess.$$$reportNull$$$0(15);
        }
        return cMakePacket;
    }

    static void sendPacket(@NotNull OutputStream out, @NotNull CMakePackets.CMakePacket packet) throws IOException {
        if (out == null) {
            CMakeDebugProcess.$$$reportNull$$$0(16);
        }
        if (packet == null) {
            CMakeDebugProcess.$$$reportNull$$$0(17);
        }
        LOG.debug("out: " + packet);
        packet.writeToStream(out);
        out.flush();
    }

    @NotNull
    private static List<CMakeArgument> getArgs(@Nullable CMakeCommand cmd) {
        if (cmd == null) {
            List<CMakeArgument> list2 = Collections.emptyList();
            if (list2 == null) {
                CMakeDebugProcess.$$$reportNull$$$0(18);
            }
            return list2;
        }
        CMakeCommandArguments args2 = cmd.getCMakeCommandArguments();
        List<CMakeArgument> list3 = args2 != null ? args2.getCMakeArgumentList() : Collections.emptyList();
        if (list3 == null) {
            CMakeDebugProcess.$$$reportNull$$$0(19);
        }
        return list3;
    }

    @Nullable
    private static String getVarNameForEval(@Nullable String name2) {
        if (name2 == null) {
            return null;
        }
        if (name2.startsWith("${") && name2.endsWith("}")) {
            name2 = name2.substring(2, name2.length() - 1);
        }
        if (!name2.contains("$")) {
            return name2;
        }
        return null;
    }

    @NotNull
    private CMakePsiVarsInfo collectCommandsFromPsi(@NotNull CMakePackets.CMakeBacktraceEntry position) {
        VirtualFile vfile;
        if (position == null) {
            CMakeDebugProcess.$$$reportNull$$$0(20);
        }
        if ((vfile = this.findVirtualFile(position)) == null) {
            return new CMakePsiVarsInfo();
        }
        Document doc = FileDocumentManager.getInstance().getDocument(vfile);
        if (doc == null) {
            return new CMakePsiVarsInfo();
        }
        CMakeFile file = (CMakeFile)ObjectUtils.tryCast((Object)PsiDocumentManager.getInstance((Project)this.getSession().getProject()).getPsiFile(doc), CMakeFile.class);
        if (file == null) {
            return new CMakePsiVarsInfo();
        }
        int offset = doc.getLineStartOffset(CMakeDebugProcess.line0(position.line1));
        PsiElement element2 = file.findElementAt(offset);
        if (element2 == null) {
            return new CMakePsiVarsInfo();
        }
        CMakePsiVarsInfo result2 = new CMakePsiVarsInfo();
        HashSet<String> uniq = new HashSet<String>();
        while (element2 != null) {
            if (element2 instanceof CMakeForeachCommand) {
                List<CMakeArgument> argList = CMakeDebugProcess.getArgs((CMakeCommand)element2);
                CMakeArgument var = (CMakeArgument)ContainerUtil.getFirstItem(argList);
                String varName = CMakeDebugProcess.getVarNameForEval(var != null ? var.getName() : null);
                if (varName != null && uniq.add(varName)) {
                    int cmdOffset = element2.getTextRange().getStartOffset();
                    result2.vars.add(new CMakePackets.CMakeVarValue(varName, null, CMakeDebugProcess.getLineNumber1(doc, cmdOffset)));
                }
            } else if (element2 instanceof CMakeIfCommand && result2.ifLine1 == null) {
                int cmdOffset = element2.getTextRange().getStartOffset();
                result2.ifLine1 = CMakeDebugProcess.getLineNumber1(doc, cmdOffset);
            } else {
                if (element2 instanceof CMakeRoutine && Objects.equals(position.function, ((CMakeRoutine)element2).getName())) {
                    List<Object> argList;
                    CMakeCommandArguments arguments = null;
                    if (element2 instanceof CMakeFunctionCommand) {
                        arguments = ((CMakeFunctionCommand)element2).getCMakeCommandArguments();
                        int cmdOffset = element2.getTextRange().getStartOffset();
                        result2.funcLine1 = CMakeDebugProcess.getLineNumber1(doc, cmdOffset);
                    } else if (element2 instanceof CMakeMacroCommand) {
                        arguments = ((CMakeMacroCommand)element2).getCMakeCommandArguments();
                    }
                    List<Object> list2 = argList = arguments != null ? arguments.getCMakeArgumentList() : Collections.emptyList();
                    if (!argList.isEmpty()) {
                        argList = argList.subList(1, argList.size());
                    }
                    for (int i = 0; i < argList.size(); ++i) {
                        CMakeArgument argument = (CMakeArgument)argList.get(i);
                        String varName = argument.getName();
                        if (varName == null || !uniq.add(varName)) continue;
                        String value = (String)ContainerUtil.getOrElse(position.args, (int)i, null);
                        int argOffset = argument.getTextRange().getStartOffset();
                        result2.vars.add(new CMakePackets.CMakeVarValue(varName, value, CMakeDebugProcess.getLineNumber1(doc, argOffset)));
                    }
                    break;
                }
                if (element2 instanceof CMakeFile) break;
            }
            element2 = element2.getParent();
        }
        CMakePsiVarsInfo cMakePsiVarsInfo = result2;
        if (cMakePsiVarsInfo == null) {
            CMakeDebugProcess.$$$reportNull$$$0(21);
        }
        return cMakePsiVarsInfo;
    }

    public XBreakpointHandler<?> @NotNull [] getBreakpointHandlers() {
        Socket socket = this.mySocket;
        Object[] objectArray = this.myConnected && socket != null && socket.isConnected() ? this.myBreakpointHandlers : super.getBreakpointHandlers();
        if (objectArray == null) {
            CMakeDebugProcess.$$$reportNull$$$0(22);
        }
        return objectArray;
    }

    @NotNull
    Promise<CMakePackets.CMakePacket> sendRequest(@NotNull CMakePackets.CMakePacket packet) {
        if (packet == null) {
            CMakeDebugProcess.$$$reportNull$$$0(23);
        }
        return this.sendRequest(null, packet);
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private Promise<CMakePackets.CMakePacket> sendRequest(@Nullable Long suspendId, @NotNull CMakePackets.CMakePacket packet) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static int line0(int oneBasedLine) {
        return oneBasedLine - 1;
    }

    private static int line1(int zeroBasedLine) {
        return zeroBasedLine + 1;
    }

    private static int getLineNumber1(@NotNull Document doc, int cmdOffset) {
        if (doc == null) {
            CMakeDebugProcess.$$$reportNull$$$0(30);
        }
        return CMakeDebugProcess.line1(doc.getLineNumber(cmdOffset));
    }

    @NotNull
    private static InetAddress getLocalHostAddress() throws UnknownHostException, ExecutionException {
        InetAddress[] addresses;
        for (InetAddress address : addresses = InetAddress.getAllByName("localhost")) {
            if (!(address instanceof Inet4Address)) continue;
            InetAddress inetAddress = address;
            if (inetAddress == null) {
                CMakeDebugProcess.$$$reportNull$$$0(31);
            }
            return inetAddress;
        }
        throw new ExecutionException(CLionCMakeBundle.message("cmake.dbg.ipv4.address.not.found", new Object[0]));
    }

    static boolean isEnabled() {
        return Registry.is((String)"cmake.debugger.enabled");
    }

    @Contract(value="null -> null")
    @Nullable
    private VirtualFile findVirtualFile(@Nullable CMakePackets.CMakeBacktraceEntry entry) {
        String filePath = entry != null ? entry.file : null;
        String localPath = StringUtil.isNotEmpty((String)filePath) ? this.myCPPEnvironment.toLocalPath(null, filePath) : null;
        return localPath != null ? VfsUtil.findFileByIoFile((File)new File(localPath), (boolean)true) : null;
    }

    private /* synthetic */ void lambda$sendRequest$12(Long suspendId, AsyncPromise response, CMakePackets.CMakePacket responsePacket) {
        this.myPacketConsumer = null;
        this.myRequestSemaphore.release();
        if (suspendId != null && suspendId.longValue() != this.mySuspendId.get()) {
            response.setError("Request canceled (program resumed)");
            return;
        }
        if (responsePacket instanceof CMakePackets.CMakePacketScError) {
            response.setError(((CMakePackets.CMakePacketScError)responsePacket).details);
        } else {
            response.setResult((Object)responsePacket);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 10, 11, 12, 13, 15, 18, 19, 21, 22, 25, 26, 27, 28, 29, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugToken";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugTokenFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageKey";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "address";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialStop";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curStack";
                break;
            }
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 17: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packet";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "connect";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "runHandshake";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "stopAsync";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "readPacket";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgs";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommandsFromPsi";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getBreakpointHandlers";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "sendRequest";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalHostAddress";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logPacketParseError";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showErrorNotification";
                break;
            }
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reachInitialBreakPositionOrResume";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSteppedIntoLibraryCode";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "runToPosition";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "sendPacket";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectCommandsFromPsi";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "sendRequest";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLineNumber1";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 10, 11, 12, 13, 15, 18, 19, 21, 22, 25, 26, 27, 28, 29, 31 -> new IllegalStateException(string);
        };
    }

    private final class CMakeLineBreakpointHandler
    extends XBreakpointHandler<XLineBreakpoint<CMakeLineBreakpointProperties>> {
        private CMakeLineBreakpointHandler() {
            super(CMakeLineBreakpointType.class);
        }

        public void registerBreakpoint(@NotNull XLineBreakpoint<CMakeLineBreakpointProperties> breakpoint) {
            XSourcePosition breakpointPosition;
            if (breakpoint == null) {
                CMakeLineBreakpointHandler.$$$reportNull$$$0(0);
            }
            if ((breakpointPosition = breakpoint.getSourcePosition()) == null) {
                return;
            }
            CMakeDebugProcess.this.myPendingBreakpointCount.incrementAndGet();
            VirtualFile file = breakpointPosition.getFile();
            ApplicationManager.getApplication().executeOnPooledThread(() -> CMakeDebugProcess.this.sendRequest(new CMakePackets.CMakePacketCsCreateBreakpoint(file.getPath(), CMakeDebugProcess.line1(breakpoint.getLine()))).onError(err -> {
                CMakeDebugProcess.this.getSession().setBreakpointInvalid(breakpoint, err.getMessage());
                CMakeDebugProcess.this.myPendingBreakpointCount.decrementAndGet();
            }).onSuccess(response -> {
                CMakePackets.CMakePacketScBreakpointCreated createdPacket = (CMakePackets.CMakePacketScBreakpointCreated)response;
                CMakeDebugProcess.this.getSession().setBreakpointVerified(breakpoint);
                CMakeDebugProcess.this.myBreakpoints.put(createdPacket.breakpointId, (XBreakpoint<CMakeLineBreakpointProperties>)breakpoint);
                CMakeDebugProcess.this.myBreakpointIds.put((XBreakpoint<CMakeLineBreakpointProperties>)breakpoint, createdPacket.breakpointId);
                CMakeDebugProcess.this.myPendingBreakpointCount.decrementAndGet();
            }));
        }

        public void unregisterBreakpoint(@NotNull XLineBreakpoint<CMakeLineBreakpointProperties> breakpoint, boolean temporary) {
            XSourcePosition breakpointPosition;
            if (breakpoint == null) {
                CMakeLineBreakpointHandler.$$$reportNull$$$0(1);
            }
            if ((breakpointPosition = breakpoint.getSourcePosition()) == null) {
                return;
            }
            Integer breakpointId = CMakeDebugProcess.this.myBreakpointIds.get(breakpoint);
            if (breakpointId == null) {
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> CMakeDebugProcess.this.sendRequest(new CMakePackets.CMakePacketCsDeleteBreakpoint(breakpointId)).onError(err -> XDebuggerManagerImpl.getNotificationGroup().createNotification(CLionCMakeBundle.message("cmake.dbg.failed.to.remove.breakpoint", new Object[0]), NotificationType.ERROR).notify(CMakeDebugProcess.this.getSession().getProject())).onSuccess(response -> {
                if (response instanceof CMakePackets.CMakePacketScBreakpointUpdated) {
                    CMakeDebugProcess.this.myBreakpoints.remove(breakpointId);
                    CMakeDebugProcess.this.myBreakpointIds.remove(breakpoint);
                } else {
                    XDebuggerManagerImpl.getNotificationGroup().createNotification(CLionCMakeBundle.message("cmake.dbg.failed.to.remove.breakpoint", new Object[0]), NotificationType.ERROR).notify(CMakeDebugProcess.this.getSession().getProject());
                }
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "breakpoint";
            objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$CMakeLineBreakpointHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerBreakpoint";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unregisterBreakpoint";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public class CMakeSuspendContext
    extends XSuspendContext {
        private final CMakeExecutionStack myStack;
        private volatile String myErrorDetails;

        public CMakeSuspendContext(CMakePackets.CMakePacketScTargetStopped packet) {
            this.myStack = new CMakeExecutionStack(packet.backtrace);
        }

        @NotNull
        public XExecutionStack getActiveExecutionStack() {
            CMakeExecutionStack cMakeExecutionStack = this.myStack;
            if (cMakeExecutionStack == null) {
                CMakeSuspendContext.$$$reportNull$$$0(0);
            }
            return cMakeExecutionStack;
        }

        public void setErrorDetails(@Nullable String errorDetails) {
            this.myErrorDetails = errorDetails;
        }

        public String getErrorDetails() {
            return this.myErrorDetails;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$CMakeSuspendContext", "getActiveExecutionStack"));
        }
    }

    class CMakeExecutionStack
    extends XExecutionStack {
        private final List<CMakePackets.CMakeBacktraceEntry> myStack;
        private volatile AtomicReference<CMakeStackFrame> myTopFrame;

        CMakeExecutionStack(List<CMakePackets.CMakeBacktraceEntry> stack) {
            super(CLionCMakeBundle.message("cmake.dbg.execution.stack.display.name", new Object[0]));
            this.myStack = stack;
        }

        @Nullable
        public XStackFrame getTopFrame() {
            if (this.myTopFrame == null) {
                CMakePackets.CMakeBacktraceEntry top = (CMakePackets.CMakeBacktraceEntry)ContainerUtil.getFirstItem(this.myStack);
                this.myTopFrame = new AtomicReference<CMakeStackFrame>(top != null ? new CMakeStackFrame(CMakeDebugProcess.this.getSession().getProject(), top) : null);
            }
            return this.myTopFrame.get();
        }

        public void computeStackFrames(int firstFrameIndex, XExecutionStack.XStackFrameContainer container) {
            ArrayList<XStackFrame> frames = new ArrayList<XStackFrame>();
            this.addFrame(frames, this.getTopFrame());
            if (this.myStack.size() > 1) {
                List<CMakePackets.CMakeBacktraceEntry> entries = this.myStack.subList(1, this.myStack.size());
                for (CMakePackets.CMakeBacktraceEntry entry : entries) {
                    this.addFrame(frames, new CMakeStackFrame(CMakeDebugProcess.this.getSession().getProject(), entry));
                }
            }
            container.addStackFrames(frames, true);
        }

        private void addFrame(@NotNull List<XStackFrame> frames, @Nullable XStackFrame frame) {
            if (frames == null) {
                CMakeExecutionStack.$$$reportNull$$$0(0);
            }
            if (frame != null) {
                String function2;
                frames.add(frame);
                String string = function2 = frame instanceof CMakeStackFrame ? ((CMakeStackFrame)frame).myEntry.function : null;
                if (NATIVE_FUNCTIONS.contains(function2)) {
                    frames.add(new CMakeNativeStackFrame());
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frames", "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$CMakeExecutionStack", "addFrame"));
        }
    }

    private static class CMakePsiVarsInfo {
        private Integer funcLine1;
        private Integer ifLine1;
        private final List<CMakePackets.CMakeVarValue> vars = new ArrayList<CMakePackets.CMakeVarValue>();

        private CMakePsiVarsInfo() {
        }
    }

    private static final class CMakeStringPresentation
    extends XValuePresentation {
        private final String myValue;

        private CMakeStringPresentation(@Nullable String value) {
            this.myValue = StringUtil.notNullize((String)value);
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
            if (renderer == null) {
                CMakeStringPresentation.$$$reportNull$$$0(0);
            }
            renderer.renderStringValue(this.myValue);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$CMakeStringPresentation", "renderValue"));
        }
    }

    private static final class CMakeTargetPresentation
    extends XValuePresentation {
        private final int myTargetType;

        private CMakeTargetPresentation(int targetType) {
            this.myTargetType = targetType;
        }

        @NotNull
        public String getType() {
            CMakeDebugConstants.CMakeTargetType targetType = 0 <= this.myTargetType && this.myTargetType < CMakeDebugConstants.CMakeTargetType.values().length ? CMakeDebugConstants.CMakeTargetType.values()[this.myTargetType] : CMakeDebugConstants.CMakeTargetType.Invalid;
            return switch (targetType) {
                case CMakeDebugConstants.CMakeTargetType.Executable -> "executable";
                case CMakeDebugConstants.CMakeTargetType.StaticLibrary -> "static library";
                case CMakeDebugConstants.CMakeTargetType.SharedLibrary -> "shared library";
                case CMakeDebugConstants.CMakeTargetType.ModuleLibrary -> "module library";
                case CMakeDebugConstants.CMakeTargetType.ObjectLibrary -> "object library";
                case CMakeDebugConstants.CMakeTargetType.GlobalTarget -> "global target";
                case CMakeDebugConstants.CMakeTargetType.InterfaceLibrary -> "interface library";
                case CMakeDebugConstants.CMakeTargetType.UnknownLibrary -> "unknown library";
                default -> "Unknown target type";
            };
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
            if (renderer == null) {
                CMakeTargetPresentation.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$CMakeTargetPresentation", "renderValue"));
        }
    }

    class CMakeTargetsXValue
    extends CMakeXValue {
        CMakeTargetsXValue(CMakeStackFrame frame) {
            if (frame == null) {
                CMakeTargetsXValue.$$$reportNull$$$0(0);
            }
            super(null, frame, "Targets");
        }

        @Override
        @NotNull
        String getCmakeName() {
            return ".targets";
        }

        @Override
        protected void drawToNode(@NotNull XValueNode node2, @Nullable String value) {
            if (node2 == null) {
                CMakeTargetsXValue.$$$reportNull$$$0(1);
            }
            node2.setPresentation(this.myIcon, EMPTY_PRESENTATION, this.myCanHaveChildren);
        }

        @Override
        @Nullable
        public String getEvaluationExpression() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$CMakeTargetsXValue";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drawToNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class CMakeEnvXValue
    extends CMakeXValue {
        CMakeEnvXValue(CMakeStackFrame frame) {
            if (frame == null) {
                CMakeEnvXValue.$$$reportNull$$$0(0);
            }
            super(null, frame, "ENV");
        }

        @Override
        protected void drawToNode(@NotNull XValueNode node2, @Nullable String value) {
            if (node2 == null) {
                CMakeEnvXValue.$$$reportNull$$$0(1);
            }
            node2.setPresentation(this.myIcon, EMPTY_PRESENTATION, this.myCanHaveChildren);
        }

        @Override
        @NotNull
        protected CMakeXValue createChildNode(@NotNull String childName) {
            if (childName == null) {
                CMakeEnvXValue.$$$reportNull$$$0(2);
            }
            CMakeXValue child = super.createChildNode(childName);
            child.setCustomEvaluationExpression("ENV{" + childName + "}");
            CMakeXValue cMakeXValue = child;
            if (cMakeXValue == null) {
                CMakeEnvXValue.$$$reportNull$$$0(3);
            }
            return cMakeXValue;
        }

        @Override
        @Nullable
        public String getEvaluationExpression() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$CMakeEnvXValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$CMakeEnvXValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createChildNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "drawToNode";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createChildNode";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    class CMakeErrorXValue
    extends CMakeXValue {
        CMakeErrorXValue(@NotNull CMakeStackFrame frame, String errorDetails) {
            if (errorDetails == null) {
                CMakeErrorXValue.$$$reportNull$$$0(0);
            }
            if (frame == null) {
                CMakeErrorXValue.$$$reportNull$$$0(1);
            }
            super(AllIcons.Debugger.Db_exception_breakpoint, frame, "");
            this.setPrecomputedValue(errorDetails);
        }

        @Override
        protected void drawToNode(@NotNull XValueNode node2, @Nullable String value) {
            if (node2 == null) {
                CMakeErrorXValue.$$$reportNull$$$0(2);
            }
            node2.setPresentation(this.myIcon, (XValuePresentation)new XErrorValuePresentation(this.myPrecomputedValue){

                @NotNull
                public String getSeparator() {
                    return "";
                }

                public boolean isShowName() {
                    return false;
                }
            }, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorDetails";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$CMakeErrorXValue";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drawToNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class CMakeCacheTxtXValue
    extends CMakeXValue {
        CMakeCacheTxtXValue(CMakeStackFrame frame) {
            if (frame == null) {
                CMakeCacheTxtXValue.$$$reportNull$$$0(0);
            }
            super(null, frame, "CMakeCache.txt");
        }

        @Override
        protected void drawToNode(@NotNull XValueNode node2, @Nullable String value) {
            if (node2 == null) {
                CMakeCacheTxtXValue.$$$reportNull$$$0(1);
            }
            if (this.myExprType != CMakeDebugConstants.CMakeExpressionType.Cache) {
                super.drawToNode(node2, value);
            } else if (this.myCanHaveChildren) {
                node2.setPresentation(this.myIcon, EMPTY_PRESENTATION, true);
            } else {
                node2.setPresentation(this.myIcon, new XValuePresentation(){

                    @NotNull
                    public String getSeparator() {
                        return " ";
                    }

                    public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                        if (renderer == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        renderer.renderComment("cache is not used");
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$CMakeCacheTxtXValue$1", "renderValue"));
                    }
                }, false);
            }
        }

        @Override
        @Nullable
        public String getEvaluationExpression() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$CMakeCacheTxtXValue";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drawToNode";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class CMakeXValue
    extends XNamedValue {
        protected final Icon myIcon;
        protected final CMakeStackFrame myFrame;
        protected volatile Integer myExprId;
        protected volatile boolean myCanHaveChildren;
        protected volatile CMakeDebugConstants.CMakeExpressionType myExprType;
        protected volatile String myPrecomputedValue;
        protected volatile int myExprSubType;
        private volatile boolean myIsWatch;
        private volatile String myCustomEvaluationExpression;

        CMakeXValue(@NotNull Icon icon, @NotNull CMakeStackFrame frame, String name2) {
            if (name2 == null) {
                CMakeXValue.$$$reportNull$$$0(0);
            }
            if (frame == null) {
                CMakeXValue.$$$reportNull$$$0(1);
            }
            super(name2);
            this.myExprId = null;
            this.myCanHaveChildren = false;
            this.myExprType = null;
            this.myPrecomputedValue = null;
            this.myExprSubType = 0;
            this.myCustomEvaluationExpression = null;
            this.myIcon = icon;
            this.myFrame = frame;
        }

        void setPrecomputedValue(@Nullable String precomputedValue) {
            this.myPrecomputedValue = precomputedValue;
        }

        void setCanHaveChildren(boolean canHaveChildren) {
            this.myCanHaveChildren = canHaveChildren;
        }

        void setExprType(CMakeDebugConstants.CMakeExpressionType exprType) {
            this.myExprType = exprType;
        }

        void setExprSubType(int exprSubType) {
            this.myExprSubType = exprSubType;
        }

        void setExprId(Integer exprId) {
            this.myExprId = exprId;
        }

        @NotNull
        String getCmakeName() {
            String string = this.getName();
            if (string == null) {
                CMakeXValue.$$$reportNull$$$0(2);
            }
            return string;
        }

        void setWatch() {
            this.myIsWatch = true;
        }

        public void computePresentation(@NotNull XValueNode node2, @NotNull XValuePlace place) {
            String precomputedValue;
            if (node2 == null) {
                CMakeXValue.$$$reportNull$$$0(3);
            }
            if (place == null) {
                CMakeXValue.$$$reportNull$$$0(4);
            }
            if ((precomputedValue = this.myPrecomputedValue) != null) {
                this.drawToNode(node2, precomputedValue);
                return;
            }
            long suspendId = CMakeDebugProcess.this.mySuspendId.get();
            ApplicationManager.getApplication().executeOnPooledThread(() -> CMakeDebugProcess.this.sendRequest(suspendId, new CMakePackets.CMakePacketCsCreateExpression(this.myFrame.myEntry.frameId, this.getCmakeName())).onError(err -> {
                String message = err.getMessage();
                if ("Failed to create expression".equals(message)) {
                    String detailedMessage = message + ". Evaluation is supported only for variables and targets.";
                    node2.setPresentation(null, (XValuePresentation)new XErrorValuePresentation(detailedMessage), false);
                } else {
                    node2.setPresentation(null, (XValuePresentation)new XErrorValuePresentation(message), false);
                }
            }).onSuccess(response -> {
                if (response instanceof CMakePackets.CMakePacketScExpressionCreated) {
                    this.myExprId = ((CMakePackets.CMakePacketScExpressionCreated)response).exprId;
                    this.myCanHaveChildren = ((CMakePackets.CMakePacketScExpressionCreated)response).childCount != 0;
                    this.myExprType = ((CMakePackets.CMakePacketScExpressionCreated)response).exprType;
                    this.myExprSubType = ((CMakePackets.CMakePacketScExpressionCreated)response).exprSubType;
                    this.drawToNode(node2, ((CMakePackets.CMakePacketScExpressionCreated)response).value);
                } else {
                    node2.setPresentation(null, (XValuePresentation)new XErrorValuePresentation("Failed to compute value"), false);
                }
            }));
        }

        public void computeChildren(@NotNull XCompositeNode node2) {
            if (node2 == null) {
                CMakeXValue.$$$reportNull$$$0(5);
            }
            long suspendId = CMakeDebugProcess.this.mySuspendId.get();
            Integer exprId = this.myExprId;
            if (exprId == null || !this.myCanHaveChildren) {
                node2.addChildren(XValueChildrenList.EMPTY, true);
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> CMakeDebugProcess.this.sendRequest(suspendId, new CMakePackets.CMakePacketCsQueryExpressionChildren(exprId)).onError(err -> node2.setErrorMessage(err.getMessage())).onSuccess(response -> {
                if (response instanceof CMakePackets.CMakePacketScExpressionChildrenQueried) {
                    XValueChildrenList list2 = new XValueChildrenList();
                    List<CMakePackets.CMakePacketScExpressionCreated> children = ((CMakePackets.CMakePacketScExpressionChildrenQueried)response).getChildren();
                    children.sort(Comparator.comparing(o -> o.name));
                    for (CMakePackets.CMakePacketScExpressionCreated child : children) {
                        CMakeXValue childValue = this.createChildNode(child.name);
                        childValue.setPrecomputedValue(StringUtil.isEmpty((String)child.value) ? "" : child.value);
                        childValue.setCanHaveChildren(child.childCount != 0);
                        childValue.setExprType(child.exprType);
                        childValue.setExprId(child.exprId);
                        childValue.setExprSubType(child.exprSubType);
                        list2.add((XNamedValue)childValue);
                    }
                    node2.addChildren(list2, true);
                } else {
                    node2.setErrorMessage(CLionCMakeBundle.message("cmake.dbg.failed.to.compute.children", new Object[0]));
                }
            }));
        }

        @NotNull
        protected CMakeXValue createChildNode(@NotNull String childName) {
            if (childName == null) {
                CMakeXValue.$$$reportNull$$$0(6);
            }
            return new CMakeXValue(AllIcons.Debugger.Value, this.myFrame, childName);
        }

        protected void drawToNode(@NotNull XValueNode node2, @Nullable String value) {
            if (node2 == null) {
                CMakeXValue.$$$reportNull$$$0(7);
            }
            if (this.myExprType == CMakeDebugConstants.CMakeExpressionType.Target) {
                node2.setPresentation(this.myIcon, (XValuePresentation)new CMakeTargetPresentation(this.myExprSubType), this.myCanHaveChildren);
            } else {
                node2.setPresentation(this.myIcon, (XValuePresentation)new CMakeStringPresentation(value), this.myCanHaveChildren);
            }
        }

        @NotNull
        public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
            if (callback == null) {
                CMakeXValue.$$$reportNull$$$0(8);
            }
            if (this.myIsWatch) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    CMakeXValue.$$$reportNull$$$0(9);
                }
                return threeState;
            }
            this.computeSourcePosition(arg_0 -> ((XInlineDebuggerDataCallback)callback).computed(arg_0));
            ThreeState threeState = ThreeState.YES;
            if (threeState == null) {
                CMakeXValue.$$$reportNull$$$0(10);
            }
            return threeState;
        }

        public void computeSourcePosition(@NotNull XNavigatable navigatable) {
            if (navigatable == null) {
                CMakeXValue.$$$reportNull$$$0(11);
            }
            String cmakeVarName = this.getCmakeName();
            Map<String, CMakePackets.CMakeVarValue> vars = this.myFrame.myVars;
            CMakePackets.CMakeVarValue varValue = vars != null ? vars.get(cmakeVarName) : null;
            VirtualFile vfile = varValue != null ? CMakeDebugProcess.this.findVirtualFile(this.myFrame.myEntry) : null;
            XSourcePosition pos = vfile != null ? XDebuggerUtil.getInstance().createPosition(vfile, CMakeDebugProcess.line0(varValue.line1)) : null;
            navigatable.setSourcePosition(pos);
        }

        @Nullable
        public String getEvaluationExpression() {
            return this.myCustomEvaluationExpression != null ? this.myCustomEvaluationExpression : this.getCmakeName();
        }

        void setCustomEvaluationExpression(@Nullable String customEvaluationExpression) {
            this.myCustomEvaluationExpression = customEvaluationExpression;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 2: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$CMakeXValue";
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "childName";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigatable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$CMakeXValue";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCmakeName";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeInlineDebuggerData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 9: 
                case 10: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "computePresentation";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "computeChildren";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createChildNode";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "drawToNode";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "computeInlineDebuggerData";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "computeSourcePosition";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 9, 10 -> new IllegalStateException(string);
            };
        }
    }

    class CMakeEvaluator
    extends XDebuggerEvaluator {
        CMakeStackFrame myFrame;

        CMakeEvaluator(CMakeStackFrame frame) {
            if (frame == null) {
                CMakeEvaluator.$$$reportNull$$$0(0);
            }
            this.myFrame = frame;
        }

        public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
            if (expression == null) {
                CMakeEvaluator.$$$reportNull$$$0(1);
            }
            if (callback == null) {
                CMakeEvaluator.$$$reportNull$$$0(2);
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> ReadAction.run(() -> {
                CMakeRoutine routine = (CMakeRoutine)this.myFrame.myRoutine.getValue();
                if (routine instanceof CMakeMacroCommand) {
                    List args2 = (List)this.myFrame.myRoutineArgs.getValue();
                    for (int i = 0; i < args2.size(); ++i) {
                        String value;
                        CMakeArgument arg = (CMakeArgument)args2.get(i);
                        if (!expression.equals(arg.getName()) || (value = (String)ContainerUtil.getOrElse(this.myFrame.myEntry.args, (int)i, null)) == null) continue;
                        CMakeXValue cmakeXValue = new CMakeXValue(AllIcons.Debugger.Watch, this.myFrame, expression);
                        cmakeXValue.setWatch();
                        cmakeXValue.setPrecomputedValue(value);
                        callback.evaluated((XValue)cmakeXValue);
                        return;
                    }
                }
                CMakeXValue watch = new CMakeXValue(AllIcons.Debugger.Watch, this.myFrame, expression);
                watch.setWatch();
                callback.evaluated((XValue)watch);
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "frame";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callback";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$CMakeEvaluator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    class CMakeStackFrame
    extends XStackFrame {
        private final Project myProject;
        private final CMakePackets.CMakeBacktraceEntry myEntry;
        private final Lazy<CMakeRoutine> myRoutine;
        private final Lazy<List<CMakeArgument>> myRoutineArgs;
        private volatile Map<String, CMakePackets.CMakeVarValue> myVars;

        CMakeStackFrame(@NotNull Project project, CMakePackets.CMakeBacktraceEntry entry) {
            if (project == null) {
                CMakeStackFrame.$$$reportNull$$$0(0);
            }
            if (entry == null) {
                CMakeStackFrame.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myEntry = entry;
            this.myRoutine = LazyKt.lazy(() -> {
                String funcName = this.myEntry.function;
                if (funcName == null) {
                    return null;
                }
                return (CMakeRoutine)ReadAction.compute(() -> {
                    CMakeFile cmakeFile;
                    VirtualFile file = CMakeDebugProcess.this.findVirtualFile(this.myEntry);
                    Document doc = file != null ? FileDocumentManager.getInstance().getDocument(file) : null;
                    CMakeFile cMakeFile = cmakeFile = doc != null ? (CMakeFile)ObjectUtils.tryCast((Object)PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(doc), CMakeFile.class) : null;
                    if (cmakeFile != null) {
                        int offset = doc.getLineStartOffset(CMakeDebugProcess.line0(this.myEntry.line1));
                        PsiElement element2 = cmakeFile.findElementAt(offset);
                        CMakeRoutine routine = (CMakeRoutine)PsiTreeUtil.getParentOfType((PsiElement)element2, CMakeRoutine.class);
                        return routine != null && funcName.equals(routine.getName()) ? routine : null;
                    }
                    return null;
                });
            });
            this.myRoutineArgs = LazyKt.lazy(() -> (List)ReadAction.compute(() -> {
                List<Object> result2;
                CMakeRoutine routine = (CMakeRoutine)this.myRoutine.getValue();
                CMakeCommandArguments arguments = null;
                if (routine instanceof CMakeFunctionCommand) {
                    arguments = ((CMakeFunctionCommand)routine).getCMakeCommandArguments();
                } else if (routine instanceof CMakeMacroCommand) {
                    arguments = ((CMakeMacroCommand)routine).getCMakeCommandArguments();
                }
                List<Object> list2 = result2 = arguments != null ? arguments.getCMakeArgumentList() : Collections.emptyList();
                if (!result2.isEmpty()) {
                    result2 = result2.subList(1, result2.size());
                }
                return result2;
            }));
        }

        @Nullable
        public XSourcePosition getSourcePosition() {
            VirtualFile vfile = CMakeDebugProcess.this.findVirtualFile(this.myEntry);
            return vfile != null ? XDebuggerUtil.getInstance().createPosition(vfile, CMakeDebugProcess.line0(this.myEntry.line1)) : null;
        }

        @Nullable
        public Object getEqualityObject() {
            return this.myEntry.frameId + ":" + this.myEntry.file + ":" + StringUtil.notNullize((String)this.myEntry.function);
        }

        public void customizePresentation(@NotNull ColoredTextContainer component2) {
            XSourcePosition position;
            if (component2 == null) {
                CMakeStackFrame.$$$reportNull$$$0(2);
            }
            if ((position = this.getSourcePosition()) != null) {
                VirtualFile file = position.getFile();
                VirtualFile dir = file.getParent();
                String fileName = file.getName();
                String funcName = this.myEntry.function;
                if (StringUtil.isNotEmpty((String)funcName)) {
                    component2.append(funcName + " ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                }
                component2.append((String)(fileName.equals("CMakeLists.txt") && dir != null ? dir.getName() + "/" : "") + fileName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                component2.append(":" + CMakeDebugProcess.line1(position.getLine()), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                component2.setIcon(AllIcons.Debugger.Frame);
            } else {
                component2.append(XDebuggerBundle.message((String)"invalid.frame", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
            }
        }

        public void computeChildren(@NotNull XCompositeNode node2) {
            if (node2 == null) {
                CMakeStackFrame.$$$reportNull$$$0(3);
            }
            long suspendId = CMakeDebugProcess.this.mySuspendId.get();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                Promise<List<CMakePackets.CMakeVarValue>> writesPromise = this.getVars(suspendId);
                XValueChildrenList list2 = new XValueChildrenList();
                CMakeSuspendContext context2 = (CMakeSuspendContext)((Object)((Object)ObjectUtils.tryCast((Object)CMakeDebugProcess.this.getSession().getSuspendContext(), CMakeSuspendContext.class)));
                if (context2 != null) {
                    XExecutionStack stack = context2.getActiveExecutionStack();
                    String error = context2.getErrorDetails();
                    if (StringUtil.isNotEmpty((String)error) && this == stack.getTopFrame()) {
                        list2.add((XNamedValue)new CMakeErrorXValue(this, error));
                    }
                }
                list2.add((XNamedValue)new CMakeEnvXValue(this));
                list2.add((XNamedValue)new CMakeCacheTxtXValue(this));
                list2.add((XNamedValue)new CMakeTargetsXValue(this));
                CMakePsiVarsInfo psiVarsInfo = (CMakePsiVarsInfo)ReadAction.compute(() -> CMakeDebugProcess.this.collectCommandsFromPsi(this.myEntry));
                writesPromise.then(writes -> {
                    HashMap<String, CMakePackets.CMakeVarValue> vars = new HashMap<String, CMakePackets.CMakeVarValue>();
                    ArrayList<CMakePackets.CMakeVarValue> all = new ArrayList<CMakePackets.CMakeVarValue>((Collection<CMakePackets.CMakeVarValue>)writes);
                    all.addAll(psiVarsInfo.vars);
                    all.sort((o1, o2) -> {
                        if (o1.line1 == o2.line1) {
                            return o1.varName.compareTo(o2.varName);
                        }
                        return Integer.compare(o1.line1, o2.line1);
                    });
                    HashSet<String> processed = new HashSet<String>();
                    for (CMakePackets.CMakeVarValue v : all) {
                        if (v.varName.startsWith("CMAKE_MATCH_") && (psiVarsInfo.ifLine1 == null || v.line1 != psiVarsInfo.ifLine1) || !processed.add(v.varName)) continue;
                        CMakeXValue value = new CMakeXValue(AllIcons.Debugger.Value, this, v.varName);
                        value.setPrecomputedValue(v.varValue);
                        list2.add((XNamedValue)value);
                        vars.put(v.varName, v);
                    }
                    if (psiVarsInfo.funcLine1 != null) {
                        CMakeDebugProcess.this.sendRequest(suspendId, new CMakePackets.CMakePacketCsCreateExpression(this.myEntry.frameId, "ARGN")).onProcessed(response -> {
                            String value;
                            if (response instanceof CMakePackets.CMakePacketScExpressionCreated && StringUtil.isNotEmpty((String)(value = ((CMakePackets.CMakePacketScExpressionCreated)response).value))) {
                                vars.put("ARGN", new CMakePackets.CMakeVarValue("ARGN", value, psiVarsInfo.funcLine1));
                                list2.add((XNamedValue)new CMakeXValue(AllIcons.Debugger.Value, this, "ARGN"));
                            }
                            this.myVars = vars;
                            node2.addChildren(list2, true);
                        });
                    } else {
                        this.myVars = vars;
                        node2.addChildren(list2, true);
                    }
                    return null;
                });
            });
        }

        @NotNull
        private Promise<List<CMakePackets.CMakeVarValue>> getVars(long suspendId) {
            Promise promise = CMakeDebugProcess.this.sendRequest(suspendId, new CMakePackets.CMakePacketCsVarsIn(this.myEntry.frameId, 1, this.myEntry.line1)).then(response -> response instanceof CMakePackets.CMakePacketScVarsOut ? ((CMakePackets.CMakePacketScVarsOut)response).vars : Collections.emptyList());
            if (promise == null) {
                CMakeStackFrame.$$$reportNull$$$0(4);
            }
            return promise;
        }

        @Nullable
        public XDebuggerEvaluator getEvaluator() {
            return new CMakeEvaluator(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$CMakeStackFrame";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$CMakeStackFrame";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVars";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "customizePresentation";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "computeChildren";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    static class CMakeNativeStackFrame
    extends XStackFrame {
        CMakeNativeStackFrame() {
        }

        public void customizePresentation(@NotNull ColoredTextContainer component2) {
            if (component2 == null) {
                CMakeNativeStackFrame.$$$reportNull$$$0(0);
            }
            component2.append(CLionCMakeBundle.message("cmake.dbg.native.code.frame", new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
            component2.setIcon(AllIcons.Debugger.Frame);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugProcess$CMakeNativeStackFrame", "customizePresentation"));
        }
    }
}

