/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.debugger;

import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.ConsoleDependentFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.cmake.console.CMakeConsoleMessageType;
import com.jetbrains.cidr.cpp.cmake.console.CMakeConsoleViewImpl;
import com.jetbrains.cidr.cpp.cmake.console.CMakeOutputFilter;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModel;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProfileInfo;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.CMakeBuildProfileExecutionTarget;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeDebugProcess;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeListConfigurationType;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeListRunConfiguration;
import com.jetbrains.cidr.cpp.execution.debugger.CMakeRunProfileState;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeDebugConsoleFilterProvider
extends ConsoleDependentFilterProvider {
    public Filter @NotNull [] getDefaultFilters(@NotNull ConsoleView consoleView, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (consoleView == null) {
            CMakeDebugConsoleFilterProvider.$$$reportNull$$$0(0);
        }
        if (project == null) {
            CMakeDebugConsoleFilterProvider.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            CMakeDebugConsoleFilterProvider.$$$reportNull$$$0(2);
        }
        if (CMakeDebugProcess.isEnabled() && consoleView instanceof CMakeConsoleViewImpl) {
            CPPEnvironment environment2;
            CMakeConsoleViewImpl cmakeConsole = (CMakeConsoleViewImpl)consoleView;
            CMakeProfileInfo profileInfo = CMakeDebugConsoleFilterProvider.findProfile(project, cmakeConsole);
            CPPEnvironment cPPEnvironment = environment2 = profileInfo != null ? profileInfo.getEnvironment() : null;
            if (environment2 != null && CMakeRunProfileState.isSupportedToolchain(environment2.getToolchain())) {
                String profileName = profileInfo.getProfile().getName();
                Filter[] filterArray = new Filter[]{new CMakeDebuggerFilter(project, profileName)};
                if (filterArray == null) {
                    CMakeDebugConsoleFilterProvider.$$$reportNull$$$0(3);
                }
                return filterArray;
            }
        }
        if (Filter.EMPTY_ARRAY == null) {
            CMakeDebugConsoleFilterProvider.$$$reportNull$$$0(4);
        }
        return Filter.EMPTY_ARRAY;
    }

    @Nullable
    private static CMakeProfileInfo findProfile(@NotNull Project project, @NotNull CMakeConsoleViewImpl cmakeConsole) {
        CMakeProfileInfo profileInfo;
        if (project == null) {
            CMakeDebugConsoleFilterProvider.$$$reportNull$$$0(5);
        }
        if (cmakeConsole == null) {
            CMakeDebugConsoleFilterProvider.$$$reportNull$$$0(6);
        }
        if ((profileInfo = cmakeConsole.getProfileInfo()) != null) {
            return profileInfo;
        }
        String profileName = cmakeConsole.getProfileName();
        CMakeWorkspace cmakeWorkspace = CMakeWorkspace.getInstance(project);
        if (!cmakeWorkspace.isInitialized()) {
            return null;
        }
        return cmakeWorkspace.getCMakeProfileInfoByName(profileName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugConsoleFilterProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugConsoleFilterProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultFilters";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findProfile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    static class CMakeDebuggerFilter
    implements Filter,
    DumbAware {
        private final Project myProject;
        private final String myCMakeProfileName;

        CMakeDebuggerFilter(@NotNull Project project, @NotNull String profileName) {
            if (project == null) {
                CMakeDebuggerFilter.$$$reportNull$$$0(0);
            }
            if (profileName == null) {
                CMakeDebuggerFilter.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myCMakeProfileName = profileName;
        }

        @Nullable
        public Filter.Result applyFilter(@NotNull String line, int entireLength) {
            if (line == null) {
                CMakeDebuggerFilter.$$$reportNull$$$0(2);
            }
            if (!CMakeConsoleMessageType.ERROR.equals((Object)CMakeOutputFilter.getMessageType(line))) {
                return null;
            }
            int lineEnd = entireLength - 1;
            return new Filter.Result(Arrays.asList(new Filter.ResultItem[]{new CMakeDebugInlayResult(this.myProject, this.myCMakeProfileName, lineEnd - 1, lineEnd), new Filter.ResultItem(0, 0, null)}));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "profileName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugConsoleFilterProvider$CMakeDebuggerFilter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyFilter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CMakeDebugInlayResult
    extends Filter.ResultItem
    implements InlayProvider {
        private final Project myProject;
        private final String myCMakeProfileName;

        private CMakeDebugInlayResult(@NotNull Project project, @NotNull String cmakeProfileName, int highlightStartOffset, int highlightEndOffset) {
            if (project == null) {
                CMakeDebugInlayResult.$$$reportNull$$$0(0);
            }
            if (cmakeProfileName == null) {
                CMakeDebugInlayResult.$$$reportNull$$$0(1);
            }
            super(highlightStartOffset, highlightEndOffset, null);
            this.myProject = project;
            this.myCMakeProfileName = cmakeProfileName;
        }

        public EditorCustomElementRenderer createInlayRenderer(Editor editor) {
            PresentationFactory factory = new PresentationFactory(editor);
            InlayPresentation presentation = factory.referenceOnHover(factory.roundWithBackground(factory.smallText(CLionCMakeBundle.message("cmake.dbg.debug.inlay", new Object[0]))), (event, point) -> {
                final RunnerAndConfigurationSettings configuration2 = RunManager.getInstance((Project)this.myProject).createConfiguration("", CMakeListConfigurationType.getInstance().getFactory());
                final CMakeListRunConfiguration cmakeConfiguration = (CMakeListRunConfiguration)((Object)((Object)ObjectUtils.tryCast((Object)configuration2.getConfiguration(), CMakeListRunConfiguration.class)));
                if (cmakeConfiguration != null) {
                    new Task.Backgroundable(this.myProject, CLionCMakeBundle.message("cmake.dbg.starting.debugger", new Object[0]), true){

                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            assert (this.myProject != null);
                            CMakeWorkspace cmakeWorkspace = CMakeWorkspace.getInstance(this.myProject);
                            CMakeProfileInfo profileInfo = cmakeWorkspace.getCMakeProfileInfoByName(myCMakeProfileName);
                            if (profileInfo == null) {
                                XDebuggerManagerImpl.getNotificationGroup().createNotification(CLionCMakeBundle.message("cmake.dbg.failed.to.find.cmake.profile", new Object[0]), NotificationType.ERROR).notify(this.myProject);
                                return;
                            }
                            CMakeModel model = cmakeWorkspace.getModel();
                            String cmakeProjectName = model != null ? model.getProjectName() : "Project";
                            cmakeConfiguration.setName(cmakeProjectName);
                            ApplicationManager.getApplication().invokeLater(() -> {
                                Executor debugExecutor = DefaultDebugExecutor.getDebugExecutorInstance();
                                ExecutionEnvironmentBuilder environment2 = ExecutionUtil.createEnvironment((Executor)debugExecutor, (RunnerAndConfigurationSettings)configuration2);
                                if (environment2 == null) {
                                    return;
                                }
                                environment2.target((ExecutionTarget)new CMakeBuildProfileExecutionTarget(myCMakeProfileName));
                                ExecutionManager.getInstance((Project)this.myProject).restartRunProfile(environment2.build());
                            });
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugConsoleFilterProvider$CMakeDebugInlayResult$1", "run"));
                        }
                    }.queue();
                } else {
                    XDebuggerManagerImpl.getNotificationGroup().createNotification(CLionCMakeBundle.message("cmake.dbg.failed.to.create.cmake.run.configuration", new Object[0]), NotificationType.ERROR).notify(this.myProject);
                }
            });
            return new PresentationRenderer(presentation);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cmakeProfileName";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/execution/debugger/CMakeDebugConsoleFilterProvider$CMakeDebugInlayResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

