/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.compound.migration;

import com.intellij.conversion.CannotConvertException;
import com.intellij.conversion.ConversionProcessor;
import com.intellij.conversion.ProjectConverter;
import com.intellij.conversion.RunManagerSettings;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.execution.compound.CidrCompoundBuildBeforeRunTaskProviderKt;
import com.jetbrains.cidr.execution.CidrBuildBeforeRunTaskProvider;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class CidrCompoundRunConfigurationConverter
extends ProjectConverter {
    public static final String EMBEDDED_GDBSERVER_TYPE_ID = "com.jetbrains.cidr.embedded.customgdbserver.type";
    static final List<String> MIGRATION_LIST = Arrays.asList("com.jetbrains.cidr.embedded.customgdbserver.type", "com.jetbrains.cidr.remote.gdbserver.type");

    @Nullable
    public ConversionProcessor<RunManagerSettings> createRunConfigurationsConverter() {
        return new ConversionProcessor<RunManagerSettings>(){

            public boolean isConversionNeeded(RunManagerSettings settings2) {
                return ContainerUtil.exists((Iterable)settings2.getRunConfigurations(), CidrCompoundRunConfigurationConverter::isConversionNeeded);
            }

            public void process(RunManagerSettings settings2) throws CannotConvertException {
                settings2.getRunConfigurations().stream().filter(CidrCompoundRunConfigurationConverter::isConversionNeeded).forEach(CidrCompoundRunConfigurationConverter::convert);
            }
        };
    }

    private static boolean isConversionNeeded(Element element2) {
        return MIGRATION_LIST.contains(element2.getAttributeValue("type")) && CidrCompoundRunConfigurationConverter.isConversionOfBeforeRunTaskNeeded(element2);
    }

    private static void convert(Element element2) {
        Element option = CidrCompoundRunConfigurationConverter.getOptionElement(element2);
        if (option != null) {
            option.setAttribute("name", CidrCompoundBuildBeforeRunTaskProviderKt.ID.toString());
            option.setAttribute("enabled", Boolean.TRUE.toString());
        }
    }

    private static boolean isConversionOfBeforeRunTaskNeeded(Element element2) {
        Element option = CidrCompoundRunConfigurationConverter.getOptionElement(element2);
        return option != null && CidrBuildBeforeRunTaskProvider.ID.toString().equals(option.getAttributeValue("name"));
    }

    @Nullable
    private static Element getOptionElement(Element element2) {
        Element method = element2.getChild("method");
        return method != null ? method.getChild("option") : null;
    }
}

