/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.build;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.ContentsUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.CidrRunnerBundle;
import com.jetbrains.cidr.cpp.execution.build.CLionBuildConsoleBuilder;
import com.jetbrains.cidr.cpp.execution.build.CLionBuildUtil;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.execution.build.CidrBuild;
import com.jetbrains.cidr.execution.build.CidrBuildListener;
import java.io.File;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001aD\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00012\b\u0010\u000b\u001a\u0004\u0018\u00010\u00012\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"ACTION_PLACE", "", "createBuildConsole", "Lcom/intellij/execution/ui/ConsoleView;", "project", "Lcom/intellij/openapi/project/Project;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "baseDir", "Ljava/io/File;", "taskName", "preBuildMessage", "buildSessionId", "", "context", "Lcom/jetbrains/cidr/execution/build/CidrBuild$BuildContext;", "getDefaultBuildProcesses", "", "cpuCount", "intellij.clion.execution"})
@SourceDebugExtension(value={"SMAP\nclionBuildUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 clionBuildUtil.kt\ncom/jetbrains/cidr/cpp/execution/build/ClionBuildUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,130:1\n1#2:131\n*E\n"})
public final class ClionBuildUtilKt {
    @NotNull
    public static final String ACTION_PLACE = "CLionBuildConsole";

    public static final int getDefaultBuildProcesses() {
        return ClionBuildUtilKt.getDefaultBuildProcesses(Runtime.getRuntime().availableProcessors());
    }

    public static final int getDefaultBuildProcesses(int cpuCount) {
        return Math.max(1, Math.max(cpuCount - 2, (int)Math.floor((double)cpuCount * 0.8)));
    }

    @NotNull
    public static final ConsoleView createBuildConsole(@NotNull Project project, @NotNull CPPEnvironment environment2, @Nullable File baseDir, @NotNull String taskName, @Nullable String preBuildMessage, @Nullable Object buildSessionId, @NotNull CidrBuild.BuildContext context2) {
        Object object;
        ContentManager contentManager;
        block4: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            ThreadingAssertions.assertEventDispatchThread();
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("Messages");
            Intrinsics.checkNotNull((Object)toolWindow);
            ToolWindow toolWindow2 = toolWindow;
            ContentManager contentManager2 = toolWindow2.getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"getContentManager(...)");
            contentManager = contentManager2;
            Content[] contentArray = contentManager.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            for (Object object2 : (Object[])contentArray) {
                Content it = (Content)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)CidrRunnerBundle.message((String)"build.logToolWindowName", (Object[])new Object[0]))) continue;
                object = object2;
                break block4;
            }
            object = null;
        }
        Content usedContent = (Content)object;
        ConsoleViewImpl consoleView = null;
        if (usedContent == null || !(usedContent.getComponent() instanceof ConsoleViewImpl) || buildSessionId == null || !Intrinsics.areEqual((Object)buildSessionId, (Object)CLionBuildUtil.getBuildSessionId(usedContent))) {
            ConsoleView consoleView2 = new CLionBuildConsoleBuilder(project, environment2, baseDir).getConsole();
            Intrinsics.checkNotNull((Object)consoleView2, (String)"null cannot be cast to non-null type com.intellij.execution.impl.ConsoleViewImpl");
            consoleView = (ConsoleViewImpl)consoleView2;
            JComponent jComponent = consoleView.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            JComponent component2 = jComponent;
            Content content = ContentFactory.getInstance().createContent(component2, CidrRunnerBundle.message((String)"build.logToolWindowName", (Object[])new Object[0]), true);
            Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
            Content content2 = content;
            content2.setPreferredFocusableComponent(component2);
            ContentsUtil.addOrReplaceContent((ContentManager)contentManager, (Content)content2, (boolean)true);
            if (buildSessionId != null) {
                content2.putUserData(ExecutionManagerImpl.EXECUTION_SESSION_ID_KEY, buildSessionId);
            }
            Disposer.register((Disposable)((Disposable)content2), (Disposable)((Disposable)consoleView));
            contentManager.addContentManagerListener((ContentManagerListener)new CidrBuild.BuildContentRemoveListener(project, contentManager, content2, context2));
        } else {
            JComponent jComponent = usedContent.getComponent();
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.execution.impl.ConsoleViewImpl");
            consoleView = (ConsoleViewImpl)jComponent;
            consoleView.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        consoleView.putClientProperty(CidrBuild.BuildContext.class, (Object)context2);
        consoleView.attachToProcess(context2.processHandler);
        MessageBusConnection buildConnection = project.getMessageBus().connect();
        CidrBuildListener cidrBuildListener = CLionBuildUtil.notificationListener(buildConnection, context2.id, context2.processHandler, taskName, preBuildMessage);
        Intrinsics.checkNotNullExpressionValue((Object)cidrBuildListener, (String)"notificationListener(...)");
        CidrBuildListener buildListener = cidrBuildListener;
        Topic topic = CidrBuildListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        buildConnection.subscribe(topic, (Object)buildListener);
        return (ConsoleView)consoleView;
    }
}

