/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.build;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.execution.CLionRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeBuildProfileExecutionTarget;
import com.jetbrains.cidr.cpp.execution.CMakeRunConfigurationUtil;
import com.jetbrains.cidr.cpp.execution.build.CMakeBuild;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrRunConfigurationUtil;
import com.jetbrains.cidr.execution.build.CidrBuildConfigurationProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/cpp/execution/build/CMakeBuildConfigurationProvider;", "Lcom/jetbrains/cidr/execution/build/CidrBuildConfigurationProvider;", "()V", "getBuildAndRunConfigurations", "Lcom/jetbrains/cidr/cpp/execution/CMakeAppRunConfiguration$BuildAndRunConfigurations;", "project", "Lcom/intellij/openapi/project/Project;", "getBuildableConfigurations", "", "Lcom/jetbrains/cidr/execution/CidrBuildConfiguration;", "getCleanableConfigurations", "hasBuildableConfigurations", "", "hasCleanableConfigurations", "intellij.clion.cmake"})
public final class CMakeBuildConfigurationProvider
implements CidrBuildConfigurationProvider {
    private final CMakeAppRunConfiguration.BuildAndRunConfigurations getBuildAndRunConfigurations(Project project) {
        CLionRunConfiguration configuration2 = (CLionRunConfiguration)CidrRunConfigurationUtil.getSelectedRunConfiguration((Project)project, CLionRunConfiguration.class);
        CMakeBuildProfileExecutionTarget target2 = CMakeAppRunConfiguration.getSelectedBuildProfile(project);
        if (configuration2 == null || target2 == null) {
            return null;
        }
        return CMakeRunConfigurationUtil.getBuildAndRunConfigurations(configuration2, target2);
    }

    @NotNull
    public List<CidrBuildConfiguration> getBuildableConfigurations(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations = this.getBuildAndRunConfigurations(project);
        if (buildAndRunConfigurations == null) {
            return CollectionsKt.emptyList();
        }
        CMakeAppRunConfiguration.BuildAndRunConfigurations configurations2 = buildAndRunConfigurations;
        List<CidrBuildConfiguration> list2 = CMakeBuild.getBuildableElements(configurations2);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getBuildableElements(...)");
        return list2;
    }

    @NotNull
    public List<CidrBuildConfiguration> getCleanableConfigurations(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations = this.getBuildAndRunConfigurations(project);
        if (buildAndRunConfigurations == null) {
            return CollectionsKt.emptyList();
        }
        CMakeAppRunConfiguration.BuildAndRunConfigurations configurations2 = buildAndRunConfigurations;
        return CollectionsKt.listOf((Object)configurations2.buildConfiguration);
    }

    public boolean hasBuildableConfigurations(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return CMakeWorkspace.Companion.getInstance(project).isInitialized() && CidrRunConfigurationUtil.getSelectedRunConfiguration((Project)project, CLionRunConfiguration.class) != null && CMakeAppRunConfiguration.getSelectedBuildProfile(project) != null;
    }

    public boolean hasCleanableConfigurations(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.hasBuildableConfigurations(project);
    }
}

