/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.execution.CidrCommandLineConfigurator;
import com.jetbrains.cidr.execution.CidrProgramParameters;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.wsl.CidrWSLHost;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/cpp/execution/CLionCommandLineConfigurator;", "Lcom/jetbrains/cidr/execution/CidrCommandLineConfigurator;", "runPath", "Ljava/nio/file/Path;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "project", "Lcom/intellij/openapi/project/Project;", "parameters", "Lcom/jetbrains/cidr/execution/CidrProgramParameters;", "(Ljava/nio/file/Path;Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/execution/CidrProgramParameters;)V", "configureCommandLine", "", "cl", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "intellij.clion.execution"})
public final class CLionCommandLineConfigurator
extends CidrCommandLineConfigurator {
    @NotNull
    private final Path runPath;
    @NotNull
    private final CPPEnvironment environment;

    public CLionCommandLineConfigurator(@NotNull Path runPath, @NotNull CPPEnvironment environment2, @NotNull Project project, @NotNull CidrProgramParameters parameters2) {
        Intrinsics.checkNotNullParameter((Object)runPath, (String)"runPath");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        super(project, parameters2);
        this.runPath = runPath;
        this.environment = environment2;
    }

    public void configureCommandLine(@NotNull GeneralCommandLine cl) throws ExecutionException {
        Path absoluteRunPath;
        boolean isRemoteHostWithoutFS;
        Intrinsics.checkNotNullParameter((Object)cl, (String)"cl");
        super.configureCommandLine(cl);
        HostMachine hostMachine = this.environment.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"getHostMachine(...)");
        HostMachine host = hostMachine;
        boolean bl = isRemoteHostWithoutFS = host.isRemote() && !host.hasRemoteFS();
        if (this.runPath.isAbsolute() || isRemoteHostWithoutFS && this.environment.isEnvAbsolute(((Object)this.runPath).toString())) {
            boolean exists;
            boolean bl2 = host instanceof CidrWSLHost ? true : (exists = isRemoteHostWithoutFS ? true : Files.exists(this.runPath, new LinkOption[0]));
            if (!exists) {
                Object[] objectArray = new Object[]{this.runPath};
                throw new ExecutionException(CLionExecutionBundle.message("run.fileNotFound", objectArray));
            }
            return;
        }
        File file = cl.getWorkDirectory();
        String workDirectory = file != null ? file.toString() : null;
        Object[] objectArray = (Object[])workDirectory;
        if (objectArray == null || StringsKt.isBlank((CharSequence)objectArray)) {
            objectArray = new Object[]{this.runPath};
            throw new ExecutionException(CLionExecutionBundle.message("run.relativeFileNotFound", objectArray));
        }
        Path path = absoluteRunPath = ApplicationManager.getApplication().isDispatchThread() ? (Path)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> CLionCommandLineConfigurator.configureCommandLine$lambda$0(this, workDirectory, cl), CLionExecutionBundle.message("checking.executable.file", new Object[0]), false, null) : CLionCommandLineConfigurator.configureCommandLine$toAbsolutePath(this, workDirectory, cl);
        if (!absoluteRunPath.isAbsolute() || !Files.exists(absoluteRunPath, new LinkOption[0])) {
            Object[] objectArray2 = new Object[]{this.runPath, workDirectory};
            throw new ExecutionException(CLionExecutionBundle.message("run.fileNotFound.inDirectory", objectArray2));
        }
        cl.withExePath(((Object)absoluteRunPath).toString());
    }

    private static final Path configureCommandLine$toAbsolutePath(CLionCommandLineConfigurator this$0, String workDirectory, GeneralCommandLine $cl) {
        String[] stringArray = new String[]{$cl.getExePath()};
        Path path = this$0.environment.getHostMachine().getPath(workDirectory, stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return path;
    }

    private static final Path configureCommandLine$lambda$0(CLionCommandLineConfigurator this$0, String $workDirectory, GeneralCommandLine $cl) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$cl, (String)"$cl");
        return CLionCommandLineConfigurator.configureCommandLine$toAbsolutePath(this$0, $workDirectory, $cl);
    }
}

