/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.workspace.ui;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.cmake.actions.CMakeActionsUtilKt;
import com.jetbrains.cidr.cpp.cmake.actions.CMakeAddFileToProjectAction;
import com.jetbrains.cidr.cpp.cmake.actions.CMakeCreateListsAction;
import com.jetbrains.cidr.cpp.cmake.actions.LoadCMakeProjectAction;
import com.jetbrains.cidr.cpp.cmake.actions.ReloadCMakeProjectAction;
import com.jetbrains.cidr.cpp.cmake.actions.ToggleCMakeAutoReloadAction;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProjectsAware;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeReloadStatusService;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.lang.daemon.OCFileScopeProvider;
import com.jetbrains.cidr.project.ui.ProjectStatusHelperKt;
import com.jetbrains.cidr.project.ui.notifications.EditorNotificationWarningProvider;
import com.jetbrains.cidr.project.ui.notifications.ProjectNotification;
import com.jetbrains.cidr.project.ui.popup.ProjectFixesPopup;
import com.jetbrains.cidr.project.ui.popup.ProjectFixesProvider;
import com.jetbrains.cidr.project.ui.popup.ProjectStatusUpdatingWrappingActionKt;
import com.jetbrains.cidr.project.ui.widget.DefaultWidgetStatus;
import com.jetbrains.cidr.project.ui.widget.Scope;
import com.jetbrains.cidr.project.ui.widget.Status;
import com.jetbrains.cidr.project.ui.widget.WidgetStatus;
import com.jetbrains.cidr.project.ui.widget.WidgetStatusProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\nH\u0016\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/workspace/ui/CMakeProjectStatusAndFixesProvider;", "Lcom/jetbrains/cidr/project/ui/notifications/EditorNotificationWarningProvider;", "Lcom/jetbrains/cidr/project/ui/popup/ProjectFixesProvider;", "Lcom/jetbrains/cidr/project/ui/widget/WidgetStatusProvider;", "()V", "cmakeNeedsToBeReloaded", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "collectFixes", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "getProjectNotification", "Lcom/jetbrains/cidr/project/ui/notifications/ProjectNotification;", "getWidgetStatus", "Lcom/jetbrains/cidr/project/ui/widget/WidgetStatus;", "currentFile", "SelectAndLoadProjectAction", "intellij.clion.cmake"})
@SourceDebugExtension(value={"SMAP\nCMakeProjectStatusAndFixesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CMakeProjectStatusAndFixesProvider.kt\ncom/jetbrains/cidr/cpp/cmake/workspace/ui/CMakeProjectStatusAndFixesProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1747#2,3:107\n*S KotlinDebug\n*F\n+ 1 CMakeProjectStatusAndFixesProvider.kt\ncom/jetbrains/cidr/cpp/cmake/workspace/ui/CMakeProjectStatusAndFixesProvider\n*L\n67#1:107,3\n*E\n"})
public final class CMakeProjectStatusAndFixesProvider
implements EditorNotificationWarningProvider,
ProjectFixesProvider,
WidgetStatusProvider {
    @Nullable
    public ProjectNotification getProjectNotification(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return ProjectStatusHelperKt.convertStatus((WidgetStatus)this.getWidgetStatus(project, file));
    }

    private final boolean cmakeNeedsToBeReloaded(Project project, VirtualFile file) {
        return !CMakeProjectsAware.Companion.isEnabled() && CMakeReloadStatusService.Companion.getInstance(project).isReloadNeeded() && CMakeWorkspace.Companion.getInstance(project).getCMakeDependencyFiles().contains(VfsUtilCore.virtualToIoFile((VirtualFile)file));
    }

    @NotNull
    public List<AnAction> collectFixes(@NotNull Project project, @Nullable VirtualFile file, @NotNull DataContext context2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        List result2 = new ArrayList();
        if (!CMakeWorkspace.Companion.getInstance(project).isInitialized()) {
            if (!LoadCMakeProjectAction.Companion.canLoadWorkspace(project)) {
                return CollectionsKt.emptyList();
            }
            if (file != null && FileUtil.namesEqual((String)file.getName(), (String)"CMakeLists.txt")) {
                result2.add(ProjectStatusUpdatingWrappingActionKt.asProjectStatusUpdatingAction((AnAction)((AnAction)new LoadCMakeProjectAction()), (String)CLionCMakeBundle.message("cmake.loadCMakeNotification.action.load", new Object[0])));
            }
            if (CMakeActionsUtilKt.canCreateNewCMakeLists(project)) {
                Object[] objectArray = new AnAction[]{ProjectStatusUpdatingWrappingActionKt.asProjectStatusUpdatingAction$default((AnAction)new SelectAndLoadProjectAction(project), null, (int)1, null), ProjectStatusUpdatingWrappingActionKt.asProjectStatusUpdatingAction((AnAction)new CMakeCreateListsAction(), (String)CLionCMakeBundle.message("action.CMake.CreateLists.text", new Object[0]))};
                result2.add(ProjectFixesPopup.Companion.createActionGroup(CollectionsKt.listOf((Object[])objectArray), true, CLionCMakeBundle.message("action.configure.cmake.project.text", new Object[0]), true));
            } else {
                result2.add(ProjectStatusUpdatingWrappingActionKt.asProjectStatusUpdatingAction$default((AnAction)new SelectAndLoadProjectAction(project), null, (int)1, null));
            }
            return result2;
        }
        if (file != null && ProjectStatusHelperKt.isProjectAwareFile((VirtualFile)file, (Project)project) && OCFileScopeProvider.Companion.getProjectSourceLocationKind(project, file).isOutProject()) {
            boolean bl;
            block11: {
                Iterable $this$any$iv = CMakeWorkspace.Companion.getInstance(project).getCMakeDependencyFiles();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        File it = (File)element$iv;
                        boolean bl2 = false;
                        if (!it.exists()) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl) {
                Object[] objectArray = new Object[]{StringUtil.shortenPathWithEllipsis((String)file.getName(), (int)30)};
                result2.add(ProjectStatusUpdatingWrappingActionKt.asProjectStatusUpdatingAction((AnAction)((AnAction)new CMakeAddFileToProjectAction()), (String)CLionCMakeBundle.message("cmake.addFileToProject.single.action.text", objectArray)));
            }
        }
        if (file != null && this.cmakeNeedsToBeReloaded(project, file)) {
            result2.add(ProjectStatusUpdatingWrappingActionKt.asProjectStatusUpdatingAction((AnAction)((AnAction)new ReloadCMakeProjectAction()), (String)CLionCMakeBundle.message("cmake.autoReloadNotification.reloadChanges", new Object[0])));
            result2.add(ProjectStatusUpdatingWrappingActionKt.asProjectStatusUpdatingAction((AnAction)((AnAction)new ToggleCMakeAutoReloadAction()), (String)CLionCMakeBundle.message("cmake.autoReloadNotification.enableAutoReload", new Object[0])));
        }
        return result2;
    }

    @Nullable
    public WidgetStatus getWidgetStatus(@NotNull Project project, @Nullable VirtualFile currentFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (currentFile == null) {
            return null;
        }
        if (ProjectStatusHelperKt.isExternalFileOrSingleFile((Project)project, (VirtualFile)currentFile)) {
            return null;
        }
        if (!CMakeWorkspace.Companion.getInstance(project).isInitialized()) {
            if (!LoadCMakeProjectAction.Companion.canLoadWorkspace(project)) {
                return null;
            }
            if (FileUtil.namesEqual((String)currentFile.getName(), (String)"CMakeLists.txt") || ProjectStatusHelperKt.isProjectAwareFile((VirtualFile)currentFile, (Project)project)) {
                String string = CLionCMakeBundle.message("cmake.loadCMakeNotification.text", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return (WidgetStatus)new DefaultWidgetStatus(Status.Warning, Scope.Project, string);
            }
        }
        if (this.cmakeNeedsToBeReloaded(project, currentFile)) {
            String string = CLionCMakeBundle.message("cmake.autoReloadNotification.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return (WidgetStatus)new DefaultWidgetStatus(Status.Info, Scope.File, string);
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/workspace/ui/CMakeProjectStatusAndFixesProvider$SelectAndLoadProjectAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.clion.cmake"})
    private static final class SelectAndLoadProjectAction
    extends AnAction {
        @NotNull
        private final Project project;

        public SelectAndLoadProjectAction(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(CLionCMakeBundle.message("cmake.loadCMakeNotification.action.select", new Object[0]));
            this.project = project;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            LoadCMakeProjectAction.Companion.selectAndLoadCMakeProject(this.project);
        }
    }
}

