/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.workspace;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectListener;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectReloadContext;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectTracker;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemRefreshStatus;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.options.advanced.AdvancedSettingsImpl;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProjectsAware;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeProjectsAwareKt;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceReloadTask;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeProjectsAware;", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectAware;", "workspace", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace;", "(Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace;)V", "projectId", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "getProjectId", "()Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectId;", "settingsFiles", "", "", "getSettingsFiles", "()Ljava/util/Set;", "reloadProject", "", "context", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectReloadContext;", "subscribe", "listener", "Lcom/intellij/openapi/externalSystem/autoimport/ExternalSystemProjectListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "Companion", "intellij.clion.cmake"})
public final class CMakeProjectsAware
implements ExternalSystemProjectAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CMakeWorkspace workspace;
    @NotNull
    private final ExternalSystemProjectId projectId;
    @NotNull
    private final Set<String> settingsFiles;

    public CMakeProjectsAware(@NotNull CMakeWorkspace workspace2) {
        Intrinsics.checkNotNullParameter((Object)((Object)workspace2), (String)"workspace");
        this.workspace = workspace2;
        this.projectId = new ExternalSystemProjectId(CMakeProjectsAwareKt.getCMAKE_ID(), ((Object)this.workspace.getProjectPath()).toString());
        this.settingsFiles = SetsKt.emptySet();
    }

    @NotNull
    public ExternalSystemProjectId getProjectId() {
        return this.projectId;
    }

    @NotNull
    public Set<String> getSettingsFiles() {
        return this.settingsFiles;
    }

    public void subscribe(@NotNull ExternalSystemProjectListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        MessageBusConnection messageBusConnection = this.workspace.getProject().getMessageBus().connect(parentDisposable);
        Topic<CMakeWorkspaceListener> topic = CMakeWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new CMakeWorkspaceListener(listener2){
            final /* synthetic */ ExternalSystemProjectListener $listener;
            {
                this.$listener = $listener;
            }

            public void reloadingStarted() {
                this.$listener.onProjectReloadStart();
            }

            public void reloadingFinished(boolean canceled2) {
                this.$listener.onProjectReloadFinish(canceled2 ? ExternalSystemRefreshStatus.CANCEL : ExternalSystemRefreshStatus.SUCCESS);
            }
        });
    }

    public void reloadProject(@NotNull ExternalSystemProjectReloadContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (this.workspace.isInitialized() && context2.isExplicitReload()) {
            this.workspace.scheduleReload(CMakeWorkspaceReloadTask.Companion.force().withExplicit(true));
        }
    }

    @JvmStatic
    public static final boolean isEnabled() {
        return Companion.isEnabled();
    }

    @JvmStatic
    @TestOnly
    public static final void setDisabled(@NotNull Disposable disposable) {
        Companion.setDisabled(disposable);
    }

    @JvmStatic
    public static final void initialize(@NotNull CMakeWorkspace workspace2, @NotNull Disposable parentDisposable) {
        Companion.initialize(workspace2, parentDisposable);
    }

    @JvmStatic
    public static final void notify(@NotNull Project project) {
        Companion.notify(project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH\u0007J$\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\bH\u0007\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeProjectsAware$Companion;", "", "()V", "initialize", "", "workspace", "Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeWorkspace;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "isEnabled", "", "notify", "project", "Lcom/intellij/openapi/project/Project;", "runTask", "block", "Lkotlin/Function1;", "setDisabled", "disposable", "intellij.clion.cmake"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean isEnabled() {
            return AdvancedSettings.Companion.getBoolean("cmake.floating.toolbar.reload.notification");
        }

        @JvmStatic
        @TestOnly
        public final void setDisabled(@NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            AdvancedSettings advancedSettings = AdvancedSettings.Companion.getInstance();
            Intrinsics.checkNotNull((Object)advancedSettings, (String)"null cannot be cast to non-null type com.intellij.openapi.options.advanced.AdvancedSettingsImpl");
            ((AdvancedSettingsImpl)advancedSettings).setSetting("cmake.floating.toolbar.reload.notification", (Object)false, disposable);
        }

        @JvmStatic
        public final void initialize(@NotNull CMakeWorkspace workspace2, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)((Object)workspace2), (String)"workspace");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            if (!this.isEnabled()) {
                return;
            }
            CMakeProjectsAware projectAware = new CMakeProjectsAware(workspace2);
            Project project = workspace2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ExternalSystemProjectTracker projectTracker = ExternalSystemProjectTracker.Companion.getInstance(project);
            projectTracker.register((ExternalSystemProjectAware)projectAware, parentDisposable);
            projectTracker.activate(projectAware.getProjectId());
        }

        @JvmStatic
        public final void notify(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.runTask(project, (Function1<? super CMakeWorkspace, Unit>)((Function1)notify.1.INSTANCE));
        }

        private final void runTask(Project project, Function1<? super CMakeWorkspace, Unit> block) {
            ApplicationManager.getApplication().invokeLater(() -> Companion.runTask$lambda$0(project, block), project.getDisposed());
        }

        private static final void runTask$lambda$0(Project $project, Function1 $block) {
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
            if (!Companion.isEnabled()) {
                return;
            }
            CMakeWorkspace workspace2 = CMakeWorkspace.Companion.getInstance($project);
            if (!workspace2.isInitialized()) {
                return;
            }
            $block.invoke((Object)workspace2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

