/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.workspace;

import com.intellij.notification.Notification;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeEnvironmentStateTask;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u0013R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/workspace/CMakeEnvironmentStateTaskQueue;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "notification", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/notification/Notification;", "getNotification", "()Ljava/util/concurrent/atomic/AtomicReference;", "setNotification", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "queue", "Lcom/intellij/openapi/progress/BackgroundTaskQueue;", "<set-?>", "", "skipNextTask", "getSkipNextTask", "()Z", "setSkipNextTask", "(Z)V", "cancelAll", "", "scheduleTask", "isFullCheck", "intellij.clion.cmake"})
public final class CMakeEnvironmentStateTaskQueue {
    @NotNull
    private final Project project;
    @Nullable
    private Disposable disposable;
    @NotNull
    private final BackgroundTaskQueue queue;
    private boolean skipNextTask;
    @NotNull
    private AtomicReference<Notification> notification;

    public CMakeEnvironmentStateTaskQueue(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.queue = new BackgroundTaskQueue(this.project, CLionCMakeBundle.message("cmake.environment.state.checker.progress", new Object[0]));
        this.notification = new AtomicReference();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean getSkipNextTask() {
        return this.skipNextTask;
    }

    public final synchronized void setSkipNextTask(boolean bl) {
        this.skipNextTask = bl;
    }

    @NotNull
    public final AtomicReference<Notification> getNotification() {
        return this.notification;
    }

    public final void setNotification(@NotNull AtomicReference<Notification> atomicReference) {
        Intrinsics.checkNotNullParameter(atomicReference, (String)"<set-?>");
        this.notification = atomicReference;
    }

    public final synchronized void scheduleTask(boolean isFullCheck) {
        if (ApplicationManager.getApplication().isUnitTestMode() || !Registry.is((String)"cmake.enable.environment.state.checker", (boolean)false)) {
            return;
        }
        if (this.skipNextTask) {
            this.skipNextTask = false;
            return;
        }
        if (this.notification.get() != null) {
            return;
        }
        CMakeWorkspace workspace2 = CMakeWorkspace.Companion.getInstance(this.project);
        if (this.disposable == null) {
            this.disposable = Disposer.newDisposable((Disposable)workspace2, (String)"parent disposable for all CMakeEnvironmentStateTask");
        }
        Disposable disposable = this.disposable;
        Intrinsics.checkNotNull((Object)disposable);
        CMakeEnvironmentStateTask task2 = new CMakeEnvironmentStateTask(this.project, disposable, workspace2, isFullCheck);
        this.queue.run((Task.Backgroundable)task2);
    }

    public static /* synthetic */ void scheduleTask$default(CMakeEnvironmentStateTaskQueue cMakeEnvironmentStateTaskQueue, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        cMakeEnvironmentStateTaskQueue.scheduleTask(bl);
    }

    public final synchronized void cancelAll() {
        if (this.disposable != null) {
            Disposable disposable = this.disposable;
            Intrinsics.checkNotNull((Object)disposable);
            Disposer.dispose((Disposable)disposable);
        }
        this.disposable = null;
    }
}

