/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.presets;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.cpp.cmake.presets.CMakePresetLoader;
import com.jetbrains.cidr.cpp.cmake.presets.FilePresetContent;
import com.jetbrains.cidr.cpp.cmake.presets.GenericPresetException;
import com.jetbrains.cidr.cpp.cmake.presets.parser.kotlin.JSONKt;
import com.jetbrains.cidr.cpp.cmake.presets.parser.kotlin.common.VersionedSchema;
import com.jetbrains.cidr.cpp.cmake.presets.parser.kotlin.v4.SchemaWithInclude;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u0007H\u0000\u001a\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u0007H\u0000\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0010\u001a\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0014\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "cmakePresetsFileName", "", "cmakeUserPresetsFileName", "collectPresetFiles", "", "Ljava/nio/file/Path;", "mainPresetFile", "getProjectPresetsFiles", "projectPath", "getProjectUserPresetsFiles", "isPresetFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/io/File;", "readVersionAttribute", "", "content", "(Ljava/lang/String;)Ljava/lang/Integer;", "intellij.clion.cmake"})
@SourceDebugExtension(value={"SMAP\nParse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parse.kt\ncom/jetbrains/cidr/cpp/cmake/presets/ParseKt\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,97:1\n96#2:98\n1603#3,9:99\n1855#3:108\n1856#3:110\n1612#3:111\n1#4:109\n13#5:112\n*S KotlinDebug\n*F\n+ 1 Parse.kt\ncom/jetbrains/cidr/cpp/cmake/presets/ParseKt\n*L\n56#1:98\n63#1:99,9\n63#1:108\n63#1:110\n63#1:111\n63#1:109\n23#1:112\n*E\n"})
public final class ParseKt {
    @NotNull
    private static final String cmakePresetsFileName = "CMakePresets.json";
    @NotNull
    private static final String cmakeUserPresetsFileName = "CMakeUserPresets.json";
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final List<Path> getProjectPresetsFiles(@NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Path path = projectPath.resolve(cmakePresetsFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return ParseKt.collectPresetFiles(path);
    }

    @NotNull
    public static final List<Path> getProjectUserPresetsFiles(@NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        Path path = projectPath.resolve(cmakeUserPresetsFileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return ParseKt.collectPresetFiles(path);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Path> collectPresetFiles(@NotNull Path mainPresetFile) {
        Intrinsics.checkNotNullParameter((Object)mainPresetFile, (String)"mainPresetFile");
        if (!Registry.is((String)"cmake.presets.use.new.parser")) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            return Files.exists(mainPresetFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? CollectionsKt.listOf((Object)mainPresetFile) : CollectionsKt.emptyList();
        }
        Set set = new LinkedHashSet();
        ArrayDeque queue = new ArrayDeque((Collection)CollectionsKt.listOf((Object)mainPresetFile));
        while (!((Collection)queue).isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            Object this_$iv;
            Path currentFile = (Path)queue.removeFirst();
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(currentFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) || set.contains(currentFile)) continue;
            String content = new FilePresetContent(currentFile).getData();
            Integer version = ParseKt.readVersionAttribute(content);
            if (version == null) {
                LOG.warn("Failed to read version from " + currentFile);
                continue;
            }
            set.add(currentFile);
            if (version < 4) continue;
            try {
                this_$iv = JSONKt.getJSON();
                boolean $i$f$decodeFromString = false;
                this_$iv.getSerializersModule();
                this_$iv = ((SchemaWithInclude)this_$iv.decodeFromString((DeserializationStrategy)SchemaWithInclude.Companion.serializer(), content)).getInclude();
            }
            catch (SerializationException ex) {
                this_$iv = CollectionsKt.emptyList();
            }
            catch (IllegalArgumentException ex) {
                this_$iv = CollectionsKt.emptyList();
            }
            Object includes = this_$iv;
            Iterable $this$mapNotNull$iv = (Iterable)includes;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Path it$iv$iv;
                Path path;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                try {
                    path = currentFile.getParent().resolve(it).toAbsolutePath().toRealPath(new LinkOption[0]);
                }
                catch (Exception ex) {
                    Object v2;
                    Exception exception = ex;
                    if (exception instanceof InvalidPathException) {
                        v2 = null;
                    } else if (exception instanceof NoSuchFileException) {
                        v2 = null;
                    } else {
                        throw ex;
                    }
                    path = v2;
                }
                if (path == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List includeList = (List)destination$iv$iv;
            queue.addAll((Collection)includeList);
        }
        return CollectionsKt.toList((Iterable)set);
    }

    private static final Integer readVersionAttribute(String content) {
        try {
            return VersionedSchema.Companion.getVersion(content);
        }
        catch (GenericPresetException ex) {
            LOG.warn("Unexpected content while reading version", (Throwable)ex);
            return null;
        }
    }

    public static final boolean isPresetFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getName(), (Object)cmakePresetsFileName) || Intrinsics.areEqual((Object)file.getName(), (Object)cmakeUserPresetsFileName);
    }

    public static final boolean isPresetFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getName(), (Object)cmakePresetsFileName) || Intrinsics.areEqual((Object)file.getName(), (Object)cmakeUserPresetsFileName);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CMakePresetLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

