/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModelConfigurationData;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.lang.OCLanguageKind;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeModel
implements Serializable {
    @NlsSafe
    public static final String BUILD_TYPE_DEFAULT = "Default";
    public static final String DEBUG = "Debug";
    public static final String RELEASE = "Release";
    public static final String REL_WITH_DEB_INFO = "RelWithDebInfo";
    public static final String MIN_SIZE_REL = "MinSizeRel";
    public static final List<@NlsSafe String> DEFAULT_BUILD_TYPES = List.of("Default", "Debug", "Release", "RelWithDebInfo", "MinSizeRel");
    public static final int SERIALIZATION_VERSION = 138;
    @NotNull
    private final String myProjectName;
    @NotNull
    private final Set<File> myCMakeDependencyFiles;
    @NotNull
    private final Set<File> myHeaderAndResourceFiles;
    @NotNull
    private final List<CMakeTarget> myTargets;
    @NotNull
    private final Map<String, OCLanguageKind> myFileExtensions;
    @NotNull
    private final List<CMakeModelConfigurationData> myConfigurationData;

    public CMakeModel(@NotNull String projectName, @NotNull Set<File> cmakeDependencyFiles, @NotNull Set<File> headerAndResourceFiles, @NotNull List<CMakeTarget> targets, @NotNull Map<String, OCLanguageKind> fileExtensions, @NotNull List<CMakeModelConfigurationData> configurationData) {
        if (projectName == null) {
            CMakeModel.$$$reportNull$$$0(0);
        }
        if (cmakeDependencyFiles == null) {
            CMakeModel.$$$reportNull$$$0(1);
        }
        if (headerAndResourceFiles == null) {
            CMakeModel.$$$reportNull$$$0(2);
        }
        if (targets == null) {
            CMakeModel.$$$reportNull$$$0(3);
        }
        if (fileExtensions == null) {
            CMakeModel.$$$reportNull$$$0(4);
        }
        if (configurationData == null) {
            CMakeModel.$$$reportNull$$$0(5);
        }
        this.myProjectName = projectName;
        this.myCMakeDependencyFiles = Collections.unmodifiableSet(cmakeDependencyFiles);
        this.myHeaderAndResourceFiles = Collections.unmodifiableSet(headerAndResourceFiles);
        this.myTargets = Collections.unmodifiableList(targets);
        this.myFileExtensions = Collections.unmodifiableMap(fileExtensions);
        this.myConfigurationData = Collections.unmodifiableList(configurationData);
    }

    @Nullable
    public static CMakeModel load(@NotNull ObjectInputStream out) throws IOException {
        if (out == null) {
            CMakeModel.$$$reportNull$$$0(6);
        }
        try {
            if (out.readInt() != 138) {
                return null;
            }
            Object object = out.readObject();
            return object instanceof CMakeModel ? (CMakeModel)object : null;
        }
        catch (ClassNotFoundException e) {
            CPPLog.LOG.info("Failed to load CMakeModel", (Throwable)e);
            return null;
        }
    }

    public void save(@NotNull ObjectOutputStream out) throws IOException {
        if (out == null) {
            CMakeModel.$$$reportNull$$$0(7);
        }
        out.writeInt(138);
        out.writeObject(this);
    }

    @NotNull
    public String getProjectName() {
        String string = this.myProjectName;
        if (string == null) {
            CMakeModel.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public Set<File> getCMakeDependencyFiles() {
        Set<File> set = this.myCMakeDependencyFiles;
        if (set == null) {
            CMakeModel.$$$reportNull$$$0(9);
        }
        return set;
    }

    @NotNull
    public Set<File> getHeaderAndResourceFiles() {
        Set<File> set = this.myHeaderAndResourceFiles;
        if (set == null) {
            CMakeModel.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    public List<CMakeTarget> getTargets() {
        List<CMakeTarget> list2 = this.myTargets;
        if (list2 == null) {
            CMakeModel.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @NotNull
    public Map<String, OCLanguageKind> getFileExtensions() {
        Map<String, OCLanguageKind> map = this.myFileExtensions;
        if (map == null) {
            CMakeModel.$$$reportNull$$$0(12);
        }
        return map;
    }

    @NotNull
    public List<CMakeModelConfigurationData> getConfigurationData() {
        List<CMakeModelConfigurationData> list2 = this.myConfigurationData;
        if (list2 == null) {
            CMakeModel.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @NonNls
    public String toString() {
        return this.myProjectName + " [" + this.myTargets.size() + " targets]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeDependencyFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerAndResourceFiles";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExtensions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationData";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeModel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeDependencyFiles";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderAndResourceFiles";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileExtensions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "save";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

