/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Trinity;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.model.CMakeSettingsFileParser;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeMakeFile {
    private final MultiMap<String, Rule> myVariables;

    public CMakeMakeFile(@NotNull String text) throws CMakeException {
        if (text == null) {
            CMakeMakeFile.$$$reportNull$$$0(0);
        }
        this.myVariables = new Parser().parse(text);
    }

    public CMakeMakeFile(@NotNull File file, @NotNull String encoding) throws CMakeException {
        if (file == null) {
            CMakeMakeFile.$$$reportNull$$$0(1);
        }
        if (encoding == null) {
            CMakeMakeFile.$$$reportNull$$$0(2);
        }
        this.myVariables = new Parser().parse(file, encoding);
    }

    @NotNull
    public Iterable<Rule> getRules() {
        Iterable iterable = ContainerUtil.concat((Iterable[])new Iterable[]{this.myVariables.values()});
        if (iterable == null) {
            CMakeMakeFile.$$$reportNull$$$0(3);
        }
        return iterable;
    }

    @Nullable
    public Rule getRule(@NotNull String key) {
        if (key == null) {
            CMakeMakeFile.$$$reportNull$$$0(4);
        }
        return (Rule)ContainerUtil.getFirstItem(this.getRules(key));
    }

    @Nullable
    public Collection<Rule> getRules(@NotNull String key) {
        if (key == null) {
            CMakeMakeFile.$$$reportNull$$$0(5);
        }
        return this.myVariables.get((Object)key);
    }

    @Nullable
    public String getRuleDependency(@NotNull String target2) {
        Rule rule;
        if (target2 == null) {
            CMakeMakeFile.$$$reportNull$$$0(6);
        }
        return (rule = this.getRule(target2)) == null ? null : rule.getDependencies();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeMakeFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeMakeFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRule";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRules";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRuleDependency";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    static final class Parser
    extends CMakeSettingsFileParser<Rule> {
        private Parser() {
            super(": ");
        }

        @Override
        @NotNull
        protected <V> Map<String, V> createMap() {
            Map map = CollectionFactory.createFilePathLinkedMap();
            if (map == null) {
                Parser.$$$reportNull$$$0(0);
            }
            return map;
        }

        @Override
        @NotNull
        protected Trinity<String, Rule, Integer> parseVariable(@NotNull String target2, @NotNull String dependencies, List<String> remainingLines) {
            int i;
            if (target2 == null) {
                Parser.$$$reportNull$$$0(1);
            }
            if (dependencies == null) {
                Parser.$$$reportNull$$$0(2);
            }
            StringBuilder recipe = new StringBuilder();
            boolean inFile = false;
            int size = remainingLines.size();
            for (i = 0; i < size; ++i) {
                String each = remainingLines.get(i);
                if (!inFile && !each.startsWith("\t")) break;
                int pos = 0;
                if (!inFile && (pos = each.indexOf("@<<", pos)) != -1) {
                    inFile = true;
                    pos += 3;
                }
                if (inFile && (pos = each.indexOf("<<", pos)) != -1) {
                    inFile = false;
                }
                recipe.append(each);
            }
            Trinity trinity = Trinity.create((Object)target2, (Object)new Rule(target2, dependencies, recipe.toString()), (Object)i);
            if (trinity == null) {
                Parser.$$$reportNull$$$0(3);
            }
            return trinity;
        }

        @Override
        @NotNull
        protected Pair<String, Rule> parseVariable(@NotNull String target2, @NotNull String dependencies) {
            if (target2 == null) {
                Parser.$$$reportNull$$$0(4);
            }
            if (dependencies == null) {
                Parser.$$$reportNull$$$0(5);
            }
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 4, 5 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeMakeFile$Parser";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createMap";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeMakeFile$Parser";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseVariable";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "parseVariable";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 4, 5 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class Rule {
        @NotNull
        private final String myTarget;
        @NotNull
        private final String myDependencies;
        @NotNull
        private final String myRecipe;

        public Rule(@NotNull String target2, @NotNull String dependencies, @NotNull String recipe) {
            if (target2 == null) {
                Rule.$$$reportNull$$$0(0);
            }
            if (dependencies == null) {
                Rule.$$$reportNull$$$0(1);
            }
            if (recipe == null) {
                Rule.$$$reportNull$$$0(2);
            }
            this.myTarget = target2;
            this.myDependencies = dependencies.trim();
            this.myRecipe = recipe;
        }

        @NotNull
        public String getTarget() {
            String string = this.myTarget;
            if (string == null) {
                Rule.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        public String getDependencies() {
            String string = this.myDependencies;
            if (string == null) {
                Rule.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getRecipe() {
            String string = this.myRecipe;
            if (string == null) {
                Rule.$$$reportNull$$$0(5);
            }
            return string;
        }

        public String toString() {
            return this.myTarget + ": " + this.myDependencies + (String)(this.myRecipe.isEmpty() ? "" : "\n" + this.myRecipe);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Rule rule = (Rule)o;
            if (!this.myTarget.equals(rule.myTarget)) {
                return false;
            }
            if (!this.myDependencies.equals(rule.myDependencies)) {
                return false;
            }
            return this.myRecipe.equals(rule.myRecipe);
        }

        public int hashCode() {
            int result2 = this.myTarget.hashCode();
            result2 = 31 * result2 + this.myDependencies.hashCode();
            result2 = 31 * result2 + this.myRecipe.hashCode();
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "recipe";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeMakeFile$Rule";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeMakeFile$Rule";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTarget";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencies";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRecipe";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

