/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.perf;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profiler.clion.ProfilerEnvironmentHost;
import com.intellij.profiler.linux.KernelVariable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0014J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/profiler/clion/perf/RemoteKernelVariable;", "Lcom/intellij/profiler/linux/KernelVariable;", "environmentHost", "Lcom/intellij/profiler/clion/ProfilerEnvironmentHost;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "requiredValue", "validator", "Lkotlin/Function1;", "", "(Lcom/intellij/profiler/clion/ProfilerEnvironmentHost;Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getPath", "isFileExist", "readLines", "", "intellij.profiler.clion"})
public final class RemoteKernelVariable
extends KernelVariable {
    @NotNull
    private final ProfilerEnvironmentHost environmentHost;
    @NotNull
    private final Project project;

    public RemoteKernelVariable(@NotNull ProfilerEnvironmentHost environmentHost, @NotNull Project project, @NotNull String name2, @NotNull String requiredValue, @NotNull Function1<? super String, Boolean> validator2) {
        Intrinsics.checkNotNullParameter((Object)environmentHost, (String)"environmentHost");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)requiredValue, (String)"requiredValue");
        Intrinsics.checkNotNullParameter(validator2, (String)"validator");
        super(name2, requiredValue, validator2);
        this.environmentHost = environmentHost;
        this.project = project;
    }

    @NotNull
    public String getPath() {
        String[] stringArray = new String[]{"/proc/sys/kernel", this.getName()};
        return this.environmentHost.getEnvPath(FileUtil.join((String[])stringArray), this.project);
    }

    protected boolean isFileExist() {
        String path = this.getPath();
        return Files.exists(this.environmentHost.getPath(path, this.project), new LinkOption[0]);
    }

    @NotNull
    protected List<String> readLines() {
        String path = this.getPath();
        List<String> list2 = Files.lines(this.environmentHost.getPath(path, this.project)).toList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"toList(...)");
        return list2;
    }
}

