/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.perf;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Version;
import com.intellij.profiler.clion.CPPProfilerBundleKt;
import com.intellij.profiler.clion.ProfilerEnvironmentHost;
import com.intellij.profiler.clion.perf.PerfProfilerSettings;
import com.intellij.profiler.clion.perf.PerfSample;
import com.intellij.profiler.clion.perf.PerfScriptParser;
import com.intellij.profiler.clion.perf.PerfUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/profiler/clion/perf/PerfScriptProcess;", "", "()V", "Companion", "intellij.profiler.clion"})
@SourceDebugExtension(value={"SMAP\nPerfScriptProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfScriptProcess.kt\ncom/intellij/profiler/clion/perf/PerfScriptProcess\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,59:1\n13#2:60\n*S KotlinDebug\n*F\n+ 1 PerfScriptProcess.kt\ncom/intellij/profiler/clion/perf/PerfScriptProcess\n*L\n18#1:60\n*E\n"})
public final class PerfScriptProcess {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PerfScriptProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JW\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2!\u0010\t\u001a\u001d\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u00060\n2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/profiler/clion/perf/PerfScriptProcess$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "execute", "", "perfDataPath", "Ljava/nio/file/Path;", "onSampleParsed", "Lkotlin/Function1;", "Lcom/intellij/profiler/clion/perf/PerfSample;", "Lkotlin/ParameterName;", "name", "sample", "onFinish", "Lkotlin/Function0;", "project", "Lcom/intellij/openapi/project/Project;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "environmentHost", "Lcom/intellij/profiler/clion/ProfilerEnvironmentHost;", "isNoInlineSupported", "", "version", "Lcom/intellij/openapi/util/Version;", "intellij.profiler.clion"})
    public static final class Companion {
        private Companion() {
        }

        public final void execute(@NotNull Path perfDataPath, @NotNull Function1<? super PerfSample, Unit> onSampleParsed, @NotNull Function0<Unit> onFinish, @NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull ProfilerEnvironmentHost environmentHost) {
            Intrinsics.checkNotNullParameter((Object)perfDataPath, (String)"perfDataPath");
            Intrinsics.checkNotNullParameter(onSampleParsed, (String)"onSampleParsed");
            Intrinsics.checkNotNullParameter(onFinish, (String)"onFinish");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            Intrinsics.checkNotNullParameter((Object)environmentHost, (String)"environmentHost");
            if (!Files.exists(perfDataPath, new LinkOption[0])) {
                LOG.warn("Cannot execute perf script: perf data is not found");
                onFinish.invoke();
                return;
            }
            Version perfVersion = PerfUtils.Companion.getPerfVersion(indicator, environmentHost, project);
            GeneralCommandLine cl = new GeneralCommandLine();
            String string = environmentHost.getEnvPath(PerfProfilerSettings.Companion.getInstance().getState().getExecutablePath(), project);
            if (string == null) {
                throw new ExecutionException(CPPProfilerBundleKt.profilerMessage("profiler.exception.perf.empty.path", new Object[0]));
            }
            cl.setExePath(string);
            String[] stringArray = new String[]{"script", "--fields", "comm,tid,ip,sym,dso"};
            cl.addParameters(stringArray);
            if (this.isNoInlineSupported(perfVersion) && !PerfProfilerSettings.Companion.getInstance().getState().getProcessInlineFunctions()) {
                cl.addParameter("--no-inline");
            }
            stringArray = new String[]{"-i", environmentHost.getEnvPath(((Object)perfDataPath).toString(), project)};
            cl.addParameters(stringArray);
            PerfScriptParser parser2 = new PerfScriptParser(onSampleParsed);
            BaseProcessHandler<?> processHandler = PerfUtils.Companion.createProcessHandler(cl, parser2, environmentHost, project);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(parser2, onFinish){
                final /* synthetic */ PerfScriptParser $parser;
                final /* synthetic */ Function0<Unit> $onFinish;
                {
                    this.$parser = $parser;
                    this.$onFinish = $onFinish;
                }

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.$parser.finish();
                    this.$onFinish.invoke();
                }
            });
            environmentHost.runProcess((ProcessHandler)processHandler, indicator, -1, project);
        }

        private final boolean isNoInlineSupported(Version version) {
            return version != null && version.major >= 5;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

