/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.perf;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profiler.LineByLineParser;
import com.intellij.profiler.clion.perf.PerfFrame;
import com.intellij.profiler.clion.perf.PerfSample;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B(\u0012!\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0006\u0010\u0018\u001a\u00020\bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R)\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/clion/perf/PerfScriptParser;", "Lcom/intellij/profiler/LineByLineParser;", "onSampleParsed", "Lkotlin/Function1;", "Lcom/intellij/profiler/clion/perf/PerfSample;", "Lkotlin/ParameterName;", "name", "sample", "", "(Lkotlin/jvm/functions/Function1;)V", "FRAME_REGEX", "Lkotlin/text/Regex;", "HEX", "", "currentFrames", "", "Lcom/intellij/profiler/clion/perf/PerfFrame;", "currentThreadId", "currentThreadName", "isIncomplete", "", "()Z", "consumeLine", "line", "finish", "Companion", "intellij.profiler.clion"})
@SourceDebugExtension(value={"SMAP\nPerfScriptParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfScriptParser.kt\ncom/intellij/profiler/clion/perf/PerfScriptParser\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,61:1\n13#2:62\n*S KotlinDebug\n*F\n+ 1 PerfScriptParser.kt\ncom/intellij/profiler/clion/perf/PerfScriptParser\n*L\n13#1:62\n*E\n"})
public final class PerfScriptParser
extends LineByLineParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<PerfSample, Unit> onSampleParsed;
    @NotNull
    private final String HEX;
    @NotNull
    private final Regex FRAME_REGEX;
    @Nullable
    private String currentThreadName;
    @Nullable
    private String currentThreadId;
    @NotNull
    private List<PerfFrame> currentFrames;
    @NotNull
    private static final Logger LOG;

    public PerfScriptParser(@NotNull Function1<? super PerfSample, Unit> onSampleParsed) {
        Intrinsics.checkNotNullParameter(onSampleParsed, (String)"onSampleParsed");
        this.onSampleParsed = onSampleParsed;
        this.HEX = "((?:0x|0X)?[a-fA-F0-9]+)";
        this.FRAME_REGEX = new Regex(this.HEX + " (.*) \\((.*)\\)");
        this.currentFrames = new ArrayList();
    }

    private final boolean isIncomplete() {
        return !this.currentFrames.isEmpty() || this.currentThreadId != null;
    }

    public void consumeLine(@NotNull String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        String trimmedLine = ((Object)StringsKt.trim((CharSequence)line)).toString();
        CharSequence charSequence = trimmedLine;
        if (this.FRAME_REGEX.matches(charSequence)) {
            Object object;
            Object function2;
            Object object2;
            Object instructionPointer;
            MatchResult matchResult = this.FRAME_REGEX.matchEntire((CharSequence)trimmedLine);
            Object groups = matchResult != null ? matchResult.getGroups() : null;
            Object object3 = groups;
            if (object3 == null || (object3 = object3.get(1)) == null || (object3 = object3.getValue()) == null) {
                object3 = instructionPointer = "";
            }
            if ((object2 = groups) == null || (object2 = object2.get(2)) == null || (object2 = object2.getValue()) == null) {
                object2 = function2 = "";
            }
            if ((object = groups) == null || (object = object.get(3)) == null || (object = object.getValue()) == null) {
                object = "";
            }
            Object binary = object;
            this.currentFrames.add(new PerfFrame((String)function2, (String)binary, (String)instructionPointer));
        } else {
            List list2 = StringUtil.split((String)trimmedLine, (String)" ", (boolean)true, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"split(...)");
            List lineParts = list2;
            if (lineParts.size() == 1 || lineParts.size() == 2) {
                if (!((Collection)this.currentFrames).isEmpty() && this.currentThreadName != null && this.currentThreadId != null) {
                    List list3 = new ArrayList(this.currentFrames);
                    String string = this.currentThreadName;
                    Intrinsics.checkNotNull((Object)string);
                    String string2 = this.currentThreadId;
                    Intrinsics.checkNotNull((Object)string2);
                    this.onSampleParsed.invoke((Object)new PerfSample(list3, string, string2));
                }
                this.currentFrames = new ArrayList();
                this.currentThreadName = lineParts.size() == 2 ? (String)lineParts.get(0) : "";
                this.currentThreadId = (String)CollectionsKt.last((List)lineParts);
            } else if (!StringsKt.isBlank((CharSequence)trimmedLine)) {
                this.currentThreadName = null;
                this.currentThreadId = null;
                this.currentFrames.clear();
                LOG.warn("Unrecognized line from perf script: " + trimmedLine);
            }
        }
    }

    public final void finish() {
        if (this.isIncomplete()) {
            List list2 = new ArrayList(this.currentFrames);
            String string = this.currentThreadName;
            Intrinsics.checkNotNull((Object)string);
            String string2 = this.currentThreadId;
            Intrinsics.checkNotNull((Object)string2);
            this.onSampleParsed.invoke((Object)new PerfSample(list2, string, string2));
        }
        this.currentFrames.clear();
        this.currentThreadId = null;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PerfScriptParser.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/profiler/clion/perf/PerfScriptParser$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.profiler.clion"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

