/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.profiler.ProfilerManagerKt;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.clion.CPPProfilerBundleKt;
import com.intellij.profiler.clion.DTraceProfilerConfigurationExtensionKt;
import com.intellij.profiler.clion.NativeTargetProcess;
import com.intellij.profiler.clion.ProfilerConfigurationExtension;
import com.intellij.profiler.clion.ProfilerEnvironmentHost;
import com.intellij.profiler.clion.ProfilerRunChecker;
import com.intellij.profiler.clion.dtrace.CPPDTraceProfilerProcess;
import com.intellij.profiler.dtrace.DTraceProfilerProcessBaseKt;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.util.system.CpuArch;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\"\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016J:\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/profiler/clion/DTraceProfilerConfigurationExtension;", "Lcom/intellij/profiler/clion/ProfilerConfigurationExtension;", "()V", "attachToProcess", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "environmentHost", "Lcom/intellij/profiler/clion/ProfilerEnvironmentHost;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "runnerId", "", "holder", "Lcom/intellij/openapi/util/UserDataHolder;", "isApplicableFor", "", "isEnabledFor", "patchCommandLine", "cmdLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "Companion", "intellij.profiler.clion"})
@SourceDebugExtension(value={"SMAP\nDTraceProfilerConfigurationExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DTraceProfilerConfigurationExtension.kt\ncom/intellij/profiler/clion/DTraceProfilerConfigurationExtension\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class DTraceProfilerConfigurationExtension
implements ProfilerConfigurationExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DYLD_INSERT_LIBRARIES = "DYLD_INSERT_LIBRARIES";

    @Override
    public boolean isApplicableFor(@NotNull RunConfiguration configuration2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isEnabledFor(@NotNull RunConfiguration configuration2, @NotNull ProfilerEnvironmentHost environmentHost, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environmentHost, (String)"environmentHost");
        if (!ProfilerRunChecker.Companion.isProfilerCompatible((RunProfile)configuration2)) return false;
        if (!ProfilerRunChecker.Companion.isDTraceProfilerCanBeUsed()) return false;
        Project project = configuration2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (environmentHost.isRemote(project)) return false;
        return true;
    }

    @Override
    public void patchCommandLine(@NotNull RunConfiguration configuration2, @NotNull ProfilerEnvironmentHost environmentHost, @Nullable RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId, @NotNull UserDataHolder holder) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environmentHost, (String)"environmentHost");
        Intrinsics.checkNotNullParameter((Object)cmdLine, (String)"cmdLine");
        Intrinsics.checkNotNullParameter((Object)runnerId, (String)"runnerId");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!Intrinsics.areEqual((Object)"ProfilerRunner", (Object)runnerId)) {
            return;
        }
        Project project = configuration2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (environmentHost.isRemote(project)) {
            throw new ExecutionException(CPPProfilerBundleKt.profilerMessage("profiler.remote.unsupported", new Object[0]));
        }
        Project project2 = configuration2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ExecutionException executionException = DTraceProfilerConfigurationExtensionKt.validateDTraceSettings(project2);
        if (executionException != null) {
            ExecutionException it = executionException;
            boolean bl = false;
            throw it;
        }
        File starterPath = DTraceProfilerConfigurationExtension.Companion.profilerStarterPath();
        if (!starterPath.exists()) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)starterPath.getAbsolutePath(), (String)"getAbsolutePath(...)");
            throw new ExecutionException(CPPProfilerBundleKt.profilerMessage("profiler.exception.cannot.find.process.starter", objectArray));
        }
        cmdLine.withEnvironment(DYLD_INSERT_LIBRARIES, starterPath.getAbsolutePath());
    }

    @Override
    public void attachToProcess(@NotNull RunConfiguration configuration2, @NotNull ProcessHandler handler2, @NotNull ProfilerEnvironmentHost environmentHost, @Nullable RunnerSettings runnerSettings, @NotNull String runnerId, @NotNull UserDataHolder holder) {
        int n;
        Process process2;
        Project project;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
                Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
                Intrinsics.checkNotNullParameter((Object)environmentHost, (String)"environmentHost");
                Intrinsics.checkNotNullParameter((Object)runnerId, (String)"runnerId");
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                project = configuration2.getProject();
                if (!Intrinsics.areEqual((Object)"ProfilerRunner", (Object)runnerId)) break block6;
                Intrinsics.checkNotNull((Object)project);
                if (!environmentHost.isRemote(project)) break block7;
            }
            return;
        }
        BaseProcessHandler baseProcessHandler = handler2 instanceof BaseProcessHandler ? (BaseProcessHandler)handler2 : null;
        Process process3 = process2 = baseProcessHandler != null ? baseProcessHandler.getProcess() : null;
        if (process2 == null) {
            throw new ExecutionException(CPPProfilerBundleKt.profilerMessage("profiler.exception.cannot.detect.target.process", new Object[0]));
        }
        Process targetProcess = process2;
        String string = DTraceProfilerProcessBaseKt.getLegacyDTraceProfilerConfiguration().getConfigurationTypeId();
        String string2 = configuration2.getType().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        ProfilerUsageTriggerCollector.logRecordingStarted((Project)project, (String)string, (String)string2);
        try {
            n = (int)targetProcess.pid();
        }
        catch (UnsupportedOperationException ignored) {
            throw new ExecutionException(CPPProfilerBundleKt.profilerMessage("profiler.exception.cannot.detect.target.process", new Object[0]));
        }
        int pid = n;
        String string3 = configuration2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        NativeTargetProcess namedProcess = new NativeTargetProcess(pid, string3);
        AttachableTargetProcess attachableTargetProcess = namedProcess;
        PerformInBackgroundOption performInBackgroundOption = PerformInBackgroundOption.ALWAYS_BACKGROUND;
        Intrinsics.checkNotNullExpressionValue((Object)performInBackgroundOption, (String)"ALWAYS_BACKGROUND");
        ProfilerManagerKt.installErrorHandlers(CPPDTraceProfilerProcess.Companion.attach(attachableTargetProcess, performInBackgroundOption, 10000, project), (Project)project).onError(arg_0 -> DTraceProfilerConfigurationExtension.attachToProcess$lambda$1((Function1)new Function1<Throwable, Unit>(handler2){
            final /* synthetic */ ProcessHandler $handler;
            {
                this.$handler = $handler;
                super(1);
            }

            public final void invoke(Throwable it) {
                ExecutionManagerImpl.Companion.stopProcess(this.$handler);
            }
        }, arg_0)).onSuccess(arg_0 -> DTraceProfilerConfigurationExtension.attachToProcess$lambda$2((Function1)new Function1<CPPDTraceProfilerProcess, Unit>(targetProcess, project){
            final /* synthetic */ Process $targetProcess;
            final /* synthetic */ Project $project;
            {
                this.$targetProcess = $targetProcess;
                this.$project = $project;
                super(1);
            }

            public final void invoke(CPPDTraceProfilerProcess process2) {
                UnixProcessManager.sendSigIntToProcessTree((Process)this.$targetProcess);
                Project project = this.$project;
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"$project");
                ProfilerToolWindowManager profilerToolWindowManager = ProfilerToolWindowManager.Companion.getInstance(project);
                Intrinsics.checkNotNull((Object)((Object)process2));
                ProfilerToolWindowManager.addProfilerProcessTab$default((ProfilerToolWindowManager)profilerToolWindowManager, (ProfilerProcess)((ProfilerProcess)process2), (boolean)false, (int)2, null);
            }
        }, arg_0));
    }

    private static final void attachToProcess$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void attachToProcess$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/profiler/clion/DTraceProfilerConfigurationExtension$Companion;", "", "()V", "DYLD_INSERT_LIBRARIES", "", "profilerStarterPath", "Ljava/io/File;", "intellij.profiler.clion"})
    public static final class Companion {
        private Companion() {
        }

        private final File profilerStarterPath() {
            String arch;
            String string = arch = CpuArch.isArm64() ? "aarch64" : "x64";
            if (PluginManagerCore.isRunningFromSources()) {
                return new File(PathManager.getHomePath(), "CIDR/clion/bin/profiler/mac/" + arch + "/libosx-starter.dylib");
            }
            return new File(PathManager.getBinPath(), "profiler/mac/" + arch + "/libosx-starter.dylib");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

