/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.profiling.valgrind.actions;

import com.intellij.cidr.profiling.CidrProfilingBundle;
import com.intellij.cidr.profiling.memory.MemoryProfileDataKeys;
import com.intellij.cidr.profiling.memory.MemoryProfileTreeDataModel;
import com.intellij.cidr.profiling.memory.MemoryProfileUtil;
import com.intellij.cidr.profiling.memory.error.MemoryProfileError;
import com.intellij.cidr.profiling.memory.error.MemoryProfileFrame;
import com.intellij.cidr.profiling.memory.tree.MemoryProfileErrorCaptionTreeNode;
import com.intellij.cidr.profiling.memory.tree.MemoryProfileTreeNode;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ValgrindSuppressAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(ValgrindSuppressAction.class);

    public void update(@NotNull AnActionEvent e) {
        MemoryProfileError errorToSuppress;
        if (e == null) {
            ValgrindSuppressAction.$$$reportNull$$$0(0);
        }
        DataContext context2 = e.getDataContext();
        MemoryProfileTreeDataModel treeDataModel = (MemoryProfileTreeDataModel)MemoryProfileDataKeys.TREE_MODEL.getData(context2);
        MemoryProfileTreeNode selectedNode = (MemoryProfileTreeNode)MemoryProfileDataKeys.SELECTED_NODE.getData(context2);
        MemoryProfileError memoryProfileError = errorToSuppress = selectedNode instanceof MemoryProfileErrorCaptionTreeNode ? ((MemoryProfileErrorCaptionTreeNode)selectedNode).getError() : null;
        if (treeDataModel == null || errorToSuppress == null) {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            ValgrindSuppressAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        MemoryProfileError errorToSuppress;
        if (e == null) {
            ValgrindSuppressAction.$$$reportNull$$$0(2);
        }
        MemoryProfileTreeNode selectedNode = (MemoryProfileTreeNode)e.getData(MemoryProfileDataKeys.SELECTED_NODE);
        MemoryProfileTreeDataModel treeDataModel = (MemoryProfileTreeDataModel)e.getData(MemoryProfileDataKeys.TREE_MODEL);
        MemoryProfileError memoryProfileError = errorToSuppress = selectedNode instanceof MemoryProfileErrorCaptionTreeNode ? ((MemoryProfileErrorCaptionTreeNode)selectedNode).getError() : null;
        if (treeDataModel == null || errorToSuppress == null) {
            LOG.warn("Failed to apply ValgrindSuppressAction, because either MemoryProfileTreeDataModel or MemoryProfileError is null");
            return;
        }
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileDescriptor();
        descriptor2.setTitle(CidrProfilingBundle.message("valgrind.suppress.action.title", new Object[0]));
        descriptor2.setDescription(CidrProfilingBundle.message("valgrind.suppress.action.description", new Object[0]));
        FileChooser.chooseFiles((FileChooserDescriptor)descriptor2, null, null, files2 -> {
            String suppressionFilePath = ((VirtualFile)files2.get(0)).getPath();
            if (!FileUtil.exists((String)suppressionFilePath)) {
                LOG.warn("Failed to append suppression, because file does not exist");
                return;
            }
            try {
                FileUtil.appendToFile((File)new File(suppressionFilePath), (String)ValgrindSuppressAction.getSuppression(errorToSuppress));
                treeDataModel.remove(errorToSuppress);
                MemoryProfileUtil.removeNode(selectedNode, treeDataModel);
            }
            catch (IOException exc) {
                LOG.warn("Failed to append suppression: " + exc);
            }
        });
    }

    @NotNull
    private static String getSuppression(@NotNull MemoryProfileError error) {
        if (error == null) {
            ValgrindSuppressAction.$$$reportNull$$$0(3);
        }
        String suppression = error.getSuppression();
        MemoryProfileFrame innermostFrame = MemoryProfileUtil.getInnermostNavigatableStackFrame(error);
        @NlsSafe String suppressionName = innermostFrame == null ? "Suppression" : (StringUtil.isNotEmpty((String)innermostFrame.getFunction()) ? innermostFrame.getFunction() : innermostFrame.getBinary());
        @NonNls String insertSuppressionNameHolder = "<insert_a_suppression_name_here>";
        suppression = suppression.replace("<insert_a_suppression_name_here>", suppressionName);
        suppression = suppression.trim();
        String string = "\n" + suppression + "\n";
        if (string == null) {
            ValgrindSuppressAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cidr/profiling/valgrind/actions/ValgrindSuppressAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cidr/profiling/valgrind/actions/ValgrindSuppressAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuppression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

