/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.profiling.memory.ui;

import com.intellij.cidr.profiling.CidrProfilingBundle;
import com.intellij.cidr.profiling.memory.MemoryProfileNavigationData;
import com.intellij.cidr.profiling.memory.MemoryProfileUtil;
import com.intellij.cidr.profiling.memory.error.MemoryProfileFrame;
import com.intellij.codeInspection.ui.PreviewEditorFoldingRegion;
import com.intellij.codeInspection.ui.ProblemPreviewEditorPresentation;
import com.intellij.diff.util.DiffUtil;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryProfileStackFramePreviewPanel
extends JPanel
implements Disposable {
    @NotNull
    private final MemoryProfileFrame myFrame;
    @NotNull
    private final Project myProject;
    @Nullable
    private EditorEx myEditor;
    private volatile boolean myTaskCanceled;
    @NotNull
    private final JPanel myMainPanel;
    @NotNull
    private final LoadingDecorator myLoadingDecorator;

    public MemoryProfileStackFramePreviewPanel(@NotNull MemoryProfileFrame frame, @NotNull Project project) {
        if (frame == null) {
            MemoryProfileStackFramePreviewPanel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            MemoryProfileStackFramePreviewPanel.$$$reportNull$$$0(1);
        }
        this.myFrame = frame;
        this.myProject = project;
        this.myEditor = null;
        this.myTaskCanceled = false;
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myLoadingDecorator = new LoadingDecorator((JComponent)this.myMainPanel, (Disposable)this, 100);
        this.myLoadingDecorator.setLoadingText(CidrProfilingBundle.message("memory.profile.panel.loading.preview.label", new Object[0]));
        this.setLayout(new BorderLayout());
        this.add((Component)this.myLoadingDecorator.getComponent(), "Center");
        this.updatePreviewPanelInBackground();
    }

    private void updatePreviewPanelInBackground() {
        this.myLoadingDecorator.startLoading(true);
        Application app = ApplicationManager.getApplication();
        app.executeOnPooledThread(() -> {
            MemoryProfileNavigationData navigationData = MemoryProfileUtil.getNavigationData(this.myFrame);
            app.invokeLater(() -> this.showPreviewInformation(navigationData), c -> this.myTaskCanceled);
        });
    }

    private void showPreviewInformation(@Nullable MemoryProfileNavigationData navigationData) {
        RunnerLayoutUi.Factory factory = RunnerLayoutUi.Factory.getInstance((Project)this.myProject);
        RunnerLayoutUi ui = factory.create("ValgrindRunner", "ValgrindRunner", "ValgrindRunner", (Disposable)this);
        if (navigationData != null) {
            this.myEditor = this.createPreviewEditor(navigationData);
            Content previewContent = ui.createContent("MemoryProfilePreview", this.myEditor.getComponent(), CidrProfilingBundle.message("memory.profile.panel.preview.editor.title", new Object[0]), AllIcons.Actions.PreviewDetails, null);
            previewContent.setCloseable(false);
            ui.addContent(previewContent);
        }
        Content frameContent = ui.createContent("MemoryProfileFrame", this.createFrameDescription(), CidrProfilingBundle.message("memory.profile.panel.frame.information.title", new Object[0]), AllIcons.Debugger.Frame, null);
        frameContent.setCloseable(false);
        ui.addContent(frameContent);
        this.myMainPanel.add((Component)ui.getComponent(), "Center");
        this.myLoadingDecorator.stopLoading();
        this.myLoadingDecorator.getComponent().revalidate();
        this.myLoadingDecorator.getComponent().repaint();
    }

    public void dispose() {
        this.myTaskCanceled = true;
        if (this.myEditor != null && !this.myEditor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
            this.myEditor = null;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private JComponent createFrameDescription() {
        JPanel panel2 = new JPanel();
        panel2.setLayout(new GridBagLayout());
        ArrayList<@Nls @NlsSafe Pair> keyValuePairs = new ArrayList<Pair>();
        if (StringUtil.isNotEmpty((String)this.myFrame.getInstructionPointer())) {
            keyValuePairs.add(Pair.create((Object)CidrProfilingBundle.message("memory.profile.instruction.pointer.label", new Object[0]), (Object)this.myFrame.getInstructionPointer()));
        }
        if (StringUtil.isNotEmpty((String)this.myFrame.getBinary())) {
            keyValuePairs.add(Pair.create((Object)CidrProfilingBundle.message("memory.profile.object.label", new Object[0]), (Object)this.myFrame.getBinary()));
        }
        if (StringUtil.isNotEmpty((String)this.myFrame.getFunction())) {
            keyValuePairs.add(Pair.create((Object)CidrProfilingBundle.message("memory.profile.function.label", new Object[0]), (Object)this.myFrame.getFunction()));
        }
        if (StringUtil.isNotEmpty((String)this.myFrame.getDirectory())) {
            keyValuePairs.add(Pair.create((Object)CidrProfilingBundle.message("memory.profile.directory.label", new Object[0]), (Object)this.myFrame.getDirectory()));
        }
        if (StringUtil.isNotEmpty((String)this.myFrame.getFile())) {
            keyValuePairs.add(Pair.create((Object)CidrProfilingBundle.message("memory.profile.file.label", new Object[0]), (Object)this.myFrame.getFile()));
        }
        if (StringUtil.isNotEmpty((String)this.myFrame.getLine())) {
            keyValuePairs.add(Pair.create((Object)CidrProfilingBundle.message("memory.profile.line.label", new Object[0]), (Object)this.myFrame.getLine()));
        }
        for (int row = 0; row < keyValuePairs.size(); ++row) {
            @Nls @NlsSafe Pair keyValuePair = (Pair)keyValuePairs.get(row);
            boolean isLastOne = row == keyValuePairs.size() - 1;
            MemoryProfileStackFramePreviewPanel.addDescription((String)keyValuePair.getFirst(), (String)keyValuePair.getSecond(), row, panel2, isLastOne);
        }
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)panel2);
        if (jScrollPane == null) {
            MemoryProfileStackFramePreviewPanel.$$$reportNull$$$0(2);
        }
        return jScrollPane;
    }

    @NotNull
    private EditorEx createPreviewEditor(@NotNull MemoryProfileNavigationData navigationData) {
        if (navigationData == null) {
            MemoryProfileStackFramePreviewPanel.$$$reportNull$$$0(3);
        }
        Document document = navigationData.getDocument();
        VirtualFile virtualFile = navigationData.getVirtualFile();
        EditorEx editor = (EditorEx)EditorFactory.getInstance().createEditor(document, this.myProject, virtualFile, true);
        DiffUtil.setFoldingModelSupport((EditorEx)editor);
        EditorSettings settings2 = editor.getSettings();
        settings2.setLineNumbersShown(false);
        settings2.setFoldingOutlineShown(true);
        settings2.setLineMarkerAreaShown(true);
        settings2.setGutterIconsShown(false);
        settings2.setAdditionalColumnsCount(0);
        settings2.setAdditionalLinesCount(0);
        settings2.setLeadingWhitespaceShown(true);
        editor.getColorsScheme().setColor(EditorColors.GUTTER_BACKGROUND, editor.getColorsScheme().getDefaultBackground());
        editor.getScrollPane().setBorder((Border)JBUI.Borders.empty());
        editor.setBorder(IdeBorderFactory.createBorder((int)2));
        if (navigationData.isLineNumberValid()) {
            int lineNumber = navigationData.getLineNumber();
            ProblemPreviewEditorPresentation.setupFoldings((EditorEx)editor, MemoryProfileStackFramePreviewPanel.getFoldingRegions(document, lineNumber));
            MemoryProfileStackFramePreviewPanel.highlightLine((Editor)editor, lineNumber);
        }
        EditorEx editorEx = editor;
        if (editorEx == null) {
            MemoryProfileStackFramePreviewPanel.$$$reportNull$$$0(4);
        }
        return editorEx;
    }

    private static SortedSet<PreviewEditorFoldingRegion> getFoldingRegions(@NotNull Document document, int lineNumber) {
        if (document == null) {
            MemoryProfileStackFramePreviewPanel.$$$reportNull$$$0(5);
        }
        int additionalVisibleLines = 5;
        int visibleStartLine = Math.max(0, lineNumber - 5);
        int visibleEndLine = Math.min(lineNumber + 5 + 1, document.getLineCount());
        TreeSet<PreviewEditorFoldingRegion> foldingRegions = new TreeSet<PreviewEditorFoldingRegion>();
        if (visibleStartLine != 0) {
            foldingRegions.add(new PreviewEditorFoldingRegion(0, visibleStartLine));
        }
        if (visibleEndLine != document.getLineCount()) {
            foldingRegions.add(new PreviewEditorFoldingRegion(visibleEndLine, document.getLineCount()));
        }
        return foldingRegions;
    }

    private static void highlightLine(@NotNull Editor editor, int lineNumber) {
        if (editor == null) {
            MemoryProfileStackFramePreviewPanel.$$$reportNull$$$0(6);
        }
        MarkupModel model = editor.getMarkupModel();
        model.addLineHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, lineNumber, 6000);
    }

    private static void addDescription(@Nls @NotNull String title, @NlsSafe @Nullable String value, int gridY, @NotNull JPanel container, boolean isLastOne) {
        if (title == null) {
            MemoryProfileStackFramePreviewPanel.$$$reportNull$$$0(7);
        }
        if (container == null) {
            MemoryProfileStackFramePreviewPanel.$$$reportNull$$$0(8);
        }
        JBLabel titleLabel = new JBLabel(title);
        titleLabel.setFont(titleLabel.getFont().deriveFont(1));
        JBLabel description = MemoryProfileStackFramePreviewPanel.createDescription(value != null ? value : "");
        double weightY = isLastOne ? 1.0 : 0.0;
        container.add((Component)titleLabel, new GridBagConstraints(0, gridY, 1, 1, 0.0, weightY, 18, 0, (Insets)JBUI.insets((int)5, (int)10, (int)0, (int)0), 0, 0));
        container.add((Component)description, new GridBagConstraints(1, gridY, 1, 1, 1.0, weightY, 18, 2, (Insets)JBUI.insets((int)5, (int)0, (int)0, (int)10), 0, 0));
    }

    private static JBLabel createDescription(@NlsSafe @NotNull String text) {
        if (text == null) {
            MemoryProfileStackFramePreviewPanel.$$$reportNull$$$0(9);
        }
        JBLabel label = new JBLabel(text);
        label.setCopyable(true);
        return label;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cidr/profiling/memory/ui/MemoryProfileStackFramePreviewPanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cidr/profiling/memory/ui/MemoryProfileStackFramePreviewPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrameDescription";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPreviewEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPreviewEditor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFoldingRegions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "highlightLine";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addDescription";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

