/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.profiling.memory.ui;

import com.intellij.cidr.profiling.memory.tree.MemoryProfileRootTreeNode;
import com.intellij.cidr.profiling.memory.tree.MemoryProfileTree;
import com.intellij.cidr.profiling.memory.tree.MemoryProfileTreeNode;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class MemoryProfileExpansionHandler
implements TreeWillExpandListener {
    @NotNull
    private final MemoryProfileTree myTree;
    @NotNull
    private Set<Object> myVisibleElements;

    public MemoryProfileExpansionHandler(@NotNull MemoryProfileTree tree) {
        if (tree == null) {
            MemoryProfileExpansionHandler.$$$reportNull$$$0(0);
        }
        this.myTree = tree;
        this.myVisibleElements = new HashSet<Object>();
    }

    public void addVisibleElement(@NotNull Object visibleElement) {
        if (visibleElement == null) {
            MemoryProfileExpansionHandler.$$$reportNull$$$0(1);
        }
        this.myVisibleElements.add(visibleElement);
    }

    @Override
    public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
        MemoryProfileTreeNode node2 = (MemoryProfileTreeNode)event.getPath().getLastPathComponent();
        Object userObject = node2.getUserObject();
        if (userObject != null) {
            this.myVisibleElements.add(userObject);
        }
    }

    @Override
    public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
        MemoryProfileTreeNode node2 = (MemoryProfileTreeNode)event.getPath().getLastPathComponent();
        Object userObject = node2.getUserObject();
        if (userObject != null) {
            this.myVisibleElements.remove(userObject);
        }
    }

    public void restoreExpansion() {
        ThreadingAssertions.assertEventDispatchThread();
        MemoryProfileTreeNode rootNode = (MemoryProfileTreeNode)this.myTree.getModel().getRoot();
        TreeUtil.traverse((TreeNode)rootNode, obj -> {
            if (!(obj instanceof MemoryProfileTreeNode)) {
                return true;
            }
            MemoryProfileTreeNode node2 = (MemoryProfileTreeNode)obj;
            if (obj instanceof MemoryProfileRootTreeNode) {
                return true;
            }
            Object userObject = node2.getUserObject();
            if (userObject != null && this.myVisibleElements.contains(userObject)) {
                this.myTree.expandPath(new TreePath(node2.getPath()));
                return true;
            }
            for (int index = 0; index < node2.getChildCount(); ++index) {
                MemoryProfileTreeNode childNode;
                TreeNode childAt = node2.getChildAt(index);
                if (!(childAt instanceof MemoryProfileTreeNode) || !this.myTree.isExpanded(new TreePath((childNode = (MemoryProfileTreeNode)childAt).getPath()))) continue;
                this.myTree.expandPath(new TreePath(node2.getPath()));
                return true;
            }
            return true;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cidr/profiling/memory/ui/MemoryProfileExpansionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addVisibleElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

