/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.scheduling;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.cidr.lang.symbols.symtable.scheduling.UtilKt;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J#\u0010\f\u001a\u00028\u00002\u0014\u0010\r\u001a\u0010\u0012\u0002\b\u00030\u000eR\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0004\u00a2\u0006\u0002\u0010\u000fJ&\u0010\u0010\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\b2\u0014\u0010\u0012\u001a\u0010\u0012\u0002\b\u00030\u000eR\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0004J\u001e\u0010\u0013\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0004R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob;", "O", "", "estimatedWorksetSize", "", "(I)V", "callerWorkset", "Ljava/util/Deque;", "Ljava/util/concurrent/CountedCompleter;", "shouldPrioritize", "", "workerQuota", "run", "rootWorker", "Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob$IterativeWorker;", "(Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob$IterativeWorker;)Ljava/lang/Object;", "forkAsPending", "", "worker", "scheduleOnCallerAsPending", "IterativeWorker", "intellij.c"})
@ApiStatus.Experimental
public abstract class CallerAwareJob<O> {
    private final int workerQuota;
    @NotNull
    private final Deque<CountedCompleter<O>> callerWorkset;
    private boolean shouldPrioritize;

    public CallerAwareJob(int estimatedWorksetSize) {
        this.workerQuota = UtilKt.calculateWorkerQuota(estimatedWorksetSize);
        this.callerWorkset = new ConcurrentLinkedDeque();
    }

    protected final O run(@NotNull IterativeWorker<?> rootWorker) {
        Intrinsics.checkNotNullParameter(rootWorker, (String)"rootWorker");
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"getInstance(...)");
        ProgressManager progressManager2 = progressManager;
        if (progressManager2 instanceof CoreProgressManager) {
            this.shouldPrioritize = ((CoreProgressManager)progressManager2).isCurrentThreadPrioritized();
        }
        rootWorker.fork();
        while (!rootWorker.isDone()) {
            while (true) {
                CountedCompleter<O> callerWorker;
                ProgressManager.checkCanceled();
                if (this.callerWorkset.poll() == null) break;
                try {
                    callerWorker.compute();
                }
                catch (Throwable t) {
                    callerWorker.completeExceptionally(t);
                }
            }
            rootWorker.stealJob();
        }
        return (O)rootWorker.join();
    }

    protected final void forkAsPending(@NotNull CountedCompleter<?> $this$forkAsPending, @NotNull IterativeWorker<?> worker) {
        Intrinsics.checkNotNullParameter($this$forkAsPending, (String)"<this>");
        Intrinsics.checkNotNullParameter(worker, (String)"worker");
        $this$forkAsPending.addToPendingCount(1);
        worker.fork();
    }

    protected final void scheduleOnCallerAsPending(@NotNull CountedCompleter<?> $this$scheduleOnCallerAsPending, @NotNull CountedCompleter<O> worker) {
        Intrinsics.checkNotNullParameter($this$scheduleOnCallerAsPending, (String)"<this>");
        Intrinsics.checkNotNullParameter(worker, (String)"worker");
        $this$scheduleOnCallerAsPending.addToPendingCount(1);
        this.callerWorkset.push(worker);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00a4\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0005H\u0002J(\u0010\f\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0000R\b\u0012\u0004\u0012\u00028\u00000\r2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0005H$J\u0018\u0010\u000f\u001a\u00020\n2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0005H$J\b\u0010\u0010\u001a\u00020\nH$J\u0006\u0010\u0011\u001a\u00020\nR\u001c\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob$IterativeWorker;", "I", "Ljava/util/concurrent/CountedCompleter;", "parent", "initialWorkset", "Lcom/google/common/collect/ImmutableList;", "(Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob;Ljava/util/concurrent/CountedCompleter;Lcom/google/common/collect/ImmutableList;)V", "getInitialWorkset", "()Lcom/google/common/collect/ImmutableList;", "compute", "", "firstWorkset", "newWorker", "Lcom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob;", "workset", "process", "processingFinished", "stealJob", "intellij.c"})
    @SourceDebugExtension(value={"SMAP\nCallerAwareJob.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallerAwareJob.kt\ncom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob$IterativeWorker\n+ 2 util.kt\ncom/jetbrains/cidr/lang/symbols/symtable/scheduling/UtilKt\n*L\n1#1,119:1\n29#2,5:120\n47#2,4:125\n*S KotlinDebug\n*F\n+ 1 CallerAwareJob.kt\ncom/jetbrains/cidr/lang/symbols/symtable/scheduling/CallerAwareJob$IterativeWorker\n*L\n85#1:120,5\n91#1:125,4\n*E\n"})
    protected abstract class IterativeWorker<I>
    extends CountedCompleter<O> {
        @NotNull
        private final ImmutableList<? extends I> initialWorkset;

        public IterativeWorker(@NotNull CountedCompleter<?> parent, ImmutableList<? extends I> initialWorkset) {
            Intrinsics.checkNotNullParameter(initialWorkset, (String)"initialWorkset");
            super(parent);
            this.initialWorkset = initialWorkset;
        }

        @NotNull
        protected final ImmutableList<? extends I> getInitialWorkset() {
            return this.initialWorkset;
        }

        public final void stealJob() {
            if (ForkJoinTask.getQueuedTaskCount() > 0) {
                this.helpComplete(1);
            } else if (ForkJoinPool.commonPool().getQueuedTaskCount() > 0L || ForkJoinPool.commonPool().hasQueuedSubmissions()) {
                Semaphore s = new Semaphore(1);
                ApplicationManager.getApplication().executeOnPooledThread(() -> IterativeWorker.stealJob$lambda$0(s));
                s.waitFor(100L);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void compute() {
            void quota$iv;
            void $this$splitWorkset$iv;
            ImmutableList<? extends I> immutableList = this.initialWorkset;
            int n = CallerAwareJob.this.workerQuota;
            CallerAwareJob callerAwareJob = CallerAwareJob.this;
            boolean $i$f$splitWorkset = false;
            ImmutableList workset$iv = $this$splitWorkset$iv;
            while (UtilKt.access$splitWorkset(workset$iv, (int)quota$iv) != null) {
                ImmutableList right$iv;
                Pair pair;
                ImmutableList left$iv = (ImmutableList)pair.component1();
                ImmutableList it = right$iv = (ImmutableList)pair.component2();
                boolean bl = false;
                callerAwareJob.forkAsPending(this, this.newWorker(it));
                workset$iv = left$iv;
            }
            void firstWorkset = workset$iv;
            if (firstWorkset.isEmpty()) {
                this.processingFinished();
                return;
            }
            boolean shouldPrioritize$iv = CallerAwareJob.this.shouldPrioritize;
            boolean $i$f$prioritize = false;
            if (shouldPrioritize$iv) {
                ProgressManager.getInstance().computePrioritized(new ThrowableComputable(this, (ImmutableList)firstWorkset){
                    final /* synthetic */ IterativeWorker this$0;
                    final /* synthetic */ ImmutableList $firstWorkset$inlined;
                    {
                        this.this$0 = iterativeWorker;
                        this.$firstWorkset$inlined = immutableList;
                    }

                    public final Unit compute() {
                        boolean bl = false;
                        IterativeWorker.access$compute(this.this$0, this.$firstWorkset$inlined);
                        return Unit.INSTANCE;
                    }
                });
            } else {
                boolean bl = false;
                this.compute((ImmutableList)firstWorkset);
            }
        }

        private final void compute(ImmutableList<? extends I> firstWorkset) {
            this.process(firstWorkset);
            this.processingFinished();
        }

        @NotNull
        protected abstract IterativeWorker<I> newWorker(@NotNull ImmutableList<? extends I> var1);

        protected abstract void process(@NotNull ImmutableList<? extends I> var1);

        protected abstract void processingFinished();

        private static final void stealJob$lambda$0(Semaphore $s) {
            Intrinsics.checkNotNullParameter((Object)$s, (String)"$s");
            ForkJoinPool.commonPool().awaitQuiescence(0L, TimeUnit.MILLISECONDS);
            $s.up();
        }
    }
}

