/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityExecutionService;
import java.util.Collection;
import java.util.concurrent.CountedCompleter;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u001cB2\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000b\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\u0010\rJ,\u0010\u0010\u001a\f0\u0011R\b\u0012\u0004\u0012\u00028\u00000\u00002\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H$J\u001a\u0010\u0016\u001a\u00020\u00172\u0010\u0010\u0018\u001a\f0\u0011R\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0004J\u001a\u0010\u0019\u001a\u00020\u00172\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00028\u00000\u001bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/building/RecursiveSymbolBuilding;", "T", "", "project", "Lcom/intellij/openapi/project/Project;", "globalIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "readIndicator", "maxLeafSize", "", "indicatorText", "", "Lcom/intellij/openapi/util/NlsContexts$ProgressText;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/progress/ProgressIndicator;Lcom/intellij/openapi/progress/ProgressIndicator;ILjava/lang/String;)V", "getIndicatorText", "()Ljava/lang/String;", "createWorkerTask", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/RecursiveSymbolBuilding$ReadActionTask;", "parent", "Ljava/util/concurrent/CountedCompleter;", "workset", "Lcom/google/common/collect/ImmutableList;", "forkOnBuildingPool", "", "task", "process", "clusteredWorkset", "Lcom/google/common/collect/ImmutableListMultimap;", "ReadActionTask", "intellij.c"})
public abstract class RecursiveSymbolBuilding<T> {
    @NotNull
    private final Project project;
    @NotNull
    private final ProgressIndicator globalIndicator;
    @NotNull
    private final ProgressIndicator readIndicator;
    private final int maxLeafSize;
    @NotNull
    private final String indicatorText;

    public RecursiveSymbolBuilding(@NotNull Project project, @NotNull ProgressIndicator globalIndicator, @NotNull ProgressIndicator readIndicator, int maxLeafSize, @NotNull String indicatorText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)globalIndicator, (String)"globalIndicator");
        Intrinsics.checkNotNullParameter((Object)readIndicator, (String)"readIndicator");
        Intrinsics.checkNotNullParameter((Object)indicatorText, (String)"indicatorText");
        this.project = project;
        this.globalIndicator = globalIndicator;
        this.readIndicator = readIndicator;
        this.maxLeafSize = maxLeafSize;
        this.indicatorText = indicatorText;
        if (this.maxLeafSize < 1) {
            throw new IllegalArgumentException("maxLeafSize");
        }
    }

    @NlsContexts.ProgressText
    @NotNull
    public final String getIndicatorText() {
        return this.indicatorText;
    }

    public final void process(@NotNull ImmutableListMultimap<Object, T> clusteredWorkset) {
        Intrinsics.checkNotNullParameter(clusteredWorkset, (String)"clusteredWorkset");
        OCBuildingActivityExecutionService.Companion.getExecutor().invoke(new CountedCompleter<Void>(clusteredWorkset, this){
            final /* synthetic */ ImmutableListMultimap<Object, T> $clusteredWorkset;
            final /* synthetic */ RecursiveSymbolBuilding<T> this$0;
            {
                this.$clusteredWorkset = $clusteredWorkset;
                this.this$0 = $receiver;
            }

            public void compute() {
                for (Collection workset2 : (ImmutableCollection)this.$clusteredWorkset.asMap().values()) {
                    RecursiveSymbolBuilding.access$getGlobalIndicator$p(this.this$0).checkCanceled();
                    if (workset2.isEmpty()) continue;
                    CountedCompleter countedCompleter = this;
                    Intrinsics.checkNotNull((Object)workset2, (String)"null cannot be cast to non-null type com.google.common.collect.ImmutableList<T of com.jetbrains.cidr.lang.symbols.symtable.building.RecursiveSymbolBuilding>");
                    ReadActionTask task2 = this.this$0.createWorkerTask(countedCompleter, (ImmutableList)workset2);
                    this.addToPendingCount(1);
                    this.this$0.forkOnBuildingPool(task2);
                }
                this.propagateCompletion();
            }
        });
    }

    @NotNull
    protected abstract ReadActionTask createWorkerTask(@NotNull CountedCompleter<?> var1, @NotNull ImmutableList<T> var2);

    protected final void forkOnBuildingPool(@NotNull ReadActionTask task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        OCBuildingActivityExecutionService service = OCBuildingActivityExecutionService.Companion.getInstance();
        if (service.isBuildingThread()) {
            task2.fork();
        } else {
            service.getExecutor().execute(task2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u00a4\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0002J\u001c\u0010\r\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\tH\u0016J\b\u0010\u0011\u001a\u00020\tH\u0002J\b\u0010\u0012\u001a\u00020\tH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/building/RecursiveSymbolBuilding$ReadActionTask;", "Ljava/util/concurrent/CountedCompleter;", "Ljava/lang/Void;", "Ljava/lang/Runnable;", "parent", "workset", "Lcom/google/common/collect/ImmutableList;", "(Lcom/jetbrains/cidr/lang/symbols/symtable/building/RecursiveSymbolBuilding;Ljava/util/concurrent/CountedCompleter;Lcom/google/common/collect/ImmutableList;)V", "compute", "", "computeInReadAction", "item", "(Ljava/lang/Object;)V", "reschedule", "addToPendingCount", "", "run", "runOrReschedule", "splitWorkset", "intellij.c"})
    @SourceDebugExtension(value={"SMAP\nRecursiveSymbolBuilding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecursiveSymbolBuilding.kt\ncom/jetbrains/cidr/lang/symbols/symtable/building/RecursiveSymbolBuilding$ReadActionTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 RecursiveSymbolBuilding.kt\ncom/jetbrains/cidr/lang/symbols/symtable/building/RecursiveSymbolBuildingKt\n*L\n1#1,130:1\n1#2:131\n113#3,16:132\n*S KotlinDebug\n*F\n+ 1 RecursiveSymbolBuilding.kt\ncom/jetbrains/cidr/lang/symbols/symtable/building/RecursiveSymbolBuilding$ReadActionTask\n*L\n69#1:132,16\n*E\n"})
    protected abstract class ReadActionTask
    extends CountedCompleter<Void>
    implements Runnable {
        @NotNull
        private ImmutableList<T> workset;

        public ReadActionTask(@NotNull CountedCompleter<?> parent, ImmutableList<T> workset2) {
            Intrinsics.checkNotNullParameter(parent, (String)"parent");
            Intrinsics.checkNotNullParameter(workset2, (String)"workset");
            super(parent);
            this.workset = workset2;
            if (this.workset.isEmpty()) {
                throw new IllegalArgumentException("empty workset");
            }
        }

        @Override
        public void compute() {
            this.splitWorkset();
            this.runOrReschedule();
            this.propagateCompletion();
        }

        private final void splitWorkset() {
            boolean bl;
            while (this.workset.size() > RecursiveSymbolBuilding.this.maxLeafSize) {
                int split = this.workset.size() / 2;
                ImmutableList immutableList = this.workset.subList(split, this.workset.size());
                Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"subList(...)");
                this.reschedule(immutableList);
                Intrinsics.checkNotNullExpressionValue((Object)this.workset.subList(0, split), (String)"subList(...)");
                this.workset = this.workset;
            }
            boolean bl2 = bl = !this.workset.isEmpty();
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "Workset should not be empty";
                throw new AssertionError((Object)string);
            }
        }

        private final void runOrReschedule() {
            block2: {
                try {
                    ProgressManager.getInstance().executeProcessUnderProgress(() -> ReadActionTask.runOrReschedule$lambda$2(RecursiveSymbolBuilding.this, this), RecursiveSymbolBuilding.this.readIndicator);
                }
                catch (ProcessCanceledException e) {
                    if (RecursiveSymbolBuilding.this.globalIndicator.isCanceled()) break block2;
                    this.reschedule(this.workset);
                }
            }
        }

        @Override
        public void run() {
            if (RecursiveSymbolBuilding.this.project.isDisposed()) {
                return;
            }
            int n = this.workset.size();
            for (int i = 0; i < n; ++i) {
                try {
                    this.computeInReadAction(this.workset.get(i));
                    continue;
                }
                catch (ProcessCanceledException e) {
                    if (!RecursiveSymbolBuilding.this.globalIndicator.isCanceled()) {
                        ImmutableList immutableList = this.workset.subList(i, this.workset.size());
                        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"subList(...)");
                        this.reschedule(immutableList);
                    }
                    return;
                }
            }
        }

        private final void reschedule(ImmutableList<T> workset2) {
            if (!workset2.isEmpty()) {
                this.reschedule(workset2, 1);
            }
        }

        public final void reschedule(@NotNull ImmutableList<T> workset2, int addToPendingCount) {
            Intrinsics.checkNotNullParameter(workset2, (String)"workset");
            ReadActionTask remainingTask = RecursiveSymbolBuilding.this.createWorkerTask(this, workset2);
            if (addToPendingCount != 0) {
                this.addToPendingCount(addToPendingCount);
            }
            RecursiveSymbolBuilding.this.forkOnBuildingPool(remainingTask);
        }

        protected abstract void computeInReadAction(T var1);

        private static final void runOrReschedule$lambda$2(RecursiveSymbolBuilding this$0, ReadActionTask this$1) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            ProgressIndicator indicator$iv = this$0.globalIndicator;
            boolean $i$f$rerunUntilSuccess = false;
            long sleep$iv = 1L;
            while (true) {
                indicator$iv.checkCanceled();
                boolean bl = false;
                if (!this$0.readIndicator.isCanceled() && ApplicationManagerEx.getApplicationEx().tryRunReadAction((Runnable)this$1)) break;
                indicator$iv.checkCanceled();
                try {
                    Thread.sleep(sleep$iv);
                    sleep$iv = RangesKt.coerceAtMost((long)(sleep$iv * (long)2), (long)100L);
                }
                catch (InterruptedException e$iv) {
                    throw new ProcessCanceledException((Throwable)e$iv);
                }
            }
        }
    }
}

