/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCInitialBuildingInfo;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolLoadingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTablesBuildingMode;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCWorkerActivity;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import java.util.HashSet;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class OCSymbolSavingActivity {
    public static Pair<Integer, Integer> build(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull OCInitialBuildingInfo userData) {
        if (indicator == null) {
            OCSymbolSavingActivity.$$$reportNull$$$0(0);
        }
        if (userData == null) {
            OCSymbolSavingActivity.$$$reportNull$$$0(1);
        }
        Ref result = new Ref();
        OCWorkerActivity.runWithProgress(indicator, OCBundle.message("saving.symbols", new Object[0]), Objects.requireNonNull(userData.getSavingFraction()), 1.0, () -> {
            Project project = userData.getProject();
            if (project.isDisposed()) {
                return;
            }
            FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project);
            OCSymbolTablesBuildingMode mode = userData.getMode();
            cache.removeJunkTables(mode == OCSymbolTablesBuildingMode.COMPACT);
            HashSet<VirtualFile> filesWithModifiedTables = new HashSet<VirtualFile>(cache.getFilesWithChangedTables());
            indicator.checkCanceled();
            int newTableFileCount = filesWithModifiedTables.size();
            int newTableCount = OCSymbolLoadingActivity.getAllTablesCount(cache, filesWithModifiedTables);
            @NonNls String serializeDescription = newTableFileCount + " files (" + newTableCount + " tables of total " + OCSymbolLoadingActivity.getAllTablesCount(cache) + ")";
            OCLog.LOG.info("Saving modified symbols for " + serializeDescription);
            try (CidrEventSpan ignored = new CidrEventSpan("symbols", "serializeTables", (Object)serializeDescription);){
                cache.serializeTables(Objects.requireNonNull(userData.getLocationHash()), filesWithModifiedTables, (ProgressIndicator)indicator);
            }
            result.set((Object)Pair.create((Object)newTableFileCount, (Object)newTableCount));
        });
        return (Pair)result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "indicator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "userData";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/symbols/symtable/building/OCSymbolSavingActivity";
        objectArray[2] = "build";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

