/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapRoot;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationService;
import com.jetbrains.cidr.lang.modulemap.serialization.RootsWithConfigurations;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCInitialBuildingInfo;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTableBuildingUtil;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCWorkerActivity;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class OCModuleMapDeserializationActivity {
    public static final Key<Boolean> DESERIALIZED_BUNDLED_MODULE_MAPS_ONLY = Key.create((String)"Deserialize bundled module maps only");

    public static void build(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull OCInitialBuildingInfo userData) {
        if (indicator == null) {
            OCModuleMapDeserializationActivity.$$$reportNull$$$0(0);
        }
        if (userData == null) {
            OCModuleMapDeserializationActivity.$$$reportNull$$$0(1);
        }
        if (!ModuleMapCache.shouldBuildCache()) {
            ModuleMapLog.INSTANCE.reportDeserializationIsDisabled();
            return;
        }
        Project project = userData.getProject();
        if (project.isDisposed()) {
            return;
        }
        Ref ref = new Ref();
        try (CidrEventSpan ignored = new CidrEventSpan("moduleMaps", "getAllHeaderRootsForModuleMapBuilding", null);){
            OCWorkerActivity.runWithIndeterminateProgress(indicator, OCBundle.message("loading.headers.search.roots", new Object[0]), () -> {
                RootsWithConfigurations roots2 = OCModuleMapDeserializationActivity.getHeadersSearchRoots(indicator, project);
                ref.set((Object)roots2);
            });
        }
        ((RootsWithConfigurations)ref.get()).log(project);
        ignored = new CidrEventSpan("moduleMaps", "deserialize", (Object)(((RootsWithConfigurations)ref.get()).getSize() + " root(s)"));
        try {
            Boolean bundledOnlyObject = (Boolean)userData.getUserData(DESERIALIZED_BUNDLED_MODULE_MAPS_ONLY);
            boolean bundledOnly = bundledOnlyObject != null && bundledOnlyObject != false;
            OCWorkerActivity.runWithProgress(indicator, OCBundle.message("loading.module.maps", new Object[0]), 0.0, 0.1, () -> ModuleMapSerializationService.getInstance(project).deserializeModuleMaps((ProgressIndicator)indicator, (RootsWithConfigurations)ref.get(), bundledOnly));
        }
        finally {
            ignored.close();
        }
    }

    @NotNull
    private static RootsWithConfigurations getHeadersSearchRoots(@NotNull OCBuildingActivityProgressIndicator indicator, @NotNull Project project) {
        if (indicator == null) {
            OCModuleMapDeserializationActivity.$$$reportNull$$$0(2);
        }
        if (project == null) {
            OCModuleMapDeserializationActivity.$$$reportNull$$$0(3);
        }
        RootsWithConfigurations rootsWithConfigurations = OCSymbolTableBuildingUtil.runCancelableReadAction(project, (ProgressIndicator)indicator, () -> {
            indicator.checkCanceled();
            ModuleMapManager moduleMapManager = ModuleMapManager.getInstance(project);
            HashMap<ModuleMapRoot, List> map2 = new HashMap<ModuleMapRoot, List>();
            for (OCResolveConfiguration configuration : OCWorkspace.getInstance((Project)project).getConfigurations()) {
                List<ModuleMapRoot> roots2 = moduleMapManager.cacheFor(configuration).getModuleMapRoots();
                for (ModuleMapRoot root : roots2) {
                    List configurations = map2.computeIfAbsent(root, k -> new ArrayList());
                    configurations.add(configuration);
                }
            }
            return new RootsWithConfigurations(map2);
        });
        if (rootsWithConfigurations == null) {
            OCModuleMapDeserializationActivity.$$$reportNull$$$0(4);
        }
        return rootsWithConfigurations;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/building/OCModuleMapDeserializationActivity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/building/OCModuleMapDeserializationActivity";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeadersSearchRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHeadersSearchRoots";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

