/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLambdaExpressionSymbol
extends OCExpressionSymbol {
    private OCType myReturnType;
    private List<OCType> myParameterTypes;
    private OCFunctionSymbol myFunctionSymbol;
    private List<OCDeclaratorSymbol> myParameters;
    private List<OCDeclaratorSymbol> myLocalVarsAndParams;
    private List<OCExpressionSymbol> myReturnExpressions;
    private Map<OCType, OCType> myAutoParamsMapping;
    public static final Comparator<OCDeclaratorSymbol> variablesComparator = Comparator.comparing(OCSymbol::getName).thenComparingLong(OCSymbol::getComplexOffset);

    public OCLambdaExpressionSymbol() {
    }

    /*
     * WARNING - void declaration
     */
    public OCLambdaExpressionSymbol(@Nullable VirtualFile file, long offset, @NotNull List<OCExpressionSymbol> returnExpressions, @NotNull List<OCDeclaratorSymbol> parameters, @NotNull List<OCDeclaratorSymbol> localVarsAndParams, @Nullable List<OCType> parameterTypes, @Nullable OCType oCType) {
        void returnType;
        if (returnExpressions == null) {
            OCLambdaExpressionSymbol.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            OCLambdaExpressionSymbol.$$$reportNull$$$0(1);
        }
        if (localVarsAndParams == null) {
            OCLambdaExpressionSymbol.$$$reportNull$$$0(2);
        }
        super(file, offset);
        this.myReturnExpressions = returnExpressions;
        this.myParameters = parameters;
        this.myLocalVarsAndParams = localVarsAndParams;
        this.myParameterTypes = parameterTypes;
        this.myReturnType = returnType;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCLambdaExpressionSymbol.$$$reportNull$$$0(3);
        }
        if (first == null) {
            OCLambdaExpressionSymbol.$$$reportNull$$$0(4);
        }
        if (second == null) {
            OCLambdaExpressionSymbol.$$$reportNull$$$0(5);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCLambdaExpressionSymbol firstSymbol = (OCLambdaExpressionSymbol)first;
        OCLambdaExpressionSymbol secondSymbol = (OCLambdaExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myParameterTypes, secondSymbol.myParameterTypes)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myParameters, secondSymbol.myParameters)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myLocalVarsAndParams, secondSymbol.myLocalVarsAndParams)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myReturnType, secondSymbol.myReturnType)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myReturnExpressions, secondSymbol.myReturnExpressions)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myFunctionSymbol, secondSymbol.myFunctionSymbol);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.LAMBDA;
        if (oCSymbolKind == null) {
            OCLambdaExpressionSymbol.$$$reportNull$$$0(6);
        }
        return oCSymbolKind;
    }

    public List<OCDeclaratorSymbol> getParameters() {
        return this.myParameters;
    }

    @NotNull
    public List<OCDeclaratorSymbol> getLocalVarsAndParams() {
        List<OCDeclaratorSymbol> list = this.myLocalVarsAndParams;
        if (list == null) {
            OCLambdaExpressionSymbol.$$$reportNull$$$0(7);
        }
        return list;
    }

    public void setFunctionSymbol(@NotNull OCFunctionSymbol functionSymbol) {
        if (functionSymbol == null) {
            OCLambdaExpressionSymbol.$$$reportNull$$$0(8);
        }
        this.myFunctionSymbol = functionSymbol;
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        if (evaluator == null) {
            OCLambdaExpressionSymbol.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCLambdaExpressionSymbol.$$$reportNull$$$0(10);
        }
        if (this.myParameterTypes != null && ContainerUtil.exists(this.myParameterTypes, OCTypeUtils::hasAutoInside) && !this.myReturnExpressions.isEmpty()) {
            Map<OCType, OCType> map2 = OCTypeUtils.newTypesMap();
            List newParameterTypes = ContainerUtil.map(this.myParameterTypes, t -> OCTypeUtils.replaceAutoTypesWithTypeParameters(t, map2, context.getProject()));
            OCLambdaExpressionSymbol newSymbol = new OCLambdaExpressionSymbol(this.myFile, this.myComplexOffset, this.myReturnExpressions, this.myParameters, this.myLocalVarsAndParams, newParameterTypes, this.myReturnType);
            newSymbol.myAutoParamsMapping = map2;
            OCAutoType result = new OCAutoType(newSymbol, null, null, false, false);
            result.setNeedsAutoParamsResolving(true);
            OCAutoType oCAutoType = result;
            if (oCAutoType == null) {
                OCLambdaExpressionSymbol.$$$reportNull$$$0(11);
            }
            return oCAutoType;
        }
        OCType returnType = this.myReturnType;
        if (returnType == null) {
            for (OCExpressionSymbol expression : this.myReturnExpressions) {
                if (this.myFunctionSymbol != null) {
                    context.pushOuterFunction(this.myFunctionSymbol);
                }
                OCType type = expression.getResolvedType(context);
                type = OCTypeUtils.decayType(type, context.getProject());
                if (this.myFunctionSymbol != null) {
                    context.popOuterFunction();
                }
                if (returnType == null) {
                    returnType = type;
                    continue;
                }
                if (type != null && type.isUnknown() || returnType.equals(type, context)) continue;
                OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
                if (oCUnknownType == null) {
                    OCLambdaExpressionSymbol.$$$reportNull$$$0(12);
                }
                return oCUnknownType;
            }
            if (returnType == null) {
                returnType = OCVoidType.instance();
            }
        }
        OCType oCType = this.myFunctionSymbol != null ? returnType : context.getSubstitution().substitute(OCPointerType.to(new OCFunctionType(returnType, this.getResolvedParameterTypes(context))), context);
        if (oCType == null) {
            OCLambdaExpressionSymbol.$$$reportNull$$$0(13);
        }
        return oCType;
    }

    private List<OCType> getResolvedParameterTypes(@NotNull OCResolveContext context) {
        if (context == null) {
            OCLambdaExpressionSymbol.$$$reportNull$$$0(14);
        }
        return ContainerUtil.map(this.myParameterTypes, p -> p.resolve(context));
    }

    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context, @NotNull OCArgumentsList<? extends OCTypeOwner> arguments) {
        if (context == null) {
            OCLambdaExpressionSymbol.$$$reportNull$$$0(15);
        }
        if (arguments == null) {
            OCLambdaExpressionSymbol.$$$reportNull$$$0(16);
        }
        return this.getResolvedType(context, arguments, false);
    }

    @Nullable
    public OCType getResolvedType(@NotNull OCResolveContext context, @NotNull OCArgumentsList<? extends OCTypeOwner> arguments, boolean failIfNotUnified) {
        if (context == null) {
            OCLambdaExpressionSymbol.$$$reportNull$$$0(17);
        }
        if (arguments == null) {
            OCLambdaExpressionSymbol.$$$reportNull$$$0(18);
        }
        if (this.myParameterTypes.size() != arguments.getCount()) {
            return failIfNotUnified ? OCUnknownType.INSTANCE : this.getResolvedType(context);
        }
        HashMap<OCTypeParameterSymbol, OCTypeArgument> map2 = new HashMap<OCTypeParameterSymbol, OCTypeArgument>();
        for (int i = 0; i < this.myParameterTypes.size(); ++i) {
            OCTypeOwner expression;
            OCType type = arguments.getTypes().get(i);
            OCTypeOwner oCTypeOwner = expression = arguments.getExprs() != null ? arguments.getExprs().get(i) : null;
            if (OCSimpleTypeSubstitution.unify(this.myParameterTypes.get(i), type, expression, map2, null, true, false, context) != OCTypeUnificationVisitor.NOT_UNIFIED) continue;
            return failIfNotUnified ? OCUnknownType.INSTANCE : this.getResolvedType(context);
        }
        context = context.substitute(OCSimpleTypeSubstitution.create(map2), false, true);
        context.setAutoParamsTypeMapping(this.myAutoParamsMapping);
        return this.getResolvedType(context);
    }

    @NotNull
    public List<OCExpressionSymbol> getReturnExpressions() {
        List<OCExpressionSymbol> list = this.myReturnExpressions;
        if (list == null) {
            OCLambdaExpressionSymbol.$$$reportNull$$$0(19);
        }
        return list;
    }

    public OCFunctionSymbol getFunctionSymbol() {
        return this.myFunctionSymbol;
    }

    public int getNonInitializedParametersCount(@Nullable OCResolveContext context) {
        return OCTypeUtils.getNonInitializedParametersCount(this.myParameters, context);
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.myFunctionSymbol != null ? this.myFunctionSymbol.getPresentableName() : "<lambda>";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 11, 12, 13, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnExpressions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localVarsAndParams";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/expression/OCLambdaExpressionSymbol";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionSymbol";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 10: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/expression/OCLambdaExpressionSymbol";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalVarsAndParams";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedType";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 19: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setFunctionSymbol";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedParameterTypes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 11, 12, 13, 19 -> new IllegalStateException(string);
        };
    }
}

