/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.settings.CidrCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.NamingConvention;
import com.jetbrains.cidr.lang.settings.NamingConventionRule;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.util.OCDeclarationKind;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCCodeStyleSettings
extends CidrCodeStyleSettings {
    public static final String[] LEW_LINE_OPTIONS = new String[]{OCBundle.message("wrapping.new.line.never", new Object[0]), OCBundle.message("wrapping.new.line.always", new Object[0]), OCBundle.message("wrapping.new.line.if.long", new Object[0])};
    public static final int[] LEW_LINE_VALUES = new int[]{0, 1, 2};
    public List<OCDeclarationKind> FILE_DECLARATIONS_ORDER = new ArrayList<OCDeclarationKind>(OCDeclarationKind.ourFileDeclarationKinds);
    public List<OCDeclarationKind> CLASS_DECLARATIONS_ORDER = new ArrayList<OCDeclarationKind>(OCDeclarationKind.ourClassDeclarationKinds);
    public NamingConvention NAMESPACES_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.CAMEL_CASE, "");
    public NamingConvention MACROS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.SCREAMING_SNAKE_CASE, "");
    public NamingConvention CLASSES_AND_STRUCTS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.CAMEL_CASE, "");
    public NamingConvention ENUMS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.CAMEL_CASE, "");
    public NamingConvention ENUMERATORS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.PASCAL_CASE, "");
    public NamingConvention TYPEDEFS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.CAMEL_CASE, "");
    public NamingConvention UNIONS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.CAMEL_CASE, "");
    public NamingConvention METHODS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.CAMEL_CASE, "");
    public NamingConvention FIELDS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.CAMEL_CASE, "");
    public NamingConvention GLOBAL_FUNCTIONS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.CAMEL_CASE, "");
    public NamingConvention GLOBAL_VARIABLES_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.CAMEL_CASE, "");
    public NamingConvention PARAMETERS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.CAMEL_CASE, "");
    public NamingConvention LOCAL_VARIABLES_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.CAMEL_CASE, "");
    public List<NamingConventionRule> NAMING_CONVENTION_RULES = this.getDefaultNamingConventionRules();

    OCCodeStyleSettings(CodeStyleSettings container) {
        super(container);
    }

    public Object clone() {
        OCCodeStyleSettings clone = (OCCodeStyleSettings)((Object)super.clone());
        clone.NAMESPACES_NAMING_CONVENTION = new NamingConvention(this.NAMESPACES_NAMING_CONVENTION);
        clone.MACROS_NAMING_CONVENTION = new NamingConvention(this.MACROS_NAMING_CONVENTION);
        clone.CLASSES_AND_STRUCTS_NAMING_CONVENTION = new NamingConvention(this.CLASSES_AND_STRUCTS_NAMING_CONVENTION);
        clone.ENUMS_NAMING_CONVENTION = new NamingConvention(this.ENUMS_NAMING_CONVENTION);
        clone.ENUMERATORS_NAMING_CONVENTION = new NamingConvention(this.ENUMERATORS_NAMING_CONVENTION);
        clone.TYPEDEFS_NAMING_CONVENTION = new NamingConvention(this.TYPEDEFS_NAMING_CONVENTION);
        clone.UNIONS_NAMING_CONVENTION = new NamingConvention(this.UNIONS_NAMING_CONVENTION);
        clone.METHODS_NAMING_CONVENTION = new NamingConvention(this.METHODS_NAMING_CONVENTION);
        clone.FIELDS_NAMING_CONVENTION = new NamingConvention(this.FIELDS_NAMING_CONVENTION);
        clone.GLOBAL_FUNCTIONS_NAMING_CONVENTION = new NamingConvention(this.GLOBAL_FUNCTIONS_NAMING_CONVENTION);
        clone.GLOBAL_VARIABLES_NAMING_CONVENTION = new NamingConvention(this.GLOBAL_VARIABLES_NAMING_CONVENTION);
        clone.PARAMETERS_NAMING_CONVENTION = new NamingConvention(this.PARAMETERS_NAMING_CONVENTION);
        clone.LOCAL_VARIABLES_NAMING_CONVENTION = new NamingConvention(this.LOCAL_VARIABLES_NAMING_CONVENTION);
        clone.FILE_DECLARATIONS_ORDER = new ArrayList<OCDeclarationKind>(this.FILE_DECLARATIONS_ORDER);
        clone.CLASS_DECLARATIONS_ORDER = new ArrayList<OCDeclarationKind>(this.CLASS_DECLARATIONS_ORDER);
        clone.NAMING_CONVENTION_RULES = NamingConventionRule.copyRules(this.NAMING_CONVENTION_RULES);
        return clone;
    }

    public void readFromExtensionNode(@Nullable Element extensionNode) {
        super.readFromExtensionNode(extensionNode);
        OCCodeStyleSettings.readDeclarationsOrder(extensionNode, "file", this.FILE_DECLARATIONS_ORDER, OCDeclarationKind.ourFileDeclarationKinds);
        OCCodeStyleSettings.readDeclarationsOrder(extensionNode, "class", this.CLASS_DECLARATIONS_ORDER, OCDeclarationKind.ourClassDeclarationKinds);
        this.readNamingConventionRules(extensionNode);
    }

    private void readNamingConventionRules(Element parentNode) {
        this.NAMING_CONVENTION_RULES = NamingConventionRule.readExternalList(parentNode, this.getDefaultNamingConventionRules());
    }

    private static void readDeclarationsOrder(@Nullable Element parentNode, String orderName, List<OCDeclarationKind> order, List<OCDeclarationKind> defaultValue) {
        Element childElement;
        order.clear();
        Element element = childElement = parentNode == null ? null : parentNode.getChild(orderName);
        if (childElement != null) {
            for (Element e : childElement.getChildren("option")) {
                try {
                    OCDeclarationKind kind;
                    String value = e.getAttributeValue("value");
                    if (value == null || !(kind = Enum.valueOf(OCDeclarationKind.class, value)).isAvailable()) continue;
                    order.add(kind);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        ArrayList<OCDeclarationKind> missing = new ArrayList<OCDeclarationKind>(defaultValue);
        missing.removeAll(order);
        order.addAll(missing);
    }

    public void writeToExtensionNode(@NotNull Element extensionNode, @NotNull CustomCodeStyleSettings parentSettings) {
        if (extensionNode == null) {
            OCCodeStyleSettings.$$$reportNull$$$0(0);
        }
        if (parentSettings == null) {
            OCCodeStyleSettings.$$$reportNull$$$0(1);
        }
        OCCodeStyleSettings.addDeclarationsOrder(extensionNode, "file", this.FILE_DECLARATIONS_ORDER, OCDeclarationKind.ourFileDeclarationKinds);
        OCCodeStyleSettings.addDeclarationsOrder(extensionNode, "class", this.CLASS_DECLARATIONS_ORDER, OCDeclarationKind.ourClassDeclarationKinds);
        NamingConventionRule.writeExternalList(extensionNode, this.NAMING_CONVENTION_RULES, this.getDefaultNamingConventionRules());
        super.writeToExtensionNode(extensionNode, parentSettings);
    }

    private List<NamingConventionRule> getDefaultNamingConventionRules() {
        return List.of(new NamingConventionRule(NamingConventionRule.EntityKind.NAMESPACE, this.NAMESPACES_NAMING_CONVENTION), new NamingConventionRule(NamingConventionRule.EntityKind.MACRO, this.MACROS_NAMING_CONVENTION), new NamingConventionRule(NamingConventionRule.EntityKind.CLASS, this.CLASSES_AND_STRUCTS_NAMING_CONVENTION), new NamingConventionRule(NamingConventionRule.EntityKind.STRUCT, this.CLASSES_AND_STRUCTS_NAMING_CONVENTION), new NamingConventionRule(NamingConventionRule.EntityKind.ENUM, this.ENUMS_NAMING_CONVENTION), new NamingConventionRule(NamingConventionRule.EntityKind.ENUMERATOR, this.ENUMERATORS_NAMING_CONVENTION), new NamingConventionRule(NamingConventionRule.EntityKind.TYPEDEF, this.TYPEDEFS_NAMING_CONVENTION), new NamingConventionRule(NamingConventionRule.EntityKind.UNION, this.UNIONS_NAMING_CONVENTION), new NamingConventionRule(NamingConventionRule.EntityKind.CLASS_MEMBER_FUNCTION, this.METHODS_NAMING_CONVENTION), new NamingConventionRule(NamingConventionRule.EntityKind.STRUCT_MEMBER_FUNCTION, this.METHODS_NAMING_CONVENTION), new NamingConventionRule(NamingConventionRule.EntityKind.CLASS_MEMBER_FIELD, this.FIELDS_NAMING_CONVENTION), new NamingConventionRule(NamingConventionRule.EntityKind.STRUCT_MEMBER_FIELD, this.FIELDS_NAMING_CONVENTION), new NamingConventionRule(NamingConventionRule.EntityKind.GLOBAL_FUNCTION, this.GLOBAL_FUNCTIONS_NAMING_CONVENTION), new NamingConventionRule(NamingConventionRule.EntityKind.GLOBAL_VARIABLE, this.GLOBAL_VARIABLES_NAMING_CONVENTION), new NamingConventionRule(NamingConventionRule.EntityKind.PARAMETER, this.PARAMETERS_NAMING_CONVENTION), new NamingConventionRule(NamingConventionRule.EntityKind.LOCAL_VARIABLE, this.LOCAL_VARIABLES_NAMING_CONVENTION));
    }

    private static void addDeclarationsOrder(Element parentElement, @NonNls String orderName, List<OCDeclarationKind> order, List<OCDeclarationKind> defaultValue) {
        if (order.equals(defaultValue)) {
            return;
        }
        Element childElement = new Element(orderName);
        for (OCDeclarationKind kind : order) {
            Element element = OCCodeStyleSettings.writeEnumField((String)OCDeclarationKind.class.getName(), (Enum)kind);
            childElement.addContent(element);
        }
        parentElement.addContent(childElement);
    }

    @Nullable
    public static CidrCodeStyleSettings.RememberedOption askAndSave(CidrCodeStyleSettings.RememberedOption option, @NlsContexts.DialogMessage String message, @NlsContexts.DialogTitle String title, Ref<Boolean> result) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            result.set((Object)true);
            return option;
        }
        if (option == CidrCodeStyleSettings.RememberedOption.ASK) {
            final Ref save = Ref.create((Object)Boolean.FALSE);
            int code = ((MessageDialogBuilder.YesNoCancel)MessageDialogBuilder.yesNoCancel((String)title, (String)message).doNotAsk(new DoNotAskOption(){

                public boolean isToBeShown() {
                    return true;
                }

                public void setToBeShown(boolean value, int exitCode) {
                    save.set((Object)(!value ? 1 : 0));
                }

                public boolean canBeHidden() {
                    return true;
                }

                public boolean shouldSaveOptionsOnCancel() {
                    return true;
                }

                @NotNull
                public String getDoNotShowMessage() {
                    String string = OCBundle.message("code.style.remember.choice", new Object[0]);
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/settings/OCCodeStyleSettings$1", "getDoNotShowMessage"));
                }
            })).guessWindowAndAsk();
            if (code == 2) {
                return null;
            }
            boolean answer = code == 0;
            result.set((Object)answer);
            if (((Boolean)save.get()).booleanValue()) {
                return answer ? CidrCodeStyleSettings.RememberedOption.YES : CidrCodeStyleSettings.RememberedOption.NO;
            }
        } else {
            result.set((Object)(option == CidrCodeStyleSettings.RememberedOption.YES ? 1 : 0));
        }
        return option;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "extensionNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parentSettings";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/settings/OCCodeStyleSettings";
        objectArray[2] = "writeToExtensionNode";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

