/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.settings.NamingConvention;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0086\b\u0018\u0000 U2\u00020\u0001:\u0005UVWXYB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B7\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eB\u000f\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0010B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013B'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0014BG\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0015\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0016J$\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100H\u0002J\u001c\u00101\u001a\u00020*2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100H\u0002J\u001a\u00102\u001a\u00020*2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u00103\u001a\u000204H\u0002J\u000e\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\nJ,\u00107\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u0001002\u0006\u00103\u001a\u000204J\u000f\u00108\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u00c6\u0003J\u000f\u00109\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015H\u00c6\u0003J\u000f\u0010:\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u00c6\u0003J\t\u0010;\u001a\u00020\nH\u00c6\u0003J\t\u0010<\u001a\u00020\fH\u00c6\u0003J\t\u0010=\u001a\u00020\nH\u00c6\u0003JW\u0010>\u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\nH\u00c6\u0001J\u0013\u0010?\u001a\u00020*2\b\u0010@\u001a\u0004\u0018\u00010AH\u00d6\u0003J\u0010\u0010B\u001a\u00020\n2\u0006\u00106\u001a\u00020\nH\u0002J\u001e\u0010C\u001a\u0004\u0018\u00010D2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100H\u0002J\u0018\u0010E\u001a\u00020*2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\t\u0010F\u001a\u00020GH\u00d6\u0001J\u0018\u0010H\u001a\u00020*2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u0006\u0010I\u001a\u00020*J\u0006\u0010J\u001a\u00020*J\u000e\u0010K\u001a\u00020*2\u0006\u00106\u001a\u00020\nJ\u0018\u0010L\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\b\u0010M\u001a\u0004\u0018\u00010NH\u0002J\u0012\u0010O\u001a\u00020P2\b\u0010M\u001a\u0004\u0018\u00010NH\u0016J\t\u0010Q\u001a\u00020\nH\u00d6\u0001J\u001c\u0010R\u001a\u00020*2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u000100H\u0002J\u0012\u0010S\u001a\u00020*2\b\u0010-\u001a\u0004\u0018\u00010.H\u0002J\u0012\u0010T\u001a\u00020P2\b\u0010M\u001a\u0004\u0018\u00010NH\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\r\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0018\"\u0004\b\u001c\u0010\u001aR \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001e\"\u0004\b(\u0010 \u00a8\u0006Z"}, d2={"Lcom/jetbrains/cidr/lang/settings/NamingConventionRule;", "Lcom/intellij/openapi/util/JDOMExternalizable;", "()V", "entityKind", "Lcom/jetbrains/cidr/lang/settings/NamingConventionRule$EntityKind;", "visibility", "Lcom/jetbrains/cidr/lang/settings/NamingConventionRule$Visibility;", "specifier", "Lcom/jetbrains/cidr/lang/settings/NamingConventionRule$Specifier;", "customPrefix", "", "namingConventionStyle", "Lcom/jetbrains/cidr/lang/settings/NamingConventionStyle;", "customSuffix", "(Lcom/jetbrains/cidr/lang/settings/NamingConventionRule$EntityKind;Lcom/jetbrains/cidr/lang/settings/NamingConventionRule$Visibility;Lcom/jetbrains/cidr/lang/settings/NamingConventionRule$Specifier;Ljava/lang/String;Lcom/jetbrains/cidr/lang/settings/NamingConventionStyle;Ljava/lang/String;)V", "otherRule", "(Lcom/jetbrains/cidr/lang/settings/NamingConventionRule;)V", "legacyNamingConvention", "Lcom/jetbrains/cidr/lang/settings/NamingConvention;", "(Lcom/jetbrains/cidr/lang/settings/NamingConventionRule$EntityKind;Lcom/jetbrains/cidr/lang/settings/NamingConvention;)V", "(Lcom/jetbrains/cidr/lang/settings/NamingConventionRule$EntityKind;Ljava/lang/String;Lcom/jetbrains/cidr/lang/settings/NamingConventionStyle;Ljava/lang/String;)V", "Ljava/util/EnumSet;", "(Ljava/util/EnumSet;Ljava/util/EnumSet;Ljava/util/EnumSet;Ljava/lang/String;Lcom/jetbrains/cidr/lang/settings/NamingConventionStyle;Ljava/lang/String;)V", "getCustomPrefix", "()Ljava/lang/String;", "setCustomPrefix", "(Ljava/lang/String;)V", "getCustomSuffix", "setCustomSuffix", "getEntityKind", "()Ljava/util/EnumSet;", "setEntityKind", "(Ljava/util/EnumSet;)V", "getNamingConventionStyle", "()Lcom/jetbrains/cidr/lang/settings/NamingConventionStyle;", "setNamingConventionStyle", "(Lcom/jetbrains/cidr/lang/settings/NamingConventionStyle;)V", "getSpecifier", "setSpecifier", "getVisibility", "setVisibility", "appliedToSameEntity", "", "symbolKind", "Lcom/jetbrains/cidr/lang/symbols/OCSymbolKind;", "symbol", "Lcom/jetbrains/cidr/lang/symbols/OCSymbol;", "context", "Lcom/jetbrains/cidr/lang/symbols/OCResolveContext;", "appliedToSameSpecifier", "appliedToSameVisibility", "project", "Lcom/intellij/openapi/project/Project;", "apply", "name", "canApply", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "", "getNameWithoutPrefixAndSuffix", "getResolvedOwner", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName;", "hasStructOwner", "hashCode", "", "isMemberFunction", "isSpecifierApplicable", "isVisibilityApplicable", "match", "readEntityKind", "element", "Lorg/jdom/Element;", "readExternal", "", "toString", "validateConstSpecifier", "validateStaticSpecifier", "writeExternal", "Companion", "EntityKind", "Specifier", "TextPresentableEnum", "Visibility", "intellij.c"})
@SourceDebugExtension(value={"SMAP\nNamingConventionRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamingConventionRule.kt\ncom/jetbrains/cidr/lang/settings/NamingConventionRule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,347:1\n1549#2:348\n1620#2,3:349\n1549#2:352\n1620#2,3:353\n1747#2,3:356\n1747#2,3:359\n*S KotlinDebug\n*F\n+ 1 NamingConventionRule.kt\ncom/jetbrains/cidr/lang/settings/NamingConventionRule\n*L\n51#1:348\n51#1:349,3\n53#1:352\n53#1:353,3\n93#1:356,3\n97#1:359,3\n*E\n"})
public final class NamingConventionRule
implements JDOMExternalizable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private EnumSet<EntityKind> entityKind;
    @NotNull
    private EnumSet<Visibility> visibility;
    @NotNull
    private EnumSet<Specifier> specifier;
    @NotNull
    private String customPrefix;
    @NotNull
    private NamingConventionStyle namingConventionStyle;
    @NotNull
    private String customSuffix;

    public NamingConventionRule(@NotNull EnumSet<EntityKind> entityKind, @NotNull EnumSet<Visibility> visibility, @NotNull EnumSet<Specifier> specifier, @NotNull String customPrefix, @NotNull NamingConventionStyle namingConventionStyle, @NotNull String customSuffix) {
        Intrinsics.checkNotNullParameter(entityKind, (String)"entityKind");
        Intrinsics.checkNotNullParameter(visibility, (String)"visibility");
        Intrinsics.checkNotNullParameter(specifier, (String)"specifier");
        Intrinsics.checkNotNullParameter((Object)customPrefix, (String)"customPrefix");
        Intrinsics.checkNotNullParameter((Object)namingConventionStyle, (String)"namingConventionStyle");
        Intrinsics.checkNotNullParameter((Object)customSuffix, (String)"customSuffix");
        this.entityKind = entityKind;
        this.visibility = visibility;
        this.specifier = specifier;
        this.customPrefix = customPrefix;
        this.namingConventionStyle = namingConventionStyle;
        this.customSuffix = customSuffix;
    }

    @NotNull
    public final EnumSet<EntityKind> getEntityKind() {
        return this.entityKind;
    }

    public final void setEntityKind(@NotNull EnumSet<EntityKind> enumSet) {
        Intrinsics.checkNotNullParameter(enumSet, (String)"<set-?>");
        this.entityKind = enumSet;
    }

    @NotNull
    public final EnumSet<Visibility> getVisibility() {
        return this.visibility;
    }

    public final void setVisibility(@NotNull EnumSet<Visibility> enumSet) {
        Intrinsics.checkNotNullParameter(enumSet, (String)"<set-?>");
        this.visibility = enumSet;
    }

    @NotNull
    public final EnumSet<Specifier> getSpecifier() {
        return this.specifier;
    }

    public final void setSpecifier(@NotNull EnumSet<Specifier> enumSet) {
        Intrinsics.checkNotNullParameter(enumSet, (String)"<set-?>");
        this.specifier = enumSet;
    }

    @NotNull
    public final String getCustomPrefix() {
        return this.customPrefix;
    }

    public final void setCustomPrefix(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.customPrefix = string;
    }

    @NotNull
    public final NamingConventionStyle getNamingConventionStyle() {
        return this.namingConventionStyle;
    }

    public final void setNamingConventionStyle(@NotNull NamingConventionStyle namingConventionStyle) {
        Intrinsics.checkNotNullParameter((Object)namingConventionStyle, (String)"<set-?>");
        this.namingConventionStyle = namingConventionStyle;
    }

    @NotNull
    public final String getCustomSuffix() {
        return this.customSuffix;
    }

    public final void setCustomSuffix(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.customSuffix = string;
    }

    public NamingConventionRule() {
        EnumSet<Enum> enumSet = EnumSet.of((Enum)EntityKind.ANY);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        EnumSet<Enum> enumSet2 = EnumSet.of((Enum)Visibility.ANY);
        Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"of(...)");
        EnumSet<Enum> enumSet3 = EnumSet.of((Enum)Specifier.ANY);
        Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"of(...)");
        this(enumSet, enumSet2, enumSet3, "", NamingConventionStyle.NONE, "");
    }

    public NamingConventionRule(@NotNull EntityKind entityKind, @NotNull Visibility visibility, @NotNull Specifier specifier, @NotNull String customPrefix, @NotNull NamingConventionStyle namingConventionStyle, @NotNull String customSuffix) {
        Intrinsics.checkNotNullParameter((Object)entityKind, (String)"entityKind");
        Intrinsics.checkNotNullParameter((Object)visibility, (String)"visibility");
        Intrinsics.checkNotNullParameter((Object)specifier, (String)"specifier");
        Intrinsics.checkNotNullParameter((Object)customPrefix, (String)"customPrefix");
        Intrinsics.checkNotNullParameter((Object)namingConventionStyle, (String)"namingConventionStyle");
        Intrinsics.checkNotNullParameter((Object)customSuffix, (String)"customSuffix");
        EnumSet<Enum> enumSet = EnumSet.of((Enum)entityKind);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        EnumSet<Enum> enumSet2 = EnumSet.of((Enum)visibility);
        Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"of(...)");
        EnumSet<Enum> enumSet3 = EnumSet.of((Enum)specifier);
        Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"of(...)");
        this(enumSet, enumSet2, enumSet3, customPrefix, namingConventionStyle, customSuffix);
    }

    public NamingConventionRule(@NotNull NamingConventionRule otherRule) {
        Intrinsics.checkNotNullParameter((Object)otherRule, (String)"otherRule");
        this(otherRule.entityKind, otherRule.visibility, otherRule.specifier, otherRule.customPrefix, otherRule.namingConventionStyle, otherRule.customSuffix);
    }

    public NamingConventionRule(@NotNull EntityKind entityKind, @NotNull NamingConvention legacyNamingConvention) {
        Intrinsics.checkNotNullParameter((Object)entityKind, (String)"entityKind");
        Intrinsics.checkNotNullParameter((Object)legacyNamingConvention, (String)"legacyNamingConvention");
        EnumSet<Enum> enumSet = EnumSet.of((Enum)entityKind);
        Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
        EnumSet<Enum> enumSet2 = EnumSet.of((Enum)Visibility.ANY);
        Intrinsics.checkNotNullExpressionValue(enumSet2, (String)"of(...)");
        EnumSet<Enum> enumSet3 = EnumSet.of((Enum)Specifier.ANY);
        Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"of(...)");
        this(enumSet, enumSet2, enumSet3, legacyNamingConvention.getCustomPrefix(), legacyNamingConvention.getNamingConventionStyle(), legacyNamingConvention.getCustomSuffix());
    }

    public NamingConventionRule(@NotNull EntityKind entityKind, @NotNull String customPrefix, @NotNull NamingConventionStyle namingConventionStyle, @NotNull String customSuffix) {
        Intrinsics.checkNotNullParameter((Object)entityKind, (String)"entityKind");
        Intrinsics.checkNotNullParameter((Object)customPrefix, (String)"customPrefix");
        Intrinsics.checkNotNullParameter((Object)namingConventionStyle, (String)"namingConventionStyle");
        Intrinsics.checkNotNullParameter((Object)customSuffix, (String)"customSuffix");
        this(entityKind, Visibility.ANY, Specifier.ANY, customPrefix, namingConventionStyle, customSuffix);
    }

    public void readExternal(@Nullable Element element) {
        String string;
        List list;
        EnumSet<Object> enumSet;
        List list2;
        String it;
        Collection collection;
        Object item$iv$iv;
        Iterator iterator2;
        Object $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        Object $this$map$iv;
        boolean $i$f$map;
        NamingConventionRule namingConventionRule;
        Object object;
        if (element == null) {
            return;
        }
        this.entityKind = this.readEntityKind(element);
        NamingConventionRule namingConventionRule2 = this;
        Object object2 = element.getAttributeValue("visibility");
        if (object2 != null && (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (String[])(object = new String[]{","}), (boolean)false, (int)0, (int)6, null)) != null) {
            object = (Iterable)object2;
            namingConventionRule = namingConventionRule2;
            $i$f$map = false;
            String[] stringArray = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                item$iv$iv = iterator2.next();
                String string2 = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Visibility.valueOf(it));
            }
            list2 = (List)destination$iv$iv;
            namingConventionRule2 = namingConventionRule;
        } else {
            list2 = null;
        }
        EnumSet enumSet2 = EnumSet.copyOf((Collection)list2);
        if (enumSet2 == null) {
            EnumSet<Enum> enumSet3 = EnumSet.of((Enum)Visibility.ANY);
            enumSet = enumSet3;
            Intrinsics.checkNotNullExpressionValue(enumSet3, (String)"of(...)");
        } else {
            enumSet = enumSet2;
        }
        namingConventionRule2.visibility = enumSet;
        NamingConventionRule namingConventionRule3 = this;
        Object object3 = element.getAttributeValue("specifier");
        if (object3 != null && (object3 = StringsKt.split$default((CharSequence)((CharSequence)object3), (String[])($this$map$iv = new String[]{","}), (boolean)false, (int)0, (int)6, null)) != null) {
            $this$map$iv = (Iterable)object3;
            namingConventionRule = namingConventionRule3;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                item$iv$iv = iterator2.next();
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Specifier.valueOf(it));
            }
            list = (List)destination$iv$iv;
            namingConventionRule3 = namingConventionRule;
        } else {
            list = null;
        }
        enumSet2 = EnumSet.copyOf((Collection)list);
        if (enumSet2 == null) {
            EnumSet<Enum> enumSet4 = EnumSet.of((Enum)Specifier.ANY);
            v9 = enumSet4;
            Intrinsics.checkNotNullExpressionValue(enumSet4, (String)"of(...)");
        } else {
            v9 = namingConventionRule3.specifier = enumSet2;
        }
        if ((string = element.getAttributeValue("prefix")) == null) {
            string = "";
        }
        this.customPrefix = string;
        this.namingConventionStyle = NamingConventionStyle.Companion.byName(element.getAttributeValue("style"));
        String string3 = element.getAttributeValue("suffix");
        if (string3 == null) {
            string3 = "";
        }
        this.customSuffix = string3;
    }

    public void writeExternal(@Nullable Element element) {
        if (element == null) {
            return;
        }
        Element ruleElement = new Element("rule");
        ruleElement.setAttribute("entity", CollectionsKt.joinToString$default((Iterable)this.entityKind, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        ruleElement.setAttribute("visibility", CollectionsKt.joinToString$default((Iterable)this.visibility, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        ruleElement.setAttribute("specifier", CollectionsKt.joinToString$default((Iterable)this.specifier, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        ruleElement.setAttribute("prefix", this.customPrefix);
        ruleElement.setAttribute("style", this.namingConventionStyle.name());
        ruleElement.setAttribute("suffix", this.customSuffix);
        element.addContent(ruleElement);
    }

    public final boolean canApply(@Nullable OCSymbolKind symbolKind, @Nullable OCSymbol symbol, @Nullable OCResolveContext context, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (symbolKind == null) {
            return false;
        }
        return this.appliedToSameEntity(symbolKind, symbol, context) && this.appliedToSameVisibility(symbol, project) && this.appliedToSameSpecifier(symbol, context);
    }

    @NotNull
    public final String apply(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.customPrefix + this.namingConventionStyle.apply(this.getNameWithoutPrefixAndSuffix(name)) + this.customSuffix;
    }

    public final boolean match(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return StringsKt.startsWith$default((String)name, (String)this.customPrefix, (boolean)false, (int)2, null) && this.namingConventionStyle.satisfies(this.getNameWithoutPrefixAndSuffix(name)) && StringsKt.endsWith$default((String)name, (String)this.customSuffix, (boolean)false, (int)2, null);
    }

    public final boolean isSpecifierApplicable() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.specifier;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Specifier it = (Specifier)element$iv;
                    boolean bl2 = false;
                    if (!it.isApplicableFor(this.entityKind)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isVisibilityApplicable() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.visibility;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Visibility it = (Visibility)element$iv;
                    boolean bl2 = false;
                    if (!it.isApplicableFor(this.entityKind)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String getNameWithoutPrefixAndSuffix(String name) {
        String nameWithoutPrefixAndSuffix = name;
        if (StringUtil.startsWith((CharSequence)name, (CharSequence)this.customPrefix)) {
            String string = nameWithoutPrefixAndSuffix.substring(this.customPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            nameWithoutPrefixAndSuffix = string;
        }
        if (StringsKt.endsWith$default((String)name, (String)this.customSuffix, (boolean)false, (int)2, null)) {
            String string = nameWithoutPrefixAndSuffix.substring(0, nameWithoutPrefixAndSuffix.length() - this.customSuffix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            nameWithoutPrefixAndSuffix = string;
        }
        return nameWithoutPrefixAndSuffix;
    }

    private final boolean appliedToSameEntity(OCSymbolKind symbolKind, OCSymbol symbol, OCResolveContext context) {
        if (this.entityKind.contains(EntityKind.ANY)) {
            OCSymbolKind[] oCSymbolKindArray = new OCSymbolKind[]{OCSymbolKind.NAMESPACE, OCSymbolKind.MACRO, OCSymbolKind.STRUCT, OCSymbolKind.ENUM, OCSymbolKind.UNION, OCSymbolKind.TYPEDEF, OCSymbolKind.USING_SYMBOL_ALIAS, OCSymbolKind.FUNCTION_DECLARATION, OCSymbolKind.FUNCTION_PREDECLARATION, OCSymbolKind.GLOBAL_VARIABLE, OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION, OCSymbolKind.STRUCT_FIELD, OCSymbolKind.ENUM_CONST, OCSymbolKind.PARAMETER, OCSymbolKind.LOCAL_VARIABLE};
            return EnumSet.of((Enum)OCSymbolKind.NAMESPACE_ALIAS, (Enum[])oCSymbolKindArray).contains((Object)symbolKind);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[symbolKind.ordinal()]) {
            case 1: 
            case 2: {
                return this.entityKind.contains(EntityKind.NAMESPACE);
            }
            case 3: {
                return this.entityKind.contains(EntityKind.MACRO);
            }
            case 4: {
                if (symbol != null && symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).isStruct()) {
                    return this.entityKind.contains(EntityKind.STRUCT);
                }
                return this.entityKind.contains(EntityKind.CLASS);
            }
            case 5: {
                return this.entityKind.contains(EntityKind.ENUM);
            }
            case 6: {
                return this.entityKind.contains(EntityKind.UNION);
            }
            case 7: 
            case 8: {
                return this.entityKind.contains(EntityKind.TYPEDEF);
            }
            case 9: 
            case 10: {
                if (symbol != null && context != null && (this.isMemberFunction(symbol, context) || this.hasStructOwner(symbol, context))) {
                    OCSymbolWithQualifiedName oCSymbolWithQualifiedName = this.getResolvedOwner(symbol, context);
                    Intrinsics.checkNotNull((Object)oCSymbolWithQualifiedName, (String)"null cannot be cast to non-null type com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol");
                    OCStructSymbol structSymbol = (OCStructSymbol)oCSymbolWithQualifiedName;
                    if (structSymbol.isStruct()) {
                        return this.entityKind.contains(EntityKind.STRUCT_MEMBER_FUNCTION);
                    }
                    return this.entityKind.contains(EntityKind.CLASS_MEMBER_FUNCTION);
                }
                return this.entityKind.contains(EntityKind.GLOBAL_FUNCTION);
            }
            case 11: 
            case 12: {
                OCSymbolWithQualifiedName structSymbol = this.getResolvedOwner(symbol, context);
                if (structSymbol instanceof OCStructSymbol) {
                    return ((OCStructSymbol)structSymbol).isStruct() ? this.entityKind.contains(EntityKind.STRUCT_MEMBER_FIELD) : this.entityKind.contains(EntityKind.CLASS_MEMBER_FIELD);
                }
                return this.entityKind.contains(EntityKind.GLOBAL_VARIABLE);
            }
            case 13: {
                OCSymbolWithQualifiedName structSymbol = this.getResolvedOwner(symbol, context);
                if (structSymbol instanceof OCStructSymbol && ((OCStructSymbol)structSymbol).isStruct()) {
                    return this.entityKind.contains(EntityKind.STRUCT_MEMBER_FIELD);
                }
                return this.entityKind.contains(EntityKind.CLASS_MEMBER_FIELD);
            }
            case 14: {
                return this.entityKind.contains(EntityKind.ENUMERATOR);
            }
            case 15: {
                return this.entityKind.contains(EntityKind.PARAMETER);
            }
            case 16: {
                return this.entityKind.contains(EntityKind.LOCAL_VARIABLE);
            }
        }
        return false;
    }

    private final boolean appliedToSameVisibility(OCSymbol symbol, Project project) {
        if (this.visibility.isEmpty() || this.visibility.contains(Visibility.ANY)) {
            return true;
        }
        OCVisibility oCVisibility = OCVisibility.getDeclaredVisibility(symbol, project);
        switch (oCVisibility == null ? -1 : WhenMappings.$EnumSwitchMapping$1[oCVisibility.ordinal()]) {
            case 1: {
                return this.visibility.contains(Visibility.PUBLIC);
            }
            case 2: {
                return this.visibility.contains(Visibility.PROTECTED);
            }
            case 3: {
                return this.visibility.contains(Visibility.PRIVATE);
            }
        }
        return false;
    }

    private final boolean appliedToSameSpecifier(OCSymbol symbol, OCResolveContext context) {
        if (this.specifier.isEmpty() || this.specifier.contains(Specifier.ANY)) {
            return true;
        }
        boolean canApply = true;
        if (this.specifier.contains(Specifier.CONST)) {
            boolean bl = canApply = this.validateConstSpecifier(symbol, context);
        }
        if (this.specifier.contains(Specifier.STATIC)) {
            canApply = canApply && this.validateStaticSpecifier(symbol);
        }
        return canApply;
    }

    private final boolean validateConstSpecifier(OCSymbol symbol, OCResolveContext context) {
        if (symbol instanceof OCDeclaratorSymbol) {
            if (context != null) {
                OCType oCType = ((OCDeclaratorSymbol)symbol).getResolvedType(context);
                Intrinsics.checkNotNullExpressionValue((Object)oCType, (String)"getResolvedType(...)");
                OCType type = oCType;
                if (type instanceof OCCppReferenceType && ((OCCppReferenceType)type).getRefType().isConst()) {
                    return true;
                }
                if (type instanceof OCArrayType && ((OCArrayType)type).getArrayElementType().isConst()) {
                    return true;
                }
            }
            return ((OCDeclaratorSymbol)symbol).isConst();
        }
        if (symbol instanceof OCFunctionSymbol) {
            return ((OCFunctionSymbol)symbol).isConst();
        }
        return false;
    }

    private final boolean validateStaticSpecifier(OCSymbol symbol) {
        if (symbol instanceof OCDeclaratorSymbol) {
            return ((OCDeclaratorSymbol)symbol).isStatic();
        }
        if (symbol instanceof OCFunctionSymbol) {
            return ((OCFunctionSymbol)symbol).isStatic();
        }
        return false;
    }

    private final boolean isMemberFunction(OCSymbol symbol, OCResolveContext context) {
        return symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isMember(context, true);
    }

    private final boolean hasStructOwner(OCSymbol symbol, OCResolveContext context) {
        return this.getResolvedOwner(symbol, context) instanceof OCStructSymbol;
    }

    private final OCSymbolWithQualifiedName getResolvedOwner(OCSymbol symbol, OCResolveContext context) {
        if (symbol != null && symbol instanceof OCSymbolWithQualifiedName && context != null) {
            return ((OCSymbolWithQualifiedName)symbol).getResolvedOwner(context);
        }
        return null;
    }

    private final EnumSet<EntityKind> readEntityKind(Element element) {
        String attributeValue;
        EnumSet<EntityKind> result = EnumSet.noneOf(EntityKind.class);
        Element element2 = element;
        String string = attributeValue = element2 != null ? element2.getAttributeValue("entity") : null;
        if (attributeValue == null) {
            EnumSet<Enum> enumSet = EnumSet.of((Enum)EntityKind.ANY);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
            return enumSet;
        }
        String[] stringArray = new String[]{","};
        for (String entity : StringsKt.split$default((CharSequence)attributeValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
            String string2 = entity;
            if (Intrinsics.areEqual((Object)string2, (Object)"MEMBER_FUNCTION")) {
                result.add(EntityKind.CLASS_MEMBER_FUNCTION);
                result.add(EntityKind.STRUCT_MEMBER_FUNCTION);
                continue;
            }
            if (Intrinsics.areEqual((Object)string2, (Object)"MEMBER_FIELD")) {
                result.add(EntityKind.CLASS_MEMBER_FIELD);
                result.add(EntityKind.STRUCT_MEMBER_FIELD);
                continue;
            }
            result.add(EntityKind.valueOf(entity));
        }
        Intrinsics.checkNotNull(result);
        return result;
    }

    @NotNull
    public final EnumSet<EntityKind> component1() {
        return this.entityKind;
    }

    @NotNull
    public final EnumSet<Visibility> component2() {
        return this.visibility;
    }

    @NotNull
    public final EnumSet<Specifier> component3() {
        return this.specifier;
    }

    @NotNull
    public final String component4() {
        return this.customPrefix;
    }

    @NotNull
    public final NamingConventionStyle component5() {
        return this.namingConventionStyle;
    }

    @NotNull
    public final String component6() {
        return this.customSuffix;
    }

    @NotNull
    public final NamingConventionRule copy(@NotNull EnumSet<EntityKind> entityKind, @NotNull EnumSet<Visibility> visibility, @NotNull EnumSet<Specifier> specifier, @NotNull String customPrefix, @NotNull NamingConventionStyle namingConventionStyle, @NotNull String customSuffix) {
        Intrinsics.checkNotNullParameter(entityKind, (String)"entityKind");
        Intrinsics.checkNotNullParameter(visibility, (String)"visibility");
        Intrinsics.checkNotNullParameter(specifier, (String)"specifier");
        Intrinsics.checkNotNullParameter((Object)customPrefix, (String)"customPrefix");
        Intrinsics.checkNotNullParameter((Object)namingConventionStyle, (String)"namingConventionStyle");
        Intrinsics.checkNotNullParameter((Object)customSuffix, (String)"customSuffix");
        return new NamingConventionRule(entityKind, visibility, specifier, customPrefix, namingConventionStyle, customSuffix);
    }

    public static /* synthetic */ NamingConventionRule copy$default(NamingConventionRule namingConventionRule, EnumSet enumSet, EnumSet enumSet2, EnumSet enumSet3, String string, NamingConventionStyle namingConventionStyle, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            enumSet = namingConventionRule.entityKind;
        }
        if ((n & 2) != 0) {
            enumSet2 = namingConventionRule.visibility;
        }
        if ((n & 4) != 0) {
            enumSet3 = namingConventionRule.specifier;
        }
        if ((n & 8) != 0) {
            string = namingConventionRule.customPrefix;
        }
        if ((n & 0x10) != 0) {
            namingConventionStyle = namingConventionRule.namingConventionStyle;
        }
        if ((n & 0x20) != 0) {
            string2 = namingConventionRule.customSuffix;
        }
        return namingConventionRule.copy(enumSet, enumSet2, enumSet3, string, namingConventionStyle, string2);
    }

    @NotNull
    public String toString() {
        return "NamingConventionRule(entityKind=" + this.entityKind + ", visibility=" + this.visibility + ", specifier=" + this.specifier + ", customPrefix=" + this.customPrefix + ", namingConventionStyle=" + this.namingConventionStyle + ", customSuffix=" + this.customSuffix + ")";
    }

    public int hashCode() {
        int result = this.entityKind.hashCode();
        result = result * 31 + this.visibility.hashCode();
        result = result * 31 + this.specifier.hashCode();
        result = result * 31 + this.customPrefix.hashCode();
        result = result * 31 + this.namingConventionStyle.hashCode();
        result = result * 31 + this.customSuffix.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NamingConventionRule)) {
            return false;
        }
        NamingConventionRule namingConventionRule = (NamingConventionRule)other;
        if (!Intrinsics.areEqual(this.entityKind, namingConventionRule.entityKind)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.visibility, namingConventionRule.visibility)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.specifier, namingConventionRule.specifier)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.customPrefix, (Object)namingConventionRule.customPrefix)) {
            return false;
        }
        if (this.namingConventionStyle != namingConventionRule.namingConventionStyle) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.customSuffix, (Object)namingConventionRule.customSuffix);
    }

    @JvmStatic
    public static final void writeExternalList(@Nullable Element element, @NotNull List<NamingConventionRule> rules, @NotNull List<NamingConventionRule> defaultRules) {
        Companion.writeExternalList(element, rules, defaultRules);
    }

    @JvmStatic
    @NotNull
    public static final List<NamingConventionRule> readExternalList(@Nullable Element element, @NotNull List<NamingConventionRule> defaultRules) {
        return Companion.readExternalList(element, defaultRules);
    }

    @JvmStatic
    @NotNull
    public static final List<NamingConventionRule> copyRules(@NotNull List<NamingConventionRule> rules) {
        return Companion.copyRules(rules);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007J.\u0010\u000b\u001a\u00020\f2\b\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/lang/settings/NamingConventionRule$Companion;", "", "()V", "copyRules", "", "Lcom/jetbrains/cidr/lang/settings/NamingConventionRule;", "rules", "readExternalList", "element", "Lorg/jdom/Element;", "defaultRules", "writeExternalList", "", "intellij.c"})
    @SourceDebugExtension(value={"SMAP\nNamingConventionRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NamingConventionRule.kt\ncom/jetbrains/cidr/lang/settings/NamingConventionRule$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,347:1\n1549#2:348\n1620#2,3:349\n*S KotlinDebug\n*F\n+ 1 NamingConventionRule.kt\ncom/jetbrains/cidr/lang/settings/NamingConventionRule$Companion\n*L\n275#1:348\n275#1:349,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void writeExternalList(@Nullable Element element, @NotNull List<NamingConventionRule> rules, @NotNull List<NamingConventionRule> defaultRules) {
            Intrinsics.checkNotNullParameter(rules, (String)"rules");
            Intrinsics.checkNotNullParameter(defaultRules, (String)"defaultRules");
            if (element == null || Intrinsics.areEqual(rules, defaultRules)) {
                return;
            }
            Element childElement = new Element("rules");
            for (NamingConventionRule rule : rules) {
                rule.writeExternal(childElement);
            }
            if (!childElement.getContent().isEmpty()) {
                element.addContent(childElement);
            }
        }

        @JvmStatic
        @NotNull
        public final List<NamingConventionRule> readExternalList(@Nullable Element element, @NotNull List<NamingConventionRule> defaultRules) {
            Intrinsics.checkNotNullParameter(defaultRules, (String)"defaultRules");
            if (element == null) {
                return defaultRules;
            }
            Element rulesElement = element.getChild("rules");
            if (rulesElement == null) {
                return defaultRules;
            }
            ArrayList<NamingConventionRule> rules = new ArrayList<NamingConventionRule>();
            for (Element ruleElement : rulesElement.getChildren("rule")) {
                NamingConventionRule rule = new NamingConventionRule();
                rule.readExternal(ruleElement);
                rules.add(rule);
            }
            return !rules.isEmpty() ? (List)rules : defaultRules;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<NamingConventionRule> copyRules(@NotNull List<NamingConventionRule> rules) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(rules, (String)"rules");
            Iterable $this$map$iv = rules;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                NamingConventionRule namingConventionRule = (NamingConventionRule)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(NamingConventionRule.copy$default((NamingConventionRule)it, null, null, null, null, null, null, 63, null));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0016\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0011\b\u0002\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/lang/settings/NamingConventionRule$EntityKind;", "", "Lcom/jetbrains/cidr/lang/settings/NamingConventionRule$TextPresentableEnum;", "presentableName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getPresentableName", "()Ljava/lang/String;", "toPresentableText", "ANY", "NAMESPACE", "MACRO", "CLASS", "STRUCT", "ENUM", "UNION", "TYPEDEF", "GLOBAL_FUNCTION", "GLOBAL_VARIABLE", "CLASS_MEMBER_FUNCTION", "STRUCT_MEMBER_FUNCTION", "CLASS_MEMBER_FIELD", "STRUCT_MEMBER_FIELD", "ENUMERATOR", "PARAMETER", "LOCAL_VARIABLE", "intellij.c"})
    public static final class EntityKind
    extends Enum<EntityKind>
    implements TextPresentableEnum<EntityKind> {
        @NotNull
        private final String presentableName;
        public static final /* enum */ EntityKind ANY;
        public static final /* enum */ EntityKind NAMESPACE;
        public static final /* enum */ EntityKind MACRO;
        public static final /* enum */ EntityKind CLASS;
        public static final /* enum */ EntityKind STRUCT;
        public static final /* enum */ EntityKind ENUM;
        public static final /* enum */ EntityKind UNION;
        public static final /* enum */ EntityKind TYPEDEF;
        public static final /* enum */ EntityKind GLOBAL_FUNCTION;
        public static final /* enum */ EntityKind GLOBAL_VARIABLE;
        public static final /* enum */ EntityKind CLASS_MEMBER_FUNCTION;
        public static final /* enum */ EntityKind STRUCT_MEMBER_FUNCTION;
        public static final /* enum */ EntityKind CLASS_MEMBER_FIELD;
        public static final /* enum */ EntityKind STRUCT_MEMBER_FIELD;
        public static final /* enum */ EntityKind ENUMERATOR;
        public static final /* enum */ EntityKind PARAMETER;
        public static final /* enum */ EntityKind LOCAL_VARIABLE;
        private static final /* synthetic */ EntityKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private EntityKind(String presentableName) {
            this.presentableName = presentableName;
        }

        @NotNull
        public final String getPresentableName() {
            return this.presentableName;
        }

        @Override
        @NotNull
        public String toPresentableText() {
            return this.presentableName;
        }

        public static EntityKind[] values() {
            return (EntityKind[])$VALUES.clone();
        }

        public static EntityKind valueOf(String value) {
            return Enum.valueOf(EntityKind.class, value);
        }

        @NotNull
        public static EnumEntries<EntityKind> getEntries() {
            return $ENTRIES;
        }

        static {
            String string = OCBundle.message("naming.convention.entity.any", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ANY = new EntityKind(string);
            String string2 = OCBundle.message("naming.convention.entity.namespace", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            NAMESPACE = new EntityKind(string2);
            String string3 = OCBundle.message("naming.convention.entity.macro", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            MACRO = new EntityKind(string3);
            String string4 = OCBundle.message("naming.convention.entity.class", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            CLASS = new EntityKind(string4);
            String string5 = OCBundle.message("naming.convention.entity.struct", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
            STRUCT = new EntityKind(string5);
            String string6 = OCBundle.message("naming.convention.entity.enumeration", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
            ENUM = new EntityKind(string6);
            String string7 = OCBundle.message("naming.convention.entity.union", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
            UNION = new EntityKind(string7);
            String string8 = OCBundle.message("naming.convention.entity.typedef", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(...)");
            TYPEDEF = new EntityKind(string8);
            String string9 = OCBundle.message("naming.convention.entity.global.function", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"message(...)");
            GLOBAL_FUNCTION = new EntityKind(string9);
            String string10 = OCBundle.message("naming.convention.entity.global.variable", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"message(...)");
            GLOBAL_VARIABLE = new EntityKind(string10);
            String string11 = OCBundle.message("naming.convention.entity.class.member.function", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"message(...)");
            CLASS_MEMBER_FUNCTION = new EntityKind(string11);
            String string12 = OCBundle.message("naming.convention.entity.struct.member.function", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"message(...)");
            STRUCT_MEMBER_FUNCTION = new EntityKind(string12);
            String string13 = OCBundle.message("naming.convention.entity.class.member.field", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"message(...)");
            CLASS_MEMBER_FIELD = new EntityKind(string13);
            String string14 = OCBundle.message("naming.convention.entity.struct.member.field", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"message(...)");
            STRUCT_MEMBER_FIELD = new EntityKind(string14);
            String string15 = OCBundle.message("naming.convention.entity.enumerator", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"message(...)");
            ENUMERATOR = new EntityKind(string15);
            String string16 = OCBundle.message("naming.convention.entity.parameter", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"message(...)");
            PARAMETER = new EntityKind(string16);
            String string17 = OCBundle.message("naming.convention.entity.local.variable", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string17, (String)"message(...)");
            LOCAL_VARIABLE = new EntityKind(string17);
            $VALUES = entityKindArray = new EntityKind[]{EntityKind.ANY, EntityKind.NAMESPACE, EntityKind.MACRO, EntityKind.CLASS, EntityKind.STRUCT, EntityKind.ENUM, EntityKind.UNION, EntityKind.TYPEDEF, EntityKind.GLOBAL_FUNCTION, EntityKind.GLOBAL_VARIABLE, EntityKind.CLASS_MEMBER_FUNCTION, EntityKind.STRUCT_MEMBER_FUNCTION, EntityKind.CLASS_MEMBER_FIELD, EntityKind.STRUCT_MEMBER_FIELD, EntityKind.ENUMERATOR, EntityKind.PARAMETER, EntityKind.LOCAL_VARIABLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0011\b\u0002\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\b\u0010\r\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/lang/settings/NamingConventionRule$Specifier;", "", "Lcom/jetbrains/cidr/lang/settings/NamingConventionRule$TextPresentableEnum;", "presentableName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getPresentableName", "()Ljava/lang/String;", "isApplicableFor", "", "entityKind", "Ljava/util/EnumSet;", "Lcom/jetbrains/cidr/lang/settings/NamingConventionRule$EntityKind;", "toPresentableText", "ANY", "CONST", "STATIC", "intellij.c"})
    public static final class Specifier
    extends Enum<Specifier>
    implements TextPresentableEnum<Specifier> {
        @NotNull
        private final String presentableName;
        public static final /* enum */ Specifier ANY;
        public static final /* enum */ Specifier CONST;
        public static final /* enum */ Specifier STATIC;
        private static final /* synthetic */ Specifier[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Specifier(String presentableName) {
            this.presentableName = presentableName;
        }

        @NotNull
        public final String getPresentableName() {
            return this.presentableName;
        }

        public final boolean isApplicableFor(@NotNull EnumSet<EntityKind> entityKind) {
            Intrinsics.checkNotNullParameter(entityKind, (String)"entityKind");
            return entityKind.contains(EntityKind.ANY) || entityKind.contains(EntityKind.GLOBAL_VARIABLE) || entityKind.contains(EntityKind.CLASS_MEMBER_FUNCTION) || entityKind.contains(EntityKind.STRUCT_MEMBER_FUNCTION) || entityKind.contains(EntityKind.CLASS_MEMBER_FIELD) || entityKind.contains(EntityKind.STRUCT_MEMBER_FIELD) || entityKind.contains(EntityKind.PARAMETER) || entityKind.contains(EntityKind.LOCAL_VARIABLE);
        }

        @Override
        @NotNull
        public String toPresentableText() {
            return this.presentableName;
        }

        public static Specifier[] values() {
            return (Specifier[])$VALUES.clone();
        }

        public static Specifier valueOf(String value) {
            return Enum.valueOf(Specifier.class, value);
        }

        @NotNull
        public static EnumEntries<Specifier> getEntries() {
            return $ENTRIES;
        }

        static {
            String string = OCBundle.message("naming.convention.entity.any", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ANY = new Specifier(string);
            CONST = new Specifier("Const");
            STATIC = new Specifier("Static");
            $VALUES = specifierArray = new Specifier[]{Specifier.ANY, Specifier.CONST, Specifier.STATIC};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\b\u0010\u0003\u001a\u00020\u0004H'\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0005\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/cidr/lang/settings/NamingConventionRule$TextPresentableEnum;", "T", "", "toPresentableText", "", "intellij.c"})
    public static interface TextPresentableEnum<T> {
        @NlsContexts.Label
        @NotNull
        public String toPresentableText();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0011\b\u0002\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\b\u0010\r\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/lang/settings/NamingConventionRule$Visibility;", "", "Lcom/jetbrains/cidr/lang/settings/NamingConventionRule$TextPresentableEnum;", "presentableName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getPresentableName", "()Ljava/lang/String;", "isApplicableFor", "", "entityKind", "Ljava/util/EnumSet;", "Lcom/jetbrains/cidr/lang/settings/NamingConventionRule$EntityKind;", "toPresentableText", "ANY", "PUBLIC", "PROTECTED", "PRIVATE", "intellij.c"})
    public static final class Visibility
    extends Enum<Visibility>
    implements TextPresentableEnum<Visibility> {
        @NotNull
        private final String presentableName;
        public static final /* enum */ Visibility ANY;
        public static final /* enum */ Visibility PUBLIC;
        public static final /* enum */ Visibility PROTECTED;
        public static final /* enum */ Visibility PRIVATE;
        private static final /* synthetic */ Visibility[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Visibility(String presentableName) {
            this.presentableName = presentableName;
        }

        @NotNull
        public final String getPresentableName() {
            return this.presentableName;
        }

        public final boolean isApplicableFor(@NotNull EnumSet<EntityKind> entityKind) {
            Intrinsics.checkNotNullParameter(entityKind, (String)"entityKind");
            return entityKind.contains(EntityKind.ANY) || entityKind.contains(EntityKind.CLASS_MEMBER_FIELD) || entityKind.contains(EntityKind.STRUCT_MEMBER_FIELD) || entityKind.contains(EntityKind.CLASS_MEMBER_FUNCTION) || entityKind.contains(EntityKind.STRUCT_MEMBER_FUNCTION);
        }

        @Override
        @NotNull
        public String toPresentableText() {
            return this.presentableName;
        }

        public static Visibility[] values() {
            return (Visibility[])$VALUES.clone();
        }

        public static Visibility valueOf(String value) {
            return Enum.valueOf(Visibility.class, value);
        }

        @NotNull
        public static EnumEntries<Visibility> getEntries() {
            return $ENTRIES;
        }

        static {
            String string = OCBundle.message("naming.convention.entity.any", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            ANY = new Visibility(string);
            PUBLIC = new Visibility("Public");
            PROTECTED = new Visibility("Protected");
            PRIVATE = new Visibility("Private");
            $VALUES = visibilityArray = new Visibility[]{Visibility.ANY, Visibility.PUBLIC, Visibility.PROTECTED, Visibility.PRIVATE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[OCSymbolKind.values().length];
            try {
                nArray[OCSymbolKind.NAMESPACE_ALIAS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCSymbolKind.NAMESPACE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCSymbolKind.MACRO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCSymbolKind.STRUCT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCSymbolKind.ENUM.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCSymbolKind.UNION.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCSymbolKind.TYPEDEF.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCSymbolKind.USING_SYMBOL_ALIAS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCSymbolKind.FUNCTION_DECLARATION.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCSymbolKind.FUNCTION_PREDECLARATION.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCSymbolKind.GLOBAL_VARIABLE.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCSymbolKind.GLOBAL_VARIABLE_PREDECLARATION.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCSymbolKind.STRUCT_FIELD.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCSymbolKind.ENUM_CONST.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCSymbolKind.PARAMETER.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCSymbolKind.LOCAL_VARIABLE.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OCVisibility.values().length];
            try {
                nArray[OCVisibility.PUBLIC.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCVisibility.PROTECTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OCVisibility.PRIVATE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

