/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.util.EditorHelper;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardDetector;
import com.jetbrains.cidr.lang.preprocessor.OCHeaderGuardInfo;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCExternalReference;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCQualifiedDesignator;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.OCUsageViewDescriptor;
import com.jetbrains.cidr.lang.refactoring.move.OCDependentMembersCollector;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfoStorage;
import com.jetbrains.cidr.lang.refactoring.move.OCTargetClass;
import com.jetbrains.cidr.lang.refactoring.move.OCTopLevelTarget;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCElementsMover;
import com.jetbrains.cidr.lang.refactoring.util.OCEscalateVisibilityHelper;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.search.OCMethodReferencesSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCMoveProcessor<C extends PsiElement, S extends OCSymbol, T extends OCTargetClass<C, S>>
extends BaseRefactoringProcessor {
    protected SmartPsiElementPointer<C> mySourceClass;
    protected S mySourceClassSymbol;
    protected List<T> myTargetClasses;
    protected String myTargetClassName;
    protected List<OCMemberInfo> mySelectedMemberInfos;
    protected List<Member> myMembers;
    @NotNull
    protected OCFile mySourceFile;
    private final Set<VirtualFile> myAllFiles = new HashSet<VirtualFile>();
    private final Set<VirtualFile> mySourceFiles = new HashSet<VirtualFile>();
    protected Set<VirtualFile> myTargetFiles = new HashSet<VirtualFile>();
    protected OCElementsMover myMover = new OCElementsMover(false);
    protected MultiMap<PsiElement, String> myConflicts;
    protected Boolean myProcessStructMembers;
    private boolean myImportsHandlingSkipped;
    private final boolean mySmartDefinitionsMode;

    protected OCMoveProcessor(C sourceClass, List<OCMemberInfo> selectedMemberInfos, @Nullable String targetClassName, Boolean processStructMembers, boolean smartDefinitionsMode) {
        super(sourceClass.getProject());
        this.mySourceClass = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(sourceClass);
        this.mySourceClassSymbol = sourceClass instanceof OCSymbolDeclarator ? ((OCSymbolDeclarator)sourceClass).getSymbol() : null;
        this.mySelectedMemberInfos = selectedMemberInfos;
        this.myTargetClasses = new ArrayList<T>();
        this.myTargetClassName = targetClassName;
        this.myProcessStructMembers = processStructMembers;
        this.mySmartDefinitionsMode = smartDefinitionsMode;
        assert (sourceClass instanceof OCFile || this.mySourceClassSymbol != null);
        this.mySourceFile = (OCFile)sourceClass.getContainingFile();
        this.mySourceFiles.add(this.mySourceFile.getVirtualFile());
        for (Member member : this.locateMembers()) {
            PsiElement element = member.getElement();
            if (element == null) continue;
            this.mySourceFiles.add(element.getContainingFile().getVirtualFile());
        }
    }

    public OCMoveProcessor(C sourceClass, List<OCMemberInfo> selectedMemberInfos, @Nullable String targetClassName, Collection<S> targetSymbols, boolean smartDefinitionsMode) {
        this(sourceClass, selectedMemberInfos, targetClassName, (Boolean)null, smartDefinitionsMode);
        for (OCSymbol targetSymbol : targetSymbols) {
            OCFile targetFile = targetSymbol.getContainingOCFile(this.myProject);
            if (targetFile == null) continue;
            this.addTarget(targetFile, targetSymbol instanceof OCClassSymbol ? targetSymbol.getPresentableName() : targetSymbol.getName(), null, targetSymbol, smartDefinitionsMode);
        }
    }

    protected void addTarget(OCFile targetFile, String targetName, PsiElement targetContext, @Nullable S targetSymbol, boolean smartDefinitionsMode) {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        files.add(targetFile.getVirtualFile());
        OCFile associatedFile = targetFile.getAssociatedFile();
        if (associatedFile != null) {
            files.add(associatedFile.getVirtualFile());
        }
        this.myTargetClasses.add(this.createTargetClass(this.mySourceFile, targetFile, targetName, targetContext, files, targetSymbol, this.mySourceClassSymbol, this.myProject, smartDefinitionsMode));
        this.myTargetFiles.addAll(files);
    }

    protected abstract T createTargetClass(OCFile var1, OCFile var2, String var3, PsiElement var4, Set<VirtualFile> var5, @Nullable S var6, S var7, Project var8, boolean var9);

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        PsiElement sourceClass;
        if (usages == null) {
            OCMoveProcessor.$$$reportNull$$$0(0);
        }
        return new OCUsageViewDescriptor((PsiElement)((sourceClass = this.mySourceClass.getElement()) != null ? sourceClass : this.mySourceFile), this.getCommandName());
    }

    protected UsageInfo @NotNull [] findUsages() {
        Set usages = ConcurrentCollectionFactory.createConcurrentSet();
        List<Member> members = this.locateMembers();
        Set symbols = ContainerUtil.map2Set(members, m -> m.getSymbol());
        for (Member member : members) {
            PsiElement definition;
            OCSymbol symbol = member.getSymbol();
            if (member.isInnerClassMember() || symbol instanceof OCClassSymbol || symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).getParent() != this.mySourceClassSymbol || (definition = symbol.locateDefinition(this.myProject)) == null) continue;
            Processor processor2 = reference -> {
                PsiElement element = reference.getElement();
                if (this.mySourceFiles.contains(element.getContainingFile().getVirtualFile()) && !(reference instanceof OCExternalReference) && !(element instanceof OCQualifiedDesignator)) {
                    for (Member member1 : members) {
                        PsiElement memberElement = member1.getElement();
                        if (member1.getSymbol() instanceof OCFunctionSymbol) {
                            memberElement = Objects.requireNonNull(memberElement).getParent();
                        }
                        if (!PsiTreeUtil.isAncestor((PsiElement)memberElement, (PsiElement)element, (boolean)true)) continue;
                        return true;
                    }
                }
                usages.add(new MoveUsage((PsiReference)reference, symbol));
                return true;
            };
            if (symbol instanceof OCMethodSymbol) {
                ReferencesSearch.SearchParameters parameters = new ReferencesSearch.SearchParameters(definition, (SearchScope)OCSearchScope.getProjectSourcesScope(this.myProject), false);
                new OCMethodReferencesSearch().execute(parameters, (Processor<? super PsiReference>)processor2);
            } else {
                ReferencesSearch.search((PsiElement)definition).forEach(processor2);
            }
            if (symbol instanceof OCStructSymbol) {
                ((OCStructSymbol)symbol).processConstructors((Processor<? super OCFunctionSymbol>)((Processor)ctor -> {
                    PsiElement ctorDefinition = ctor.locateDefinition(this.myProject);
                    if (ctorDefinition != null) {
                        ReferencesSearch.search((PsiElement)ctorDefinition).forEach(processor2);
                    }
                    return true;
                }));
            }
            symbol.processSameSymbols((Processor<OCSymbol>)((Processor)symbol1 -> {
                PsiReference reference;
                OCCppNamespaceQualifier qualifier;
                PsiElement definition1 = symbol1.locateDefinition(this.myProject);
                if (definition1 instanceof OCDeclarator && (qualifier = ((OCDeclarator)definition1).getNamespaceQualifier()) != null && (reference = qualifier.getReference()) != null && reference.isReferenceTo(Objects.requireNonNull(this.mySourceClass.getElement()))) {
                    usages.add(new QualifierRebindUsage(reference, (OCSymbol)symbol1, symbols.contains(symbol1)));
                }
                return true;
            }), this.myProject);
        }
        UsageInfo[] usageInfoArray = usages.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            OCMoveProcessor.$$$reportNull$$$0(1);
        }
        return usageInfoArray;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        Object psi;
        if (usages == null) {
            OCMoveProcessor.$$$reportNull$$$0(2);
        }
        SmartPsiElementPointer sourceFilePointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)this.mySourceFile);
        if (!this.createNewClass()) {
            return;
        }
        this.getAllFiles(usages);
        this.locateTargetClasses(false);
        if (this.myTargetClasses.size() == 1 && (psi = ((OCTargetClass)this.myTargetClasses.get(0)).getPsi()) != null) {
            EditorHelper.openInEditor(psi);
        }
        Runnable r = () -> {
            List<Member> members = this.locateMembers();
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
            for (Member member : members) {
                PsiElement element = member.getElement();
                if (element == null) continue;
                elements.add(member.getSymbol() instanceof OCFunctionSymbol ? element.getParent() : element);
            }
            for (UsageInfo usage : usages) {
                if (!(usage instanceof QualifierRebindUsage) || !((QualifierRebindUsage)usage).isMoved()) continue;
                OCBindUtil.encodeAsRefToParent(Objects.requireNonNull(usage.getElement()).getParent());
            }
            OCFile restoredSourceFile = (OCFile)sourceFilePointer.getElement();
            if (restoredSourceFile != null) {
                this.addImports(restoredSourceFile);
            }
            OCBindUtil.encodeContextInfo(elements, this.mySourceClassSymbol, false, false);
            this.locateTargetClasses(true);
            this.addSuperClasses();
            MultiMap memberToNewElements = new MultiMap();
            MultiMap targetToNewElements = new MultiMap();
            HashMap<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility = new HashMap<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>>();
            for (Member member : members) {
                OCSymbol symbol = member.getSymbol();
                PsiElement element = member.getElement();
                if (element != null && !element.isValid()) continue;
                if (element instanceof OCStructLike) {
                    element = PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclaration.class);
                }
                if (element instanceof OCDeclarator) {
                    element = OCNormalizeUtil.normalizeDeclarator((OCDeclarator)element);
                }
                if (element instanceof OCSynthesizeProperty) {
                    element = OCNormalizeUtil.normalizeSynthesizeStatement((OCSynthesizeProperty)element);
                }
                block3: for (OCTargetClass targetClass : this.myTargetClasses) {
                    OCSymbolDeclarator newMember;
                    ASTNode elemNode;
                    ASTNode targetNode;
                    OCMemberInfoStorage memberStorage = targetClass.getMemberStorage();
                    boolean wasAbstract = false;
                    for (OCMemberInfo info : Objects.requireNonNull(memberStorage).getClassMemberInfos((PsiElement)targetClass.getPsi())) {
                        if (!memberStorage.memberConflict((OCSymbolHolderVirtualPsiElement)info.getMember(), (OCSymbolHolderVirtualPsiElement)member.getMemberInfo().getMember())) continue;
                        PsiElement existingPsi = targetClass.getMemberElement(info);
                        if (member.getMemberInfo().isAbstract()) {
                            if (symbol == null || !(existingPsi instanceof OCSymbolDeclarator)) continue block3;
                            memberToNewElements.putValue((Object)symbol, (Object)((OCSymbolDeclarator)existingPsi));
                            continue block3;
                        }
                        if (!info.isAbstract()) continue;
                        OCChangeUtil.delete(existingPsi);
                        wasAbstract = true;
                        break;
                    }
                    if ((targetNode = targetClass.getPsi().getNode()).getFirstChildNode().getElementType().equals(OCLexerTokenTypes.EXPORT_MODULE_KEYWORD) && element != null && (elemNode = element.getNode()).getFirstChildNode().getElementType().equals(OCLexerTokenTypes.EXPORT_MODULE_KEYWORD)) {
                        ASTNode elemNodeCopy = elemNode.copyElement();
                        elemNodeCopy.removeChild(elemNodeCopy.getFirstChildNode());
                        OCChangeUtil.delete(element);
                        element = elemNodeCopy.getPsi(OCDeclaration.class);
                    }
                    if ((newMember = targetClass.addMember(element, symbol, member.getVisibility())) == null) continue;
                    if (wasAbstract) {
                        OCMoveProcessor.removeOverrideFinalSpecifiers(newMember);
                    }
                    memberToNewElements.putValue((Object)symbol, (Object)newMember);
                    targetToNewElements.putValue((Object)targetClass, newMember instanceof OCDeclarator ? newMember.getParent() : newMember);
                }
                if (element != null && !memberToNewElements.containsKey((Object)symbol)) continue;
                this.removeMember(element, symbol);
            }
            this.locateTargetClasses(true);
            for (OCTargetClass targetClass : this.myTargetClasses) {
                for (PsiElement element : targetToNewElements.get((Object)targetClass)) {
                    OCBindUtil.decodeContextInfo(element, targetClass.getSymbol(), elemsToEscalateVisibility);
                }
            }
            this.bindExternalUsages(usages, (MultiMap<OCSymbol, OCSymbolDeclarator>)memberToNewElements, elemsToEscalateVisibility);
            OCEscalateVisibilityHelper.ALL_ELEMENTS_TO_ESCALATE_VISIBILITY.set((UserDataHolder)this.myProject, elemsToEscalateVisibility);
            this.addMissingImports(targetToNewElements);
        };
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        if (dumbService.isDumb()) {
            dumbService.smartInvokeLater(() -> WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)this.getCommandName(), null, (Runnable)r, (PsiFile[])new PsiFile[0]));
        } else {
            r.run();
        }
    }

    private static void removeOverrideFinalSpecifiers(@NotNull OCSymbolDeclarator newMember) {
        PsiElement psiElement;
        if (newMember == null) {
            OCMoveProcessor.$$$reportNull$$$0(3);
        }
        if (!((psiElement = newMember.getParent()) instanceof OCFunctionDeclaration)) {
            return;
        }
        OCFunctionDeclaration functionDecl = (OCFunctionDeclaration)psiElement;
        PsiElement overrideOrFinal = functionDecl.getOverrideOrFinalSpecifier();
        while (overrideOrFinal != null) {
            OCChangeUtil.delete(overrideOrFinal);
            overrideOrFinal = functionDecl.getOverrideOrFinalSpecifier();
        }
    }

    protected abstract void removeMember(@Nullable PsiElement var1, OCSymbol var2);

    protected void locateTargetClasses(boolean underWriteAction) {
        for (OCTargetClass targetClass : this.myTargetClasses) {
            targetClass.locateTargetClass(underWriteAction);
        }
    }

    protected void performPsiSpoilingRefactoring() {
        OCBindUtil.escalateVisibilities(this.myProject, this.myAllFiles.toArray(VirtualFile.EMPTY_ARRAY));
    }

    protected void addMissingImports(MultiMap<T, PsiElement> newElements) {
        for (PsiElement newElement : newElements.values()) {
            OCImportSymbolFix.fixAllSymbolsRecursively(newElement);
        }
    }

    private void bindExternalUsages(UsageInfo[] usages, MultiMap<OCSymbol, OCSymbolDeclarator> newElementsMap, Map<SmartPsiElementPointer, Pair<OCSymbol, OCVisibility>> elemsToEscalateVisibility) {
        for (UsageInfo usage : usages) {
            OCSymbol associatedSymbol;
            if (!(usage instanceof MoveUsage)) continue;
            OCSymbol formerSymbol = ((MoveUsage)usage).getFormerSymbol();
            Collection newElements = newElementsMap.get((Object)formerSymbol);
            OCSymbolDeclarator newElement = newElements.size() == 1 ? (OCSymbolDeclarator)newElements.iterator().next() : null;
            OCSymbol symbol = newElement != null ? (OCSymbol)newElement.getSymbol() : null;
            Object targetSymbol = ((OCTargetClass)this.myTargetClasses.get(0)).getSymbol();
            if (usage instanceof QualifierRebindUsage) {
                if (!((QualifierRebindUsage)usage).isMoved()) {
                    symbol = (OCSymbol)targetSymbol;
                    newElement = null;
                }
            } else if (symbol != null && formerSymbol.isDefinition() && (associatedSymbol = symbol.getAssociatedSymbol(this.myProject)) != null && associatedSymbol.isPredeclaration()) {
                symbol = associatedSymbol;
                newElement = (OCSymbolDeclarator)associatedSymbol.locateDefinition(this.myProject);
            }
            boolean bindQualifier = symbol instanceof OCSymbolWithParent && ((OCSymbolWithParent)symbol).getParent() == targetSymbol;
            OCBindUtil.bindReferenceAndMakeVisible(usage.getReference(), symbol, newElement, elemsToEscalateVisibility, bindQualifier, this.myProject);
        }
    }

    protected void addSuperClasses() {
    }

    public OCFile[] getCreatedFiles() {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>(this.myTargetFiles);
        files.removeAll(this.mySourceFiles);
        return ContainerUtil.map(files, file -> (OCFile)PsiManager.getInstance((Project)this.myProject).findFile(file)).toArray(new OCFile[files.size()]);
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        if (descriptor == null) {
            OCMoveProcessor.$$$reportNull$$$0(4);
        }
        HashSet<Object> files = new HashSet<Object>();
        files.add(this.mySourceFile);
        for (VirtualFile file : this.myTargetFiles) {
            PsiFile psiFile2 = PsiManager.getInstance((Project)this.myProject).findFile(file);
            if (psiFile2 == null) continue;
            files.add(psiFile2);
        }
        for (Member member : this.locateMembers()) {
            PsiElement element = member.getElement();
            if (element == null) continue;
            files.add(element);
        }
        HashSet<Object> hashSet = files;
        if (hashSet == null) {
            OCMoveProcessor.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private List<Member> locateMembers() {
        if (this.myMembers != null) {
            return this.myMembers;
        }
        ArrayList<Member> members = new ArrayList<Member>();
        for (OCMemberInfo info : this.mySelectedMemberInfos) {
            OCSymbol member = info.getSymbol();
            if (!this.mySmartDefinitionsMode) {
                members.add(new Member(member, member.locateDefinition(this.myProject), info));
                continue;
            }
            if (this.mySourceClassSymbol instanceof OCClassSymbol && member instanceof OCProtocolSymbol) {
                members.add(new Member(member, null, info));
                continue;
            }
            if (this.mySourceClassSymbol instanceof OCStructSymbol && member instanceof OCStructSymbol && ((OCStructSymbol)member).getParent() != this.mySourceClassSymbol) {
                members.add(new Member(member, null, info));
                continue;
            }
            members.addAll(this.getAssociatedSymbols(info, member));
        }
        this.myMembers = members;
        return members;
    }

    protected List<Member> getAssociatedSymbols(OCMemberInfo info, OCSymbol member) {
        HashSet<Member> members = new HashSet<Member>();
        if (this.mySmartDefinitionsMode) {
            VirtualFile sourceVirtualFile = this.mySourceFile.getVirtualFile();
            OCFile associatedFile = this.mySourceFile.getAssociatedFile();
            VirtualFile associatedVirtualFile = associatedFile != null ? associatedFile.getVirtualFile() : null;
            member.processSameSymbols((Processor<OCSymbol>)((Processor)symbol -> {
                if (symbol instanceof OCSymbolWithParent && ((OCSymbolWithParent)symbol).getParent() instanceof OCStructSymbol && !Objects.requireNonNull(((OCSymbolWithParent)symbol).getParent()).equals(this.mySourceClassSymbol)) {
                    return true;
                }
                if (symbol instanceof OCClassSymbol && !((OCClassSymbol)symbol).isSameCategory(member)) {
                    return true;
                }
                if (symbol.isDefinition() || sourceVirtualFile != null && sourceVirtualFile.equals(symbol.getContainingFile()) || associatedVirtualFile != null && associatedVirtualFile.equals(symbol.getContainingFile())) {
                    this.addAssociatedMember((Collection<Member>)members, (OCSymbol)symbol, info);
                }
                return true;
            }), this.myProject);
        } else {
            this.addAssociatedMember(members, member, info);
        }
        if (member instanceof OCStructSymbol) {
            ((OCStructSymbol)member).processMembers((String)null, (Processor<? super OCSymbol>)((Processor)symbol -> {
                List<Member> innerMembers = this.getAssociatedSymbols(info, (OCSymbol)symbol);
                if (!innerMembers.isEmpty()) {
                    if (this.myProcessStructMembers == null) {
                        String message = OCBundle.message("dialog.message.do.you.want.to.move.class.member.definitions", new Object[0]);
                        this.myProcessStructMembers = ApplicationManager.getApplication().isUnitTestMode() || Messages.showYesNoDialog((Project)this.myProject, (String)message, (String)this.getCommandName(), (Icon)Messages.getQuestionIcon()) == 0;
                    }
                    if (this.myProcessStructMembers.booleanValue()) {
                        for (Member inner : innerMembers) {
                            inner.setInnerClassMember(true);
                            members.add(inner);
                        }
                    }
                }
                return true;
            }));
        }
        ArrayList<Member> list = new ArrayList<Member>(members);
        list.sort(Comparator.comparingLong(m -> m.getSymbol().getComplexOffset()));
        return list;
    }

    protected void addAssociatedMember(Collection<Member> members, OCSymbol symbol, OCMemberInfo info) {
        PsiElement element;
        PsiElement psiElement = element = symbol != null ? symbol.locateDefinition(this.myProject) : null;
        if (element != null && !symbol.isSynthetic()) {
            members.add(new Member(symbol, element, info));
        }
    }

    private boolean createNewClass() {
        PsiFile[] createdElements;
        OCNewFileActionBase action = this.getNewClassAction();
        if (action == null || !this.myTargetClasses.isEmpty()) {
            return true;
        }
        OCFile sampleFile = this.mySourceFile;
        if (sampleFile.isHeader()) {
            OCFile associatedFile = sampleFile.getAssociatedFile();
            OCFile oCFile = sampleFile = associatedFile != null ? associatedFile : sampleFile;
        }
        if ((createdElements = action.performActionWithoutDialog(this.myTargetClassName, (PsiFile)sampleFile, true)) == null) {
            return false;
        }
        this.myTargetFiles = new HashSet<VirtualFile>();
        OCFile mainTargetFile = null;
        for (PsiFile file : createdElements) {
            VirtualFile virtualFile = file.getVirtualFile();
            this.myTargetFiles.add(virtualFile);
            if (!(file instanceof OCFile) || !((OCFile)file).isHeader()) continue;
            mainTargetFile = (OCFile)file;
        }
        this.myTargetClasses.add(this.createTargetClass(this.mySourceFile, mainTargetFile, this.myTargetClassName, null, new HashSet<VirtualFile>(this.myTargetFiles), null, this.mySourceClassSymbol, this.myProject, true));
        return true;
    }

    @Nullable
    protected OCNewFileActionBase getNewClassAction() {
        return null;
    }

    private boolean processFilesWithProgress(final Collection<VirtualFile> files, final FileProcessor processor2, @NlsContexts.DialogTitle String title, boolean skippable) {
        if (this.myImportsHandlingSkipped) {
            return false;
        }
        final Ref finished = Ref.create((Object)false);
        Task.Modal task2 = new Task.Modal(this.myProject, title, skippable){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                int fileCount = files.size();
                int curFile = 0;
                for (VirtualFile file : files) {
                    indicator.setText2(file.getPresentableUrl());
                    indicator.setFraction((double)curFile++ / (double)fileCount);
                    PsiFile psiFile2 = PsiManager.getInstance((Project)this.myProject).findFile(file);
                    if (!(psiFile2 instanceof OCFile)) continue;
                    processor2.process(file, (OCFile)psiFile2);
                }
                finished.set((Object)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor$1", "run"));
            }
        };
        if (skippable) {
            task2.setCancelText(OCBundle.message("move.processor.skip", new Object[0]));
            task2.setCancelTooltipText(OCBundle.message("move.processor.skip", new Object[0]));
        }
        ProgressManager.getInstance().run((Task)task2);
        if (skippable && !((Boolean)finished.get()).booleanValue()) {
            this.myImportsHandlingSkipped = true;
        }
        return (Boolean)finished.get();
    }

    private void addImports(@NotNull OCFile sourceFile) {
        if (sourceFile == null) {
            OCMoveProcessor.$$$reportNull$$$0(6);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        MultiMap targetFileToUsages = new MultiMap();
        MultiMap targetFileToSourceFiles = MultiMap.createSet();
        MultiMap targetFileToImports = new MultiMap();
        for (Member member : this.locateMembers()) {
            for (OCTargetClass targetClass : this.myTargetClasses) {
                PsiElement element = member.getElement();
                if (element != null) {
                    VirtualFile targetFile = targetClass.getTargetFile(element, member.getSymbol());
                    if (targetFile == null) continue;
                    targetFileToUsages.putValue((Object)targetFile, (Object)element);
                    targetFileToSourceFiles.putValue((Object)targetFile, (Object)((OCFile)element.getContainingFile()));
                    continue;
                }
                Object targetPsi = targetClass.getPsi();
                if (targetPsi == null) continue;
                VirtualFile targetFile = targetPsi.getContainingFile().getVirtualFile();
                targetFileToUsages.putValue((Object)targetFile, (Object)new OCSymbolHolderVirtualPsiElement(member.getSymbol(), this.myProject));
                targetFileToSourceFiles.putValue((Object)targetFile, (Object)sourceFile);
            }
        }
        List<OCIncludeDirective> importTarget = Collections.emptyList();
        for (VirtualFile virtualFile2 : this.myTargetFiles) {
            if (!OCFileTypeHelpers.isHeaderFile((String)virtualFile2.getName())) continue;
            String importStr = (this.mySourceClassSymbol instanceof OCClassSymbol ? "#import \"" : "#include \"") + virtualFile2.getName() + "\"";
            importTarget = Collections.singletonList((OCIncludeDirective)OCElementFactory.topLevelDeclarationFromText(importStr, sourceFile));
        }
        if (this.importTargetFromSource()) {
            this.addImports(sourceFile, importTarget, -1);
        } else {
            for (VirtualFile virtualFile3 : this.mySourceFiles) {
                OCFile curSourceFile = (OCFile)psiManager.findFile(virtualFile3);
                if (curSourceFile == null || curSourceFile.isHeader()) continue;
                this.addImports(curSourceFile, importTarget, -1);
            }
        }
        this.processFilesWithProgress(targetFileToUsages.keySet(), (virtualFile, psiFile2) -> {
            for (OCFile curSourceFile : targetFileToSourceFiles.get((Object)virtualFile)) {
                targetFileToImports.putValues((Object)psiFile2, OCMoveProcessor.getFileImports(curSourceFile));
            }
        }, OCBundle.message("dialog.title.move.refactoring.adding.imports", new Object[0]), false);
        if (this.importSourceFromTarget()) {
            String string = (this.mySourceClassSymbol instanceof OCClassSymbol ? "#import \"" : "#include \"") + sourceFile.getName() + "\"";
            List<OCIncludeDirective> list = Collections.singletonList((OCIncludeDirective)OCElementFactory.topLevelDeclarationFromText(string, sourceFile));
            for (VirtualFile file : this.myTargetFiles) {
                OCFile psiFile3 = (OCFile)PsiManager.getInstance((Project)this.myProject).findFile(file);
                if (psiFile3 == null || !psiFile3.isHeader()) continue;
                this.addImports(psiFile3, list, -1);
            }
        } else {
            for (OCFile oCFile : targetFileToImports.keySet()) {
                this.addImports(oCFile, (List)targetFileToImports.get((Object)oCFile), OCMoveProcessor.getImportInsertOffset(oCFile));
            }
        }
        for (VirtualFile virtualFile4 : this.myAllFiles) {
            PsiFile psiFile4;
            if (this.mySourceFiles.contains(virtualFile4) || this.myTargetFiles.contains(virtualFile4) || !((psiFile4 = psiManager.findFile(virtualFile4)) instanceof OCFile)) continue;
            this.addImports((OCFile)psiFile4, importTarget, -1);
        }
    }

    private static int getImportInsertOffset(@NotNull OCFile file) {
        if (file == null) {
            OCMoveProcessor.$$$reportNull$$$0(7);
        }
        if (file.isHeader()) {
            PsiElement nextSiblingElement;
            OCHeaderGuardInfo headerGuardInfo = OCHeaderGuardDetector.findCachedHeaderGuard(file, false);
            OCDefineDirective defineDirective = headerGuardInfo != null ? headerGuardInfo.getDefineDirective() : null;
            PsiElement psiElement = nextSiblingElement = defineDirective != null ? OCElementUtil.getNextNonWhitespaceSibling(defineDirective) : null;
            if (nextSiblingElement != null) {
                return nextSiblingElement.getTextOffset();
            }
        } else {
            List<OCIncludeDirective> existing = file.findIncludeDirectives();
            if (existing != null && !existing.isEmpty()) {
                return existing.get(0).getTextOffset();
            }
        }
        return -1;
    }

    protected boolean importTargetFromSource() {
        return false;
    }

    protected boolean importSourceFromTarget() {
        return false;
    }

    public static List<OCIncludeDirective> getFileImports(OCFile file) {
        ArrayList<OCIncludeDirective> result = new ArrayList<OCIncludeDirective>();
        for (OCIncludeDirective directive : file.findIncludeDirectives()) {
            if (!OCCodeInsightUtil.isValid(directive) || !directive.isTopLevel() || !directive.getContainingFile().equals(file)) continue;
            result.add(directive);
        }
        return result;
    }

    private void addImports(@NotNull OCFile file, List<OCIncludeDirective> originalImports, int beforeOffset) {
        if (file == null) {
            OCMoveProcessor.$$$reportNull$$$0(8);
        }
        ArrayList<PsiElement> imports = new ArrayList<PsiElement>();
        HashSet<String> addedImports = new HashSet<String>();
        for (OCIncludeDirective directive : file.findIncludeDirectives()) {
            addedImports.add(directive.getReferenceText());
        }
        for (OCIncludeDirective directive : originalImports) {
            String directiveText = directive.getReferenceText();
            if (!(addedImports.contains(directiveText) || OCMoveProcessor.importsFile(directiveText, file.getName()) || file.isHeader() && this.myTargetFiles.contains(file.getVirtualFile()) && OCMoveProcessor.importsFile(directiveText, this.mySourceFile.getName()) && !this.importSourceFromTarget())) {
                imports.add(OCImportSymbolFix.addImportToFile(file, directive.getText(), OCImportSymbolFix.ImportStyle.INCLUDE, beforeOffset));
            }
            addedImports.add(directiveText);
        }
        OCChangeUtil.processPostponedFormatIfNeed(file);
        CodeStyleManager.getInstance((Project)file.getProject()).reformatText((PsiFile)file, (Collection)ContainerUtil.map(imports, element -> element.getTextRange()));
    }

    private static boolean importsFile(String directiveText, String fileName) {
        if (directiveText.endsWith(fileName)) {
            if (directiveText.length() == fileName.length()) {
                return true;
            }
            return !Character.isJavaIdentifierPart(directiveText.charAt(directiveText.length() - fileName.length()));
        }
        return false;
    }

    private void getAllFiles(UsageInfo[] usages) {
        for (UsageInfo usage : usages) {
            this.myAllFiles.add(Objects.requireNonNull(usage.getFile()).getVirtualFile());
        }
        this.myAllFiles.addAll(this.mySourceFiles);
        this.myAllFiles.addAll(this.myTargetFiles);
    }

    public void setConflicts(MultiMap<PsiElement, String> conflicts) {
        this.myConflicts = conflicts;
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            OCMoveProcessor.$$$reportNull$$$0(9);
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        HashSet<OCMemberInfo> conflictingMembers = new HashSet<OCMemberInfo>();
        block0: for (OCTargetClass targetClass : this.myTargetClasses) {
            Object target;
            if (!(targetClass instanceof OCTopLevelTarget) || !((OCTopLevelTarget)(target = (OCTopLevelTarget)targetClass)).isWrapNamespaceMode()) continue;
            PsiNamedElement parent = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)((OCTopLevelTarget)target).getTargetContext(), (Class[])new Class[]{OCCppNamespace.class, PsiFile.class});
            Set selectedSymbols = OCTypeUtils.newSymbolWithSubstitutionSet();
            for (OCMemberInfo oCMemberInfo : this.mySelectedMemberInfos) {
                selectedSymbols.add(oCMemberInfo.getSymbol());
            }
            if (parent == null) continue;
            OCMemberInfoStorage storage = new OCMemberInfoStorage((PsiElement)parent, this.mySmartDefinitionsMode, false, true);
            for (OCMemberInfo info : storage.getClassMemberInfos((PsiElement)parent)) {
                Object conflictSymbol;
                PsiElement conflictElement;
                if (selectedSymbols.contains(info.getSymbol())) continue;
                String targetName = OCQualifiedName.parse(((OCTopLevelTarget)target).getNamespaceName()).getLeftmostQualifier();
                OCNamespaceSymbol wrappedNamespace = new OCNamespaceSymbol(parent.getContainingFile().getVirtualFile(), 0L, 0L, null, OCQualifiedName.with(targetName), Collections.emptyList(), null, null, null, false, false, false);
                if (!storage.memberConflict((OCSymbolHolderVirtualPsiElement)info.getMember(), new OCSymbolHolderVirtualPsiElement(wrappedNamespace, this.myProject)) || (conflictElement = (conflictSymbol = ((OCSymbolHolderVirtualPsiElement)info.getMember()).getSymbol()).locateDefinition(this.myProject)) == null) continue;
                String parentName = (parent instanceof OCFile ? "file \"" : "namespace \"") + parent.getName() + "\"";
                this.myConflicts.putValue((Object)conflictElement, (Object)(info.getDisplayNameWithKind(OCCompilationContext.create(conflictElement)) + " is already defined in the " + parentName));
                continue block0;
            }
        }
        for (OCMemberInfo memberInfo : this.mySelectedMemberInfos) {
            if (memberInfo.isAbstract()) continue;
            block4: for (OCTargetClass targetClass : this.myTargetClasses) {
                OCMemberInfoStorage memberStorage = targetClass.getMemberStorage();
                if (memberStorage == null || targetClass.getPsi() == null) continue;
                for (OCMemberInfo oCMemberInfo : memberStorage.getClassMemberInfos((PsiElement)targetClass.getPsi())) {
                    Object conflictSymbol;
                    PsiElement conflictElement;
                    if (oCMemberInfo.isAbstract() || !memberStorage.memberConflict((OCSymbolHolderVirtualPsiElement)oCMemberInfo.getMember(), (OCSymbolHolderVirtualPsiElement)memberInfo.getMember()) || (conflictElement = (conflictSymbol = ((OCSymbolHolderVirtualPsiElement)oCMemberInfo.getMember()).getSymbol()).locateDefinition(this.myProject)) == null) continue;
                    this.myConflicts.putValue((Object)conflictElement, (Object)(oCMemberInfo.getDisplayNameWithKind(OCCompilationContext.create(conflictElement)) + " is already defined in the " + targetClass.getDisplayName()));
                    conflictingMembers.add(memberInfo);
                    continue block4;
                }
            }
            if (ContainerUtil.exists(this.myTargetFiles, f -> Comparing.equal((Object)this.mySourceFile.getVirtualFile(), (Object)f))) continue;
            OCDependentMembersCollector collector = new OCDependentMembersCollector(this.mySourceClass.getElement(), null);
            collector.collect((OCSymbolHolderVirtualPsiElement)memberInfo.getMember());
            for (OCSymbol dependency : collector.getDependenciesFromSameFile()) {
                PsiElement element = dependency.locateDefinition(this.myProject);
                VirtualFile virtualFile = dependency.getContainingFile();
                if (virtualFile == null || element == null || OCFileTypeHelpers.isHeaderFile((String)virtualFile.getName())) continue;
                this.myConflicts.putValue((Object)element, (Object)(dependency.getNameWithKindUppercase(OCCompilationContext.create(element)) + " will be inaccessible in the moved code"));
            }
        }
        HashSet<OCSymbol> symbols = new HashSet<OCSymbol>();
        for (UsageInfo usage : usages) {
            OCSymbol symbol = ((MoveUsage)usage).getFormerSymbol();
            OCCompilationContext oCCompilationContext = OCCompilationContext.create(symbol, this.myProject);
            if (usage.getElement() instanceof OCQualifiedDesignator) {
                if (!symbols.add(symbol)) continue;
                this.myConflicts.putValue((Object)usage.getElement(), (Object)("Qualified designators for the " + symbol.getNameWithKindLowercase(oCCompilationContext) + " will become unresolved"));
                continue;
            }
            if (usage.getReference() instanceof OCExternalReference) {
                if (!symbols.add(symbol)) continue;
                String componentName = ((OCExternalReference)usage.getReference()).getExternalComponentName();
                this.myConflicts.putValue((Object)usage.getElement(), (Object)(componentName + " references for the " + symbol.getNameWithKindLowercase(oCCompilationContext) + " may become unresolved"));
                continue;
            }
            if (this.myTargetClasses.size() <= 1 || usage instanceof QualifierRebindUsage && ((QualifierRebindUsage)usage).isMoved() || !symbols.add(symbol)) continue;
            this.myConflicts.putValue((Object)usage.getElement(), (Object)("Some references to the " + symbol.getNameWithKindLowercase(oCCompilationContext) + " will become unresolved"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (this.removeConflictingMembers()) {
                this.mySelectedMemberInfos.removeAll(conflictingMembers);
                this.myMembers = null;
            }
            this.prepareSuccessful();
            return true;
        }
        return this.showConflicts(this.myConflicts, usages);
    }

    protected boolean removeConflictingMembers() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMember";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeOverrideFinalSpecifiers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addImports";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getImportInsertOffset";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }

    protected static class Member {
        private final OCSymbol mySymbol;
        private final SmartPsiElementPointer<PsiElement> myPointer;
        private final OCMemberInfo myMemberInfo;
        private boolean isInnerClassMember;

        public Member(OCSymbol symbol, @Nullable PsiElement element, OCMemberInfo memberInfo) {
            this.mySymbol = symbol;
            this.myPointer = element != null ? SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer(element) : null;
            this.myMemberInfo = memberInfo;
        }

        public OCSymbol getSymbol() {
            return this.mySymbol;
        }

        @Nullable
        public PsiElement getElement() {
            return this.myPointer != null ? this.myPointer.getElement() : null;
        }

        public OCMemberInfo getMemberInfo() {
            return this.myMemberInfo;
        }

        @Nullable
        public OCVisibility getVisibility() {
            return this.myMemberInfo.getVisibility();
        }

        public boolean isInnerClassMember() {
            return this.isInnerClassMember;
        }

        public void setInnerClassMember(boolean innerClassMember) {
            this.isInnerClassMember = innerClassMember;
        }
    }

    private static class MoveUsage
    extends UsageInfo {
        private final OCSymbol myFormerSymbol;

        MoveUsage(@NotNull PsiReference reference, OCSymbol symbol) {
            if (reference == null) {
                MoveUsage.$$$reportNull$$$0(0);
            }
            super(reference);
            this.myFormerSymbol = symbol;
        }

        public OCSymbol getFormerSymbol() {
            return this.myFormerSymbol;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor$MoveUsage", "<init>"));
        }
    }

    private static class QualifierRebindUsage
    extends MoveUsage {
        private final boolean myMoved;

        QualifierRebindUsage(@NotNull PsiReference qualifier, OCSymbol symbol, boolean isMoved) {
            if (qualifier == null) {
                QualifierRebindUsage.$$$reportNull$$$0(0);
            }
            super(qualifier, symbol);
            this.myMoved = isMoved;
        }

        public boolean isMoved() {
            return this.myMoved;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/jetbrains/cidr/lang/refactoring/move/OCMoveProcessor$QualifierRebindUsage", "<init>"));
        }
    }

    @FunctionalInterface
    private static interface FileProcessor {
        public void process(@NotNull VirtualFile var1, @NotNull OCFile var2);
    }
}

