/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.move;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.refactoring.move.OCCppTargetClass;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfo;
import com.jetbrains.cidr.lang.refactoring.move.OCMoveProcessor;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public abstract class OCMoveCppProcessor
extends OCMoveProcessor<OCStruct, OCStructSymbol, OCCppTargetClass> {
    public OCMoveCppProcessor(OCStruct sourceClass, List<OCMemberInfo> selectedMemberInfos, @Nullable String targetClassName, Collection<OCStructSymbol> targetSymbols) {
        super(sourceClass, selectedMemberInfos, targetClassName, targetSymbols, true);
    }

    @Override
    protected OCCppTargetClass createTargetClass(OCFile sourceFile, OCFile mainTargetFile, String targetClassName, PsiElement targetContext, Set<VirtualFile> files, OCStructSymbol targetSymbol, OCStructSymbol sourceSymbol, Project project, boolean smartDefinitionsMode) {
        return new OCCppTargetClass(targetClassName, files, targetSymbol, sourceSymbol, project);
    }

    @Override
    protected void removeMember(PsiElement element, OCSymbol symbol) {
        if (symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).getParent() != this.mySourceClassSymbol) {
            OCStruct sourceClass = (OCStruct)this.mySourceClass.getElement();
            if (sourceClass != null) {
                this.myMover.removeBaseClass(sourceClass, (OCStructSymbol)symbol, true);
            }
        } else {
            OCChangeUtil.delete(element);
        }
    }
}

