/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.actions.newFile.OCNewClassAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewCppClassAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewProtocolAction;
import com.jetbrains.cidr.lang.formatting.OCFormattingModelBuilder;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.quickfixes.OCCreateDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCHighPriorityCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureActionHandler;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureDialog;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCChangeSignatureHandler;
import com.jetbrains.cidr.lang.refactoring.introduce.OCBaseIntroduceHandler;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIntroduceIvarAction;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIntroducePropertyAction;
import com.jetbrains.cidr.lang.refactoring.introduce.OCIntroduceVariableAction;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScopeService;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCreateNewDefinitionIntentionAction
extends OCCreateDefinitionIntentionAction {
    private final String myName;
    private OCType myType;
    private OCObjectType myReceiverType;
    private final OCPropertySymbol myPropertySymbol;
    private OCExpectedTypeUtil.Expectable myExpectableType;
    private final boolean myIsStaticMember;
    private final boolean myAddConst;
    private final boolean myAddConstexpr;
    private final boolean myAddNoexcept;
    private boolean mySilentMode;
    private String myMessageSignature;

    @Nullable
    public static IntentionAction getCreateNewDefinitionFix(OCSymbolContext context, PsiElement psiElement, String name) {
        if (context.getSymbolKind() == OCSymbolKind.METHOD && psiElement instanceof OCQualifiedExpression) {
            boolean isSetter = new OCReadWriteAccessDetector().getExpressionAccess(psiElement) == ReadWriteAccessDetector.Access.Write;
            OCObjectTypeContext receiverContext = ((OCQualifiedExpression)psiElement).getQualifier().getTypeContext();
            OCType expectedType = context.getExpectedType();
            if (receiverContext == null || expectedType == null) {
                return null;
            }
            expectedType = expectedType.resolve(psiElement);
            OCType returnType = isSetter ? OCVoidType.instance() : expectedType;
            String methodName = isSetter ? OCNameSuggester.getObjCSetterFromGetter(name) : name;
            String staticToken = receiverContext.getStaticMode() == OCObjectTypeContext.StaticMode.STATIC ? "+" : "-";
            StringBuilder signature2 = new StringBuilder();
            signature2.append(staticToken).append('(').append(returnType.getName(psiElement)).append(')').append(methodName);
            if (isSetter) {
                signature2.append('(').append(expectedType.getName(psiElement)).append(')').append(name);
            }
            return new OCCreateNewDefinitionIntentionAction(psiElement, context.getParent(), staticToken + methodName, signature2.toString(), returnType, receiverContext.getType());
        }
        if (OCHighPriorityCreateNewDefinitionIntentionAction.isHighPrioritySymbolKind(context.getSymbolKind())) {
            return new OCHighPriorityCreateNewDefinitionIntentionAction(context, psiElement, name);
        }
        return new OCCreateNewDefinitionIntentionAction(context, psiElement, name);
    }

    public OCCreateNewDefinitionIntentionAction(OCSymbolKind symbolKind, @NotNull PsiElement usage, @Nullable OCPropertySymbol propertySymbol, OCSymbol parent, String name, OCType type, boolean staticMember, boolean addConstexpr, boolean addConst, boolean addNoexcept) {
        if (usage == null) {
            OCCreateNewDefinitionIntentionAction.$$$reportNull$$$0(0);
        }
        super(symbolKind, usage, parent);
        this.mySilentMode = ApplicationManager.getApplication().isUnitTestMode();
        this.myName = name;
        this.myType = type;
        this.myPropertySymbol = propertySymbol;
        this.myIsStaticMember = staticMember;
        this.myAddConstexpr = addConstexpr;
        this.myAddConst = addConst;
        this.myAddNoexcept = addNoexcept;
    }

    public OCCreateNewDefinitionIntentionAction(OCSymbolKind symbolKind, @NotNull PsiElement usage, @Nullable OCPropertySymbol propertySymbol, OCSymbol parent, String name, OCType type, boolean staticMember) {
        if (usage == null) {
            OCCreateNewDefinitionIntentionAction.$$$reportNull$$$0(1);
        }
        this(symbolKind, usage, propertySymbol, parent, name, type, staticMember, false, false, false);
    }

    public OCCreateNewDefinitionIntentionAction(OCSymbolKind symbolKind, @NotNull PsiElement usage, OCSymbol parent, String name, OCType type) {
        if (usage == null) {
            OCCreateNewDefinitionIntentionAction.$$$reportNull$$$0(2);
        }
        this(symbolKind, usage, null, parent, name, type, false);
    }

    public OCCreateNewDefinitionIntentionAction(@NotNull PsiElement usage, OCSymbol parent, String name, String messageSignature, OCType returnType, @Nullable OCObjectType receiverType) {
        if (usage == null) {
            OCCreateNewDefinitionIntentionAction.$$$reportNull$$$0(3);
        }
        this(OCSymbolKind.METHOD, usage, null, parent, name, returnType, false);
        this.myMessageSignature = messageSignature;
        this.myReceiverType = receiverType;
        if (receiverType instanceof OCIdType) {
            this.myParent = null;
            for (OCProtocolSymbol protocolSymbol : receiverType.getAllProtocols()) {
                if (!OCSearchScope.isInProjectSources(protocolSymbol, usage.getProject()) || protocolSymbol.isPredeclaration()) continue;
                this.myParent = protocolSymbol;
                break;
            }
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            OCSymbol parentInProject = this.getParentInProject();
            this.myParent = parentInProject != null ? parentInProject : this.myParent;
        }
    }

    public OCCreateNewDefinitionIntentionAction(OCSymbolContext symbolContext, PsiElement usage, String name) {
        super(symbolContext.getSymbolKind(), usage, symbolContext.getParent());
        this.mySilentMode = ApplicationManager.getApplication().isUnitTestMode();
        this.myName = name;
        this.myExpectableType = symbolContext.getExpectable();
        this.myIsStaticMember = symbolContext instanceof OCSymbolContext.StructMemberContext && ((OCSymbolContext.StructMemberContext)symbolContext).isStatic();
        this.myPropertySymbol = null;
        this.myAddConst = false;
        this.myAddConstexpr = false;
        this.myAddNoexcept = false;
    }

    public void setSilentMode(boolean silentMode) {
        this.mySilentMode = silentMode;
    }

    @NotNull
    public String getText() {
        Object subject = "";
        if (this.mySymbolKind == OCSymbolKind.INTERFACE) {
            subject = OCInspectionsBundle.message((String)"intention.name.class", (Object[])new Object[0]);
        } else {
            if (this.myIsStaticMember) {
                subject = switch (this.mySymbolKind) {
                    case OCSymbolKind.INSTANCE_VARIABLE, OCSymbolKind.PROPERTY, OCSymbolKind.METHOD -> OCInspectionsBundle.message((String)"intention.name.class", (Object[])new Object[0]) + " ";
                    default -> OCInspectionsBundle.message((String)"intention.name.static", (Object[])new Object[0]) + " ";
                };
            }
            subject = this.mySymbolKind == OCSymbolKind.STRUCT ? OCInspectionsBundle.message((String)"intention.name.cpp.class", (Object[])new Object[0]) : (String)subject + this.mySymbolKind.getNameLowercase();
        }
        subject = (String)subject + " '" + this.getSubjectName() + "'";
        if (this.myParent != null && this.myReceiverType != null && this.getParentInProject() == null) {
            String string = OCInspectionsBundle.message((String)"intention.name.create.new.category", (Object[])new Object[]{this.myParent.getName(), subject});
            if (string == null) {
                OCCreateNewDefinitionIntentionAction.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = OCInspectionsBundle.message((String)"intention.name.create.new", (Object[])new Object[]{subject});
        if (string == null) {
            OCCreateNewDefinitionIntentionAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            OCCreateNewDefinitionIntentionAction.$$$reportNull$$$0(6);
        }
        if (this.myName == null || !OCCodeInsightUtil.isValid(this.myUsage) || this.myParent != null && !OCSearchScope.isInProjectSources(this.myParent, project) && this.mySymbolKind != OCSymbolKind.METHOD) {
            return false;
        }
        if (!(this.mySymbolKind.isClass() || this.mySymbolKind == OCSymbolKind.STRUCT || !(this.myUsage instanceof OCReferenceElement) || this.myUsage.getParent() instanceof OCReferenceExpression || this.myUsage.getParent() instanceof OCConstructorFieldInitializer || this.myUsage.getParent() instanceof OCSynthesizeProperty)) {
            return false;
        }
        if (this.myType == null && this.myExpectableType != null) {
            this.myType = this.myExpectableType.getExpectedType();
        }
        if (this.myType != null && this.myType.accept(new OCBooleanTypeVisitor(){

            @Override
            public Boolean visitUnknownType(OCUnknownType type) {
                return true;
            }
        }).booleanValue()) {
            return false;
        }
        if (this.hasBracedInitListParams()) {
            return false;
        }
        boolean isFunctionType = this.myType instanceof OCFunctionType;
        switch (this.mySymbolKind) {
            case CPP_CONSTRUCTOR_DECLARATION: {
                if (!isFunctionType || this.myParent == null || this.myParent.isPredeclaration() || this.isInvalidDestructor()) {
                    return false;
                }
                if (this.myUsage instanceof OCReferenceExpression) {
                    this.myUsage = ((OCReferenceExpression)this.myUsage).getReferenceElement();
                }
                return !(this.myUsage instanceof OCReferenceElement) || ((OCReferenceElement)this.myUsage).getName().equals(this.myParent.getName());
            }
            case FUNCTION_DECLARATION: {
                return isFunctionType && (this.myParent == null || !this.myParent.isPredeclaration());
            }
            case PARAMETER: {
                return this.myParent != null && !isFunctionType && !this.containingFunctionHasDefaultParameters();
            }
            case METHOD: {
                return (this.myParent == null || this.myParent instanceof OCClassSymbol && !this.myParent.isPredeclaration()) && this.myMessageSignature != null && (this.myMessageSignature.startsWith("+") || this.myMessageSignature.startsWith("-"));
            }
            case INTERFACE: 
            case PROTOCOL: {
                return (file == null || file instanceof OCFile && ((OCFile)file).getKind().isObjC()) && OCNewFileActionBase.isNewFileActionSupported((Project)project) && !ApplicationManager.getApplication().isUnitTestMode();
            }
            case STRUCT: {
                return (file == null || file instanceof OCFile && ((OCFile)file).getKind().isCpp()) && OCNewFileActionBase.isNewFileActionSupported((Project)project) && !ApplicationManager.getApplication().isUnitTestMode() && !(this.myUsage.getParent() instanceof OCConstructorFieldInitializer);
            }
            case INSTANCE_VARIABLE: 
            case PROPERTY: {
                if (this.myParent != null && !this.myParent.isPredeclaration()) break;
                return false;
            }
        }
        return super.isAvailable(project, editor, file) && this.myType != null && !isFunctionType;
    }

    private boolean isInvalidDestructor() {
        return this.myName.startsWith("~") && this.myType instanceof OCFunctionType && !((OCFunctionType)this.myType).hasNoParameters();
    }

    private boolean containingFunctionHasDefaultParameters() {
        PsiElement block = PsiTreeUtil.getContextOfType((PsiElement)this.myUsage, (Class[])new Class[]{OCBlockStatement.class, OCConstructorFieldInitializer.class});
        PsiElement callable = PsiTreeUtil.getParentOfType((PsiElement)block, (Class[])new Class[]{OCMethod.class, OCFunctionDeclaration.class});
        List<OCDeclarator> parameters = callable instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)callable).getParameters() : null;
        return parameters != null && ContainerUtil.exists(parameters, p -> p.getInitializer() != null);
    }

    @NotNull
    private String getSubjectName() {
        if (this.myName == null || !OCCodeInsightUtil.isValid(this.myUsage)) {
            return "";
        }
        if (this.mySymbolKind.isFunctionOrConstructor() && this.myType instanceof OCFunctionType) {
            String string = OCTypeNameVisitor.getFunctionSignature(OCResolveContext.forPsi(this.myUsage), (OCFunctionType)this.myType, this.myName, false, null);
            if (string == null) {
                OCCreateNewDefinitionIntentionAction.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = this.myName;
        if (string == null) {
            OCCreateNewDefinitionIntentionAction.$$$reportNull$$$0(8);
        }
        return string;
    }

    private boolean hasBracedInitListParams() {
        return this.myType instanceof OCFunctionType && ContainerUtil.exists(((OCFunctionType)this.myType).getParameterTypes(), type -> type instanceof OCBracedInitListType);
    }

    @Nullable
    private OCSymbol getParentInProject() {
        Project project = this.myUsage.getProject();
        OCSearchScopeService scopeService = OCSearchScopeService.getInstance(project);
        if (this.myParent == null || scopeService.isInProjectSources(this.myParent) || this.myReceiverType == null) {
            return this.myParent;
        }
        for (OCProtocolSymbol oCProtocolSymbol : this.myReceiverType.getAugmentedProtocols()) {
            if (!scopeService.isInProjectSources(oCProtocolSymbol)) continue;
            return oCProtocolSymbol;
        }
        for (OCInterfaceSymbol oCInterfaceSymbol : this.myReceiverType.getCategoryInterfaces()) {
            if (!scopeService.isInProjectSources(oCInterfaceSymbol)) continue;
            return oCInterfaceSymbol;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doCreate(Project project, Editor editor, PsiFile file) {
        OCNewFileActionBase action = null;
        OCBaseIntroduceHandler introduceHandler = null;
        if (this.mySymbolKind == OCSymbolKind.INTERFACE) {
            action = new OCNewClassAction();
        } else if (this.mySymbolKind == OCSymbolKind.PROTOCOL) {
            action = new OCNewProtocolAction();
        } else if (this.mySymbolKind == OCSymbolKind.STRUCT) {
            action = new OCNewCppClassAction();
            this.createCppConstructor(action);
        } else if (this.mySymbolKind == OCSymbolKind.LOCAL_VARIABLE) {
            introduceHandler = (OCBaseIntroduceHandler)new OCIntroduceVariableAction().getHandler();
        } else if (this.mySymbolKind == OCSymbolKind.INSTANCE_VARIABLE) {
            introduceHandler = (OCBaseIntroduceHandler)new OCIntroduceIvarAction().getHandler();
        } else if (this.mySymbolKind == OCSymbolKind.PROPERTY) {
            introduceHandler = (OCBaseIntroduceHandler)new OCIntroducePropertyAction().getHandler();
        } else {
            if (this.mySymbolKind == OCSymbolKind.PARAMETER) {
                return this.introduceParameterFromUsage();
            }
            if (this.mySymbolKind.isFunctionOrConstructor()) {
                return this.createFunction();
            }
            if (this.mySymbolKind == OCSymbolKind.METHOD) {
                return this.createMethod();
            }
            return super.doCreate(project, editor, file);
        }
        if (introduceHandler != null) {
            OCBaseIntroduceHandler finalIntroduceHandler = introduceHandler;
            Runnable runnable = () -> {
                OCElement usage = null;
                if (this.mySymbolKind == OCSymbolKind.PROPERTY || this.mySymbolKind == OCSymbolKind.INSTANCE_VARIABLE) {
                    usage = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)this.myUsage, OCElement.class, (boolean)false);
                } else if (this.myUsage instanceof OCReferenceElement && this.myUsage.getParent() instanceof OCReferenceExpression) {
                    usage = (OCReferenceExpression)this.myUsage.getParent();
                }
                if (usage != null) {
                    finalIntroduceHandler.invoke(project, editor, usage, this.myType.resolve(usage), true, false, this.myName, this.myParent);
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                runnable.run();
            } else {
                ApplicationManager.getApplication().invokeLater(runnable);
            }
            return true;
        }
        if (action != null && action.performAction(project, file.getParent(), file, this.myName) == null) {
            return false;
        }
        if (this.myUsage instanceof OCReferenceElement && this.myUsage.getText().equals(this.myName)) {
            OCImportSymbolFix importFix = new OCImportSymbolFix((OCReferenceElement)this.myUsage);
            try {
                OCFormattingModelBuilder.requestAlwaysCreateFullModel();
                WriteCommandAction.writeCommandAction((Project)project).run(() -> importFix.fixBestItem(project, file));
            }
            finally {
                OCFormattingModelBuilder.releaseAlwaysCreateFullModel();
            }
        }
        return true;
    }

    private boolean introduceParameterFromUsage() {
        OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)this.myUsage, (Class[])new Class[]{OCMethod.class, OCFunctionDefinition.class});
        if (callable == null) {
            return false;
        }
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler(callable, callable, OCChangeSignatureActionHandler.getDefaultFlags(this.mySilentMode));
        handler.addParameter(this.myName, this.myName, this.myType, -1, false);
        if (this.mySilentMode) {
            handler.invokeSynchronously();
        } else if (handler instanceof OCChangeSignatureDialog.DialogChangeSignatureHandlerImpl) {
            ((OCChangeSignatureDialog.DialogChangeSignatureHandlerImpl)handler).invoke(handler.getParameters().size() - 1, 0);
        } else {
            handler.invoke();
        }
        return true;
    }

    private void createCppConstructor(OCNewFileActionBase action) {
        OCArgumentList argumentList;
        PsiElement constructorUsage;
        PsiElement parent = this.myUsage.getParent();
        if (parent instanceof OCReferenceExpression && parent.getParent() instanceof OCCallExpression) {
            constructorUsage = parent;
            argumentList = ((OCCallExpression)parent.getParent()).getArgumentList();
        } else if (parent.getParent() instanceof OCCppNewExpression) {
            constructorUsage = parent.getParent();
            argumentList = ((OCCppNewExpression)constructorUsage).getArgumentList();
        } else {
            constructorUsage = null;
            argumentList = null;
        }
        if (argumentList != null) {
            OCNewFileActionBase.AuxAction createConstructorAuxAction = new OCNewFileActionBase.AuxAction(){

                public void run(PsiFile[] createdElements) {
                    PsiFile psiFile2;
                    OCSymbol clazz = null;
                    PsiFile[] psiFileArray = createdElements;
                    int n = psiFileArray.length;
                    for (int i = 0; i < n && (clazz = ((OCFile)(psiFile2 = psiFileArray[i])).getSameNamedClass()) == null; ++i) {
                    }
                    if (clazz != null) {
                        OCFunctionType type = new OCFunctionType(OCVoidType.instance(), argumentList.getArgumentTypes(OCResolveContext.forPsi(OCCreateNewDefinitionIntentionAction.this.myUsage)));
                        OCCreateNewDefinitionIntentionAction constructorAction = new OCCreateNewDefinitionIntentionAction(OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION, constructorUsage, clazz, OCCreateNewDefinitionIntentionAction.this.myName, type);
                        constructorAction.setSilentMode(true);
                        Project project = OCCreateNewDefinitionIntentionAction.this.myUsage.getProject();
                        OCFile file = clazz.getContainingOCFile(project);
                        if (constructorAction.isAvailable(project, null, file)) {
                            constructorAction.invoke(project, null, file);
                        }
                    }
                }

                public boolean executeUnderWriteAction() {
                    return false;
                }
            };
            action.addAuxAction(createConstructorAuxAction);
        }
    }

    private boolean createMethod() {
        PsiElement parent;
        if (this.myType == null || this.myType == OCUnknownType.INSTANCE) {
            this.myType = OCVoidType.instance();
        }
        PsiElement insertionPoint = (parent = OCChangeUtil.getAppropriateParent(this.mySymbolKind, this.myUsage)) != null ? OCChangeUtil.getRealAnchorForInsertion(parent, this.myUsage) : null;
        insertionPoint = insertionPoint != null ? insertionPoint : this.myUsage;
        OCMethod method = (OCMethod)WriteAction.compute(() -> {
            String functionText = OCCallableUtil.methodWithSignature(this.myType, this.myMessageSignature, this.myUsage);
            return OCElementFactory.methodFromText(functionText, this.myUsage, true);
        });
        OCChangeSignatureHandler handler = OCChangeSignatureActionHandler.getHandler(method, insertionPoint);
        handler.getGeneratedInfo().setMethodReference(this.myUsage);
        List auxParents = this.myReceiverType != null ? this.myReceiverType.getAugmentedProtocols() : Collections.emptyList();
        handler.setParentClass(this.myParent, true, auxParents);
        handler.setChangeUsages(false);
        handler.getGeneratedInfo().setSelectMethod(!this.mySilentMode);
        handler.setTitle(OCBundle.message("new.definition.dialog.title.create.new.method", new Object[0]));
        handler.setRefactorButtonText(OCBundle.message("new.definition.button.create", new Object[0]));
        if (this.myParent == null || this.myReceiverType == null) {
            handler.setChangeParentClassPossible(true);
        }
        if (this.mySilentMode) {
            handler.invokeSynchronously();
        } else {
            handler.invoke();
        }
        return true;
    }

    private boolean createFunction() {
        OCChangeSignatureHandler handler;
        PsiElement declaration;
        OCSymbolWithQualifiedName callerParent;
        if (!(this.myType instanceof OCFunctionType)) {
            return false;
        }
        Project project = this.myUsage.getProject();
        PsiElement parent = this.myParent != null ? this.myParent.locateDefinition(project) : OCChangeUtil.getAppropriateParent(this.mySymbolKind, this.myUsage);
        OCFunctionDefinition caller = (OCFunctionDefinition)PsiTreeUtil.getParentOfType((PsiElement)this.myUsage, OCFunctionDefinition.class);
        OCFunctionSymbol callerSymbol = caller != null ? caller.getSymbol() : null;
        PsiElement insertionPoint = (PsiElement)ObjectUtils.notNull((Object)OCChangeUtil.getRealAnchorForInsertion(parent, this.myUsage), (Object)this.myUsage);
        if (callerSymbol != null && (callerParent = callerSymbol.getResolvedOwner(OCResolveContext.forPsi(this.myUsage))) != null && callerParent.isSameSymbol(this.myParent, project)) {
            this.myType = this.myType.cloneWithAddedCVQualifiers(callerSymbol.getType().getCVQualifiers(), project);
        }
        boolean signatureOnly = this.myUsage instanceof OCDeclarator ? (declaration = this.myUsage.getParent()) instanceof OCFunctionDeclaration && ((OCFunctionDeclaration)declaration).getBody() != null : false;
        String signature2 = this.getFunctionSignature(insertionPoint);
        OCCallable function = (OCCallable)WriteAction.compute(() -> {
            OCDeclaration declaration;
            if (this.mySymbolKind.isConstructorOrDestructor()) {
                declaration = OCElementFactory.constructorFromText(signature2, this.myParent.getName(), this.myUsage, true);
            } else if (this.myParent instanceof OCStructSymbol) {
                declaration = (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(signature2, this.myUsage, true);
            } else {
                String functionText = signatureOnly ? signature2 : OCCallableUtil.functionWithSignature(((OCFunctionType)this.myType).getReturnType(), signature2, this.myUsage);
                declaration = (OCDeclaration)OCElementFactory.topLevelDeclarationFromText(functionText, this.myUsage, true);
            }
            OCLog.LOG.assertTrue(declaration instanceof OCCallable, (Object)declaration.getTextWithMacros());
            return (OCCallable)((Object)declaration);
        });
        if (this.mySymbolKind.isConstructorOrDestructor()) {
            EnumSet<OCChangeSignatureActionHandler.ChangeSignatureFlags> flags = EnumSet.noneOf(OCChangeSignatureActionHandler.ChangeSignatureFlags.class);
            flags.add(OCChangeSignatureActionHandler.ChangeSignatureFlags.SureThatConstructor);
            if (this.mySilentMode) {
                flags.add(OCChangeSignatureActionHandler.ChangeSignatureFlags.SilentMode);
            } else {
                flags.add(OCChangeSignatureActionHandler.ChangeSignatureFlags.AskForSuperMethods);
            }
            handler = OCChangeSignatureActionHandler.getHandler(function, insertionPoint, flags);
        } else {
            EnumSet<OCChangeSignatureActionHandler.ChangeSignatureFlags> flags = OCChangeSignatureActionHandler.getDefaultFlags(this.mySilentMode);
            if (parent instanceof OCStruct) {
                flags.add(OCChangeSignatureActionHandler.ChangeSignatureFlags.WillBeMemberFunction);
            }
            handler = OCChangeSignatureActionHandler.getHandler(function, insertionPoint, flags);
        }
        handler.setAddConstQualifier(this.myAddConst || this.myType.isConst());
        handler.setAddConstexprSpecifier(this.myAddConstexpr);
        handler.setAddNoexceptSpecifier(this.myAddNoexcept);
        handler.getGeneratedInfo().setMethodReference(this.myUsage);
        handler.setParentClass(this.myParent, false, Collections.emptyList());
        handler.getGeneratedInfo().setSelectMethod(!this.mySilentMode);
        handler.setTitle(this.mySymbolKind.isConstructorOrDestructor() ? OCBundle.message("new.definition.dialog.title.create.new.constructor", new Object[0]) : OCBundle.message("new.definition.dialog.title.create.new.function", new Object[0]));
        handler.setRefactorButtonText(OCBundle.message("new.definition.button.create", new Object[0]));
        if (this.mySilentMode) {
            handler.invokeSynchronously();
        } else {
            handler.invoke();
        }
        return true;
    }

    protected String getFunctionSignature(@NotNull PsiElement insertionPoint) {
        if (insertionPoint == null) {
            OCCreateNewDefinitionIntentionAction.$$$reportNull$$$0(9);
        }
        @NlsSafe StringBuilder signature2 = new StringBuilder();
        OCResolveContext context = OCResolveContext.forPsi(insertionPoint);
        List<OCTypeParameterSymbol<?>> symbols = OCCallableUtil.getDependentTemplateSymbols(this.myType, null, false, true, context);
        signature2.append(OCCallableUtil.getFunctionTemplateHeader(symbols, insertionPoint));
        if (!this.mySymbolKind.isConstructorOrDestructor()) {
            if (this.myIsStaticMember) {
                signature2.append("static ");
            }
            signature2.append(((OCFunctionType)this.myType).getReturnType().getBestNameInContext(context));
            signature2.append(' ');
        }
        signature2.append(this.myName);
        List<OCExpression> arguments = this.myUsage instanceof OCReferenceElement && this.myUsage.getParent().getParent() instanceof OCCallExpression ? ((OCCallExpression)this.myUsage.getParent().getParent()).getArguments() : null;
        return OCTypeNameVisitor.getFunctionSignature(context, (OCFunctionType)this.myType, signature2.toString(), true, arguments);
    }

    @Override
    @Nullable
    public PsiElement getDefinition(Project project, Editor editor, PsiFile file) {
        OCResolveContext context = OCResolveContext.forNullablePsi((PsiElement)file, project);
        return switch (this.mySymbolKind) {
            case OCSymbolKind.INSTANCE_VARIABLE, OCSymbolKind.GLOBAL_VARIABLE, OCSymbolKind.LOCAL_VARIABLE -> {
                OCPropertySymbol.FlagAttribute propAttribute;
                ARCAttribute ivarAttribute;
                OCType type;
                String modifier = null;
                OCType v0 = type = this.myPropertySymbol != null ? this.myPropertySymbol.getResolvedType(context) : null;
                if (this.myPropertySymbol != null && OCCompilerFeaturesHelper.isArcEnabled(file) && type.isPointerToObjectCompatible() && !(ivarAttribute = (propAttribute = this.myPropertySymbol.getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ASSIGN, type, (PsiElement)file)).getIvarCompatibleARCAttribute()).isDefault()) {
                    modifier = ivarAttribute.getTokenName();
                }
                yield OCElementFactory.declaration(modifier, this.myName, this.myType, this.myUsage);
            }
            case OCSymbolKind.STRUCT_FIELD, OCSymbolKind.ENUM_CONST -> {
                if (this.myParent != null && this.myParent.getKind() == OCSymbolKind.ENUM) {
                    yield OCElementFactory.enumConst(this.myName, (PsiElement)file);
                }
                yield OCElementFactory.declaration(this.myIsStaticMember ? "static" : null, this.myName, this.myType, this.myUsage);
            }
            case OCSymbolKind.PROPERTY -> OCElementFactory.propertyDeclaration(this.myName, this.myType.resolve(context), (PsiElement)file);
            case OCSymbolKind.MACRO -> OCElementFactory.macroDeclarationFromText(this.myName, this.myType.resolve(context).getDefaultValue(context), file);
            default -> null;
        };
    }

    @Override
    public boolean startInWriteAction() {
        return switch (this.mySymbolKind) {
            case OCSymbolKind.INSTANCE_VARIABLE, OCSymbolKind.PROPERTY, OCSymbolKind.METHOD, OCSymbolKind.CPP_CONSTRUCTOR_DECLARATION, OCSymbolKind.FUNCTION_DECLARATION, OCSymbolKind.PARAMETER, OCSymbolKind.INTERFACE, OCSymbolKind.PROTOCOL, OCSymbolKind.STRUCT, OCSymbolKind.LOCAL_VARIABLE, OCSymbolKind.FUNCTION_PREDECLARATION, OCSymbolKind.CPP_CONSTRUCTOR_PREDECLARATION -> false;
            default -> super.startInWriteAction();
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCCreateNewDefinitionIntentionAction";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertionPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCCreateNewDefinitionIntentionAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubjectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionSignature";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

