/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.impl.OCDirectiveImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPragmaImpl
extends OCDirectiveImpl
implements OCPragma {
    public OCPragmaImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCPragmaImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @Nullable
    public Pair<OCPragma.Mode, String> parsePragma() {
        int pos = 0;
        for (PsiElement token = this.getHeaderToken().getNextSibling(); token != null; token = token.getNextSibling()) {
            if (OCElementUtil.isWhitespace(token)) continue;
            IElementType type = OCElementUtil.getElementType(token);
            switch (pos) {
                case 0: {
                    if (type == OCTokenTypes.PRAGMA_CLANG_LITERAL || type == OCTokenTypes.PRAGMA_IDE_LITERAL) break;
                    return null;
                }
                case 1: {
                    if (type == OCTokenTypes.PRAGMA_DIAGNOSTIC_LITERAL) break;
                    return null;
                }
                case 2: {
                    if (type == OCTokenTypes.PRAGMA_PUSH_LITERAL) {
                        return Pair.create((Object)((Object)OCPragma.Mode.PUSH), null);
                    }
                    if (type == OCTokenTypes.PRAGMA_POP_LITERAL) {
                        return Pair.create((Object)((Object)OCPragma.Mode.POP), null);
                    }
                    PsiElement maybeString = OCElementUtil.getNextNonWhitespaceSibling(token);
                    if (OCElementUtil.getElementType(maybeString) == OCTokenTypes.STRING_LITERAL) {
                        String param = StringUtil.unquoteString((String)maybeString.getText().replace("\\\n", ""));
                        if (type == OCTokenTypes.PRAGMA_IGNORED_LITERAL) {
                            return Pair.create((Object)((Object)OCPragma.Mode.IGNORE), (Object)param);
                        }
                        if (type == OCTokenTypes.PRAGMA_WARNING_LITERAL) {
                            return Pair.create((Object)((Object)OCPragma.Mode.WARNING), (Object)param);
                        }
                        if (type == OCTokenTypes.PRAGMA_ERROR_LITERAL) {
                            return Pair.create((Object)((Object)OCPragma.Mode.ERROR), (Object)param);
                        }
                        if (type == OCTokenTypes.PRAGMA_FATAL_LITERAL) {
                            return Pair.create((Object)((Object)OCPragma.Mode.FATAL), (Object)param);
                        }
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
            ++pos;
        }
        return null;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCPragmaImpl.$$$reportNull$$$0(1);
        }
        visitor.visitPragma(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCPragmaImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "accept";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

