/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.serialization;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.modulemap.AllowedModules;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapRoot;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPlatformType;
import com.jetbrains.cidr.lang.modulemap.serialization.DependencyInitializer;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapAssembledPack;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapBundledSerializationData;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapConcurrentSerializationService;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapDeserializationSession;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapInitialDeserializationPack;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapPlatformHolder;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapProjectSerializedData;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapReference;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationInfo;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationService;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleSeriailzationUtilKt;
import com.jetbrains.cidr.lang.modulemap.serialization.PackAssembler;
import com.jetbrains.cidr.lang.modulemap.serialization.RefToMapIndex;
import com.jetbrains.cidr.lang.modulemap.serialization.RootsWithConfigurations;
import com.jetbrains.cidr.lang.modulemap.serialization.SerializedModuleMap;
import com.jetbrains.cidr.lang.modulemap.serialization.ValidPackCollector;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMap;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapPack;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapPackWithRoot;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSignature;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000fJ,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J \u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0016\u0010\u001d\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\fH\u0002J&\u0010 \u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\"\u001a\u00020\u000fH\u0002J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010$\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapDeserializationSession;", "", "project", "Lcom/intellij/openapi/project/Project;", "serializationService", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationService;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationService;)V", "buildModuleToSignatureIndex", "", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSymbol;", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSignature;", "packs", "", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapAssembledPack;", "deserializeAllModuleMaps", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "roots", "Lcom/jetbrains/cidr/lang/modulemap/serialization/RootsWithConfigurations;", "deserializeBundledModuleMapsOnly", "deserializeForAllowedModuleRebuild", "", "deserializeModuleMaps", "bundledOnly", "deserializeRawPacks", "preparedPacks", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapInitialDeserializationPack;", "doDeserializePacks", "flushValidPacksToModuleMapCache", "validPacks", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapPackWithRoot;", "initializeDependencies", "deserializedPacks", "ignoreSetupErrors", "prepareInitialPacks", "reportDeserializationFailure", "intellij.c"})
@SourceDebugExtension(value={"SMAP\nModuleMapDeserializationSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleMapDeserializationSession.kt\ncom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapDeserializationSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public final class ModuleMapDeserializationSession {
    @NotNull
    private final Project project;
    @NotNull
    private final ModuleMapSerializationService serializationService;

    public ModuleMapDeserializationSession(@NotNull Project project, @NotNull ModuleMapSerializationService serializationService) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)serializationService, (String)"serializationService");
        this.project = project;
        this.serializationService = serializationService;
    }

    public final void deserializeModuleMaps(@NotNull ProgressIndicator indicator, @NotNull RootsWithConfigurations roots2, boolean bundledOnly) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)roots2, (String)"roots");
        ModuleMapLog.INSTANCE.reportDeserializationStarted(this.project, roots2);
        if (AllowedModules.Companion.isRebuildRequired()) {
            this.deserializeForAllowedModuleRebuild(indicator, roots2);
            return;
        }
        if (!bundledOnly) {
            if (this.deserializeAllModuleMaps(indicator, roots2)) {
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new AssertionError((Object)"Deserialization failed");
            }
            ModuleMapLog.LOG.error("Module map deserialization failed");
        }
        if (this.deserializeBundledModuleMapsOnly(indicator, roots2)) {
            return;
        }
        this.reportDeserializationFailure();
    }

    private final void deserializeForAllowedModuleRebuild(ProgressIndicator indicator, RootsWithConfigurations roots2) {
        if (!this.deserializeBundledModuleMapsOnly(indicator, roots2)) {
            this.reportDeserializationFailure();
        }
    }

    private final void reportDeserializationFailure() {
        ModuleMapLog.LOG.error("Bundled module map deserialization failed");
    }

    private final boolean deserializeAllModuleMaps(ProgressIndicator indicator, RootsWithConfigurations roots2) {
        return this.doDeserializePacks(indicator, roots2, false);
    }

    private final boolean deserializeBundledModuleMapsOnly(ProgressIndicator indicator, RootsWithConfigurations roots2) {
        ModuleMapCache.Companion.getInstance(this.project).reset();
        ModuleMapManager.Companion.getInstance(this.project).clearCache();
        return this.doDeserializePacks(indicator, roots2, true);
    }

    private final boolean doDeserializePacks(ProgressIndicator indicator, RootsWithConfigurations roots2, boolean bundledOnly) {
        List<ModuleMapInitialDeserializationPack> preparedPacks2 = this.prepareInitialPacks(roots2);
        ModuleMapLog.INSTANCE.reportDeserializationPacksCreated(this.project, preparedPacks2);
        List<ModuleMapAssembledPack> packs = this.deserializeRawPacks(preparedPacks2, indicator, bundledOnly);
        ModuleMapLog.INSTANCE.reportDeserializationRawPacks(this.project, packs);
        List<ModuleMapPackWithRoot> initializedPacks = this.initializeDependencies(packs, bundledOnly);
        ModuleMapLog.INSTANCE.reportDependenciesInitialized(this.project, initializedPacks);
        if (initializedPacks == null) {
            return false;
        }
        this.flushValidPacksToModuleMapCache(initializedPacks);
        ModuleMapLog.LOG.info("Loaded " + ModuleSeriailzationUtilKt.flatSize((Collection<ModuleMapPackWithRoot>)initializedPacks) + " module maps in " + initializedPacks.size() + " packs for " + roots2.getSize() + " search roots");
        return true;
    }

    private final List<ModuleMapAssembledPack> deserializeRawPacks(List<ModuleMapInitialDeserializationPack> preparedPacks2, ProgressIndicator indicator, boolean bundledOnly) {
        boolean shouldDeserializeNonBundledPacks = ModuleMapCache.Companion.shouldReloadCache();
        ConcurrentLinkedDeque<ModuleMapAssembledPack> concurrentDeque = new ConcurrentLinkedDeque<ModuleMapAssembledPack>();
        ModuleMapConcurrentSerializationService.Companion.getInstance().deserialize(preparedPacks2, indicator, this.serializationService, (Function3<? super ModuleMapInitialDeserializationPack, ? super ModuleMapBundledSerializationData, ? super ModuleMapProjectSerializedData, Unit>)((Function3)new Function3<ModuleMapInitialDeserializationPack, ModuleMapBundledSerializationData, ModuleMapProjectSerializedData, Unit>(indicator, shouldDeserializeNonBundledPacks, concurrentDeque, bundledOnly){
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ boolean $shouldDeserializeNonBundledPacks;
            final /* synthetic */ ConcurrentLinkedDeque<ModuleMapAssembledPack> $concurrentDeque;
            final /* synthetic */ boolean $bundledOnly;
            {
                this.$indicator = $indicator;
                this.$shouldDeserializeNonBundledPacks = $shouldDeserializeNonBundledPacks;
                this.$concurrentDeque = $concurrentDeque;
                this.$bundledOnly = $bundledOnly;
                super(3, Intrinsics.Kotlin.class, "assemblePack", "deserializeRawPacks$assemblePack(Lcom/intellij/openapi/progress/ProgressIndicator;ZLjava/util/concurrent/ConcurrentLinkedDeque;ZLcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapInitialDeserializationPack;Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapBundledSerializationData;Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapProjectSerializedData;)V", 0);
            }

            public final void invoke(@NotNull ModuleMapInitialDeserializationPack p0, @Nullable ModuleMapBundledSerializationData p1, @Nullable ModuleMapProjectSerializedData p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ModuleMapDeserializationSession.access$deserializeRawPacks$assemblePack(this.$indicator, this.$shouldDeserializeNonBundledPacks, this.$concurrentDeque, this.$bundledOnly, p0, p1, p2);
            }
        }));
        List assembledPacks = CollectionsKt.toList((Iterable)concurrentDeque);
        return assembledPacks;
    }

    private final List<ModuleMapInitialDeserializationPack> prepareInitialPacks(RootsWithConfigurations roots2) {
        ModuleMapPlatformHolder platformHolder = new ModuleMapPlatformHolder();
        List preparedPacks2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)roots2.getEntries()), (Function1)prepareInitialPacks.preparedPacks.1.INSTANCE), (Function1)((Function1)new Function1<Map.Entry<? extends ModuleMapRoot, ? extends List<? extends OCResolveConfiguration>>, ModuleMapInitialDeserializationPack>(this, platformHolder){
            final /* synthetic */ ModuleMapDeserializationSession this$0;
            final /* synthetic */ ModuleMapPlatformHolder $platformHolder;
            {
                this.this$0 = $receiver;
                this.$platformHolder = $platformHolder;
                super(1);
            }

            @NotNull
            public final ModuleMapInitialDeserializationPack invoke(@NotNull Map.Entry<? extends ModuleMapRoot, ? extends List<? extends OCResolveConfiguration>> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                ModuleMapRoot moduleMapRoot = entry.getKey();
                List<? extends OCResolveConfiguration> configurations = entry.getValue();
                ModuleMapSerializationInfo info = ModuleMapDeserializationSession.access$getSerializationService$p(this.this$0).createSerializationInfo(moduleMapRoot);
                Set<ModuleMapPlatformType> platforms = this.$platformHolder.getPlatforms(configurations);
                return new ModuleMapInitialDeserializationPack(platforms, info);
            }
        })), (Function1)prepareInitialPacks.preparedPacks.3.INSTANCE));
        return preparedPacks2;
    }

    private final List<ModuleMapPackWithRoot> initializeDependencies(List<ModuleMapAssembledPack> deserializedPacks, boolean ignoreSetupErrors) {
        Map<ModuleMapReference, SerializedModuleMap> refToSerializedModuleMap = new RefToMapIndex(deserializedPacks).buildRefToMapIndex();
        ModuleMapLog.INSTANCE.reportRefToSerializedModuleMap(this.project, refToSerializedModuleMap);
        List<ModuleMapAssembledPack> validPacks = new ValidPackCollector(deserializedPacks, refToSerializedModuleMap, ignoreSetupErrors).collectValidPacks();
        ModuleMapLog.INSTANCE.reportValidPacks(this.project, validPacks);
        Map<ModuleMapSymbol, ModuleMapSignature> moduleToSignature = this.buildModuleToSignatureIndex(validPacks);
        DependencyInitializer dependencyInitializer = new DependencyInitializer(validPacks, refToSerializedModuleMap, moduleToSignature, ignoreSetupErrors, this.project);
        return dependencyInitializer.setupModuleDependencies();
    }

    private final Map<ModuleMapSymbol, ModuleMapSignature> buildModuleToSignatureIndex(List<ModuleMapAssembledPack> packs) {
        Map result = new LinkedHashMap();
        for (ModuleMapAssembledPack pack : packs) {
            for (SerializedModuleMap serializedModuleMap : pack.getData().getAllMaps()) {
                ModuleMap moduleMap = serializedModuleMap.getModuleMap();
                for (ModuleMapSymbol module2 : ModuleMapUtil.allModules$default(moduleMap, null, 1, null)) {
                    result.put(module2, moduleMap.getSignature());
                }
            }
        }
        return result;
    }

    private final void flushValidPacksToModuleMapCache(List<ModuleMapPackWithRoot> validPacks) {
        ModuleMapCache moduleMapCache = ModuleMapCache.Companion.getInstance(this.project);
        for (ModuleMapPackWithRoot pack : validPacks) {
            ModuleMapPack moduleMapPack = pack.getModuleMapPack();
            moduleMapPack.compact();
            moduleMapCache.cache(pack.getModuleMapRoot(), moduleMapPack);
        }
    }

    private static final void deserializeRawPacks$assemblePack(ProgressIndicator $indicator, boolean shouldDeserializeNonBundledPacks, ConcurrentLinkedDeque<ModuleMapAssembledPack> concurrentDeque, boolean $bundledOnly, ModuleMapInitialDeserializationPack pack, ModuleMapBundledSerializationData bundledData, ModuleMapProjectSerializedData projectData) {
        ModuleMapProjectSerializedData moduleMapProjectSerializedData;
        ModuleMapProjectSerializedData moduleMapProjectSerializedData2 = moduleMapProjectSerializedData = projectData;
        ModuleMapBundledSerializationData moduleMapBundledSerializationData = bundledData;
        ModuleMapInitialDeserializationPack moduleMapInitialDeserializationPack = pack;
        PackAssembler packAssembler = PackAssembler.INSTANCE;
        boolean bl = false;
        boolean bl2 = $bundledOnly;
        ModuleMapAssembledPack assembledPack = packAssembler.assemblePack(moduleMapInitialDeserializationPack, moduleMapBundledSerializationData, !bl2 ? moduleMapProjectSerializedData : null);
        ModuleMapLog.INSTANCE.reportAssembledPack(pack, assembledPack);
        if (assembledPack == null) {
            return;
        }
        $indicator.setText2(assembledPack.getModuleMapRoot().getRoot().getName());
        if (!shouldDeserializeNonBundledPacks && assembledPack.getData().getBundledMaps().isEmpty()) {
            return;
        }
        concurrentDeque.add(assembledPack);
    }

    public static final /* synthetic */ void access$deserializeRawPacks$assemblePack(ProgressIndicator $indicator, boolean shouldDeserializeNonBundledPacks, ConcurrentLinkedDeque concurrentDeque, boolean $bundledOnly, ModuleMapInitialDeserializationPack pack, ModuleMapBundledSerializationData bundledData, ModuleMapProjectSerializedData projectData) {
        ModuleMapDeserializationSession.deserializeRawPacks$assemblePack($indicator, shouldDeserializeNonBundledPacks, concurrentDeque, $bundledOnly, pack, bundledData, projectData);
    }

    public static final /* synthetic */ ModuleMapSerializationService access$getSerializationService$p(ModuleMapDeserializationSession $this) {
        return $this.serializationService;
    }
}

