/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.resolve.manager;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.modulemap.AllowedModules;
import com.jetbrains.cidr.lang.modulemap.ModuleMapRoot;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.resolve.manager.AllowedModuleHandler;
import com.jetbrains.cidr.lang.modulemap.resolve.manager.CacheImpl;
import com.jetbrains.cidr.lang.modulemap.resolve.manager.EmptyCache;
import com.jetbrains.cidr.lang.modulemap.resolve.manager.GlobalCache;
import com.jetbrains.cidr.lang.modulemap.resolve.manager.ModuleMapHeaderCache;
import com.jetbrains.cidr.lang.modulemap.resolve.manager.ModuleMapLocationCache;
import com.jetbrains.cidr.lang.modulemap.resolve.manager.ModuleMapManagerHelper;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMap;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.building.ModuleMapDescriptor;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationSession;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 ,2\u00020\u0001:\u0001,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0012H\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J$\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0018\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u001e\u0010*\u001a\u0004\u0018\u00010+2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006-"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapManagerImpl;", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapManager;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "_globalCache", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapManager$Cache;", "descriptorsForInitialBuilding", "", "Lcom/jetbrains/cidr/lang/symbols/symtable/building/ModuleMapDescriptor;", "getDescriptorsForInitialBuilding", "()Ljava/util/List;", "globalCache", "getGlobalCache", "()Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapManager$Cache;", "getProject", "()Lcom/intellij/openapi/project/Project;", "buildDependencies", "", "item", "impatientRescheduling", "Ljava/lang/Runnable;", "session", "Lcom/jetbrains/cidr/lang/symbols/symtable/serialization/SerializationSession;", "buildModule", "cacheFor", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "clearCache", "findModule", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSymbol;", "header", "Lcom/intellij/openapi/vfs/VirtualFile;", "hasModuleMap", "", "root", "Lcom/jetbrains/cidr/lang/modulemap/ModuleMapRoot;", "newCache", "obtainModules", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMap;", "processDependencies", "modules", "setupInclusionContext", "Lcom/jetbrains/cidr/lang/preprocessor/OCInclusionContext;", "Companion", "intellij.c"})
public final class ModuleMapManagerImpl
implements ModuleMapManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private volatile ModuleMapManager.Cache _globalCache;
    @NotNull
    private static final Key<ModuleMapManager.Cache> CACHE_KEY;

    public ModuleMapManagerImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.project.getMessageBus().connect().subscribe(AllowedModules.INVALIDATION_TOPIC, () -> ModuleMapManagerImpl._init_$lambda$0(this));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public ModuleMapManager.Cache cacheFor(@Nullable OCResolveConfiguration configuration) {
        if (configuration == null) {
            return this.getGlobalCache();
        }
        ModuleMapManager.Cache cache = (ModuleMapManager.Cache)configuration.getUserData(CACHE_KEY);
        if (cache != null) {
            return cache;
        }
        Object object = configuration.putUserDataIfAbsent(CACHE_KEY, (Object)this.newCache(configuration));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"putUserDataIfAbsent(...)");
        return (ModuleMapManager.Cache)object;
    }

    @Override
    @NotNull
    public ModuleMapManager.Cache getGlobalCache() {
        ModuleMapManager.Cache cache = this._globalCache;
        if (cache == null) {
            ModuleMapManager.Cache cache2;
            ModuleMapManager.Cache it = cache2 = this.newCache(null);
            boolean bl = false;
            this._globalCache = it;
            cache = cache2;
        }
        return cache;
    }

    private final ModuleMapManager.Cache newCache(OCResolveConfiguration configuration) {
        return !AllowedModuleHandler.INSTANCE.isEnabled(this.project) ? (ModuleMapManager.Cache)EmptyCache.INSTANCE : (configuration != null ? (ModuleMapManager.Cache)new CacheImpl(configuration) : (ModuleMapManager.Cache)new GlobalCache(this.project));
    }

    @Override
    public boolean hasModuleMap(@NotNull ModuleMapRoot root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        return ModuleMapCache.Companion.getInstance(this.project).getPack(root).getHasModuleMapFile();
    }

    @Override
    @Nullable
    public ModuleMapSymbol findModule(@NotNull VirtualFile header, @NotNull OCResolveConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return ModuleMapHeaderCache.Companion.getInstance(this.project).findModule(header, configuration);
    }

    @Override
    public void buildModule(@NotNull ModuleMapDescriptor item, @Nullable Runnable impatientRescheduling, @NotNull SerializationSession session) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.obtainModules(item, session, impatientRescheduling);
    }

    private final ModuleMap obtainModules(ModuleMapDescriptor item, SerializationSession session, Runnable impatientRescheduling) {
        ModuleMapRoot root = item.getModuleMapRoot();
        if (!this.hasModuleMap(root)) {
            return null;
        }
        OCResolveConfiguration configuration = item.isForGlobal() ? null : item.getConfiguration();
        ModuleMapManager.Cache cache = this.cacheFor(configuration);
        OCInclusionContext context = this.setupInclusionContext(configuration, impatientRescheduling);
        return cache.getModuleMap(root, session, context, true);
    }

    @Override
    public void buildDependencies(@NotNull ModuleMapDescriptor item, @Nullable Runnable impatientRescheduling, @NotNull SerializationSession session) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ModuleMap moduleMap = this.obtainModules(item, session, impatientRescheduling);
        if (moduleMap == null) {
            return;
        }
        ModuleMap modules2 = moduleMap;
        this.processDependencies(modules2, item.getConfiguration());
    }

    private final OCInclusionContext setupInclusionContext(OCResolveConfiguration configuration, Runnable impatientRescheduling) {
        if (configuration == null) {
            return null;
        }
        OCInclusionContext oCInclusionContext = ModuleMapUtil.createSignatureContext(configuration).derive();
        Intrinsics.checkNotNullExpressionValue((Object)oCInclusionContext, (String)"derive(...)");
        OCInclusionContext inclusionContext = oCInclusionContext;
        inclusionContext.setImpatientRescheduling(impatientRescheduling);
        return inclusionContext;
    }

    private final void processDependencies(ModuleMap modules2, OCResolveConfiguration configuration) {
        for (ModuleMapSymbol module2 : ModuleMapUtil.allModules$default(modules2, null, 1, null)) {
            if (!AllowedModules.Companion.getAllowedModules().contains(module2.getModuleName())) continue;
            module2.getDependencies(configuration);
        }
    }

    @Override
    @NotNull
    public List<ModuleMapDescriptor> getDescriptorsForInitialBuilding() {
        List descriptors = new ArrayList();
        List list = OCWorkspace.getInstance((Project)this.project).getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurations(...)");
        List configurations = list;
        Set visitedGlobalRoots = new LinkedHashSet();
        ModuleMapManagerHelper moduleMapManagerHelper = ModuleMapManagerHelper.Companion.getInstance();
        for (OCResolveConfiguration configuration : configurations) {
            ModuleMapManager.Cache cache = this.cacheFor(configuration);
            List<ModuleMapRoot> roots2 = cache.getModuleMapRoots();
            for (ModuleMapRoot root : roots2) {
                Intrinsics.checkNotNull((Object)configuration);
                if (moduleMapManagerHelper.findDelegatingConfiguration(root, configuration) != null) continue;
                descriptors.add(new ModuleMapDescriptor(configuration, root, false));
                if (!visitedGlobalRoots.add(root)) continue;
                descriptors.add(new ModuleMapDescriptor(configuration, root, true));
            }
        }
        return descriptors;
    }

    @Override
    public void clearCache() {
        ModuleMapHeaderCache.Companion.getInstance(this.project).clear();
        ModuleMapLocationCache.Companion.getInstance(this.project).clear();
        this._globalCache = null;
        for (OCResolveConfiguration config : OCWorkspace.getInstance((Project)this.project).getConfigurations()) {
            config.putUserData(CACHE_KEY, null);
        }
    }

    private static final void _init_$lambda$0(ModuleMapManagerImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.clearCache();
    }

    static {
        Key key = Key.create((String)"CACHE_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CACHE_KEY = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapManagerImpl$Companion;", "", "()V", "CACHE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/jetbrains/cidr/lang/modulemap/resolve/ModuleMapManager$Cache;", "findModuleConfigurations", "", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "module", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSymbol;", "project", "Lcom/intellij/openapi/project/Project;", "findModuleMapRoot", "", "Lcom/jetbrains/cidr/lang/modulemap/ModuleMapRoot;", "intellij.c"})
    @SourceDebugExtension(value={"SMAP\nModuleMapManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleMapManagerImpl.kt\ncom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapManagerImpl$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,165:1\n766#2:166\n857#2,2:167\n1360#2:169\n1446#2,5:170\n372#3,7:175\n*S KotlinDebug\n*F\n+ 1 ModuleMapManagerImpl.kt\ncom/jetbrains/cidr/lang/modulemap/resolve/manager/ModuleMapManagerImpl$Companion\n*L\n134#1:166\n134#1:167,2\n145#1:169\n145#1:170,5\n159#1:175,7\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<OCResolveConfiguration> findModuleConfigurations(@NotNull ModuleMapSymbol module2, @NotNull Project project) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ModuleMapManager moduleMapManager = ModuleMapManager.Companion.getInstance(project);
            QualifiedName moduleName = module2.getModuleName();
            List list = OCWorkspace.getInstance((Project)project).getConfigurations();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getConfigurations(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                OCResolveConfiguration configuration = (OCResolveConfiguration)element$iv$iv;
                boolean bl = false;
                ModuleMapSymbol found = moduleMapManager.cacheFor(configuration).findModule(moduleName);
                if (!(found == module2)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<ModuleMapRoot, List<OCResolveConfiguration>> findModuleMapRoot(@NotNull ModuleMapSymbol module2, @NotNull Project project) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            List<OCResolveConfiguration> configurations = this.findModuleConfigurations(module2, project);
            ModuleMapManager moduleMapManager = ModuleMapManager.Companion.getInstance(project);
            Iterable $this$flatMap$iv = configurations;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                OCResolveConfiguration configuration = (OCResolveConfiguration)element$iv$iv;
                boolean bl = false;
                ModuleMapManager.Cache cache = moduleMapManager.cacheFor(configuration);
                List result = new ArrayList();
                for (ModuleMapRoot root : cache.getModuleMapRoots()) {
                    ModuleMap map2;
                    if (cache.getModuleMap(root) == null || !map2.getModules().contains(module2)) continue;
                    result.add(TuplesKt.to((Object)configuration, (Object)root));
                }
                Iterable list$iv$iv = result;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List roots2 = (List)destination$iv$iv;
            Map map3 = new LinkedHashMap();
            for (Pair root : roots2) {
                Object object;
                void $this$getOrPut$iv;
                destination$iv$iv = map3;
                Object key$iv = root.getSecond();
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(root.getFirst());
            }
            return map3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

