/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.resolve;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.jetbrains.cidr.lang.OCLog;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/resolve/AppCodeModuleErrorsTestChecker;", "", "()V", "isDisabled", "", "key", "Lcom/intellij/openapi/util/Key;", "", "checkModules", "", "project", "Lcom/intellij/openapi/project/Project;", "disable", "testRootDisposable", "Lcom/intellij/openapi/Disposable;", "forceCheckModules", "registerError", "errorMessage", "intellij.c"})
@TestOnly
public final class AppCodeModuleErrorsTestChecker {
    @NotNull
    public static final AppCodeModuleErrorsTestChecker INSTANCE = new AppCodeModuleErrorsTestChecker();
    @NotNull
    private static final Key<String> key;
    private static volatile boolean isDisabled;

    private AppCodeModuleErrorsTestChecker() {
    }

    public final void checkModules(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (isDisabled) {
            return;
        }
        this.forceCheckModules(project);
    }

    public final void forceCheckModules(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String data = (String)project.getUserData(key);
        if (data != null) {
            System.err.println(data);
            OCLog.LOG.error("Some Xcode modules were missing in prebuilt caches");
        }
    }

    public final void registerError(@NotNull Project project, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        String previousError = (String)project.getUserData(key);
        String newError = previousError != null ? previousError + "\n-------------------------------------------------\n" + errorMessage : errorMessage;
        project.putUserData(key, (Object)newError);
    }

    public final void disable(@NotNull Disposable testRootDisposable) {
        Intrinsics.checkNotNullParameter((Object)testRootDisposable, (String)"testRootDisposable");
        isDisabled = true;
        Disposer.register((Disposable)testRootDisposable, () -> AppCodeModuleErrorsTestChecker.disable$lambda$0(this));
    }

    private static final void disable$lambda$0(AppCodeModuleErrorsTestChecker this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        isDisabled = false;
    }

    static {
        Key key = Key.create((String)"AppCodeReportErrorsUserDataKey");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        AppCodeModuleErrorsTestChecker.key = key;
    }
}

