/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class OCIntroduceTypeDefIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        OCDeclarator declarator;
        if (project == null) {
            OCIntroduceTypeDefIntentionAction.$$$reportNull$$$0(0);
        }
        if (element == null) {
            OCIntroduceTypeDefIntentionAction.$$$reportNull$$$0(1);
        }
        if ((declarator = (OCDeclarator)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclarator.class, (boolean)false)) == null) {
            return false;
        }
        OCDeclaration declaration = (OCDeclaration)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclaration.class, (boolean)false);
        if (declaration == null || declaration instanceof OCFunctionDefinition || declaration instanceof OCParameterDeclaration) {
            return false;
        }
        if (declarator.getParameterList() != null) {
            return false;
        }
        List<OCDeclarator> declarators = declaration.getDeclarators();
        if (declarators.size() != 1) {
            return false;
        }
        OCType type = declarator.getType();
        if (OCIntroduceTypeDefIntentionAction.isComplexType(type, false, false)) {
            this.setText(OCInspectionsBundle.message((String)"intentions.introduce.typedef.for.type", (Object[])new Object[]{type.getBestNameInContext(element)}));
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        OCDeclarator declarator;
        if (project == null) {
            OCIntroduceTypeDefIntentionAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            OCIntroduceTypeDefIntentionAction.$$$reportNull$$$0(3);
        }
        if ((declarator = (OCDeclarator)PsiTreeUtil.getParentOfType((PsiElement)element, OCDeclarator.class, (boolean)false)) != null) {
            String name = declarator.getName();
            PsiElement psiElement = declarator.getParent();
            if (psiElement instanceof OCDeclaration) {
                OCDeclaration declaration = (OCDeclaration)psiElement;
                OCDeclaration typedefDeclaration = (OCDeclaration)declaration.copy();
                PsiFile psiFile2 = element.getContainingFile();
                PsiElement typedef = OCElementFactory.typeElementFromText("typedef int", (PsiElement)psiFile2).getFirstChild();
                typedefDeclaration.addBefore(typedef.getNextSibling(), typedefDeclaration.getFirstChild());
                typedefDeclaration.addBefore(typedef, typedefDeclaration.getFirstChild());
                OCChangeUtil.addBefore((PsiElement)psiFile2, typedefDeclaration, declaration);
                OCTypeElement type = OCElementFactory.typeElementFromText(name, declaration);
                declaration.replace(OCElementFactory.declarationByNameAndType(name, type.getType(), declaration));
            }
        }
    }

    private static boolean isComplexType(@NotNull OCType type, boolean hasPointer, boolean hasArray) {
        if (type == null) {
            OCIntroduceTypeDefIntentionAction.$$$reportNull$$$0(4);
        }
        if (type instanceof OCPointerType) {
            if (hasArray) {
                return true;
            }
            if (hasPointer) {
                return true;
            }
            return OCIntroduceTypeDefIntentionAction.isComplexType(((OCPointerType)type).getRefType(), true, hasArray);
        }
        if (type instanceof OCReferenceType) {
            return false;
        }
        return type instanceof OCFunctionType;
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message((String)"intentions.introduce.typedef", (Object[])new Object[0]);
        if (string == null) {
            OCIntroduceTypeDefIntentionAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCIntroduceTypeDefIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCIntroduceTypeDefIntentionAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isComplexType";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

